/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormFamily;
import visad.data.FormFileInformer;
import visad.data.FormNode;

public class FunctionFormFamily
extends FormFamily {
    public synchronized void save(String string, Data data, boolean bl) throws BadFormException, RemoteException, IOException, VisADException {
        SaveForm saveForm = new SaveForm(this, string, data, bl);
        if (!saveForm.run()) {
            throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
        }
    }

    public synchronized void add(String string, Data data, boolean bl) throws BadFormException {
        AddForm addForm = new AddForm(this, string, data, bl);
        try {
            if (addForm.run()) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
    }

    public synchronized DataImpl open(String string) throws BadFormException, VisADException {
        Object object;
        URL uRL;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        DataImpl dataImpl = null;
        if (uRL != null) {
            object = new OpenURLForm(this, uRL);
            try {
                dataImpl = !((FormFunction)object).run() ? null : ((OpenURLForm)object).getData();
            }
            catch (Exception exception) {
                dataImpl = null;
            }
        }
        object = null;
        if (dataImpl == null) {
            if (uRL == null) {
                object = string;
            } else if (uRL.getProtocol() == "file" && ((String)(object = uRL.getFile())).length() > 2 && ((String)object).charAt(2) == ':' && ((String)object).charAt(0) == '/') {
                object = ((String)object).substring(1);
            }
        }
        if (object != null) {
            OpenStringForm openStringForm = new OpenStringForm(this, string);
            try {
                dataImpl = !openStringForm.run() ? null : openStringForm.getData();
            }
            catch (IOException iOException) {
                dataImpl = null;
            }
        }
        if (dataImpl == null) {
            if (object != null && !new File((String)object).exists()) {
                throw new BadFormException("No such data object \"" + string + "\"");
            }
            throw new BadFormException("Data object \"" + string + "\" not compatible with \"" + this.getName() + "\" data family");
        }
        return dataImpl;
    }

    public synchronized DataImpl open(URL uRL) throws BadFormException, IOException, VisADException {
        OpenURLForm openURLForm = new OpenURLForm(this, uRL);
        if (!openURLForm.run()) {
            throw new BadFormException("Data object \"" + uRL + "\" not compatible with \"" + this.getName() + "\" data family");
        }
        return openURLForm.getData();
    }

    public FunctionFormFamily(String string) {
        super(string);
    }

    abstract class FormFunction {
        abstract boolean check(FormFileInformer var1);

        abstract InputStream getStream() throws IOException;

        abstract boolean function(FormNode var1);

        public boolean run() throws IOException {
            FormNode formNode;
            Enumeration enumeration;
            Object object;
            Object object2 = FunctionFormFamily.this.forms.elements();
            while (object2.hasMoreElements()) {
                object = (FormNode)object2.nextElement();
                if (!(object instanceof FormFileInformer)) continue;
                try {
                    if (!this.check((FormFileInformer)object) || !this.function((FormNode)object)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            object2 = new byte[2048];
            object = this.getStream();
            if (object != null) {
                ((InputStream)object).read((byte[])object2);
                ((InputStream)object).close();
                enumeration = FunctionFormFamily.this.forms.elements();
                while (enumeration.hasMoreElements()) {
                    formNode = (FormNode)enumeration.nextElement();
                    if (!(formNode instanceof FormFileInformer)) continue;
                    try {
                        if (!((FormFileInformer)((Object)formNode)).isThisType((byte[])object2) || !this.function(formNode)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
            enumeration = FunctionFormFamily.this.forms.elements();
            while (enumeration.hasMoreElements()) {
                formNode = (FormNode)enumeration.nextElement();
                try {
                    if (!this.function(formNode)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            return false;
        }

        FormFunction() {
        }
    }

    abstract class FileFunction
    extends FormFunction {
        String name;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean check(FormFileInformer formFileInformer) {
            return formFileInformer.isThisType(this.name);
        }

        InputStream getStream() throws IOException {
            return new FileInputStream(this.name);
        }

        public FileFunction(FunctionFormFamily functionFormFamily) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            this.this$0 = functionFormFamily;
            this.name = null;
        }
    }

    class SaveForm
    extends FileFunction {
        private Data data;
        private boolean replace;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean function(FormNode formNode) {
            try {
                formNode.save(this.name, this.data, this.replace);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        InputStream getStream() throws IOException {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileInputStream = null;
            }
            return fileInputStream;
        }

        public SaveForm(FunctionFormFamily functionFormFamily, String string, Data data, boolean bl) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            super(functionFormFamily2);
            this.this$0 = functionFormFamily;
            this.name = string;
            this.data = data;
            this.replace = bl;
        }
    }

    class AddForm
    extends FileFunction {
        private Data data;
        private boolean replace;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean function(FormNode formNode) {
            try {
                formNode.add(this.name, this.data, this.replace);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        public AddForm(FunctionFormFamily functionFormFamily, String string, Data data, boolean bl) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            super(functionFormFamily2);
            this.this$0 = functionFormFamily;
            this.name = string;
            this.data = data;
            this.replace = bl;
        }
    }

    class OpenStringForm
    extends FileFunction {
        private DataImpl data;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean function(FormNode formNode) {
            try {
                this.data = formNode.open(this.name);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                return false;
            }
            return true;
        }

        public DataImpl getData() {
            return this.data;
        }

        public OpenStringForm(FunctionFormFamily functionFormFamily, String string) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            super(functionFormFamily2);
            this.this$0 = functionFormFamily;
            this.name = string;
            this.data = null;
        }
    }

    abstract class URLFunction
    extends FormFunction {
        URL url;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean check(FormFileInformer formFileInformer) {
            return formFileInformer.isThisType(this.url.getFile());
        }

        InputStream getStream() throws IOException {
            return this.url.openStream();
        }

        public URLFunction(FunctionFormFamily functionFormFamily) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            this.this$0 = functionFormFamily;
            this.url = null;
        }
    }

    class OpenURLForm
    extends URLFunction {
        private DataImpl data;
        private final /* synthetic */ FunctionFormFamily this$0;

        boolean function(FormNode formNode) {
            try {
                this.data = formNode.open(this.url);
            }
            catch (Throwable throwable) {
                return false;
            }
            return true;
        }

        public DataImpl getData() {
            return this.data;
        }

        public OpenURLForm(FunctionFormFamily functionFormFamily, URL uRL) {
            FunctionFormFamily functionFormFamily2 = functionFormFamily;
            if (functionFormFamily2 == null) {
                throw null;
            }
            super(functionFormFamily2);
            this.this$0 = functionFormFamily;
            this.url = uRL;
            this.data = null;
        }
    }
}

