/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataShadow;
import visad.Field;
import visad.FlatField;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.FileAccessor;

public class FileFlatField
extends FlatField {
    private static final int MAX_FILE_FLAT_FIELDS = 10;
    private static transient FlatField[] adaptedFlatFields = new FlatField[10];
    private static transient boolean[] adaptedFlatFieldDirty = new boolean[10];
    private static transient FileFlatField[] adaptedFlatFieldOwner = new FileFlatField[10];
    private static transient long[] adaptedFlatFieldSizes = new long[10];
    private static transient long[] adaptedFlatFieldTimes = new long[10];
    private transient int adaptedFlatFieldIndex;
    transient FileAccessor fileAccessor;
    private transient CacheStrategy cacheStrategy;

    private static Set getNullDomainSet(RealTupleType realTupleType) throws VisADException {
        int n = realTupleType.getDimension();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        try {
            RealTuple realTuple = new RealTuple(realTupleType, dArray);
            return new SingletonSet(realTuple);
        }
        catch (RemoteException remoteException) {
            throw new VisADError("FileFlatField.getNullDomainSet: " + remoteException.toString());
        }
    }

    private FlatField getAdaptedFlatField() {
        if (adaptedFlatFieldOwner == null) {
            return null;
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (flatFieldArray) {
            int n = 0;
            while (n < 10) {
                if (this == adaptedFlatFieldOwner[n]) {
                    FileFlatField.adaptedFlatFieldTimes[n] = System.currentTimeMillis();
                    FlatField flatField = adaptedFlatFields[n];
                    Object var2_8 = null;
                    return flatField;
                }
                ++n;
            }
            this.adaptedFlatFieldIndex = this.cacheStrategy.allocate(adaptedFlatFields, adaptedFlatFieldDirty, adaptedFlatFieldSizes, adaptedFlatFieldTimes);
            if (adaptedFlatFieldDirty[this.adaptedFlatFieldIndex]) {
                try {
                    adaptedFlatFieldOwner[this.adaptedFlatFieldIndex].flushCache();
                }
                catch (VisADException visADException) {
                    System.out.println(visADException.getMessage());
                }
            }
            try {
                FileFlatField.adaptedFlatFields[this.adaptedFlatFieldIndex] = this.fileAccessor.getFlatField();
            }
            catch (VisADException visADException) {
                System.out.println(visADException.getMessage());
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException.getMessage());
            }
            FileFlatField.adaptedFlatFieldOwner[this.adaptedFlatFieldIndex] = this;
            FileFlatField.adaptedFlatFieldTimes[this.adaptedFlatFieldIndex] = System.currentTimeMillis();
            FlatField flatField = adaptedFlatFields[this.adaptedFlatFieldIndex];
            Object var2_9 = null;
            return flatField;
        }
    }

    private void flushCache() throws VisADException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        if (this == adaptedFlatFieldOwner[this.adaptedFlatFieldIndex]) {
            // empty if block
        }
    }

    public Data getSample(int n) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.getSample(n);
    }

    public int getLength() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return 0;
        }
        return flatField.getLength();
    }

    public Unit[] getDomainUnits() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getDomainUnits();
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getDomainCoordinateSystem();
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getRangeCoordinateSystem();
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int n) throws TypeException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getRangeCoordinateSystem(n);
    }

    public Unit[][] getRangeUnits() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getRangeUnits();
    }

    public Unit[] getDefaultRangeUnits() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getDefaultRangeUnits();
    }

    public double[][] getValues() throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.getValues();
    }

    public double[][] getValues(boolean bl) throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.getValues(bl);
    }

    public double[] getValues(int n) throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.getValues(n);
    }

    public float[][] getFloats(boolean bl) throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.getFloats(bl);
    }

    public Set getDomainSet() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.getDomainSet();
    }

    public void setSample(int n, Data data) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (flatFieldArray) {
            FlatField flatField = this.getAdaptedFlatField();
            if (flatField == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            flatField.setSample(n, data);
        }
    }

    public void setSample(RealTuple realTuple, Data data) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (flatFieldArray) {
            FlatField flatField = this.getAdaptedFlatField();
            if (flatField == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            flatField.setSample(realTuple, data);
        }
    }

    public void setSample(int n, Data data, boolean bl) throws VisADException, RemoteException {
        if (adaptedFlatFields == null) {
            throw new VisADException("Cannot access serialized FileFlatField");
        }
        FlatField[] flatFieldArray = adaptedFlatFields;
        synchronized (flatFieldArray) {
            FlatField flatField = this.getAdaptedFlatField();
            if (flatField == null) {
                throw new VisADException("Cannot get cached FlatField");
            }
            FileFlatField.adaptedFlatFieldDirty[this.adaptedFlatFieldIndex] = true;
            flatField.setSample(n, data, bl);
        }
    }

    public boolean isMissing() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return true;
        }
        return flatField.isMissing();
    }

    public Data binary(Data data, int n, int n2, int n3) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.binary(data, n, n2, n3);
    }

    public Data unary(int n, int n2, int n3) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.unary(n, n2, n3);
    }

    public double[][] unpackValues() throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.unpackValues();
    }

    public Field extract(int n) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.extract(n);
    }

    public Field domainFactor(RealType realType) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.domainFactor(realType);
    }

    public Field resample(Set set, int n, int n2) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.resample(set, n, n2);
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.computeRanges(shadowType, dataShadow);
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            throw new VisADException("Cannot get cached FlatField");
        }
        return flatField.adjustSamplingError(data, n);
    }

    public boolean isFlatField() {
        return true;
    }

    public Object clone() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return null;
        }
        return flatField.clone();
    }

    public String toString() {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return "Cannot get cached FlatField";
        }
        return flatField.toString();
    }

    public String longString(String string) {
        FlatField flatField = this.getAdaptedFlatField();
        if (flatField == null) {
            return string + "Cannot get cached FlatField";
        }
        try {
            return flatField.longString(string);
        }
        catch (VisADException visADException) {
            return string + visADException.getMessage();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        throw new NotSerializableException("FileFlatField is not serializable");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("FileFlatField is not serializable");
    }

    public FileFlatField(FileAccessor fileAccessor, CacheStrategy cacheStrategy) throws VisADException {
        super(fileAccessor.getFunctionType(), FileFlatField.getNullDomainSet(fileAccessor.getFunctionType().getDomain()));
        this.fileAccessor = fileAccessor;
        this.cacheStrategy = cacheStrategy;
        this.adaptedFlatFieldIndex = 0;
    }

    static {
        if (adaptedFlatFieldOwner != null && adaptedFlatFields != null && adaptedFlatFieldSizes != null && adaptedFlatFieldTimes != null && adaptedFlatFieldDirty != null) {
            int n = 0;
            while (n < 10) {
                FileFlatField.adaptedFlatFieldOwner[n] = null;
                FileFlatField.adaptedFlatFields[n] = null;
                FileFlatField.adaptedFlatFieldSizes[n] = 0L;
                FileFlatField.adaptedFlatFieldTimes[n] = System.currentTimeMillis();
                FileFlatField.adaptedFlatFieldDirty[n] = false;
                ++n;
            }
        }
    }
}

