/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import visad.data.BadRepositoryException;
import visad.data.Repository;

public class DirectoryRepository
extends Repository {
    protected File dir;
    protected String dirString;

    public Enumeration getEnumeration() throws BadRepositoryException, SecurityException {
        return new Enumerator();
    }

    protected String fullName(String string) {
        return this.getLocation() + File.separator + string;
    }

    public static void main(String[] stringArray) throws BadRepositoryException, IOException {
        DirectoryRepository directoryRepository = new DirectoryRepository("Test", ".");
        Enumeration enumeration = directoryRepository.getEnumeration();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
        System.out.println("dir.fullName(\"foo.bar\") = " + directoryRepository.fullName("foo.bar"));
    }

    public DirectoryRepository(String string, String string2) throws BadRepositoryException, IOException {
        super(string, string2);
        try {
            this.dir = new File(this.getLocation());
        }
        catch (NullPointerException nullPointerException) {
            throw new BadRepositoryException("Null repository name");
        }
        this.dirString = "\"" + this.getName() + "\" (path \"" + this.getLocation() + "\")";
        if (!this.dir.isDirectory()) {
            throw new BadRepositoryException("Repository " + this.dirString + " is not a directory");
        }
        if (!this.dir.canRead()) {
            throw new BadRepositoryException("Repository " + this.dirString + " is not readable");
        }
    }

    public class Enumerator
    implements Enumeration {
        protected int i;
        protected final String[] list;

        public boolean hasMoreElements() {
            return this.i < this.list.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.i == this.list.length) {
                throw new NoSuchElementException();
            }
            return this.list[this.i++];
        }

        protected Enumerator() throws SecurityException {
            this.list = DirectoryRepository.this.dir.list();
            this.i = 0;
        }
    }
}

