/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.DataProcessor;

public abstract class BaseDataProcessor
implements DataProcessor {
    public void process(DataImpl dataImpl, Object object) throws VisADException {
        MathType mathType = dataImpl.getType();
        boolean bl = false;
        if (mathType instanceof ScalarType) {
            try {
                if (mathType instanceof TextType) {
                    Text text = (Text)dataImpl;
                    this.processText((TextType)text.getType(), text.getValue(), text.isMissing(), text, object);
                    bl = true;
                } else if (mathType instanceof RealType) {
                    Real real = (Real)dataImpl;
                    this.processReal((RealType)real.getType(), real.getValue(), real.getUnit(), real.getError(), real, object);
                    bl = true;
                }
            }
            catch (UnimplementedException unimplementedException) {}
        } else if (mathType instanceof TupleType) {
            TupleType tupleType = (TupleType)mathType;
            Tuple tuple = (Tuple)dataImpl;
            Data[] dataArray = tuple.getComponents();
            if (tupleType instanceof RealTupleType) {
                RealTuple realTuple = (RealTuple)tuple;
                RealTupleType realTupleType = (RealTupleType)tupleType;
                if (dataArray != null) {
                    Real[] realArray = new Real[dataArray.length];
                    int n = 0;
                    while (n < dataArray.length) {
                        realArray[n] = (Real)dataArray[n];
                        ++n;
                    }
                    try {
                        this.processRealTuple(realTupleType, realArray, realTuple.getCoordinateSystem(), realTuple, object);
                        bl = true;
                    }
                    catch (UnimplementedException unimplementedException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                try {
                    this.processTuple(tupleType, dataArray, tuple, object);
                    bl = true;
                }
                catch (UnimplementedException unimplementedException) {}
            }
        } else if (mathType instanceof SetType) {
            SetType setType = (SetType)mathType;
            try {
                if (dataImpl instanceof SampledSet) {
                    this.processSampledSet(setType, (SampledSet)dataImpl, object);
                    bl = true;
                } else if (dataImpl instanceof SimpleSet) {
                    this.processSimpleSet(setType, (SimpleSet)dataImpl, object);
                    bl = true;
                }
            }
            catch (UnimplementedException unimplementedException) {}
        } else if (mathType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)mathType;
            try {
                if (dataImpl instanceof FlatField) {
                    FlatField flatField = (FlatField)dataImpl;
                    CoordinateSystem coordinateSystem = null;
                    CoordinateSystem[] coordinateSystemArray = null;
                    if (functionType.getReal()) {
                        coordinateSystem = flatField.getRangeCoordinateSystem()[0];
                    } else {
                        MathType mathType2 = functionType.getRange();
                        int n = ((TupleType)functionType.getRange()).getDimension();
                        coordinateSystemArray = new CoordinateSystem[n];
                        int n2 = 0;
                        while (n2 < n) {
                            coordinateSystemArray[n2] = flatField.getRangeCoordinateSystem(n2)[0];
                            ++n2;
                        }
                    }
                    this.processFlatField(functionType, flatField.getDomainSet(), coordinateSystem, coordinateSystemArray, flatField.getRangeSets(), flatField.getDefaultRangeUnits(), flatField, object);
                    bl = true;
                } else if (dataImpl instanceof FieldImpl) {
                    FieldImpl fieldImpl = (FieldImpl)dataImpl;
                    this.processFieldImpl(functionType, fieldImpl.getDomainSet(), fieldImpl, object);
                    bl = true;
                }
            }
            catch (UnimplementedException unimplementedException) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                this.processUnknownData(dataImpl, object);
            }
            catch (UnimplementedException unimplementedException) {
                throw new UnimplementedException("Couldn't process " + dataImpl.getClass().getName() + " in " + this.getClass().getName());
            }
        }
    }

    public abstract void processDoubleSet(SetType var1, CoordinateSystem var2, Unit[] var3, DoubleSet var4, Object var5) throws VisADException;

    public abstract void processFieldImpl(FunctionType var1, Set var2, FieldImpl var3, Object var4) throws VisADException;

    public abstract void processFlatField(FunctionType var1, Set var2, CoordinateSystem var3, CoordinateSystem[] var4, Set[] var5, Unit[] var6, FlatField var7, Object var8) throws VisADException;

    public abstract void processFloatSet(SetType var1, CoordinateSystem var2, Unit[] var3, FloatSet var4, Object var5) throws VisADException;

    public abstract void processGridded1DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded1DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded2DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded2DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded3DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded3DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded1DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded1DSet var7, Object var8) throws VisADException;

    private void processGridded1DSet(SetType setType, Gridded1DSet gridded1DSet, Object object) throws VisADException {
        int[] nArray = gridded1DSet.getLengths();
        CoordinateSystem coordinateSystem = gridded1DSet.getCoordinateSystem();
        Unit[] unitArray = gridded1DSet.getSetUnits();
        ErrorEstimate[] errorEstimateArray = gridded1DSet.getSetErrors();
        boolean bl = false;
        try {
            if (gridded1DSet instanceof Gridded1DDoubleSet) {
                Gridded1DDoubleSet gridded1DDoubleSet = (Gridded1DDoubleSet)gridded1DSet;
                this.processGridded1DDoubleSet(setType, gridded1DDoubleSet.getDoubles(), nArray, coordinateSystem, unitArray, errorEstimateArray, gridded1DDoubleSet, object);
                bl = true;
            } else if (gridded1DSet instanceof Integer1DSet) {
                this.processInteger1DSet(setType, nArray, coordinateSystem, unitArray, errorEstimateArray, (Integer1DSet)gridded1DSet, object);
                bl = true;
            } else if (gridded1DSet instanceof Linear1DSet) {
                Linear1DSet linear1DSet = (Linear1DSet)gridded1DSet;
                double[] dArray = new double[]{linear1DSet.getFirst()};
                double[] dArray2 = new double[]{linear1DSet.getLast()};
                this.processLinear1DSet(setType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray, linear1DSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processGridded1DSet(setType, gridded1DSet.getSamples(), gridded1DSet.getLengths(), gridded1DSet.getCoordinateSystem(), gridded1DSet.getSetUnits(), gridded1DSet.getSetErrors(), gridded1DSet, object);
        }
    }

    public abstract void processGridded2DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded2DSet var7, Object var8) throws VisADException;

    private void processGridded2DSet(SetType setType, Gridded2DSet gridded2DSet, Object object) throws VisADException {
        int[] nArray = gridded2DSet.getLengths();
        CoordinateSystem coordinateSystem = gridded2DSet.getCoordinateSystem();
        Unit[] unitArray = gridded2DSet.getSetUnits();
        ErrorEstimate[] errorEstimateArray = gridded2DSet.getSetErrors();
        boolean bl = false;
        try {
            if (gridded2DSet instanceof Gridded2DDoubleSet) {
                Gridded2DDoubleSet gridded2DDoubleSet = (Gridded2DDoubleSet)gridded2DSet;
                this.processGridded2DDoubleSet(setType, gridded2DDoubleSet.getDoubles(), nArray, coordinateSystem, unitArray, errorEstimateArray, gridded2DDoubleSet, object);
                bl = true;
            } else if (gridded2DSet instanceof Integer2DSet) {
                this.processInteger2DSet(setType, nArray, coordinateSystem, unitArray, errorEstimateArray, (Integer2DSet)gridded2DSet, object);
                bl = true;
            } else if (gridded2DSet instanceof Linear2DSet) {
                Linear2DSet linear2DSet = (Linear2DSet)gridded2DSet;
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                int n = 0;
                while (n < 2) {
                    Linear1DSet linear1DSet = linear2DSet.getLinear1DComponent(n);
                    dArray[n] = linear1DSet.getFirst();
                    dArray2[n] = linear1DSet.getLast();
                    ++n;
                }
                if (linear2DSet instanceof LinearLatLonSet) {
                    this.processLinearLatLonSet(setType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray, (LinearLatLonSet)linear2DSet, object);
                } else {
                    this.processLinear2DSet(setType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray, linear2DSet, object);
                }
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processGridded2DSet(setType, gridded2DSet.getSamples(), gridded2DSet.getLengths(), gridded2DSet.getCoordinateSystem(), gridded2DSet.getSetUnits(), gridded2DSet.getSetErrors(), gridded2DSet, object);
        }
    }

    public abstract void processGridded3DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded3DSet var7, Object var8) throws VisADException;

    private void processGridded3DSet(SetType setType, Gridded3DSet gridded3DSet, Object object) throws VisADException {
        int[] nArray = gridded3DSet.getLengths();
        CoordinateSystem coordinateSystem = gridded3DSet.getCoordinateSystem();
        Unit[] unitArray = gridded3DSet.getSetUnits();
        ErrorEstimate[] errorEstimateArray = gridded3DSet.getSetErrors();
        boolean bl = false;
        try {
            if (gridded3DSet instanceof Gridded3DDoubleSet) {
                Gridded3DDoubleSet gridded3DDoubleSet = (Gridded3DDoubleSet)gridded3DSet;
                this.processGridded3DDoubleSet(setType, gridded3DDoubleSet.getDoubles(), nArray, coordinateSystem, unitArray, errorEstimateArray, gridded3DDoubleSet, object);
                bl = true;
            } else if (gridded3DSet instanceof Integer3DSet) {
                this.processInteger3DSet(setType, nArray, coordinateSystem, unitArray, errorEstimateArray, (Integer3DSet)gridded3DSet, object);
                bl = true;
            } else if (gridded3DSet instanceof Linear3DSet) {
                Linear3DSet linear3DSet = (Linear3DSet)gridded3DSet;
                double[] dArray = new double[3];
                double[] dArray2 = new double[3];
                int n = 0;
                while (n < 3) {
                    Linear1DSet linear1DSet = linear3DSet.getLinear1DComponent(n);
                    dArray[n] = linear1DSet.getFirst();
                    dArray2[n] = linear1DSet.getLast();
                    ++n;
                }
                this.processLinear3DSet(setType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray, linear3DSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processGridded3DSet(setType, gridded3DSet.getSamples(), gridded3DSet.getLengths(), gridded3DSet.getCoordinateSystem(), gridded3DSet.getSetUnits(), gridded3DSet.getSetErrors(), gridded3DSet, object);
        }
    }

    public abstract void processGriddedSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, GriddedSet var7, Object var8) throws VisADException;

    private void processGriddedSet(SetType setType, GriddedSet griddedSet, Object object) throws VisADException {
        boolean bl = false;
        try {
            if (griddedSet instanceof Gridded1DSet) {
                this.processGridded1DSet(setType, (Gridded1DSet)griddedSet, object);
                bl = true;
            } else if (griddedSet instanceof Gridded2DSet) {
                this.processGridded2DSet(setType, (Gridded2DSet)griddedSet, object);
                bl = true;
            } else if (griddedSet instanceof Gridded3DSet) {
                this.processGridded3DSet(setType, (Gridded3DSet)griddedSet, object);
                bl = true;
            } else if (griddedSet instanceof LinearNDSet) {
                this.processLinearNDSet(setType, (LinearNDSet)griddedSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processGriddedSet(setType, griddedSet.getSamples(), griddedSet.getLengths(), griddedSet.getCoordinateSystem(), griddedSet.getSetUnits(), griddedSet.getSetErrors(), griddedSet, object);
        }
    }

    public abstract void processInteger1DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer1DSet var6, Object var7) throws VisADException;

    public abstract void processInteger2DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer2DSet var6, Object var7) throws VisADException;

    public abstract void processInteger3DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer3DSet var6, Object var7) throws VisADException;

    public abstract void processIntegerNDSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, IntegerNDSet var6, Object var7) throws VisADException;

    public abstract void processIrregular1DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Irregular1DSet var6, Object var7) throws VisADException;

    public abstract void processIrregular2DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, Irregular2DSet var7, Object var8) throws VisADException;

    public abstract void processIrregular3DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, Irregular3DSet var7, Object var8) throws VisADException;

    public abstract void processIrregularSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, IrregularSet var7, Object var8) throws VisADException;

    private void processIrregularSet(SetType setType, IrregularSet irregularSet, Object object) throws VisADException {
        float[][] fArray = irregularSet.getSamples();
        CoordinateSystem coordinateSystem = irregularSet.getCoordinateSystem();
        Unit[] unitArray = irregularSet.getSetUnits();
        ErrorEstimate[] errorEstimateArray = irregularSet.getSetErrors();
        boolean bl = false;
        try {
            if (irregularSet instanceof Irregular1DSet) {
                this.processIrregular1DSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, (Irregular1DSet)irregularSet, object);
                bl = true;
            } else if (irregularSet instanceof Irregular2DSet) {
                this.processIrregular2DSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, irregularSet.Delan, (Irregular2DSet)irregularSet, object);
                bl = true;
            } else if (irregularSet instanceof Irregular3DSet) {
                this.processIrregular3DSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, irregularSet.Delan, (Irregular3DSet)irregularSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processIrregularSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, irregularSet.Delan, irregularSet, object);
        }
    }

    public abstract void processLinear1DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear1DSet var8, Object var9) throws VisADException;

    public void processLinear1DSet(SetType setType, Linear1DSet linear1DSet, Object object) throws VisADException {
        this.processLinear1DSet(setType, new double[]{linear1DSet.getFirst()}, new double[]{linear1DSet.getLast()}, linear1DSet.getLengths(), linear1DSet.getCoordinateSystem(), linear1DSet.getSetUnits(), linear1DSet.getSetErrors(), linear1DSet, object);
    }

    public abstract void processLinear2DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear2DSet var8, Object var9) throws VisADException;

    public abstract void processLinear3DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear3DSet var8, Object var9) throws VisADException;

    public abstract void processLinearLatLonSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, LinearLatLonSet var8, Object var9) throws VisADException;

    public abstract void processLinearNDSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, LinearNDSet var8, Object var9) throws VisADException;

    private void processLinearNDSet(SetType setType, LinearNDSet linearNDSet, Object object) throws VisADException {
        boolean bl = false;
        try {
            if (linearNDSet instanceof IntegerNDSet) {
                this.processIntegerNDSet(setType, linearNDSet.getLengths(), linearNDSet.getCoordinateSystem(), linearNDSet.getSetUnits(), linearNDSet.getSetErrors(), (IntegerNDSet)linearNDSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processLinearNDSet(setType, linearNDSet.getFirsts(), linearNDSet.getLasts(), linearNDSet.getLengths(), linearNDSet.getCoordinateSystem(), linearNDSet.getSetUnits(), linearNDSet.getSetErrors(), linearNDSet, object);
        }
    }

    public abstract void processList1DSet(SetType var1, float[] var2, CoordinateSystem var3, Unit[] var4, List1DSet var5, Object var6) throws VisADException;

    public abstract void processProductSet(SetType var1, SampledSet[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, ProductSet var6, Object var7) throws VisADException;

    public abstract void processReal(RealType var1, double var2, Unit var4, ErrorEstimate var5, Real var6, Object var7) throws VisADException;

    public abstract void processRealTuple(RealTupleType var1, Real[] var2, CoordinateSystem var3, RealTuple var4, Object var5) throws VisADException;

    public abstract void processSampledSet(SetType var1, int var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, SampledSet var6, Object var7) throws VisADException;

    private void processSampledSet(SetType setType, SampledSet sampledSet, Object object) throws VisADException {
        boolean bl = false;
        try {
            if (sampledSet instanceof GriddedSet) {
                this.processGriddedSet(setType, (GriddedSet)sampledSet, object);
                bl = true;
            } else if (sampledSet instanceof IrregularSet) {
                this.processIrregularSet(setType, (IrregularSet)sampledSet, object);
                bl = true;
            } else if (sampledSet instanceof ProductSet) {
                ProductSet productSet = (ProductSet)sampledSet;
                this.processProductSet(setType, productSet.getSets(), productSet.getCoordinateSystem(), productSet.getSetUnits(), productSet.getSetErrors(), productSet, object);
                bl = true;
            } else if (sampledSet instanceof SingletonSet) {
                SingletonSet singletonSet = (SingletonSet)sampledSet;
                this.processSingletonSet(singletonSet.getData(), singletonSet.getCoordinateSystem(), singletonSet.getSetUnits(), singletonSet.getSetErrors(), singletonSet, object);
                bl = true;
            } else if (sampledSet instanceof UnionSet) {
                UnionSet unionSet = (UnionSet)sampledSet;
                this.processUnionSet(setType, unionSet.getSets(), unionSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processSampledSet(setType, sampledSet.getManifoldDimension(), sampledSet.getCoordinateSystem(), sampledSet.getSetUnits(), sampledSet.getSetErrors(), sampledSet, object);
        }
    }

    public abstract void processSimpleSet(SetType var1, int var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, SimpleSet var6, Object var7) throws VisADException;

    private void processSimpleSet(SetType setType, SimpleSet simpleSet, Object object) throws VisADException {
        boolean bl = false;
        try {
            if (simpleSet instanceof DoubleSet) {
                DoubleSet doubleSet = (DoubleSet)simpleSet;
                this.processDoubleSet(setType, doubleSet.getCoordinateSystem(), doubleSet.getSetUnits(), doubleSet, object);
                bl = true;
            } else if (simpleSet instanceof FloatSet) {
                FloatSet floatSet = (FloatSet)simpleSet;
                this.processFloatSet(setType, floatSet.getCoordinateSystem(), floatSet.getSetUnits(), floatSet, object);
                bl = true;
            } else if (simpleSet instanceof List1DSet) {
                List1DSet list1DSet = (List1DSet)simpleSet;
                float[][] fArray = list1DSet.getSamples();
                this.processList1DSet(setType, fArray[0], list1DSet.getCoordinateSystem(), list1DSet.getSetUnits(), list1DSet, object);
                bl = true;
            }
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        if (!bl) {
            this.processSimpleSet(setType, simpleSet.getManifoldDimension(), simpleSet.getCoordinateSystem(), simpleSet.getSetUnits(), simpleSet.getSetErrors(), simpleSet, object);
        }
    }

    public abstract void processSingletonSet(RealTuple var1, CoordinateSystem var2, Unit[] var3, ErrorEstimate[] var4, SingletonSet var5, Object var6) throws VisADException;

    public abstract void processText(TextType var1, String var2, boolean var3, Text var4, Object var5) throws VisADException;

    public abstract void processTuple(TupleType var1, Data[] var2, Tuple var3, Object var4) throws VisADException;

    public abstract void processUnionSet(SetType var1, SampledSet[] var2, UnionSet var3, Object var4) throws VisADException;

    public abstract void processUnknownData(DataImpl var1, Object var2) throws VisADException;
}

