/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import visad.RemoteReferenceLink;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class ReferenceMonitorEvent
extends MonitorEvent {
    private RemoteReferenceLink link;

    public String getKey() {
        return this.link.toString();
    }

    public RemoteReferenceLink getLink() {
        return this.link;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReferenceMonitorEvent)) {
            return false;
        }
        ReferenceMonitorEvent referenceMonitorEvent = (ReferenceMonitorEvent)object;
        if (this.getType() != referenceMonitorEvent.getType()) {
            return false;
        }
        return this.link.equals(referenceMonitorEvent.link);
    }

    public Object clone() {
        ReferenceMonitorEvent referenceMonitorEvent;
        try {
            referenceMonitorEvent = new ReferenceMonitorEvent(this.getType(), this.getOriginator(), this.link);
            referenceMonitorEvent.seqNum = this.seqNum;
        }
        catch (VisADException visADException) {
            referenceMonitorEvent = null;
        }
        return referenceMonitorEvent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReferenceMonitorEvent[");
        stringBuffer.append('#');
        stringBuffer.append(this.getSequenceNumber());
        stringBuffer.append(' ');
        stringBuffer.append(this.getTypeName());
        int n = this.getOriginator();
        if (n == -1) {
            stringBuffer.append(" Lcl ");
        } else {
            stringBuffer.append(" Rmt ");
            stringBuffer.append(n);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.link);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public ReferenceMonitorEvent(int n, RemoteReferenceLink remoteReferenceLink) throws VisADException {
        this(n, -1, remoteReferenceLink);
    }

    public ReferenceMonitorEvent(int n, int n2, RemoteReferenceLink remoteReferenceLink) throws VisADException {
        super(n, n2);
        if (n != 10 && n != 11) {
            throw new VisADException("Bad type for ReferenceMonitorEvent");
        }
        if (remoteReferenceLink == null) {
            throw new VisADException("Null link for ReferenceMonitorEvent");
        }
        this.link = remoteReferenceLink;
    }
}

