/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.io.Serializable;

public abstract class MonitorEvent
implements Serializable {
    public static final int MAP_ADDED = 1;
    public static final int MAP_CHANGED = 2;
    public static final int MAPS_CLEARED = 3;
    public static final int REFERENCE_ADDED = 10;
    public static final int REFERENCE_REMOVED = 11;
    public static final int CONTROL_INIT_REQUESTED = 20;
    public static final int CONTROL_CHANGED = 21;
    public static final int MESSAGE_SENT = 22;
    private static int nextSeqNum = 0;
    protected int seqNum = nextSeqNum++;
    protected int type;
    private int originator;

    public int getType() {
        return this.type;
    }

    public abstract String getKey();

    public int getOriginator() {
        return this.originator;
    }

    public int getSequenceNumber() {
        return this.seqNum;
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "MAP_ADDED";
            }
            case 2: {
                return "MAP_CHANGED";
            }
            case 3: {
                return "MAPS_CLEARED";
            }
            case 10: {
                return "REFERENCE_ADDED";
            }
            case 11: {
                return "REFERENCE_REMOVED";
            }
            case 20: {
                return "CONTROL_INIT_REQUESTED";
            }
            case 21: {
                return "CONTROL_CHANGED";
            }
        }
        return "Unknown MonitorEvent Type #" + n;
    }

    public String getTypeName() {
        return MonitorEvent.getTypeName(this.type);
    }

    public void setOriginator(int n) {
        this.originator = n;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MonitorEvent[");
        stringBuffer.append('#');
        stringBuffer.append(this.getSequenceNumber());
        stringBuffer.append(' ');
        stringBuffer.append(this.getTypeName());
        if (this.originator == -1) {
            stringBuffer.append(" Lcl");
        } else {
            stringBuffer.append(" Rmt ");
            stringBuffer.append(this.originator);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public MonitorEvent(int n, int n2) {
        this.type = n;
        this.originator = n2;
    }
}

