/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import visad.ConstantMap;
import visad.ScalarMap;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class MapMonitorEvent
extends MonitorEvent {
    private ScalarMap map;

    public String getKey() {
        String string;
        if (this.type == 3) {
            string = "MAPS_CLEARED";
        } else {
            string = this.map.toString();
            switch (this.type) {
                case 1: {
                    string = "ADD " + string;
                    break;
                }
                case 2: {
                    string = "CHG " + string;
                    break;
                }
                default: {
                    System.err.println("MapMonitorEvent type " + this.type + " not handled by getKey()");
                    break;
                }
            }
        }
        return string;
    }

    public ScalarMap getMap() {
        return this.map;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapMonitorEvent)) {
            return false;
        }
        MapMonitorEvent mapMonitorEvent = (MapMonitorEvent)object;
        if (this.getType() != mapMonitorEvent.getType()) {
            return false;
        }
        if (this.map == null) {
            if (mapMonitorEvent.map != null) {
                return false;
            }
        } else {
            if (mapMonitorEvent.map == null) {
                return false;
            }
            if (!this.map.equals(mapMonitorEvent.map)) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        MapMonitorEvent mapMonitorEvent;
        try {
            mapMonitorEvent = new MapMonitorEvent(this.getType(), this.getOriginator(), this.map == null ? null : (ScalarMap)this.map.clone());
            mapMonitorEvent.seqNum = this.seqNum;
        }
        catch (VisADException visADException) {
            mapMonitorEvent = null;
        }
        return mapMonitorEvent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MapMonitorEvent[");
        stringBuffer.append('#');
        stringBuffer.append(this.getSequenceNumber());
        stringBuffer.append(' ');
        stringBuffer.append(this.getTypeName());
        int n = this.getOriginator();
        if (n == -1) {
            stringBuffer.append(" Lcl");
        } else {
            stringBuffer.append(" Rmt ");
            stringBuffer.append(n);
        }
        if (this.map == null) {
            stringBuffer.append(" <null>");
        } else if (this.map instanceof ConstantMap) {
            stringBuffer.append(' ');
            stringBuffer.append(((ConstantMap)this.map).getConstant());
            stringBuffer.append(" -> ");
            stringBuffer.append(this.map.getDisplayScalar());
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(this.map.getScalar());
            stringBuffer.append(" -> ");
            stringBuffer.append(this.map.getDisplayScalar());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public MapMonitorEvent(int n, ScalarMap scalarMap) throws VisADException {
        this(n, -1, scalarMap);
    }

    public MapMonitorEvent(int n, int n2, ScalarMap scalarMap) throws VisADException {
        super(n, n2);
        if (n != 1 && n != 2 && n != 3) {
            throw new VisADException("Bad type " + n);
        }
        if (scalarMap == null && n != 3) {
            throw new VisADException("Null map");
        }
        this.map = scalarMap;
    }
}

