/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import visad.ConstantMap;
import visad.Control;
import visad.DataReference;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLink;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.VisADException;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplaySync;
import visad.collab.MapMonitorEvent;
import visad.collab.MessageMonitorEvent;
import visad.collab.MonitorEvent;
import visad.collab.ReferenceMonitorEvent;
import visad.collab.RemoteEventProvider;

public class DisplaySyncImpl
implements Comparator,
DisplaySync,
Runnable {
    private String Name;
    private DisplayImpl myDisplay;
    private DisplayMonitor monitor;
    private Object mapClearSync = new Object();
    private int mapClearCount = 0;
    private boolean dead = false;
    private Object tableLock = new Object();
    private Thread thisThread = null;
    private HashMap current = new HashMap();
    private HashMap diverted = null;
    private boolean cluster = false;

    private void addLink(RemoteReferenceLink remoteReferenceLink) throws VisADException {
        Object object;
        Object object2;
        if (this.cluster) {
            return;
        }
        ConstantMap[] constantMapArray = null;
        try {
            object2 = remoteReferenceLink.getConstantMapVector();
            int n = ((Vector)object2).size();
            if (n > 0) {
                constantMapArray = new ConstantMap[n];
                int n2 = 0;
                while (n2 < n) {
                    object = (ConstantMap)((Vector)object2).elementAt(n2);
                    constantMapArray[n2] = (ConstantMap)((ConstantMap)object).clone();
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new VisADException("Couldn't copy ConstantMaps for remote DataReference");
        }
        try {
            object2 = remoteReferenceLink.getReference();
        }
        catch (Exception exception) {
            throw new VisADException("Couldn't copy remote DataReference");
        }
        if (object2 != null) {
            Object object3;
            DataRenderer dataRenderer = this.myDisplay.getDisplayRenderer().makeDefaultRenderer();
            String string = dataRenderer.getClass().getName();
            try {
                object3 = remoteReferenceLink.getRendererClassName();
                if (object3 == string) {
                    object = null;
                } else {
                    Object obj = Class.forName((String)object3).newInstance();
                    object = (DataRenderer)obj;
                }
            }
            catch (Exception exception) {
                throw new VisADException("Couldn't copy remote DataRenderer name; using " + string);
            }
            try {
                object3 = new RemoteDisplayImpl(this.myDisplay);
                if (object == null) {
                    ((RemoteDisplayImpl)object3).addReference((DataReference)object2, constantMapArray);
                } else {
                    ((RemoteDisplayImpl)object3).addReferences((DataRenderer)object, (DataReference)object2, constantMapArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new VisADException("Couldn't add remote DataReference " + object2 + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
    }

    public int compare(Object object, Object object2) {
        return ((MonitorEvent)object).getSequenceNumber() - ((MonitorEvent)object2).getSequenceNumber();
    }

    public void destroy() {
        this.monitor = null;
        this.myDisplay = null;
    }

    private ScalarMap findMap(ScalarMap scalarMap) {
        boolean bl;
        Vector vector;
        ScalarMap scalarMap2 = null;
        if (scalarMap instanceof ConstantMap) {
            vector = this.myDisplay.getConstantMapVector();
            bl = true;
        } else {
            vector = this.myDisplay.getMapVector();
            bl = false;
        }
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        while (listIterator.hasNext()) {
            ScalarMap scalarMap3 = (ScalarMap)listIterator.next();
            if (!scalarMap3.equals(scalarMap)) continue;
            scalarMap2 = scalarMap3;
            break;
        }
        return scalarMap2;
    }

    public void eventReady(RemoteEventProvider remoteEventProvider, Object object) {
        Object object2 = this.tableLock;
        synchronized (object2) {
            if (this.thisThread != null) {
                if (this.diverted == null) {
                    this.diverted = new HashMap();
                }
                this.diverted.put(object, remoteEventProvider);
            } else {
                this.current.put(object, remoteEventProvider);
                this.thisThread = new Thread(this);
                this.thisThread.start();
            }
        }
    }

    public String getName() {
        return this.Name;
    }

    public boolean isLocalClear() {
        boolean bl = true;
        Object object = this.mapClearSync;
        synchronized (object) {
            if (this.mapClearCount > 0) {
                --this.mapClearCount;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isThreadRunning() {
        return this.thisThread != null;
    }

    private void processMap(HashMap hashMap) {
        MonitorEvent[] monitorEventArray = new MonitorEvent[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        int n = monitorEventArray.length - 1;
        while (n >= 0) {
            if (iterator.hasNext()) {
                String string = (String)iterator.next();
                monitorEventArray[n] = (MonitorEvent)hashMap.get(string);
            } else {
                monitorEventArray[n] = null;
            }
            --n;
        }
        Arrays.sort(monitorEventArray, this);
        int n2 = 0;
        n = 0;
        while (n < monitorEventArray.length) {
            try {
                this.processOneEvent(monitorEventArray[n]);
                ++n;
            }
            catch (RemoteException remoteException) {
                if (n2++ < 5) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.dead = true;
                break;
            }
            catch (RemoteVisADException remoteVisADException) {
                System.err.println("While processing " + monitorEventArray[n] + ":");
                ++n;
                remoteVisADException.printStackTrace();
            }
        }
    }

    private void processOneEvent(MonitorEvent monitorEvent) throws RemoteException, RemoteVisADException {
        switch (monitorEvent.getType()) {
            case 1: {
                ScalarMap scalarMap = ((MapMonitorEvent)monitorEvent).getMap();
                if (this.findMap(scalarMap) != null) break;
                if (!this.myDisplay.getRendererVector().isEmpty()) {
                    System.err.println("Late addMap: " + scalarMap);
                    break;
                }
                try {
                    this.myDisplay.addMap(scalarMap, monitorEvent.getOriginator());
                    break;
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                    throw new RemoteVisADException("Map " + scalarMap + " not added: " + visADException);
                }
            }
            case 2: {
                double[] dArray;
                ScalarMap scalarMap = ((MapMonitorEvent)monitorEvent).getMap();
                ScalarMap scalarMap2 = this.findMap(scalarMap);
                if (scalarMap2 == null) {
                    throw new RemoteVisADException("ScalarMap " + scalarMap + " not found");
                }
                double[] dArray2 = scalarMap.getRange();
                if (dArray2[0] == (dArray = scalarMap2.getRange())[0] && dArray2[1] == dArray[1]) break;
                try {
                    scalarMap2.setRange(dArray2[0], dArray2[1], monitorEvent.getOriginator());
                    break;
                }
                catch (VisADException visADException) {
                    throw new RemoteVisADException("Map not changed: " + visADException);
                }
            }
            case 3: {
                try {
                    this.myDisplay.removeAllReferences();
                    this.myDisplay.clearMaps();
                    break;
                }
                catch (VisADException visADException) {
                    throw new RemoteVisADException("Maps not cleared: " + visADException);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    throw new RemoteVisADException("Maps not cleared");
                }
            }
            case 10: {
                RemoteReferenceLink remoteReferenceLink = ((ReferenceMonitorEvent)monitorEvent).getLink();
                try {
                    this.addLink(remoteReferenceLink);
                    break;
                }
                catch (VisADException visADException) {
                    throw new RemoteVisADException("DataReference " + remoteReferenceLink + " not found by " + this.Name + ": " + visADException.getMessage());
                }
            }
            case 20: {
                Control control = ((ControlMonitorEvent)monitorEvent).getControl();
                Control control2 = this.myDisplay.getControl(control.getClass(), control.getInstanceNumber());
                if (control2 == null) break;
                try {
                    ControlMonitorEvent controlMonitorEvent = new ControlMonitorEvent(21, (Control)control2.clone());
                    this.monitor.notifyListeners(controlMonitorEvent);
                    break;
                }
                catch (VisADException visADException) {
                    throw new RemoteVisADException("Control " + control + " not changed by " + this.Name + ": " + visADException);
                }
            }
            case 21: {
                Control control = ((ControlMonitorEvent)monitorEvent).getControl();
                Control control3 = this.myDisplay.getControl(control.getClass(), control.getInstanceNumber());
                if (control3 == null || this.monitor.hasEventQueued(monitorEvent.getOriginator(), control3)) break;
                try {
                    control3.syncControl(control);
                    break;
                }
                catch (VisADException visADException) {
                    throw new RemoteVisADException("Control " + control3 + " not changed by " + this.Name + ": " + visADException.getMessage());
                }
            }
            case 22: {
                this.myDisplay.sendMessage(((MessageMonitorEvent)monitorEvent).getMessage());
                break;
            }
            default: {
                throw new RemoteVisADException("Event " + monitorEvent + " not handled");
            }
        }
    }

    private HashMap requestEventTable(HashMap hashMap) throws RemoteException {
        HashMap<String, MonitorEvent> hashMap2 = null;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RemoteEventProvider remoteEventProvider = (RemoteEventProvider)hashMap.get(string);
            iterator.remove();
            MonitorEvent monitorEvent = this.requestOneEvent(string, remoteEventProvider);
            if (monitorEvent == null) continue;
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, MonitorEvent>();
            }
            hashMap2.put(string, monitorEvent);
        }
        return hashMap2;
    }

    private MonitorEvent requestOneEvent(String string, RemoteEventProvider remoteEventProvider) throws RemoteException {
        MonitorEvent monitorEvent;
        try {
            monitorEvent = remoteEventProvider.getEvent(string);
        }
        catch (RemoteVisADException remoteVisADException) {
            remoteVisADException.printStackTrace();
            throw new RemoteException(remoteVisADException.getMessage());
        }
        if (monitorEvent == null) {
            return null;
        }
        switch (monitorEvent.getType()) {
            case 3: {
                Object object = this.mapClearSync;
                synchronized (object) {
                    ++this.mapClearCount;
                    break;
                }
            }
            case 21: {
                boolean bl;
                try {
                    bl = this.monitor.hasEventQueued(monitorEvent.getOriginator(), ((ControlMonitorEvent)monitorEvent).getControl());
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                    bl = false;
                }
                if (!bl) break;
                return null;
            }
        }
        return monitorEvent;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        var2_2 = false;
        try {
            var5_3 = 0;
            while (!var2_2) {
                try {
                    var6_6 = this.requestEventTable(this.current);
                    var2_2 = true;
                }
                catch (RemoteException var7_8) {
                    if (var5_3++ >= 5) {
                        this.dead = true;
                        ** break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException var8_9) {
                        // empty catch block
                    }
                    var6_6 = null;
                }
                if (var1_1 == null) {
                    var1_1 = var6_6;
                } else if (var6_6 != null) {
                    var1_1.putAll(var6_6);
                }
                if (!var2_2) continue;
                var7_7 = this.tableLock;
                synchronized (var7_7) {
                    if (!this.undivertEvents()) {
                        var8_10 = null;
                        ** break;
                    }
                    var2_2 = false;
                }
            }
        }
        catch (Throwable var3_13) {
            var4_12 = null;
            if (var1_1 != null) {
                this.processMap(var1_1);
            }
            var5_5 = this.tableLock;
            synchronized (var5_5) {
                this.thisThread = null;
            }
            throw var3_13;
        }
lbl50:
        // 3 sources

        var4_11 = null;
        if (var1_1 != null) {
            this.processMap(var1_1);
        }
        var5_4 = this.tableLock;
        synchronized (var5_4) {
            this.thisThread = null;
        }
    }

    private boolean undivertEvents() {
        boolean bl;
        Object object = this.tableLock;
        synchronized (object) {
            boolean bl2 = bl = this.diverted != null;
            if (bl) {
                this.current = this.diverted;
                this.diverted = null;
            }
        }
        return bl;
    }

    public DisplaySyncImpl(DisplayImpl displayImpl) throws RemoteException {
        this(displayImpl, false);
    }

    public DisplaySyncImpl(DisplayImpl displayImpl, boolean bl) throws RemoteException {
        this.Name = displayImpl.getName() + ":Sync";
        this.myDisplay = displayImpl;
        this.monitor = displayImpl.getDisplayMonitor();
        this.monitor.setDisplaySync(this);
        this.cluster = bl;
    }
}

