/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import visad.AnimationControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayMapEvent;
import visad.DisplayReferenceEvent;
import visad.MessageEvent;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLinkImpl;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.VisADException;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.collab.MapMonitorEvent;
import visad.collab.MessageMonitorEvent;
import visad.collab.MonitorCallback;
import visad.collab.MonitorEvent;
import visad.collab.MonitorSyncer;
import visad.collab.ReferenceMonitorEvent;
import visad.collab.RemoteDisplayMonitor;
import visad.collab.RemoteDisplaySyncImpl;

public class DisplayMonitorImpl
implements DisplayMonitor {
    private int nextListenerID = 1;
    private String Name;
    private DisplayImpl myDisplay;
    private ArrayList listeners;
    private DisplaySync sync;
    private boolean cluster = false;

    public void addListener(MonitorCallback monitorCallback, int n) throws RemoteException, VisADException {
        MonitorSyncer monitorSyncer = new MonitorSyncer(this.myDisplay.getName(), monitorCallback, n);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(monitorSyncer);
        }
    }

    public void addListener(RemoteDisplay remoteDisplay, int n) throws RemoteException, VisADException {
        MonitorSyncer monitorSyncer = new MonitorSyncer(this.myDisplay.getName(), remoteDisplay, n);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(monitorSyncer);
        }
    }

    public void addRemoteListener(RemoteDisplay remoteDisplay) throws RemoteException, RemoteVisADException {
        RemoteDisplayMonitor remoteDisplayMonitor = remoteDisplay.getRemoteDisplayMonitor();
        int n = this.negotiateUniqueID(remoteDisplayMonitor);
        DisplaySyncImpl displaySyncImpl = (DisplaySyncImpl)this.myDisplay.getDisplaySync();
        RemoteDisplaySyncImpl remoteDisplaySyncImpl = new RemoteDisplaySyncImpl(displaySyncImpl);
        try {
            remoteDisplayMonitor.addListener(new RemoteDisplayImpl(this.myDisplay), n);
        }
        catch (Exception exception) {
            throw new RemoteVisADException("Couldn't make this object a listener for the remote display");
        }
        boolean bl = false;
        try {
            if (!this.cluster) {
                this.addListener(remoteDisplay, n);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.removeListener(remoteDisplaySyncImpl);
            throw new RemoteVisADException("Couldn't add listener for the remote display to this object");
        }
    }

    public int checkID(int n) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            boolean bl = true;
            block3: while (bl) {
                bl = false;
                ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
                while (listIterator.hasNext()) {
                    MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                    if (n != 0 && monitorSyncer.getID() != n) continue;
                    n = this.getNextListenerID();
                    bl = true;
                    continue block3;
                }
            }
        }
        return n;
    }

    public void controlChanged(ControlEvent controlEvent) {
        Object object;
        Control control;
        if (this.myDisplay.hasSlaves()) {
            control = controlEvent.getControl();
            object = control.getSaveString();
            Class<?> clazz = control.getClass();
            Vector vector = this.myDisplay.getControls(clazz);
            int n = -1;
            int n2 = 0;
            while (n2 < vector.size()) {
                Control control2 = (Control)vector.elementAt(n2);
                if (control == control2) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            String string = clazz.getName() + "\n" + n + "\n" + (String)object;
            this.myDisplay.updateSlaves(string);
        }
        if (!this.hasListeners()) {
            return;
        }
        if (controlEvent.getControl() instanceof AnimationControl) {
            return;
        }
        control = (Control)controlEvent.getControl().clone();
        try {
            object = new ControlMonitorEvent(21, controlEvent.getRemoteId(), control);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            object = null;
        }
        if (object != null) {
            this.notifyListeners((MonitorEvent)object);
        }
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        if (!this.hasListeners()) {
            return;
        }
        int n = scalarMapControlEvent.getId();
        if (n == 4 || n == 5) {
            scalarMapControlEvent.getControl().removeControlListener(this);
        }
        if (n == 5 || n == 3) {
            Control control = scalarMapControlEvent.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(control, scalarMapControlEvent.getRemoteId()));
            control.addControlListener(this);
        }
    }

    public void destroy() {
        this.sync = null;
        this.myDisplay.removeDisplayListener(this);
    }

    public void displayChanged(DisplayEvent displayEvent) {
        if (!this.hasListeners()) {
            return;
        }
        switch (displayEvent.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                MapMonitorEvent mapMonitorEvent;
                ScalarMap scalarMap = (ScalarMap)((DisplayMapEvent)displayEvent).getMap().clone();
                try {
                    mapMonitorEvent = new MapMonitorEvent(1, displayEvent.getRemoteId(), scalarMap);
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                    mapMonitorEvent = null;
                }
                if (mapMonitorEvent == null) break;
                this.notifyListeners(mapMonitorEvent);
                break;
            }
            case 12: {
                MapMonitorEvent mapMonitorEvent;
                boolean bl;
                try {
                    bl = this.sync.isLocalClear();
                }
                catch (RemoteException remoteException) {
                    bl = false;
                }
                if (!bl) break;
                try {
                    mapMonitorEvent = new MapMonitorEvent(3, displayEvent.getRemoteId(), null);
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                    mapMonitorEvent = null;
                }
                if (mapMonitorEvent == null) break;
                this.notifyListeners(mapMonitorEvent);
                break;
            }
            case 13: {
                ReferenceMonitorEvent referenceMonitorEvent;
                RemoteReferenceLinkImpl remoteReferenceLinkImpl;
                DataReference dataReference;
                DisplayReferenceEvent displayReferenceEvent = (DisplayReferenceEvent)displayEvent;
                DataDisplayLink dataDisplayLink = displayReferenceEvent.getDataDisplayLink();
                try {
                    dataReference = dataDisplayLink.getDataReference();
                }
                catch (Exception exception) {
                    dataReference = null;
                }
                if (dataReference == null || !(dataReference instanceof DataReferenceImpl)) break;
                try {
                    remoteReferenceLinkImpl = new RemoteReferenceLinkImpl(dataDisplayLink);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                    remoteReferenceLinkImpl = null;
                }
                if (remoteReferenceLinkImpl == null) break;
                try {
                    referenceMonitorEvent = new ReferenceMonitorEvent(10, displayEvent.getRemoteId(), remoteReferenceLinkImpl);
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                    referenceMonitorEvent = null;
                }
                if (referenceMonitorEvent == null) break;
                this.notifyListeners(referenceMonitorEvent);
                break;
            }
            case 15: {
                break;
            }
            default: {
                System.err.println("DisplayMonitorImpl.displayChanged: " + this.Name + " got " + displayEvent.getClass().getName() + " " + displayEvent + "=>" + displayEvent.getDisplay());
                System.exit(1);
                break;
            }
        }
    }

    public int getConnectionID(RemoteDisplay remoteDisplay) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
            while (listIterator.hasNext()) {
                MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                if (!monitorSyncer.isMonitored(remoteDisplay)) continue;
                int n = monitorSyncer.getID();
                Object var3_6 = null;
                return n;
            }
        }
        return 0;
    }

    private int getNextListenerID() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.nextListenerID == 0) {
                ++this.nextListenerID;
            }
            int n = this.nextListenerID++;
            Object var2_3 = null;
            return n;
        }
    }

    public boolean hasEventQueued(Control control) {
        return this.hasEventQueued(0, control, true);
    }

    public boolean hasEventQueued(int n, Control control) {
        return this.hasEventQueued(n, control, false);
    }

    private boolean hasEventQueued(int n, Control control, boolean bl) {
        boolean bl2 = false;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
            while (listIterator.hasNext()) {
                MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                if (!bl && n != monitorSyncer.getID()) continue;
                bl2 = monitorSyncer.hasControlEventQueued(control);
                if (!bl || bl2) break;
            }
        }
        return bl2;
    }

    public boolean isEmpty() {
        boolean bl = true;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
            while (listIterator.hasNext()) {
                MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                if (monitorSyncer.isEmpty()) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        MapMonitorEvent mapMonitorEvent;
        if (!this.hasListeners()) {
            return;
        }
        if (scalarMapEvent.getId() == 1 && this.cluster) {
            return;
        }
        ScalarMap scalarMap = (ScalarMap)scalarMapEvent.getScalarMap().clone();
        try {
            mapMonitorEvent = new MapMonitorEvent(2, scalarMapEvent.getRemoteId(), scalarMap);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            mapMonitorEvent = null;
        }
        if (mapMonitorEvent != null) {
            this.notifyListeners(mapMonitorEvent);
        }
    }

    private int negotiateUniqueID(RemoteDisplayMonitor remoteDisplayMonitor) throws RemoteException, RemoteVisADException {
        int n;
        int n2 = 20;
        int n3 = this.getNextListenerID();
        int n4 = 0;
        do {
            if ((n3 = remoteDisplayMonitor.checkID(n = n3)) == n) continue;
            n = this.checkID(n3);
        } while (n != n3 && ++n4 < 20);
        if (n4 >= 20) {
            throw new RemoteVisADException("ID negotiation failed");
        }
        return n;
    }

    public void notifyListeners(MonitorEvent monitorEvent) {
        int n = monitorEvent.getOriginator();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
            while (listIterator.hasNext()) {
                MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                if (monitorSyncer.isDead()) {
                    this.myDisplay.lostCollabConnection(monitorSyncer.getID());
                    listIterator.remove();
                    continue;
                }
                if (n == monitorSyncer.getID()) continue;
                monitorSyncer.addEvent(monitorEvent);
            }
        }
    }

    public void receiveMessage(MessageEvent messageEvent) {
        MessageMonitorEvent messageMonitorEvent;
        if (!this.hasListeners()) {
            return;
        }
        try {
            messageMonitorEvent = new MessageMonitorEvent(22, messageEvent.getOriginatorId(), messageEvent);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            messageMonitorEvent = null;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            messageMonitorEvent = null;
        }
        if (messageMonitorEvent != null) {
            this.notifyListeners(messageMonitorEvent);
        }
    }

    public void removeListener(MonitorCallback monitorCallback) {
        if (monitorCallback != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                ListIterator listIterator = ((AbstractList)this.listeners).listIterator();
                while (listIterator.hasNext()) {
                    MonitorSyncer monitorSyncer = (MonitorSyncer)listIterator.next();
                    if (!monitorSyncer.getListener().equals(monitorCallback)) continue;
                    listIterator.remove();
                    break;
                }
            }
        }
    }

    public void setDisplaySync(DisplaySync displaySync) {
        this.sync = displaySync;
    }

    public String toString() {
        return this.Name;
    }

    public DisplayMonitorImpl(DisplayImpl displayImpl) {
        this(displayImpl, false);
    }

    public DisplayMonitorImpl(DisplayImpl displayImpl, boolean bl) {
        this.Name = displayImpl.getName() + ":Mon";
        displayImpl.addDisplayListener(this);
        displayImpl.addMessageListener(this);
        this.myDisplay = displayImpl;
        this.listeners = new ArrayList();
        this.cluster = bl;
    }
}

