/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteData;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClientRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.data.netcdf.Plain;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.ss.SSCellData;

public class TestWRFCluster
extends FancySSCell
implements ActionListener {
    private RemoteDataReferenceImpl remote_ref = null;
    int[] res = new int[]{1, 1, 1, 1};

    protected String addData(int n, Data data, ConstantMap[] constantMapArray, String string, int n2, boolean bl) throws VisADException, RemoteException {
        SSCellData sSCellData;
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl(this.Name);
        if (data instanceof RemoteData) {
            this.remote_ref = new RemoteDataReferenceImpl(dataReferenceImpl);
            this.remote_ref.setData(data);
        } else {
            dataReferenceImpl.setData(data);
        }
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.addReferenceImpl(n, dataReferenceImpl, constantMapArray, string, n2, bl, true);
        }
        return sSCellData.getVariableName();
    }

    protected SSCellData addReferenceImpl(int n, DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray, String string, int n2, boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (n == 0) {
            n = this.getFirstFreeId();
        }
        if (dataReferenceImpl == null) {
            dataReferenceImpl = new DataReferenceImpl(this.Name);
        }
        SSCellData sSCellData = new SSCellData(n, this, dataReferenceImpl, constantMapArray, string, n2, bl2);
        this.CellData.add(sSCellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(dataReferenceImpl, constantMapArray);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteDataReferenceImpl = sSCellData.getRemoteReference();
                int n3 = this.Servers.size();
                int n4 = 0;
                while (n4 < n3) {
                    RemoteServerImpl remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n4);
                    remoteServerImpl.addDataReference(remoteDataReferenceImpl);
                    ++n4;
                }
            }
        }
        return sSCellData;
    }

    public synchronized void setMaps(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        if (scalarMapArray == null) {
            return;
        }
        VisADException visADException = null;
        RemoteException remoteException = null;
        if (!this.IsRemote) {
            int n;
            ConstantMap[][] constantMapArray;
            DataReference[] dataReferenceArray;
            Vector vector = this.CellData;
            synchronized (vector) {
                int n2 = this.CellData.size();
                dataReferenceArray = new DataReference[n2];
                constantMapArray = new ConstantMap[n2][];
                n = 0;
                while (n < n2) {
                    SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n);
                    dataReferenceArray[n] = sSCellData.getReference();
                    constantMapArray[n] = sSCellData.getConstantMaps();
                    ++n;
                }
            }
            String string = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            n = 0;
            while (n < scalarMapArray.length) {
                if (scalarMapArray[n] != null) {
                    try {
                        this.VDisplay.addMap(scalarMapArray[n]);
                    }
                    catch (VisADException visADException2) {
                        visADException = visADException2;
                    }
                    catch (RemoteException remoteException2) {
                        remoteException = remoteException2;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < dataReferenceArray.length) {
                boolean bl;
                block19: {
                    bl = false;
                    Data data = dataReferenceArray[n].getData();
                    if (data != null && BasicSSCell.Possible3D) {
                        MathType mathType = data.getType();
                        try {
                            bl = ImageRendererJ3D.isRendererUsable(mathType, scalarMapArray);
                        }
                        catch (VisADException visADException3) {
                            if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) break block19;
                            visADException3.printStackTrace();
                        }
                    }
                }
                if (bl && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dataReferenceArray[n], constantMapArray[n]);
                } else {
                    this.RemoteVDisplay.addReference(this.remote_ref, constantMapArray[n]);
                }
                ++n;
            }
            this.VDisplay.enableAction();
            this.setPartialSaveString(string, true);
        }
        this.HasMappings = true;
        if (visADException != null) {
            throw visADException;
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    public synchronized boolean constructDisplay() {
        boolean bl = true;
        DisplayImpl displayImpl = this.VDisplay;
        RemoteDisplay remoteDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                displayImpl = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                bl = false;
            }
            catch (RemoteException remoteException) {
                if (BasicSSCell.DEBUG) {
                    remoteException.printStackTrace();
                }
                bl = false;
            }
        } else if (!BasicSSCell.CanDo3D && this.Dim != 2) {
            bl = false;
        } else {
            try {
                DisplayRendererJ3D displayRendererJ3D;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        displayImpl = new DisplayImplJ3D(remoteDisplay);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(remoteDisplay);
                    } else {
                        displayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(remoteDisplay, displayRendererJ3D);
                    }
                } else {
                    if (this.Dim == 1) {
                        displayRendererJ3D = new ClientDisplayRendererJ3D(100000L);
                        displayImpl = new DisplayImplJ3D(this.Name, displayRendererJ3D);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(this.Name);
                    } else {
                        displayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(this.Name, displayRendererJ3D);
                    }
                    remoteDisplay = new RemoteDisplayImpl(displayImpl);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (BasicSSCell.DEBUG) {
                    noClassDefFoundError.printStackTrace();
                }
                bl = false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (BasicSSCell.DEBUG) {
                    unsatisfiedLinkError.printStackTrace();
                }
                bl = false;
            }
            catch (Exception exception) {
                if (BasicSSCell.DEBUG) {
                    exception.printStackTrace();
                }
                bl = false;
            }
        }
        if (bl) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!BasicSSCell.DEBUG) break block32;
                        remoteException.printStackTrace();
                    }
                }
            }
            this.VDisplay = displayImpl;
            this.RemoteVDisplay = remoteDisplay;
        }
        return bl;
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException, IOException {
        Object object;
        boolean bl;
        int n = 2;
        int n2 = n * n;
        RemoteNodeField[] remoteNodeFieldArray = new RemoteNodeField[n2];
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("usage: 'java visad.cluster.TestWRFCluster n (file)'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        int n3 = -1;
        try {
            n3 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("usage: 'java visad.cluster.TestWRFCluster n (file)'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        if (n3 < 0 || n3 > n2) {
            System.out.println("usage: 'java visad.cluster.TestWRFCluster n (file)'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        if (n3 > 0 && stringArray.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestWRFCluster n (file)'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        boolean bl2 = bl = n3 == 0;
        if (!bl) {
            Object object2;
            Object object3;
            Plain plain = new Plain();
            FieldImpl fieldImpl = (FieldImpl)plain.open(stringArray[1]);
            if (fieldImpl == null) {
                System.out.println("cannot open " + stringArray[1]);
                return;
            }
            FunctionType functionType = (FunctionType)fieldImpl.getType();
            System.out.println("wrf_type = " + functionType);
            Set set = fieldImpl.getDomainSet();
            int n4 = set.getLength();
            RealTupleType realTupleType = functionType.getDomain();
            RealType realType = (RealType)realTupleType.getComponent(0);
            TupleType tupleType = (TupleType)functionType.getRange();
            FunctionType functionType2 = (FunctionType)tupleType.getComponent(3);
            RealTupleType realTupleType2 = functionType2.getDomain();
            RealTupleType realTupleType3 = (RealTupleType)functionType2.getRange();
            FunctionType functionType3 = (FunctionType)tupleType.getComponent(5);
            RealTupleType realTupleType4 = RealTupleType.SpatialEarth3DTuple;
            FunctionType functionType4 = new FunctionType(realTupleType4, realTupleType3);
            FunctionType functionType5 = new FunctionType(realType, functionType4);
            FieldImpl fieldImpl2 = new FieldImpl(functionType5, set);
            Gridded3DSet gridded3DSet = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl3 = false;
            int n9 = 0;
            while (n9 < n4) {
                Tuple tuple = (Tuple)fieldImpl.getSample(n9);
                object3 = (FlatField)tuple.getComponent(3);
                object2 = (FlatField)tuple.getComponent(5);
                FlatField flatField = (FlatField)tuple.getComponent(6);
                float[][] fArray = flatField.getFloats(false);
                Gridded3DSet gridded3DSet2 = (Gridded3DSet)((FieldImpl)object3).getDomainSet();
                n6 = gridded3DSet2.getLength(0);
                n5 = gridded3DSet2.getLength(1);
                n7 = gridded3DSet2.getLength(2);
                float[][] fArray2 = ((FlatField)object2).getFloats(false);
                float[] fArray3 = fArray2[9];
                float[] fArray4 = fArray2[10];
                if (fArray3.length != n5 * n6) {
                    throw new ClusterException("lats.length = " + fArray3.length + " != " + n5 + " * " + n6);
                }
                float[][] fArray5 = ((FlatField)object3).getFloats(false);
                n8 = n5 * n6 * n7;
                float[][] fArray6 = new float[3][n8];
                fArray6[0] = new float[n8];
                fArray6[1] = new float[n8];
                int n10 = 0;
                while (n10 < n7) {
                    int n11 = n10 * n5 * n6;
                    int n12 = 0;
                    while (n12 < n5 * n6) {
                        fArray6[0][n11 + n12] = fArray4[n12];
                        fArray6[1][n11 + n12] = fArray3[n12];
                        ++n12;
                    }
                    ++n10;
                }
                fArray6[2] = fArray5[11];
                gridded3DSet = new Gridded3DSet(realTupleType4, fArray6, n6, n5, n7, null, null, null, false, false);
                FlatField flatField2 = new FlatField(functionType4, gridded3DSet);
                flatField2.setSamples(fArray5, false);
                fieldImpl2.setSample(n9, (Data)flatField2);
                System.out.println("done with time step " + n9);
                ++n9;
            }
            System.out.println("pid = " + n3);
            RemoteNodeFieldImpl remoteNodeFieldImpl = new RemoteNodeFieldImpl(fieldImpl2);
            int n13 = n3 - 1;
            System.out.println("kk = " + n13);
            object3 = "///TestWRFCluster" + n13;
            try {
                Naming.rebind((String)object3, remoteNodeFieldImpl);
            }
            catch (Exception exception) {
                System.out.println("rebind " + n13 + " " + exception);
                return;
            }
            object2 = new DisplayImplJ2D("dummy");
            System.out.println("data ready as " + functionType5);
            return;
        }
        int n14 = 0;
        while (n14 < n2) {
            object = "///TestWRFCluster" + n14;
            try {
                remoteNodeFieldArray[n14] = (RemoteNodeField)Naming.lookup((String)object);
            }
            catch (Exception exception) {
                System.out.println("lookup " + n14 + " " + exception);
                return;
            }
            ++n14;
        }
        FunctionType functionType = (FunctionType)remoteNodeFieldArray[0].getType();
        System.out.println("data type = " + functionType);
        object = remoteNodeFieldArray[0].getDomainSet();
        RemoteClientFieldImpl remoteClientFieldImpl = new RemoteClientFieldImpl(functionType, (Set)object);
        RemoteClusterData[] remoteClusterDataArray = new RemoteClusterData[n2 + 1];
        int n15 = 0;
        while (n15 < n2) {
            remoteClusterDataArray[n15] = remoteNodeFieldArray[n15];
            ++n15;
        }
        remoteClusterDataArray[n2] = remoteClientFieldImpl;
        n15 = 0;
        while (n15 < remoteClusterDataArray.length) {
            remoteClusterDataArray[n15].setupClusterData(null, remoteClusterDataArray);
            ++n15;
        }
        JFrame jFrame = new JFrame("test ClientRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        TestWRFCluster testWRFCluster = new TestWRFCluster("TestWRFCluster", jFrame);
        testWRFCluster.addData(remoteClientFieldImpl);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton("Maps");
        jButton.addActionListener(testWRFCluster);
        jButton.setActionCommand("map");
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Widgets");
        jButton2.addActionListener(testWRFCluster);
        jButton2.setActionCommand("widgets");
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("Res 1");
        jButton3.addActionListener(testWRFCluster);
        jButton3.setActionCommand("res1");
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton("Res 2");
        jButton4.addActionListener(testWRFCluster);
        jButton4.setActionCommand("res2");
        jPanel2.add(jButton4);
        JButton jButton5 = new JButton("Res 3");
        jButton5.addActionListener(testWRFCluster);
        jButton5.setActionCommand("res3");
        jPanel2.add(jButton5);
        JButton jButton6 = new JButton("Res 4");
        jButton6.addActionListener(testWRFCluster);
        jButton6.setActionCommand("res4");
        jPanel2.add(jButton6);
        jPanel.add(testWRFCluster);
        jPanel.add(jPanel2);
        ((Component)jFrame).setSize(600, 600);
        ((Component)jFrame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("map")) {
            this.hideWidgetFrame();
            this.addMapDialog();
        } else if (string.equals("widgets")) {
            this.showWidgetFrame();
        } else if (string.equals("res1")) {
            this.flipRes(0);
        } else if (string.equals("res2")) {
            this.flipRes(1);
        } else if (string.equals("res3")) {
            this.flipRes(2);
        } else if (string.equals("res4")) {
            this.flipRes(3);
        }
    }

    private void flipRes(int n) {
        this.res[n] = 5 - this.res[n];
        DisplayImpl displayImpl = this.getDisplay();
        Vector vector = displayImpl.getRendererVector();
        int n2 = 0;
        while (n2 < vector.size()) {
            DataRenderer dataRenderer = (DataRenderer)vector.elementAt(n2);
            if (dataRenderer instanceof ClientRendererJ3D) {
                ((ClientRendererJ3D)dataRenderer).setResolutions(this.res);
            }
            ++n2;
        }
        displayImpl.reDisplayAll();
    }

    public TestWRFCluster(String string, Frame frame) throws VisADException, RemoteException {
        super(string, frame);
    }
}

