/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.vis5d.Vis5DForm;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;

public class TestVis5DCluster {
    public static void main(String[] stringArray) throws RemoteException, VisADException, IOException {
        RemoteClusterData[] remoteClusterDataArray;
        int n = 2;
        int n2 = n * n;
        RemoteNodeField[] remoteNodeFieldArray = new RemoteNodeField[n2];
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        int n3 = -1;
        try {
            n3 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        if (n3 < 0 || n3 > n2) {
            System.out.println("usage: 'java visad.cluster.TestVis5DCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        boolean bl = n3 == 0;
        Vis5DForm vis5DForm = new Vis5DForm();
        FieldImpl fieldImpl = (FieldImpl)vis5DForm.open(stringArray[1]);
        if (fieldImpl == null) {
            System.out.println("cannot open " + stringArray[1]);
            return;
        }
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        Set set = fieldImpl.getDomainSet();
        int n4 = set.getLength();
        MathType mathType = functionType.getRange();
        DataImpl dataImpl = (DataImpl)fieldImpl.getSample(0);
        FunctionType functionType2 = null;
        FunctionType functionType3 = null;
        FlatField flatField = null;
        if (mathType instanceof FunctionType) {
            functionType2 = (FunctionType)mathType;
            functionType3 = null;
            flatField = (FlatField)dataImpl;
        } else {
            functionType2 = (FunctionType)((TupleType)mathType).getComponent(0);
            functionType3 = (FunctionType)((TupleType)mathType).getComponent(1);
            flatField = (FlatField)((Tuple)dataImpl).getComponent(0);
        }
        Gridded3DSet gridded3DSet = (Gridded3DSet)flatField.getDomainSet();
        Gridded3DSet gridded3DSet2 = TestVis5DCluster.makePS(gridded3DSet, n);
        if (!bl) {
            int n5;
            int n6;
            System.out.println("v5d_type = " + functionType);
            RealTupleType realTupleType = functionType2.getDomain();
            RealTupleType realTupleType2 = functionType.getDomain();
            RealType realType = (RealType)realTupleType2.getComponent(0);
            RealType realType2 = (RealType)realTupleType.getComponent(0);
            RealType realType3 = (RealType)realTupleType.getComponent(1);
            RealType realType4 = (RealType)realTupleType.getComponent(2);
            RealType realType5 = (RealType)functionType2.getRange();
            RealType realType6 = functionType3 == null ? null : (RealType)functionType3.getRange();
            float[][] fArray = gridded3DSet.getSamples(false);
            int n7 = gridded3DSet.getLength(0);
            int n8 = gridded3DSet.getLength(1);
            int n9 = gridded3DSet.getLength(2);
            int n10 = gridded3DSet.getLength();
            Gridded3DSet[] gridded3DSetArray = new Gridded3DSet[n2];
            int n11 = n3 - 1;
            int n12 = n11 % n;
            int n13 = n12 * n7 / n;
            int n14 = (n12 + 1) * n7 / n;
            if (n12 == n - 1) {
                n14 = n7;
            }
            int n15 = n11 / n;
            int n16 = n15 * n8 / n;
            int n17 = (n15 + 1) * n8 / n;
            if (n15 == n - 1) {
                n17 = n8;
            }
            int n18 = n14 - n13;
            int n19 = n17 - n16;
            int n20 = n18 * n19 * n9;
            float[][] fArray2 = new float[3][n20];
            int n21 = 0;
            while (n21 < n18) {
                n6 = 0;
                while (n6 < n19) {
                    int n22 = 0;
                    while (n22 < n9) {
                        int n23 = n21 + n18 * (n6 + n19 * n22);
                        n5 = n21 + n13 + n7 * (n6 + n16 + n8 * n22);
                        fArray2[0][n23] = fArray[0][n5];
                        fArray2[1][n23] = fArray[1][n5];
                        fArray2[2][n23] = fArray[2][n5];
                        ++n22;
                    }
                    ++n6;
                }
                ++n21;
            }
            gridded3DSetArray[n11] = new Gridded3DSet((MathType)realTupleType, fArray2, n18, n19, n9, gridded3DSet.getCoordinateSystem(), gridded3DSet.getSetUnits(), null);
            Data[] dataArray = new RemoteNodeDataImpl[n4];
            n6 = 0;
            while (n6 < n4) {
                DataImpl dataImpl2;
                DataImpl dataImpl3 = (DataImpl)fieldImpl.getSample(n6);
                if (dataImpl3 instanceof FlatField) {
                    dataImpl2 = (FlatField)dataImpl3;
                    FlatField flatField2 = (FlatField)((FunctionImpl)dataImpl2).resample(gridded3DSetArray[n11]);
                    dataArray[n6] = new RemoteNodePartitionedFieldImpl(flatField2);
                } else {
                    dataImpl2 = (Tuple)dataImpl3;
                    n5 = ((Tuple)dataImpl2).getDimension();
                    RemoteNodeDataImpl[] remoteNodeDataImplArray = new RemoteNodeDataImpl[n5];
                    Field[] fieldArray = new FlatField[n5];
                    int n24 = 0;
                    while (n24 < n5) {
                        FlatField flatField3 = (FlatField)((Tuple)dataImpl2).getComponent(n24);
                        fieldArray[n24] = (FlatField)flatField3.resample(gridded3DSetArray[n11]);
                        ++n24;
                    }
                    FlatField flatField4 = (FlatField)FieldImpl.combine(fieldArray);
                    dataArray[n6] = new RemoteNodePartitionedFieldImpl(flatField4);
                }
                ++n6;
            }
            FunctionType functionType4 = new FunctionType(realTupleType2, dataArray[0].getType());
            remoteNodeFieldArray[n11] = new RemoteNodeFieldImpl(functionType4, set);
            remoteNodeFieldArray[n11].setSamples(dataArray, false);
            int n25 = n3 - 1;
            String string = "///TestVis5DCluster" + n25;
            try {
                Naming.rebind(string, remoteNodeFieldArray[n25]);
            }
            catch (Exception exception) {
                System.out.println("rebind " + n25 + " " + exception);
                return;
            }
            DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("dummy");
            System.out.println("data ready as " + functionType4);
            return;
        }
        int n26 = 0;
        while (n26 < n2) {
            remoteClusterDataArray = "///TestVis5DCluster" + n26;
            try {
                remoteNodeFieldArray[n26] = (RemoteNodeField)Naming.lookup((String)remoteClusterDataArray);
            }
            catch (Exception exception) {
                System.out.println("lookup " + n26 + " " + exception);
                return;
            }
            ++n26;
        }
        functionType = (FunctionType)remoteNodeFieldArray[0].getType();
        System.out.println("data type = " + functionType);
        set = remoteNodeFieldArray[0].getDomainSet();
        RemoteClientFieldImpl remoteClientFieldImpl = new RemoteClientFieldImpl(functionType, set);
        remoteClusterDataArray = new RemoteClusterData[n2 + 1];
        int n27 = 0;
        while (n27 < n2) {
            remoteClusterDataArray[n27] = remoteNodeFieldArray[n27];
            ++n27;
        }
        remoteClusterDataArray[n2] = remoteClientFieldImpl;
        n27 = 0;
        while (n27 < remoteClusterDataArray.length) {
            remoteClusterDataArray[n27].setupClusterData(gridded3DSet2, remoteClusterDataArray);
            ++n27;
        }
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("main_display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D(100000L));
        functionType2 = (FunctionType)functionType.getRange();
        RealTupleType realTupleType = functionType2.getDomain();
        RealTupleType realTupleType3 = functionType.getDomain();
        RealType realType = (RealType)realTupleType3.getComponent(0);
        RealType realType7 = (RealType)realTupleType.getComponent(0);
        RealType realType8 = (RealType)realTupleType.getComponent(1);
        RealType realType9 = (RealType)realTupleType.getComponent(2);
        RealTupleType realTupleType4 = (RealTupleType)functionType2.getRange();
        int n28 = realTupleType4.getDimension();
        RealType[] realTypeArray = new RealType[n28];
        int n29 = 0;
        while (n29 < n28) {
            realTypeArray[n29] = (RealType)realTupleType4.getComponent(n29);
            ++n29;
        }
        ScalarMap scalarMap = new ScalarMap(realType, Display.Animation);
        displayImplJ3D.addMap(scalarMap);
        displayImplJ3D.addMap(new ScalarMap(realType7, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(realType8, Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap(realType9, Display.ZAxis));
        ScalarMap[] scalarMapArray = new ScalarMap[n28];
        int n30 = 0;
        while (n30 < n28) {
            scalarMapArray[n30] = new ScalarMap(realTypeArray[n30], Display.IsoContour);
            displayImplJ3D.addMap(scalarMapArray[n30]);
            ++n30;
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("image");
        RemoteDataReferenceImpl remoteDataReferenceImpl = new RemoteDataReferenceImpl(dataReferenceImpl);
        remoteDataReferenceImpl.setData(remoteClientFieldImpl);
        RemoteDisplayImpl remoteDisplayImpl = new RemoteDisplayImpl(displayImplJ3D);
        remoteDisplayImpl.addReference(remoteDataReferenceImpl);
        JFrame jFrame = new JFrame("test ClientRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(displayImplJ3D.getComponent());
        AnimationWidget animationWidget = new AnimationWidget(scalarMap);
        animationWidget.setMaximumSize(new Dimension(400, 400));
        jPanel2.add(new AnimationWidget(scalarMap));
        int n31 = 0;
        while (n31 < n28) {
            ContourWidget contourWidget = new ContourWidget(scalarMapArray[n31]);
            contourWidget.setMaximumSize(new Dimension(400, 200));
            jPanel2.add(new ContourWidget(scalarMapArray[n31]));
            ++n31;
        }
        jPanel2.setMaximumSize(new Dimension(400, 600));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        ((Component)jFrame).setSize(800, 600);
        ((Component)jFrame).setVisible(true);
    }

    private static Gridded3DSet makePS(Gridded3DSet gridded3DSet, int n) throws VisADException {
        int n2 = n * n;
        int n3 = gridded3DSet.getLength(0);
        int n4 = gridded3DSet.getLength(1);
        int n5 = gridded3DSet.getLength(2);
        int n6 = gridded3DSet.getLength();
        float[][] fArray = gridded3DSet.getSamples(false);
        float[][] fArray2 = new float[3][n2];
        int n7 = 0;
        while (n7 < n) {
            int n8 = n7 * (n3 - 1) / (n - 1);
            int n9 = 0;
            while (n9 < n) {
                int n10 = n9 * (n4 - 1) / (n - 1);
                int n11 = n7 + n * n9;
                int n12 = n8 + n3 * (n10 + n4 * (n5 / 2));
                fArray2[0][n11] = fArray[0][n12];
                fArray2[1][n11] = fArray[1][n12];
                fArray2[2][n11] = fArray[2][n12];
                ++n9;
            }
            ++n7;
        }
        Gridded3DSet gridded3DSet2 = new Gridded3DSet(gridded3DSet.getType(), fArray2, n, n, 1, gridded3DSet.getCoordinateSystem(), gridded3DSet.getSetUnits(), null);
        return gridded3DSet2;
    }
}

