/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteData;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClientRendererJ3D;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.vis5d.Vis5DForm;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.ss.SSCellData;

public class TestSSCluster
extends FancySSCell
implements ActionListener {
    private RemoteDataReferenceImpl remote_ref = null;
    int[] res = new int[]{1, 1, 1, 1};

    protected String addData(int n, Data data, ConstantMap[] constantMapArray, String string, int n2, boolean bl) throws VisADException, RemoteException {
        SSCellData sSCellData;
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl(this.Name);
        if (data instanceof RemoteData) {
            this.remote_ref = new RemoteDataReferenceImpl(dataReferenceImpl);
            this.remote_ref.setData(data);
        } else {
            dataReferenceImpl.setData(data);
        }
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.addReferenceImpl(n, dataReferenceImpl, constantMapArray, string, n2, bl, true);
        }
        return sSCellData.getVariableName();
    }

    protected SSCellData addReferenceImpl(int n, DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray, String string, int n2, boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (n == 0) {
            n = this.getFirstFreeId();
        }
        if (dataReferenceImpl == null) {
            dataReferenceImpl = new DataReferenceImpl(this.Name);
        }
        SSCellData sSCellData = new SSCellData(n, this, dataReferenceImpl, constantMapArray, string, n2, bl2);
        this.CellData.add(sSCellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(dataReferenceImpl, constantMapArray);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteDataReferenceImpl = sSCellData.getRemoteReference();
                int n3 = this.Servers.size();
                int n4 = 0;
                while (n4 < n3) {
                    RemoteServerImpl remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n4);
                    remoteServerImpl.addDataReference(remoteDataReferenceImpl);
                    ++n4;
                }
            }
        }
        return sSCellData;
    }

    public synchronized void setMaps(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        if (scalarMapArray == null) {
            return;
        }
        VisADException visADException = null;
        RemoteException remoteException = null;
        if (!this.IsRemote) {
            int n;
            ConstantMap[][] constantMapArray;
            DataReference[] dataReferenceArray;
            Vector vector = this.CellData;
            synchronized (vector) {
                int n2 = this.CellData.size();
                dataReferenceArray = new DataReference[n2];
                constantMapArray = new ConstantMap[n2][];
                n = 0;
                while (n < n2) {
                    SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n);
                    dataReferenceArray[n] = sSCellData.getReference();
                    constantMapArray[n] = sSCellData.getConstantMaps();
                    ++n;
                }
            }
            String string = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            n = 0;
            while (n < scalarMapArray.length) {
                if (scalarMapArray[n] != null) {
                    try {
                        this.VDisplay.addMap(scalarMapArray[n]);
                    }
                    catch (VisADException visADException2) {
                        visADException = visADException2;
                    }
                    catch (RemoteException remoteException2) {
                        remoteException = remoteException2;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < dataReferenceArray.length) {
                boolean bl;
                block19: {
                    bl = false;
                    Data data = dataReferenceArray[n].getData();
                    if (data != null && BasicSSCell.Possible3D) {
                        MathType mathType = data.getType();
                        try {
                            bl = ImageRendererJ3D.isRendererUsable(mathType, scalarMapArray);
                        }
                        catch (VisADException visADException3) {
                            if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) break block19;
                            visADException3.printStackTrace();
                        }
                    }
                }
                if (bl && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dataReferenceArray[n], constantMapArray[n]);
                } else {
                    this.RemoteVDisplay.addReference(this.remote_ref, constantMapArray[n]);
                }
                ++n;
            }
            this.VDisplay.enableAction();
            this.setPartialSaveString(string, true);
        }
        this.HasMappings = true;
        if (visADException != null) {
            throw visADException;
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    public synchronized boolean constructDisplay() {
        boolean bl = true;
        DisplayImpl displayImpl = this.VDisplay;
        RemoteDisplay remoteDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                displayImpl = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                bl = false;
            }
            catch (RemoteException remoteException) {
                if (BasicSSCell.DEBUG) {
                    remoteException.printStackTrace();
                }
                bl = false;
            }
        } else if (!BasicSSCell.CanDo3D && this.Dim != 2) {
            bl = false;
        } else {
            try {
                DisplayRendererJ3D displayRendererJ3D;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        displayImpl = new DisplayImplJ3D(remoteDisplay);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(remoteDisplay);
                    } else {
                        displayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(remoteDisplay, displayRendererJ3D);
                    }
                } else {
                    if (this.Dim == 1) {
                        displayRendererJ3D = new ClientDisplayRendererJ3D(100000L);
                        displayImpl = new DisplayImplJ3D(this.Name, displayRendererJ3D);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(this.Name);
                    } else {
                        displayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(this.Name, displayRendererJ3D);
                    }
                    remoteDisplay = new RemoteDisplayImpl(displayImpl);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (BasicSSCell.DEBUG) {
                    noClassDefFoundError.printStackTrace();
                }
                bl = false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (BasicSSCell.DEBUG) {
                    unsatisfiedLinkError.printStackTrace();
                }
                bl = false;
            }
            catch (Exception exception) {
                if (BasicSSCell.DEBUG) {
                    exception.printStackTrace();
                }
                bl = false;
            }
        }
        if (bl) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!BasicSSCell.DEBUG) break block32;
                        remoteException.printStackTrace();
                    }
                }
            }
            this.VDisplay = displayImpl;
            this.RemoteVDisplay = remoteDisplay;
        }
        return bl;
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException, IOException {
        RemoteClusterData[] remoteClusterDataArray;
        int n = 2;
        int n2 = n * n;
        RemoteNodeField[] remoteNodeFieldArray = new RemoteNodeField[n2];
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        int n3 = -1;
        try {
            n3 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        if (n3 < 0 || n3 > n2) {
            System.out.println("usage: 'java visad.cluster.TestSSCluster n file.v5d'");
            System.out.println("  where n = 0 for client, 1 - " + n2 + " for nodes");
            return;
        }
        boolean bl = n3 == 0;
        Vis5DForm vis5DForm = new Vis5DForm();
        FieldImpl fieldImpl = (FieldImpl)vis5DForm.open(stringArray[1]);
        if (fieldImpl == null) {
            System.out.println("cannot open " + stringArray[1]);
            return;
        }
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        Set set = fieldImpl.getDomainSet();
        int n4 = set.getLength();
        MathType mathType = functionType.getRange();
        DataImpl dataImpl = (DataImpl)fieldImpl.getSample(0);
        FunctionType functionType2 = null;
        FunctionType functionType3 = null;
        FlatField flatField = null;
        if (mathType instanceof FunctionType) {
            functionType2 = (FunctionType)mathType;
            functionType3 = null;
            flatField = (FlatField)dataImpl;
        } else {
            functionType2 = (FunctionType)((TupleType)mathType).getComponent(0);
            functionType3 = (FunctionType)((TupleType)mathType).getComponent(1);
            flatField = (FlatField)((Tuple)dataImpl).getComponent(0);
        }
        Gridded3DSet gridded3DSet = (Gridded3DSet)flatField.getDomainSet();
        Gridded3DSet gridded3DSet2 = TestSSCluster.makePS(gridded3DSet, n);
        if (!bl) {
            int n5;
            int n6;
            System.out.println("v5d_type = " + functionType);
            RealTupleType realTupleType = functionType2.getDomain();
            RealTupleType realTupleType2 = functionType.getDomain();
            RealType realType = (RealType)realTupleType2.getComponent(0);
            RealType realType2 = (RealType)realTupleType.getComponent(0);
            RealType realType3 = (RealType)realTupleType.getComponent(1);
            RealType realType4 = (RealType)realTupleType.getComponent(2);
            RealType realType5 = (RealType)functionType2.getRange();
            RealType realType6 = functionType3 == null ? null : (RealType)functionType3.getRange();
            float[][] fArray = gridded3DSet.getSamples(false);
            int n7 = gridded3DSet.getLength(0);
            int n8 = gridded3DSet.getLength(1);
            int n9 = gridded3DSet.getLength(2);
            int n10 = gridded3DSet.getLength();
            Gridded3DSet[] gridded3DSetArray = new Gridded3DSet[n2];
            int n11 = n3 - 1;
            int n12 = n11 % n;
            int n13 = n12 * n7 / n;
            int n14 = (n12 + 1) * n7 / n;
            if (n12 == n - 1) {
                n14 = n7;
            }
            int n15 = n11 / n;
            int n16 = n15 * n8 / n;
            int n17 = (n15 + 1) * n8 / n;
            if (n15 == n - 1) {
                n17 = n8;
            }
            int n18 = n14 - n13;
            int n19 = n17 - n16;
            int n20 = n18 * n19 * n9;
            float[][] fArray2 = new float[3][n20];
            int n21 = 0;
            while (n21 < n18) {
                n6 = 0;
                while (n6 < n19) {
                    int n22 = 0;
                    while (n22 < n9) {
                        int n23 = n21 + n18 * (n6 + n19 * n22);
                        n5 = n21 + n13 + n7 * (n6 + n16 + n8 * n22);
                        fArray2[0][n23] = fArray[0][n5];
                        fArray2[1][n23] = fArray[1][n5];
                        fArray2[2][n23] = fArray[2][n5];
                        ++n22;
                    }
                    ++n6;
                }
                ++n21;
            }
            gridded3DSetArray[n11] = new Gridded3DSet((MathType)realTupleType, fArray2, n18, n19, n9, gridded3DSet.getCoordinateSystem(), gridded3DSet.getSetUnits(), null);
            Data[] dataArray = new RemoteNodeDataImpl[n4];
            n6 = 0;
            while (n6 < n4) {
                DataImpl dataImpl2;
                DataImpl dataImpl3 = (DataImpl)fieldImpl.getSample(n6);
                if (dataImpl3 instanceof FlatField) {
                    dataImpl2 = (FlatField)dataImpl3;
                    FlatField flatField2 = (FlatField)((FunctionImpl)dataImpl2).resample(gridded3DSetArray[n11]);
                    dataArray[n6] = new RemoteNodePartitionedFieldImpl(flatField2);
                } else {
                    dataImpl2 = (Tuple)dataImpl3;
                    n5 = ((Tuple)dataImpl2).getDimension();
                    RemoteNodeDataImpl[] remoteNodeDataImplArray = new RemoteNodeDataImpl[n5];
                    Field[] fieldArray = new FlatField[n5];
                    int n24 = 0;
                    while (n24 < n5) {
                        FlatField flatField3 = (FlatField)((Tuple)dataImpl2).getComponent(n24);
                        fieldArray[n24] = (FlatField)flatField3.resample(gridded3DSetArray[n11]);
                        ++n24;
                    }
                    FlatField flatField4 = (FlatField)FieldImpl.combine(fieldArray);
                    dataArray[n6] = new RemoteNodePartitionedFieldImpl(flatField4);
                }
                ++n6;
            }
            FunctionType functionType4 = new FunctionType(realTupleType2, dataArray[0].getType());
            remoteNodeFieldArray[n11] = new RemoteNodeFieldImpl(functionType4, set);
            remoteNodeFieldArray[n11].setSamples(dataArray, false);
            int n25 = n3 - 1;
            String string = "///TestVis5DCluster" + n25;
            try {
                Naming.rebind(string, remoteNodeFieldArray[n25]);
            }
            catch (Exception exception) {
                System.out.println("rebind " + n25 + " " + exception);
                return;
            }
            DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("dummy");
            System.out.println("data ready as " + functionType4);
            return;
        }
        int n26 = 0;
        while (n26 < n2) {
            remoteClusterDataArray = "///TestVis5DCluster" + n26;
            try {
                remoteNodeFieldArray[n26] = (RemoteNodeField)Naming.lookup((String)remoteClusterDataArray);
            }
            catch (Exception exception) {
                System.out.println("lookup " + n26 + " " + exception);
                return;
            }
            ++n26;
        }
        functionType = (FunctionType)remoteNodeFieldArray[0].getType();
        System.out.println("data type = " + functionType);
        set = remoteNodeFieldArray[0].getDomainSet();
        RemoteClientFieldImpl remoteClientFieldImpl = new RemoteClientFieldImpl(functionType, set);
        remoteClusterDataArray = new RemoteClusterData[n2 + 1];
        int n27 = 0;
        while (n27 < n2) {
            remoteClusterDataArray[n27] = remoteNodeFieldArray[n27];
            ++n27;
        }
        remoteClusterDataArray[n2] = remoteClientFieldImpl;
        n27 = 0;
        while (n27 < remoteClusterDataArray.length) {
            remoteClusterDataArray[n27].setupClusterData(gridded3DSet2, remoteClusterDataArray);
            ++n27;
        }
        JFrame jFrame = new JFrame("test ClientRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        TestSSCluster testSSCluster = new TestSSCluster("TestSSCluster", jFrame);
        testSSCluster.addData(remoteClientFieldImpl);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton("Maps");
        jButton.addActionListener(testSSCluster);
        jButton.setActionCommand("map");
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Widgets");
        jButton2.addActionListener(testSSCluster);
        jButton2.setActionCommand("widgets");
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("Res 1");
        jButton3.addActionListener(testSSCluster);
        jButton3.setActionCommand("res1");
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton("Res 2");
        jButton4.addActionListener(testSSCluster);
        jButton4.setActionCommand("res2");
        jPanel2.add(jButton4);
        JButton jButton5 = new JButton("Res 3");
        jButton5.addActionListener(testSSCluster);
        jButton5.setActionCommand("res3");
        jPanel2.add(jButton5);
        JButton jButton6 = new JButton("Res 4");
        jButton6.addActionListener(testSSCluster);
        jButton6.setActionCommand("res4");
        jPanel2.add(jButton6);
        jPanel.add(testSSCluster);
        jPanel.add(jPanel2);
        ((Component)jFrame).setSize(600, 600);
        ((Component)jFrame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("map")) {
            this.hideWidgetFrame();
            this.addMapDialog();
        } else if (string.equals("widgets")) {
            this.showWidgetFrame();
        } else if (string.equals("res1")) {
            this.flipRes(0);
        } else if (string.equals("res2")) {
            this.flipRes(1);
        } else if (string.equals("res3")) {
            this.flipRes(2);
        } else if (string.equals("res4")) {
            this.flipRes(3);
        }
    }

    private void flipRes(int n) {
        this.res[n] = 5 - this.res[n];
        DisplayImpl displayImpl = this.getDisplay();
        Vector vector = displayImpl.getRendererVector();
        int n2 = 0;
        while (n2 < vector.size()) {
            DataRenderer dataRenderer = (DataRenderer)vector.elementAt(n2);
            if (dataRenderer instanceof ClientRendererJ3D) {
                ((ClientRendererJ3D)dataRenderer).setResolutions(this.res);
            }
            ++n2;
        }
        displayImpl.reDisplayAll();
    }

    private static Gridded3DSet makePS(Gridded3DSet gridded3DSet, int n) throws VisADException {
        int n2 = n * n;
        int n3 = gridded3DSet.getLength(0);
        int n4 = gridded3DSet.getLength(1);
        int n5 = gridded3DSet.getLength(2);
        int n6 = gridded3DSet.getLength();
        float[][] fArray = gridded3DSet.getSamples(false);
        float[][] fArray2 = new float[3][n2];
        int n7 = 0;
        while (n7 < n) {
            int n8 = n7 * (n3 - 1) / (n - 1);
            int n9 = 0;
            while (n9 < n) {
                int n10 = n9 * (n4 - 1) / (n - 1);
                int n11 = n7 + n * n9;
                int n12 = n8 + n3 * (n10 + n4 * (n5 / 2));
                fArray2[0][n11] = fArray[0][n12];
                fArray2[1][n11] = fArray[1][n12];
                fArray2[2][n11] = fArray[2][n12];
                ++n9;
            }
            ++n7;
        }
        Gridded3DSet gridded3DSet2 = new Gridded3DSet(gridded3DSet.getType(), fArray2, n, n, 1, gridded3DSet.getCoordinateSystem(), gridded3DSet.getSetUnits(), null);
        return gridded3DSet2;
    }

    public TestSSCluster(String string, Frame frame) throws VisADException, RemoteException {
        super(string, frame);
    }
}

