/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataShadow;
import visad.Field;
import visad.FieldImpl;
import visad.Function;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;

public class RemoteNodeFieldImpl
extends RemoteNodeDataImpl
implements RemoteNodeField {
    private Field adaptedField = null;
    private int length;

    public void setSamples(RemoteNodeDataImpl[] remoteNodeDataImplArray) throws VisADException, RemoteException {
        this.setSamples(remoteNodeDataImplArray, false);
    }

    public void setSamples(Data[] dataArray, boolean bl) throws VisADException, RemoteException {
        if (dataArray == null) {
            throw new ClusterException("range cannot be null");
        }
        if (dataArray.length != this.length) {
            throw new ClusterException("range length must match set length");
        }
        int n = 0;
        while (n < dataArray.length) {
            if (!(dataArray[n] instanceof RemoteNodeDataImpl)) {
                throw new ClusterException("range values must be RemoteNodeDataImpl");
            }
            ++n;
        }
        this.adaptedField.setSamples(dataArray, false);
        n = 0;
        while (n < this.length) {
            ((RemoteNodeDataImpl)dataArray[n]).setParent(this);
            ++n;
        }
    }

    public void setSamples(double[][] dArray) throws VisADException, RemoteException {
        throw new ClusterException("no setSamples(double[][]) method");
    }

    public void setSamples(float[][] fArray) throws VisADException, RemoteException {
        throw new ClusterException("no setSamples(float[][]) method");
    }

    public MathType getType() throws VisADException, RemoteException {
        return this.adaptedField.getType();
    }

    public boolean isMissing() throws VisADException, RemoteException {
        return this.adaptedField.isMissing();
    }

    public int getDomainDimension() throws VisADException, RemoteException {
        return this.adaptedField.getDomainDimension();
    }

    public Set getDomainSet() throws VisADException, RemoteException {
        return this.adaptedField.getDomainSet();
    }

    public int getLength() throws RemoteException {
        return this.length;
    }

    public Unit[] getDomainUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDomainUnits();
    }

    public CoordinateSystem getDomainCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getDomainCoordinateSystem();
    }

    public Data getSample(int n) throws VisADException, RemoteException {
        return this.adaptedField.getSample(n);
    }

    public void setSample(RealTuple realTuple, Data data, boolean bl) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    public void setSample(RealTuple realTuple, Data data) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    public void setSample(int n, Data data, boolean bl) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    public void setSample(int n, Data data) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    public Field extract(int n) throws VisADException, RemoteException {
        throw new ClusterException("no extract() method");
    }

    public Field domainMultiply() throws VisADException, RemoteException {
        throw new ClusterException("no domainMultiply() method");
    }

    public Field domainMultiply(int n) throws VisADException, RemoteException {
        throw new ClusterException("no domainMultiply() method");
    }

    public Field domainFactor(RealType realType) throws VisADException, RemoteException {
        throw new ClusterException("no domainFactor() method");
    }

    public double[][] getValues() throws VisADException, RemoteException {
        return this.adaptedField.getValues();
    }

    public double[][] getValues(boolean bl) throws VisADException, RemoteException {
        return this.adaptedField.getValues(bl);
    }

    public float[][] getFloats() throws VisADException, RemoteException {
        return this.adaptedField.getFloats();
    }

    public float[][] getFloats(boolean bl) throws VisADException, RemoteException {
        return this.adaptedField.getFloats(bl);
    }

    public String[][] getStringValues() throws VisADException, RemoteException {
        return this.adaptedField.getStringValues();
    }

    public Unit[] getDefaultRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDefaultRangeUnits();
    }

    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getRangeUnits();
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem();
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int n) throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem(n);
    }

    public boolean isFlatField() throws VisADException, RemoteException {
        return false;
    }

    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return this.adaptedField.domainEnumeration();
    }

    public Data evaluate(Real real) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    public Data evaluate(Real real, int n, int n2) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    public Data evaluate(RealTuple realTuple) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    public Data evaluate(RealTuple realTuple, int n, int n2) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    public Field resample(Set set) throws VisADException, RemoteException {
        throw new ClusterException("no resample() method");
    }

    public Field resample(Set set, int n, int n2) throws VisADException, RemoteException {
        throw new ClusterException("no resample() method");
    }

    public Data derivative(RealTuple realTuple, RealType[] realTypeArray, MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    public Data derivative(int n) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    public Data derivative(MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    public Function derivative(RealType realType, int n) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    public Function derivative(RealType realType, MathType mathType, int n) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(shadowType, dataShadow);
    }

    public DataShadow computeRanges(ShadowType shadowType, int n) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(shadowType, n);
    }

    public double[][] computeRanges(RealType[] realTypeArray) throws VisADException, RemoteException {
        throw new ClusterException("no computeRanges(RealType[]) method");
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        return this.adaptedField.adjustSamplingError(data, n);
    }

    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    public String longString(String string) throws VisADException, RemoteException {
        return string + "RemoteNodeFieldImpl";
    }

    public RemoteNodeFieldImpl(FunctionType functionType, Set set) throws VisADException, RemoteException {
        if (functionType == null) {
            throw new ClusterException("type cannot be null");
        }
        if (set == null) {
            throw new ClusterException("set cannot be null");
        }
        this.adaptedField = new FieldImpl(functionType, set);
        this.length = set.getLength();
    }

    public RemoteNodeFieldImpl(FieldImpl fieldImpl) throws VisADException, RemoteException {
        if (fieldImpl == null) {
            throw new ClusterException("field cannot be null");
        }
        this.adaptedField = fieldImpl;
    }
}

