/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RemoteDataImpl;
import visad.RemoteThingImpl;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ThingImpl;
import visad.ThingReference;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientTupleImpl;
import visad.cluster.RemoteClusterData;

public abstract class RemoteClusterDataImpl
extends RemoteDataImpl
implements RemoteClusterData {
    private Set partitionSet = null;
    private int dimension = -1;
    private RemoteClusterData[] jvmTable = null;
    private RemoteClusterData me = null;
    private RemoteClusterDataImpl parent = null;
    private ThingImpl adaptedThingImpl = new ThingImpl();
    private RemoteThingImpl adaptedRemoteThingImpl = new RemoteThingImpl(this.adaptedThingImpl);

    RemoteClusterData[] getTable() {
        return this.jvmTable;
    }

    public RemoteClusterData getClusterData(RealTuple realTuple) throws RemoteException, VisADException {
        CoordinateSystem coordinateSystem;
        RealTupleType realTupleType;
        CoordinateSystem coordinateSystem2;
        if (realTuple == null || this.partitionSet == null || this.jvmTable == null) {
            throw new ClusterException("null domain or setup not done");
        }
        if (this.dimension != realTuple.getDimension()) {
            return this.jvmTable[this.jvmTable.length - 1];
        }
        double[][] dArray = new double[this.dimension][1];
        int n = 0;
        while (n < this.dimension) {
            dArray[n][0] = ((Real)realTuple.getComponent(n)).getValue();
            ++n;
        }
        RealTupleType realTupleType2 = ((SetType)this.partitionSet.getType()).getDomain();
        if (!CoordinateSystem.canConvert(realTupleType2, coordinateSystem2 = this.partitionSet.getCoordinateSystem(), realTupleType = (RealTupleType)realTuple.getType(), coordinateSystem = realTuple.getCoordinateSystem())) {
            return this.jvmTable[this.jvmTable.length - 1];
        }
        if (this.partitionSet.getLength() == 1) {
            return this.jvmTable[0];
        }
        dArray = CoordinateSystem.transformCoordinates(((SetType)this.partitionSet.getType()).getDomain(), this.partitionSet.getCoordinateSystem(), this.partitionSet.getSetUnits(), null, (RealTupleType)realTuple.getType(), realTuple.getCoordinateSystem(), realTuple.getTupleUnits(), null, dArray);
        try {
            int[] nArray = this.partitionSet.doubleToIndex(dArray);
            return nArray[0] < 0 ? null : this.jvmTable[nArray[0]];
        }
        catch (SetException setException) {
            return null;
        }
    }

    public void setupClusterData(Set set, RemoteClusterData[] remoteClusterDataArray) throws RemoteException, VisADException {
        if (remoteClusterDataArray == null) {
            throw new ClusterException("table must be non-null");
        }
        if (set != null) {
            if (set.getLength() + 1 > remoteClusterDataArray.length) {
                throw new ClusterException("table.length (" + remoteClusterDataArray.length + ") must " + " >= ps.length + 1 (" + (set.getLength() + 1) + ")");
            }
            this.partitionSet = set;
            this.dimension = set.getDimension();
        } else {
            this.partitionSet = null;
            this.dimension = -1;
        }
        this.jvmTable = remoteClusterDataArray;
    }

    public Set getPartitionSet() {
        return this.partitionSet;
    }

    public boolean clusterDataEquals(RemoteClusterData remoteClusterData) throws RemoteException {
        return remoteClusterData == this.me;
    }

    public void setParent(RemoteClusterDataImpl remoteClusterDataImpl) {
        this.parent = remoteClusterDataImpl;
    }

    public void notifyReferences() throws VisADException, RemoteException {
        this.adaptedThingImpl.notifyReferences();
        if (this.parent != null) {
            this.parent.notifyReferences();
        }
    }

    public void addReference(ThingReference thingReference) throws VisADException {
        this.adaptedRemoteThingImpl.addReference(thingReference);
    }

    public void removeReference(ThingReference thingReference) throws VisADException {
        this.adaptedRemoteThingImpl.removeReference(thingReference);
    }

    public DataImpl local() throws VisADException, RemoteException {
        throw new ClusterException("no local() method for cluster data");
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        Real real = new Real(0.0);
        RemoteClientTupleImpl remoteClientTupleImpl = new RemoteClientTupleImpl(new Data[]{real});
        RemoteClientTupleImpl remoteClientTupleImpl2 = new RemoteClientTupleImpl(new Data[]{real});
        System.out.println(remoteClientTupleImpl.equals(remoteClientTupleImpl));
        System.out.println(remoteClientTupleImpl.equals(remoteClientTupleImpl2));
        System.out.println(remoteClientTupleImpl.clusterDataEquals(remoteClientTupleImpl));
        System.out.println(remoteClientTupleImpl.clusterDataEquals(remoteClientTupleImpl2));
        System.exit(0);
    }

    public RemoteClusterDataImpl() throws RemoteException {
        super((DataImpl)null);
        this.me = this;
    }
}

