/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataShadow;
import visad.DisplayException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.VisADException;
import visad.VisADGroup;
import visad.cluster.NodeAgent;
import visad.cluster.NodeDisplayRendererJ3D;
import visad.cluster.ShadowNodeFunctionTypeJ3D;
import visad.cluster.ShadowNodeRealTupleTypeJ3D;
import visad.cluster.ShadowNodeRealTypeJ3D;
import visad.cluster.ShadowNodeSetTypeJ3D;
import visad.cluster.ShadowNodeTupleTypeJ3D;
import visad.collab.CollabUtil;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class NodeRendererJ3D
extends DefaultRendererJ3D {
    private NodeAgent agent = null;
    private boolean enable_transform = false;
    private int resolution = 1;

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowNodeFunctionTypeJ3D(functionType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType realTupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowNodeRealTupleTypeJ3D(realTupleType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealType(RealType realType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowNodeRealTypeJ3D(realType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowSetType(SetType setType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowNodeSetTypeJ3D(setType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTupleType(TupleType tupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowNodeTupleTypeJ3D(tupleType, dataDisplayLink, shadowType);
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void enableTransform() {
        this.enable_transform = true;
    }

    public DataShadow prepareAction(boolean bl, boolean bl2, DataShadow dataShadow) throws VisADException, RemoteException {
        return super.prepareAction(bl, false, dataShadow);
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(13);
        branchGroup.setCapability(14);
        if (!this.enable_transform) {
            return branchGroup;
        }
        this.enable_transform = false;
        VisADGroup visADGroup = new VisADGroup();
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return null;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        ShadowTypeJ3D shadowTypeJ3D = (ShadowTypeJ3D)dataDisplayLink.getShadow();
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = dataDisplayLink.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, dataDisplayLink);
                this.removeLink(dataDisplayLink);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            visADGroup = null;
            this.addException(new DisplayException("Data is null: NodeRendererJ3D.doTransform"));
        } else {
            boolean bl;
            dataDisplayLink.start_time = System.currentTimeMillis();
            dataDisplayLink.time_flag = false;
            shadowTypeJ3D.preProcess();
            try {
                bl = shadowTypeJ3D.doTransform(visADGroup, data, fArray, dataDisplayLink.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, dataDisplayLink);
                    this.removeLink(dataDisplayLink);
                    return null;
                }
                throw remoteException;
            }
            if (bl) {
                shadowTypeJ3D.postProcess(visADGroup);
            }
        }
        dataDisplayLink.clearData();
        if (this.agent != null) {
            this.agent.sendToClient(visADGroup);
            System.out.println("scene graph sent to client");
        }
        return branchGroup;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display", (DisplayRendererJ3D)new NodeDisplayRendererJ3D(), 4);
        JFrame jFrame = new JFrame("test NodeRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }

    public NodeRendererJ3D() {
        this(null);
    }

    public NodeRendererJ3D(NodeAgent nodeAgent) {
        this.agent = nodeAgent;
    }
}

