/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import visad.cluster.RemoteAgentContactImpl;
import visad.cluster.RemoteClientAgent;

public abstract class NodeAgent
implements Serializable,
Runnable {
    private Object object = null;
    private RemoteClientAgent source = null;
    RemoteAgentContactImpl contact = null;
    private transient Thread agentThread;
    Serializable message = null;

    public boolean onlyOne() {
        return true;
    }

    public Object getObject() {
        return this.object;
    }

    public Thread getAgentThread() {
        return this.agentThread;
    }

    public synchronized void sendToNode(Serializable serializable) {
        this.message = serializable;
        this.notify();
    }

    public synchronized Serializable getMessage() {
        while (this.message == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Serializable serializable = this.message;
        this.message = null;
        return serializable;
    }

    public void sendToClient(Serializable serializable) {
        try {
            this.source.sendToClient(serializable);
        }
        catch (RemoteException remoteException) {
            System.out.println("unable to send: " + serializable);
        }
    }

    public RemoteAgentContactImpl getRemoteAgentContact(Object object) {
        this.object = object;
        this.agentThread = new Thread(this);
        this.agentThread.start();
        try {
            this.contact = new RemoteAgentContactImpl(this);
            return this.contact;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void stop() {
        this.sendToNode((Serializable)((Object)"stop"));
        this.agentThread = null;
    }

    public abstract void run();

    public NodeAgent(RemoteClientAgent remoteClientAgent) {
        this.source = remoteClientAgent;
    }
}

