/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AVControl;
import visad.ConstantMap;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.GraphicsModeControl;
import visad.RealType;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADSceneGraphObject;
import visad.VisADSwitch;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.DefaultNodeRendererAgent;
import visad.cluster.RemoteAgentContact;
import visad.cluster.RemoteClientAgentImpl;
import visad.cluster.RemoteClientDataImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteClusterDataImpl;
import visad.cluster.RemoteNodeData;
import visad.collab.CollabUtil;
import visad.java3d.AVControlJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.ShadowTypeJ3D;

public class ClientRendererJ3D
extends DefaultRendererJ3D {
    private DisplayImpl display = null;
    private RemoteDisplay rdisplay = null;
    private ConstantMap[] cmaps = null;
    private DataDisplayLink link = null;
    private Data data = null;
    private ClientDisplayRendererJ3D cdr = null;
    private boolean cluster = true;
    private RemoteClientAgentImpl[] agents = null;
    private RemoteClientAgentImpl focus_agent = null;
    private RemoteAgentContact[] contacts = null;
    private long time_out = 10000L;
    private int[] resolutions = null;
    private boolean enable_spatial = true;

    public void setResolutions(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        this.resolutions = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.resolutions[n2] = nArray[n2];
            ++n2;
        }
    }

    public DataShadow prepareAction(boolean bl, boolean bl2, DataShadow dataShadow) throws VisADException, RemoteException {
        Serializable serializable;
        Data data = this.data;
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray != null && dataDisplayLinkArray.length > 0) {
            int n;
            this.link = dataDisplayLinkArray[0];
            if (this.rdisplay == null) {
                this.display = this.getDisplay();
                this.rdisplay = new RemoteDisplayImpl(this.display);
                serializable = this.link.getConstantMaps();
                if (serializable != null && ((Vector)serializable).size() > 0) {
                    int n2 = ((Vector)serializable).size();
                    this.cmaps = new ConstantMap[n2];
                    n = 0;
                    while (n < n2) {
                        this.cmaps[n] = (ConstantMap)((Vector)serializable).elementAt(n);
                        ++n;
                    }
                }
                this.cdr = (ClientDisplayRendererJ3D)this.display.getDisplayRenderer();
            }
            try {
                this.data = this.link.getData();
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw remoteException;
            }
            if (this.data == null) {
                this.addException(new DisplayException("Data is null: ClientRendererJ3D.doTransform"));
            }
            this.cluster = this.data instanceof RemoteClientDataImpl;
            if (this.cluster && this.data != data) {
                serializable = (RemoteClientDataImpl)this.data;
                this.focus_agent = new RemoteClientAgentImpl(null, -1, this.time_out);
                RemoteClusterData[] remoteClusterDataArray = ((RemoteClusterDataImpl)serializable).getTable();
                n = remoteClusterDataArray.length - 1;
                this.agents = new RemoteClientAgentImpl[n];
                this.contacts = new RemoteAgentContact[n];
                int n3 = 0;
                while (n3 < n) {
                    this.agents[n3] = new RemoteClientAgentImpl(this.focus_agent, n3);
                    DefaultNodeRendererAgent defaultNodeRendererAgent = new DefaultNodeRendererAgent(this.agents[n3], this.rdisplay, this.cmaps);
                    this.contacts[n3] = ((RemoteNodeData)remoteClusterDataArray[n3]).sendAgent(defaultNodeRendererAgent);
                    ++n3;
                }
            }
        }
        serializable = new Vector();
        Vector vector = this.display.getMapVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
            ((Vector)serializable).addElement(scalarMap);
            ((Vector)serializable).addElement(scalarMap.getControl());
        }
        Serializable[] serializableArray = this.focus_agent.broadcastWithResponses(serializable, this.contacts);
        return super.prepareAction(bl, bl2, dataShadow);
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Serializable serializable;
        Object object;
        int n;
        if (this.link == null || this.data == null) {
            this.addException(new DisplayException("Data is null: ClientRendererJ3D.doTransform"));
        }
        if (!this.cluster) {
            return super.doTransform();
        }
        int n2 = this.contacts.length;
        Serializable[] serializableArray = new Vector[n2];
        if (this.resolutions == null || this.resolutions.length != n2) {
            this.resolutions = new int[n2];
            n = 0;
            while (n < n2) {
                this.resolutions[n] = 1;
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            serializableArray[n] = new Vector();
            ((Vector)serializableArray[n]).addElement("transform");
            ((Vector)serializableArray[n]).addElement(new Integer(this.resolutions[n]));
            object = this.display.getMapVector();
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                serializable = (ScalarMap)enumeration.nextElement();
                ((Vector)serializableArray[n]).addElement(serializable);
            }
            ++n;
        }
        Serializable[] serializableArray2 = this.focus_agent.broadcastWithResponses(serializableArray, this.contacts);
        object = new BranchGroup();
        object.setCapability(17);
        object.setCapability(12);
        object.setCapability(13);
        object.setCapability(14);
        n2 = serializableArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            if (serializableArray2[n3] != null) {
                serializable = (VisADSceneGraphObject)serializableArray2[n3];
                object.addChild(this.convertSceneGraph((VisADSceneGraphObject)serializable));
            }
            ++n3;
        }
        if (n2 == 0) {
            ShadowTypeJ3D.ensureNotEmpty(object, this.display);
        }
        return object;
    }

    public synchronized void setSpatialValues(float[][] fArray) {
        if (this.enable_spatial) {
            super.setSpatialValues(fArray);
        }
    }

    public Node convertSceneGraph(VisADSceneGraphObject visADSceneGraphObject) throws VisADException {
        if (visADSceneGraphObject instanceof VisADSwitch) {
            VisADSwitch visADSwitch = (VisADSwitch)visADSceneGraphObject;
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.setCapability(12);
            branchGroup.setCapability(13);
            branchGroup.setCapability(14);
            Switch switch_ = new Switch();
            switch_.setCapability(17);
            switch_.setCapability(18);
            switch_.setCapability(17);
            switch_.setCapability(12);
            switch_.setCapability(13);
            int n = visADSwitch.numChildren();
            Set set = visADSwitch.getSet();
            if (set != null) {
                Object object;
                int n2 = 0;
                while (n2 < n) {
                    object = visADSwitch.getChild(n2);
                    switch_.addChild(this.convertSceneGraph((VisADSceneGraphObject)object));
                    ++n2;
                }
                RealType realType = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
                object = null;
                Vector vector = this.display.getMapVector();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    DisplayRealType displayRealType;
                    ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                    if (!realType.equals(scalarMap.getScalar()) || !(displayRealType = scalarMap.getDisplayScalar()).equals(Display.Animation) && !displayRealType.equals(Display.SelectValue)) continue;
                    object = (AVControl)((Object)scalarMap.getControl());
                    break;
                }
                if (object == null) {
                    throw new ClusterException("AVControl is null");
                }
                ((AVControlJ3D)object).addPair(switch_, set, this);
                ((AVControlJ3D)object).init();
            } else {
                VisADAppearance visADAppearance;
                VisADAppearance visADAppearance2;
                if (visADSwitch.numChildren() != 3) {
                    throw new ClusterException("VisADSwitch for volume render must have 3 children");
                }
                VisADGroup visADGroup = (VisADGroup)((VisADSwitch)visADSceneGraphObject).getChild(0);
                VisADGroup visADGroup2 = (VisADGroup)((VisADSwitch)visADSceneGraphObject).getChild(1);
                VisADGroup visADGroup3 = (VisADGroup)((VisADSwitch)visADSceneGraphObject).getChild(2);
                int n3 = visADGroup.numChildren();
                OrderedGroup orderedGroup = new OrderedGroup();
                orderedGroup.setCapability(12);
                VisADAppearance[] visADAppearanceArray = new VisADAppearance[n3];
                int n4 = 0;
                while (n4 < n3) {
                    VisADAppearance visADAppearance3 = (VisADAppearance)visADGroup.getChild(n4);
                    orderedGroup.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance3)));
                    ++n4;
                }
                OrderedGroup orderedGroup2 = new OrderedGroup();
                orderedGroup2.setCapability(12);
                int n5 = n3 - 1;
                while (n5 >= 0) {
                    visADAppearance2 = (VisADAppearance)visADGroup.getChild(n5);
                    orderedGroup2.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance2)));
                    --n5;
                }
                n5 = visADGroup2.numChildren();
                visADAppearance2 = new OrderedGroup();
                visADAppearance2.setCapability(12);
                VisADAppearance[] visADAppearanceArray2 = new VisADAppearance[n5];
                int n6 = 0;
                while (n6 < n5) {
                    VisADAppearance visADAppearance4 = (VisADAppearance)visADGroup2.getChild(n6);
                    visADAppearance2.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance4)));
                    ++n6;
                }
                OrderedGroup orderedGroup3 = new OrderedGroup();
                orderedGroup3.setCapability(12);
                int n7 = n5 - 1;
                while (n7 >= 0) {
                    visADAppearance = (VisADAppearance)visADGroup2.getChild(n7);
                    orderedGroup3.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance)));
                    --n7;
                }
                n7 = visADGroup3.numChildren();
                visADAppearance = new OrderedGroup();
                visADAppearance.setCapability(12);
                VisADAppearance[] visADAppearanceArray3 = new VisADAppearance[n7];
                int n8 = 0;
                while (n8 < n7) {
                    VisADAppearance visADAppearance5 = (VisADAppearance)visADGroup3.getChild(n8);
                    visADAppearance.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance5)));
                    ++n8;
                }
                OrderedGroup orderedGroup4 = new OrderedGroup();
                orderedGroup4.setCapability(12);
                int n9 = n7 - 1;
                while (n9 >= 0) {
                    VisADAppearance visADAppearance6 = (VisADAppearance)visADGroup3.getChild(n9);
                    orderedGroup4.addChild((Node)((Shape3D)this.convertSceneGraph(visADAppearance6)));
                    --n9;
                }
                switch_.addChild((Node)orderedGroup);
                switch_.addChild((Node)visADAppearance2);
                switch_.addChild((Node)visADAppearance);
                switch_.addChild((Node)orderedGroup2);
                switch_.addChild((Node)orderedGroup3);
                switch_.addChild((Node)orderedGroup4);
                ProjectionControlJ3D projectionControlJ3D = (ProjectionControlJ3D)this.display.getProjectionControl();
                projectionControlJ3D.addPair(switch_, this);
            }
            branchGroup.addChild((Node)switch_);
            return branchGroup;
        }
        if (visADSceneGraphObject instanceof VisADGroup) {
            VisADGroup visADGroup = (VisADGroup)visADSceneGraphObject;
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.setCapability(12);
            branchGroup.setCapability(13);
            branchGroup.setCapability(14);
            int n = visADGroup.numChildren();
            int n10 = 0;
            while (n10 < n) {
                VisADSceneGraphObject visADSceneGraphObject2 = visADGroup.getChild(n10);
                branchGroup.addChild(this.convertSceneGraph(visADSceneGraphObject2));
                ++n10;
            }
            ShadowTypeJ3D.ensureNotEmpty(branchGroup, this.display);
            return branchGroup;
        }
        if (visADSceneGraphObject instanceof VisADAppearance) {
            VisADAppearance visADAppearance = (VisADAppearance)visADSceneGraphObject;
            GraphicsModeControl graphicsModeControl = this.display.getGraphicsModeControl();
            VisADGeometryArray visADGeometryArray = visADAppearance.array;
            GeometryArray geometryArray = ((DisplayImplJ3D)this.display).makeGeometry(visADGeometryArray);
            if (geometryArray == null) {
                return null;
            }
            BufferedImage bufferedImage = null;
            if (visADAppearance.image_pixels != null) {
                bufferedImage = new BufferedImage(visADAppearance.image_width, visADAppearance.image_height, visADAppearance.image_type);
                bufferedImage.setRGB(0, 0, visADAppearance.image_width, visADAppearance.image_height, visADAppearance.image_pixels, 0, visADAppearance.image_width);
            }
            if (bufferedImage != null) {
                Appearance appearance = this.makeTextureAppearance(visADAppearance, graphicsModeControl, geometryArray);
                TextureAttributes textureAttributes = new TextureAttributes();
                textureAttributes.setTextureMode(2);
                textureAttributes.setPerspectiveCorrectionMode(1);
                appearance.setTextureAttributes(textureAttributes);
                int n = graphicsModeControl.getTransparencyMode();
                Texture2D texture2D = new Texture2D(1, 6, visADAppearance.texture_width, visADAppearance.texture_height);
                texture2D.setCapability(4);
                ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
                imageComponent2D.setCapability(2);
                texture2D.setImage(0, (ImageComponent)imageComponent2D);
                if (n == 0) {
                    texture2D.setMinFilter(2);
                    texture2D.setMagFilter(2);
                } else {
                    texture2D.setBoundaryModeS(2);
                    texture2D.setBoundaryModeT(2);
                    texture2D.setMinFilter(3);
                    texture2D.setMagFilter(3);
                }
                texture2D.setEnable(true);
                appearance.setTexture((Texture)texture2D);
                appearance.setCapability(2);
                Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
                shape3D.setCapability(14);
                return shape3D;
            }
            Appearance appearance = this.makeAppearance(visADAppearance, graphicsModeControl, geometryArray);
            Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
            return shape3D;
        }
        throw new VisADException("unknown scene " + visADSceneGraphObject);
    }

    private Appearance makeTextureAppearance(VisADAppearance visADAppearance, GraphicsModeControl graphicsModeControl, GeometryArray geometryArray) {
        TransparencyAttributes transparencyAttributes = null;
        if (visADAppearance.alpha == 1.0f) {
            transparencyAttributes = null;
        } else if (visADAppearance.alpha == visADAppearance.alpha) {
            transparencyAttributes = new TransparencyAttributes(2, visADAppearance.alpha);
        } else {
            transparencyAttributes = new TransparencyAttributes();
            transparencyAttributes.setTransparencyMode(2);
        }
        ColoringAttributes coloringAttributes = null;
        if (visADAppearance.red == visADAppearance.red && visADAppearance.green == visADAppearance.green && visADAppearance.blue == visADAppearance.blue) {
            coloringAttributes = new ColoringAttributes();
            coloringAttributes.setColor(visADAppearance.red, visADAppearance.green, visADAppearance.blue);
        }
        return ShadowTypeJ3D.makeAppearance(graphicsModeControl, transparencyAttributes, null, geometryArray, false);
    }

    private Appearance makeAppearance(VisADAppearance visADAppearance, GraphicsModeControl graphicsModeControl, GeometryArray geometryArray) {
        TransparencyAttributes transparencyAttributes = null;
        transparencyAttributes = visADAppearance.alpha == 1.0f ? new TransparencyAttributes(4, 0.0f) : (visADAppearance.alpha == visADAppearance.alpha ? new TransparencyAttributes(graphicsModeControl.getTransparencyMode(), visADAppearance.alpha) : new TransparencyAttributes(graphicsModeControl.getTransparencyMode(), 0.0f));
        ColoringAttributes coloringAttributes = null;
        if (visADAppearance.red == visADAppearance.red && visADAppearance.green == visADAppearance.green && visADAppearance.blue == visADAppearance.blue) {
            coloringAttributes = new ColoringAttributes();
            coloringAttributes.setColor(visADAppearance.red, visADAppearance.green, visADAppearance.blue);
        }
        return ShadowTypeJ3D.makeAppearance(graphicsModeControl, transparencyAttributes, coloringAttributes, geometryArray, false);
    }

    public DataShadow computeRanges(Data data, ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        if (!this.cluster) {
            return super.computeRanges(data, shadowType, dataShadow);
        }
        Object var4_4 = null;
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.addElement(shadowType);
        if (dataShadow == null) {
            vector.addElement(new Integer(this.getDisplay().getScalarCount()));
        } else {
            vector.addElement(dataShadow);
        }
        Serializable[] serializableArray = this.focus_agent.broadcastWithResponses(vector, this.contacts);
        DataShadow dataShadow2 = null;
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (serializableArray[n2] != null) {
                if (dataShadow2 == null) {
                    dataShadow2 = (DataShadow)serializableArray[n2];
                } else {
                    dataShadow2.merge((DataShadow)serializableArray[n2]);
                }
            }
            ++n2;
        }
        return dataShadow2;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D());
        JFrame jFrame = new JFrame("test ClientRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }

    public ClientRendererJ3D() {
        this(10000L);
    }

    public ClientRendererJ3D(long l) {
        this.time_out = l;
    }
}

