/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import visad.browser.ContourWidget;
import visad.browser.Convert;
import visad.browser.Divider;
import visad.browser.Widget;
import visad.browser.WidgetEvent;
import visad.browser.WidgetListener;

public class VisADApplet
extends Applet
implements ActionListener,
MouseListener,
MouseMotionListener,
WidgetListener {
    private static final boolean DEBUG = false;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 4567;
    public static final int REFRESH = 0;
    public static final int MOUSE_EVENT = 1;
    public static final int MESSAGE = 2;
    private boolean connected = false;
    private String address = "";
    private int port = 4567;
    private Socket socket = null;
    private DataOutputStream out = null;
    private int id;
    private Image image = null;
    private TextField addressField;
    private TextField portField;
    private Button connectButton;
    private Component canvas;
    private Frame frame;
    private GridBagLayout widgetLayout;
    private GridBagConstraints constraints;
    private Thread commThread = null;
    private Hashtable hashtable = new Hashtable();
    private Applet myself;

    private void addComponent(Component component, GridBagLayout gridBagLayout, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void addWidget(Widget widget, String string) {
        this.hashtable.put(string, widget);
        if (this.constraints.gridy > 0) {
            Divider divider = new Divider();
            this.widgetLayout.setConstraints(divider, this.constraints);
            ++this.constraints.gridy;
            this.frame.add(divider);
        }
        this.widgetLayout.setConstraints(widget, this.constraints);
        ++this.constraints.gridy;
        this.frame.add(widget);
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    private synchronized void removeAllWidgets() {
        this.hashtable = new Hashtable();
        this.constraints.gridy = 0;
        ((Component)this.frame).setVisible(false);
        this.frame.removeAll();
    }

    public void init() {
        this.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.myself = this;
        this.addressField = new TextField(DEFAULT_HOST);
        this.portField = new TextField("4567", 4);
        this.connectButton = new Button("Connect");
        this.canvas = new Component(this){
            private final /* synthetic */ VisADApplet this$0;

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void paint(Graphics graphics) {
                if (VisADApplet.access$0(this.this$0)) {
                    if (VisADApplet.access$1(this.this$0) != null) {
                        graphics.drawImage(VisADApplet.access$1(this.this$0), 0, 0, this);
                    }
                } else {
                    graphics.setColor(Color.black);
                    graphics.drawString("VisADApplet", 80, 20);
                    graphics.drawString("To connect to a VisAD display available", 10, 50);
                    graphics.drawString("through a SocketSlaveDisplay server, type", 10, 70);
                    graphics.drawString("the IP address of the server into the IP", 10, 90);
                    graphics.drawString("address field and type the port of the", 10, 110);
                    graphics.drawString("server into the port field, then press", 10, 130);
                    graphics.drawString("the Connect button.", 10, 150);
                }
            }
            {
                this.this$0 = visADApplet;
                this.constructor$0(visADApplet);
            }

            private final void constructor$0(VisADApplet visADApplet) {
            }
        };
        this.addressField.addActionListener(this);
        this.portField.addActionListener(this);
        this.connectButton.addActionListener(this);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.addComponent(new Label("IP address"), gridBagLayout, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.addressField, gridBagLayout, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("Port"), gridBagLayout, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.portField, gridBagLayout, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.connectButton, gridBagLayout, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.canvas, gridBagLayout, 0, 1, 5, 1, 1.0, 1.0);
        this.frame = new Frame("Controls");
        this.widgetLayout = new GridBagLayout();
        this.frame.setLayout(this.widgetLayout);
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        ((Component)this.frame).setBackground(Widget.PALE_GRAY);
    }

    public void disconnect() {
        if (this.connected) {
            this.connected = false;
            int n = 0;
            while (n < this.frame.getComponentCount()) {
                Component component = this.frame.getComponent(n);
                if (component instanceof Widget) {
                    Widget widget = (Widget)this.frame.getComponent(n);
                    widget.removeWidgetListener(this);
                }
                ++n;
            }
            this.removeAllWidgets();
            this.repaint();
        }
    }

    private void requestRefresh() {
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(0);
            }
            catch (SocketException socketException) {
                this.disconnect();
            }
            catch (IOException iOException) {
                this.disconnect();
            }
        }
    }

    private void sendEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        long l = mouseEvent.getWhen();
        int n2 = mouseEvent.getModifiers();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = mouseEvent.getClickCount();
        boolean bl = mouseEvent.isPopupTrigger();
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(1);
                this.out.writeInt(n);
                this.out.writeLong(l);
                this.out.writeInt(n2);
                this.out.writeInt(n3);
                this.out.writeInt(n4);
                this.out.writeInt(n5);
                this.out.writeBoolean(bl);
            }
            catch (SocketException socketException) {
                this.disconnect();
            }
            catch (IOException iOException) {
                this.disconnect();
            }
        }
    }

    private void sendMessage(String string) {
        if (this.out != null) {
            try {
                this.out.writeInt(this.id);
                this.out.writeInt(2);
                this.out.writeInt(string.length());
                this.out.writeChars(string);
            }
            catch (SocketException socketException) {
                this.disconnect();
            }
            catch (IOException iOException) {
                this.disconnect();
            }
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.connectButton.requestFocus();
        String string = this.addressField.getText();
        int n = this.port;
        try {
            n = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.portField.setText("" + n);
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.addressField.setText("" + this.address);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (socket == null) {
            return;
        }
        if (this.connected) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.disconnect();
            while (this.commThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.socket = socket;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.id = 0;
            while (true) {
                this.id = dataInputStream.readInt();
                if (this.id != 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.connected = true;
        }
        catch (IOException iOException) {
            this.disconnect();
        }
        DataInputStream dataInputStream2 = dataInputStream;
        VisADApplet visADApplet = this;
        this.commThread = new Thread(new Runnable(this, visADApplet, dataInputStream2){
            private final /* synthetic */ VisADApplet this$0;
            private final /* synthetic */ VisADApplet val$applet;
            private final /* synthetic */ DataInputStream val$in;

            public void run() {
                try {
                    VisADApplet.access$2(this.this$0);
                    while (VisADApplet.access$0(this.this$0)) {
                        Object object;
                        Object object2;
                        Object object3;
                        int n;
                        int n2 = this.val$in.readInt();
                        if (n2 == 0) continue;
                        if (n2 == -1) {
                            int n3;
                            Widget widget;
                            Object object4;
                            Object object5;
                            String string;
                            StringTokenizer stringTokenizer;
                            n = this.val$in.readInt();
                            char[] cArray = new char[n];
                            int n4 = 0;
                            while (n4 < n) {
                                cArray[n4] = this.val$in.readChar();
                                ++n4;
                            }
                            object3 = new String(cArray);
                            if (((String)object3).startsWith("visad.ScalarMap\n")) {
                                stringTokenizer = new StringTokenizer((String)object3);
                                stringTokenizer.nextToken();
                                object2 = stringTokenizer.nextToken();
                                object = stringTokenizer.nextToken();
                                float f = Convert.getFloat(stringTokenizer.nextToken());
                                float f2 = Convert.getFloat(stringTokenizer.nextToken());
                                String string2 = (String)object2 + " " + (String)object;
                                string = "." + (String)object;
                                object5 = (Integer)VisADApplet.access$3(this.this$0).get(string2);
                                if (object5 == null) {
                                    object4 = (Integer)VisADApplet.access$3(this.this$0).get(string);
                                    if (object4 == null) {
                                        object4 = new Integer(0);
                                    }
                                    object5 = object4;
                                    VisADApplet.access$3(this.this$0).put(string2, object5);
                                    VisADApplet.access$3(this.this$0).put(string, new Integer((Integer)object4 + 1));
                                }
                                if (!((String)object).equals("DisplayIsoContour")) continue;
                                object4 = "Contour" + (Integer)object5;
                                widget = (ContourWidget)VisADApplet.access$3(this.this$0).get(object4);
                                ((ContourWidget)widget).setName((String)object2);
                                ((ContourWidget)widget).setRange(f, f2);
                                continue;
                            }
                            stringTokenizer = new StringTokenizer((String)object3, "\n");
                            object2 = stringTokenizer.nextToken();
                            int n5 = Convert.getInt(stringTokenizer.nextToken());
                            String string3 = stringTokenizer.nextToken();
                            int n6 = ((String)object2).lastIndexOf(".");
                            string = ((String)object2).substring(n6 + 1, n3 = ((String)object2).lastIndexOf("Control"));
                            if (string.equals("GraphicsMode")) {
                                string = "GMC";
                            }
                            object5 = "visad.browser." + string + "Widget";
                            object4 = string + n5;
                            widget = (Widget)VisADApplet.access$3(this.this$0).get(object4);
                            if (widget == null) {
                                try {
                                    widget = (Widget)Class.forName((String)object5).newInstance();
                                    widget.addWidgetListener(this.val$applet);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                }
                                catch (InstantiationException instantiationException) {
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    // empty catch block
                                }
                                if (widget != null) {
                                    VisADApplet.access$5(this.this$0, widget, (String)object4);
                                }
                            }
                            if (widget == null) continue;
                            widget.setSaveString(string3);
                            continue;
                        }
                        n = this.val$in.readInt();
                        int n7 = this.val$in.readInt();
                        object3 = new byte[n7];
                        int n8 = 0;
                        while (n8 < n7) {
                            n8 += this.val$in.read((byte[])object3, n8, n7 - n8);
                        }
                        object2 = Convert.bytesToInt((byte[])object3);
                        object = Convert.decodeRLE((int[])object2);
                        if (VisADApplet.access$1(this.this$0) != null) {
                            VisADApplet.access$1(this.this$0).flush();
                        }
                        VisADApplet.access$6(this.this$0, this.this$0.createImage(new MemoryImageSource(n2, n, (int[])object, 0, n2)));
                        MediaTracker mediaTracker = new MediaTracker(VisADApplet.access$7(this.this$0));
                        mediaTracker.addImage(VisADApplet.access$1(this.this$0), 0);
                        try {
                            mediaTracker.waitForAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        VisADApplet.access$8(this.this$0).paint(VisADApplet.access$8(this.this$0).getGraphics());
                    }
                }
                catch (SocketException socketException) {
                    this.val$applet.disconnect();
                }
                catch (IOException iOException) {
                    this.val$applet.disconnect();
                }
            }
            {
                this.val$applet = visADApplet2;
                this.val$in = dataInputStream;
                this.this$0 = visADApplet;
                this.constructor$0(visADApplet);
            }

            private final void constructor$0(VisADApplet visADApplet) {
            }
        });
        this.commThread.start();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.sendEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.sendEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.sendEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.sendEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.sendEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void widgetChanged(WidgetEvent widgetEvent) {
        Widget widget;
        int n;
        int n2;
        Widget widget2 = widgetEvent.getWidget();
        String string = widget2.getClass().getName();
        String string2 = string.substring((n2 = string.lastIndexOf(".")) + 1, n = string.lastIndexOf("Widget"));
        String string3 = string2;
        if (string3.equals("GMC")) {
            string3 = "GraphicsMode";
        }
        String string4 = "visad." + string3 + "Control";
        String string5 = widget2.getSaveString();
        int n3 = 0;
        int n4 = -1;
        do {
            if ((widget = (Widget)this.hashtable.get(string2 + n3)) == widget2) {
                n4 = n3;
                break;
            }
            ++n3;
        } while (widget != null);
        String string6 = string4 + "\n" + n4 + "\n" + string5;
        this.sendMessage(string6);
    }

    static /* synthetic */ boolean access$0(VisADApplet visADApplet) {
        return visADApplet.connected;
    }

    static /* synthetic */ Image access$1(VisADApplet visADApplet) {
        return visADApplet.image;
    }

    static /* synthetic */ void access$2(VisADApplet visADApplet) {
        visADApplet.requestRefresh();
    }

    static /* synthetic */ Hashtable access$3(VisADApplet visADApplet) {
        return visADApplet.hashtable;
    }

    static /* synthetic */ boolean access$4() {
        return DEBUG;
    }

    static /* synthetic */ void access$5(VisADApplet visADApplet, Widget widget, String string) {
        visADApplet.addWidget(widget, string);
    }

    static /* synthetic */ void access$6(VisADApplet visADApplet, Image image) {
        visADApplet.image = image;
    }

    static /* synthetic */ Applet access$7(VisADApplet visADApplet) {
        return visADApplet.myself;
    }

    static /* synthetic */ Component access$8(VisADApplet visADApplet) {
        return visADApplet.canvas;
    }
}

