/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import visad.browser.Widget;

public class Slider
extends Component
implements MouseListener,
MouseMotionListener {
    public static final int SLIDER_PREF_HEIGHT = 14;
    public static final int SLIDER_PREF_WIDTH = 300;
    public static final int GRIP_WIDTH = 29;
    public static final int GRIP_HEIGHT = 14;
    public static final int GRIP_TOP_Y = 0;
    public static final int GRIP_BOTTOM_Y = 14;
    public static final int LINE_LEVEL = 7;
    protected int width = 300;
    protected float value = 0.0f;
    protected float minimum = 0.0f;
    protected float maximum = 100.0f;
    private int grip = 0;
    private boolean slide = false;
    private boolean moved = false;
    protected Dimension minSize = null;
    protected Dimension prefSize = null;
    protected Dimension maxSize = null;
    private int gripX;
    private Vector listeners = new Vector();
    private String command = null;

    public float getValue() {
        return this.value;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setValue(float f) {
        this.value = f;
        this.grip = this.valueToGrip(f);
        this.repaint();
    }

    public void setBounds(float f, float f2) {
        this.minimum = f;
        this.maximum = f2;
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
    }

    private void updateGrip(int n) {
        this.grip = n - this.gripX;
        if (this.grip < 0) {
            this.grip = 0;
        }
        if (this.grip > this.width - 29) {
            this.grip = this.width - 29;
        }
        this.value = this.gripToValue(this.grip);
        this.notifyListeners();
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(actionListener);
        }
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void notifyListeners() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.command);
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                ActionListener actionListener = (ActionListener)this.listeners.elementAt(n);
                actionListener.actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (Widget.containedIn(n2, n = mouseEvent.getY(), this.grip, 0, 29, 14)) {
            this.gripX = n2 - this.grip;
            this.slide = true;
        } else if (Widget.containedIn(n2, n, 0, 0, this.grip - 1, 14) || Widget.containedIn(n2, n, this.grip + 29, 0, this.width - this.grip - 29, 14)) {
            this.gripX = 14;
            this.slide = true;
            this.updateGrip(n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.slide = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.slide) {
            this.updateGrip(n);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(0, 14);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, 14);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 14);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    private float gripToValue(int n) {
        return (float)n / (float)(this.width - 29) * (this.maximum - this.minimum) + this.minimum;
    }

    private int valueToGrip(float f) {
        return (int)((f - this.minimum) / (this.maximum - this.minimum) * (float)(this.width - 29));
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Widget.PALE_GRAY);
        graphics.fillRect(0, 0, this.grip, 7);
        graphics.fillRect(this.grip + 29, 0, this.width - this.grip - 29, 7);
        graphics.fillRect(0, 8, this.grip, 6);
        graphics.fillRect(this.grip + 29, 8, this.width - this.grip - 29, 6);
        graphics.drawRect(this.grip, 0, 0, 0);
        graphics.drawRect(this.grip + 29 - 1, 0, 0, 0);
        graphics.drawRect(this.grip, 13, 0, 0);
        graphics.drawRect(this.grip + 29 - 1, 13, 0, 0);
        graphics.fillRect(this.grip + 2, 2, 26, 11);
        graphics.setColor(Color.black);
        graphics.drawLine(this.grip + 1, 0, this.grip + 29 - 2, 0);
        graphics.drawLine(this.grip + 1, 13, this.grip + 29 - 2, 13);
        graphics.drawLine(this.grip, 1, this.grip, 12);
        graphics.drawLine(this.grip + 29 - 1, 1, this.grip + 29 - 1, 12);
        graphics.setColor(Color.white);
        graphics.drawLine(this.grip + 1, 1, this.grip + 29 - 2, 1);
        graphics.drawLine(this.grip + 1, 2, this.grip + 1, 12);
        if (this.grip > 0) {
            graphics.drawLine(0, 7, this.grip - 1, 7);
        }
        graphics.drawLine(this.grip + 29, 7, this.width, 7);
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public static void main(String[] stringArray) {
        Slider slider = new Slider(26.3f, 0.0f, 100.0f);
        Frame frame = new Frame("Slider test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        frame.add(slider);
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    public Slider() {
    }

    public Slider(float f, float f2, float f3) {
        this.setBounds(f2, f3);
        this.setValue(f);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

