/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import visad.browser.Convert;
import visad.browser.Widget;

public class RangeSlider
extends Component
implements MouseListener,
MouseMotionListener {
    public static final String DEFAULT_NAME = "value";
    public static final int SLIDER_PREF_HEIGHT = 42;
    public static final int SLIDER_PREF_WIDTH = 300;
    public static final int GRIP_WIDTH = 9;
    public static final int GRIP_HEIGHT = 17;
    public static final int GRIP_TOP_Y = 4;
    public static final int GRIP_BOTTOM_Y = 21;
    public static final int GRIP_MIDDLE_Y = 12;
    public static final int SLIDER_LINE_HEIGHT = 19;
    public static final int SLIDER_LINE_WIDTH = 2;
    public static final int FONT_HEIGHT = 15;
    public static final int FONT_TOP_Y = 27;
    public static final int FONT_BOTTOM_Y = 40;
    protected float minValue = 0.0f;
    protected float maxValue = 100.0f;
    protected float minLimit = 0.0f;
    protected float maxLimit = 1.0f;
    private int minGrip = 9;
    private int maxGrip = 291;
    private boolean minSlide = false;
    private boolean maxSlide = false;
    private boolean lSlideMoved = false;
    private boolean rSlideMoved = false;
    private boolean textChanged = false;
    private String name;
    private float lastMinLimit = 0.0f;
    private float lastMaxLimit = 0.0f;
    private String lastCurStr = "";
    protected Dimension minSize = null;
    protected Dimension prefSize = null;
    protected Dimension maxSize = null;
    private int oldX;

    public float[] getMinMaxValues() {
        return new float[]{this.minValue, this.maxValue};
    }

    protected void resetValues(float f, float f2) {
        this.minLimit = f;
        this.maxLimit = f2;
        this.minGrip = 9;
        this.maxGrip = this.getSize().width - 9;
        this.minSlide = false;
        this.maxSlide = false;
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        int n = this.getSize().width;
        this.minValue = this.gripToValue(this.minGrip, n);
        this.maxValue = this.gripToValue(this.maxGrip, n);
    }

    public void setName(String string) {
        this.name = string;
        this.textChanged = true;
        this.repaint();
    }

    public void setBounds(float f, float f2) {
        this.resetValues(f, f2);
        this.valuesUpdated();
        this.repaint();
    }

    public void setValues(float f, float f2) {
        int n = this.getSize().width;
        this.minValue = f;
        int n2 = this.minGrip;
        this.minGrip = this.valueToGrip(this.minValue, n);
        if (n2 != this.minGrip) {
            this.lSlideMoved = true;
        }
        this.maxValue = f2;
        n2 = this.maxGrip;
        this.maxGrip = this.valueToGrip(this.maxValue, n);
        if (n2 != this.maxGrip) {
            this.rSlideMoved = true;
        }
        this.textChanged = true;
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getSize().width;
        super.setBounds(n, n2, n3, n4);
        if (n5 != n3) {
            this.minGrip = this.valueToGrip(this.minValue, n3);
            this.maxGrip = this.valueToGrip(this.maxValue, n3);
            Graphics graphics = this.getGraphics();
            this.drawLabels(graphics, n5);
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getSize().width;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.oldX = n2;
        if (Widget.containedIn(n2, n3, this.minGrip - 8, 4, 9, 17)) {
            this.minSlide = true;
        } else if (Widget.containedIn(n2, n3, this.maxGrip, 4, 9, 17)) {
            this.maxSlide = true;
        } else if (Widget.containedIn(n2, n3, this.minGrip, 1, this.maxGrip - this.minGrip, 22)) {
            this.minSlide = true;
            this.maxSlide = true;
        } else if (Widget.containedIn(n2, n3, 0, 1, this.minGrip - 9, 22)) {
            this.minGrip = n2 < 9 ? 9 : n2;
            this.minValue = this.gripToValue(this.minGrip, n);
            this.minSlide = true;
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (Widget.containedIn(n2, n3, this.maxGrip + 1 - 9, 1, n - this.maxGrip + 9, 22)) {
            this.maxGrip = n2 > n - 9 ? n - 9 : n2;
            this.maxValue = this.gripToValue(this.maxGrip, n);
            this.maxSlide = true;
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.minSlide = false;
        this.maxSlide = false;
        this.textChanged = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.getSize().width;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.minSlide && this.maxSlide) {
            int n4 = n2 - this.oldX;
            if (this.minGrip + n4 < 9) {
                n4 = 9 - this.minGrip;
            } else if (this.maxGrip + n4 > n - 9) {
                n4 = n - 9 - this.maxGrip;
            }
            if (n4 != 0) {
                this.minGrip += n4;
                this.minValue = this.gripToValue(this.minGrip, n);
                this.maxGrip += n4;
                this.maxValue = this.gripToValue(this.maxGrip, n);
                this.lSlideMoved = true;
                this.rSlideMoved = true;
                this.valuesUpdated();
                this.repaint();
            }
        } else if (this.minSlide) {
            this.minGrip = n2 < 9 ? 9 : (n2 >= this.maxGrip ? this.maxGrip - 1 : n2);
            this.minValue = this.gripToValue(this.minGrip, n);
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (this.maxSlide) {
            this.maxGrip = n2 > n - 9 ? n - 9 : (n2 <= this.minGrip ? this.minGrip + 1 : n2);
            this.maxValue = this.gripToValue(this.maxGrip, n);
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
        this.oldX = n2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(0, 42);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, 42);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 42);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    private float gripToValue(int n, int n2) {
        return (this.maxLimit - this.minLimit) * (float)(n - 9) / (float)(n2 - 18) + this.minLimit;
    }

    private int valueToGrip(float f, int n) {
        float f2 = (f - this.minLimit) * (float)(n - 18) / (this.maxLimit - this.minLimit);
        f2 = f2 < 0.0f ? (f2 -= 0.5f) : (f2 += 0.5f);
        return (int)f2 + 9;
    }

    public void valuesUpdated() {
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, 42);
        int n2 = n - 1;
        graphics.setColor(Color.white);
        graphics.drawLine(0, 12, n2, 12);
        graphics.drawLine(0, 0, 0, 23);
        graphics.drawLine(0, 0, 2, 0);
        graphics.drawLine(0, 23, 2, 23);
        graphics.drawLine(n2, 0, n2, 23);
        graphics.drawLine(n2, 0, n2 - 2, 0);
        graphics.drawLine(n2, 23, n2 - 2, 23);
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        this.paintMinimum(graphics);
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintMinimum(graphics);
            graphics.dispose();
        }
    }

    private void paintMinimum(Graphics graphics) {
        int[] nArray;
        int[] nArray2;
        int n = this.getSize().width;
        if (this.lSlideMoved) {
            graphics.setColor(Color.black);
            graphics.fillRect(2, 4, this.maxGrip - 3, 17);
            graphics.setColor(Color.white);
            graphics.drawLine(2, 12, this.maxGrip - 3, 12);
            graphics.setColor(Color.yellow);
            nArray2 = new int[]{this.minGrip - 9, this.minGrip + 1, this.minGrip + 1};
            nArray = new int[]{12, 4, 21};
            graphics.fillPolygon(nArray2, nArray, 3);
        }
        if (this.rSlideMoved) {
            graphics.setColor(Color.black);
            graphics.fillRect(this.minGrip + 1, 4, n - this.minGrip - 3, 17);
            graphics.setColor(Color.white);
            graphics.drawLine(this.minGrip + 1, 12, n - 3, 12);
            graphics.setColor(Color.yellow);
            nArray2 = new int[]{this.maxGrip + 9 - 1, this.maxGrip, this.maxGrip};
            nArray = new int[]{12, 4, 21};
            graphics.fillPolygon(nArray2, nArray, 3);
        }
        if (this.lSlideMoved || this.rSlideMoved) {
            graphics.setColor(Color.pink);
            graphics.fillRect(this.minGrip + 1, 12, this.maxGrip - this.minGrip - 1, 3);
        }
        if (this.textChanged) {
            this.drawLabels(graphics, n);
        }
        this.lSlideMoved = false;
        this.rSlideMoved = false;
        this.textChanged = false;
    }

    private void drawLabels(Graphics graphics, int n) {
        int n2;
        int n3 = this.getSize().width;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.lastMinLimit != this.minLimit || n != n3) {
            graphics.setColor(Color.black);
            n2 = fontMetrics.stringWidth("" + this.lastMinLimit);
            graphics.fillRect(1, 27, n2, 15);
            this.lastMinLimit = this.minLimit;
        }
        if (this.lastMaxLimit != this.maxLimit || n != n3) {
            graphics.setColor(Color.black);
            n2 = fontMetrics.stringWidth("" + this.lastMaxLimit);
            graphics.fillRect(n - 4 - n2, 27, n2, 15);
            this.lastMaxLimit = this.maxLimit;
        }
        String string = Convert.shortString(this.minValue);
        String string2 = Convert.shortString(this.maxValue);
        String string3 = this.name + " = (" + string + ", " + string2 + ")";
        if (!string3.equals(this.lastCurStr) || n != n3) {
            graphics.setColor(Color.black);
            int n4 = fontMetrics.stringWidth(this.lastCurStr);
            graphics.fillRect((n - n4) / 2, 27, n4, 15);
            this.lastCurStr = string3;
        }
        graphics.setColor(Color.white);
        graphics.drawString(Convert.shortString(this.minLimit), 1, 40);
        String string4 = Convert.shortString(this.maxLimit);
        graphics.drawString(string4, n3 - 4 - fontMetrics.stringWidth(string4), 40);
        graphics.drawString(string3, (n3 - fontMetrics.stringWidth(string3)) / 2, 40);
    }

    public static void main(String[] stringArray) {
        RangeSlider rangeSlider = new RangeSlider("", 0.0f, 100.0f);
        Frame frame = new Frame("RangeSlider test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        frame.add(rangeSlider);
        frame.pack();
        ((Component)frame).setVisible(true);
        rangeSlider.setValues(22.2222f, 76.5432f);
    }

    public RangeSlider(String string, float f, float f2) {
        this.name = string;
        this.resetValues(f, f2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

