/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import visad.browser.Convert;
import visad.browser.Widget;
import visad.browser.WidgetEvent;

public class GMCWidget
extends Widget
implements ActionListener,
ItemListener {
    Checkbox scale;
    Checkbox point;
    Checkbox texture;
    TextField lineWidth;
    TextField pointSize;
    boolean gmcScaleEnable;
    boolean gmcPointMode;
    boolean gmcTextureEnable;
    float gmcLineWidth;
    float gmcPointSize;
    int gmcTransparencyMode;
    int gmcProjectionPolicy;
    int gmcPolygonMode;
    boolean gmcMissingTransparent;
    int gmcCurvedSize;

    public float getLineWidth() {
        return this.gmcLineWidth;
    }

    public void setLineWidth(float f) {
        this.gmcLineWidth = f;
        this.lineWidth.setText(Convert.shortString(f));
    }

    public float getPointSize() {
        return this.gmcPointSize;
    }

    public void setPointSize(float f) {
        this.gmcPointSize = f;
        this.pointSize.setText(Convert.shortString(f));
    }

    public boolean getPointMode() {
        return this.gmcPointMode;
    }

    public void setPointMode(boolean bl) {
        this.gmcPointMode = bl;
        this.point.setState(bl);
    }

    public boolean getTextureEnable() {
        return this.gmcTextureEnable;
    }

    public void setTextureEnable(boolean bl) {
        this.gmcTextureEnable = bl;
        this.texture.setState(bl);
    }

    public boolean getScaleEnable() {
        return this.gmcScaleEnable;
    }

    public void setScaleEnable(boolean bl) {
        this.gmcScaleEnable = bl;
        this.scale.setState(bl);
    }

    public int getTransparencyMode() {
        return this.gmcTransparencyMode;
    }

    public void setTransparencyMode(int n) {
        this.gmcTransparencyMode = n;
    }

    public int getProjectionPolicy() {
        return this.gmcProjectionPolicy;
    }

    public void setProjectionPolicy(int n) {
        this.gmcProjectionPolicy = n;
    }

    public int getPolygonMode() {
        return this.gmcPolygonMode;
    }

    public void setPolygonMode(int n) {
        this.gmcPolygonMode = n;
    }

    public boolean getMissingTransparent() {
        return this.gmcMissingTransparent;
    }

    public void setMissingTransparent(boolean bl) {
        this.gmcMissingTransparent = bl;
    }

    public int getCurvedSize() {
        return this.gmcCurvedSize;
    }

    public void setCurvedSize(int n) {
        this.gmcCurvedSize = n;
    }

    public String getSaveString() {
        return "" + this.gmcLineWidth + " " + this.gmcPointSize + " " + this.gmcPointMode + " " + this.gmcTextureEnable + " " + this.gmcScaleEnable + " " + this.gmcTransparencyMode + " " + this.gmcProjectionPolicy + " " + this.gmcPolygonMode + " " + this.gmcMissingTransparent + " " + this.gmcCurvedSize;
    }

    public void setSaveString(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 10) {
            System.out.println("Invalid save string");
            return;
        }
        float f = Convert.getFloat(stringTokenizer.nextToken());
        float f2 = Convert.getFloat(stringTokenizer.nextToken());
        boolean bl = Convert.getBoolean(stringTokenizer.nextToken());
        boolean bl2 = Convert.getBoolean(stringTokenizer.nextToken());
        boolean bl3 = Convert.getBoolean(stringTokenizer.nextToken());
        int n2 = Convert.getInt(stringTokenizer.nextToken());
        int n3 = Convert.getInt(stringTokenizer.nextToken());
        int n4 = Convert.getInt(stringTokenizer.nextToken());
        boolean bl4 = Convert.getBoolean(stringTokenizer.nextToken());
        int n5 = Convert.getInt(stringTokenizer.nextToken());
        this.setLineWidth(f);
        this.setPointSize(f2);
        this.setPointMode(bl);
        this.setTextureEnable(bl2);
        this.setScaleEnable(bl3);
        this.setTransparencyMode(n2);
        this.setProjectionPolicy(n3);
        this.setPolygonMode(n4);
        this.setMissingTransparent(bl4);
        this.setCurvedSize(n5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object == this.lineWidth) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.lineWidth.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.lineWidth.setText(Convert.shortString(this.gmcLineWidth));
            }
            if (f == f) {
                this.setLineWidth(f);
                this.scale.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (object == this.pointSize) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.pointSize.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.pointSize.setText(Convert.shortString(this.gmcPointSize));
            }
            if (f == f) {
                this.setPointSize(f);
                this.scale.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.scale) {
            this.setScaleEnable(bl);
        } else if (itemSelectable == this.point) {
            this.setPointMode(bl);
        } else if (itemSelectable == this.texture) {
            this.setTextureEnable(bl);
        }
        this.notifyListeners(new WidgetEvent(this));
    }

    public static void main(String[] stringArray) {
        new GMCWidget().testWidget();
    }

    public GMCWidget() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.scale = new Checkbox("Enable scale", this.gmcScaleEnable);
        this.point = new Checkbox("Point mode", this.gmcPointMode);
        this.texture = new Checkbox("Texture mapping", this.gmcTextureEnable);
        this.lineWidth = new TextField(Convert.shortString(this.gmcLineWidth));
        this.pointSize = new TextField(Convert.shortString(this.gmcPointSize));
        this.scale.addItemListener(this);
        this.point.addItemListener(this);
        this.texture.addItemListener(this);
        this.lineWidth.addActionListener(this);
        this.pointSize.addActionListener(this);
        this.addComponent(this.scale, gridBagLayout, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.point, gridBagLayout, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.texture, gridBagLayout, 2, 0, 2, 1, 0.0, 0.0);
        this.addComponent(new Label("Line width:"), gridBagLayout, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.lineWidth, gridBagLayout, 1, 1, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("Point size:"), gridBagLayout, 2, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.pointSize, gridBagLayout, 3, 1, 1, 1, 1.0, 0.0);
    }
}

