/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

public class Convert {
    private static final int RLE_ESCAPE = Integer.MIN_VALUE;
    public static final int PLACES = 3;

    public static byte[] intToBytes(int[] nArray) {
        int n = nArray.length;
        byte[] byArray = new byte[4 * n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            byArray[4 * n2] = (byte)(n3 & 0xFF);
            byArray[4 * n2 + 1] = (byte)((n3 & 0xFF00) >> 8);
            byArray[4 * n2 + 2] = (byte)((n3 & 0xFF0000) >> 16);
            byArray[4 * n2 + 3] = (byte)((n3 & 0xFF000000) >> 24);
            ++n2;
        }
        return byArray;
    }

    public static int[] bytesToInt(byte[] byArray) {
        int n = byArray.length / 4;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[4 * n2 + 3] << 24;
            int n4 = byArray[4 * n2 + 2] << 16;
            int n5 = byArray[4 * n2 + 1] << 8;
            int n6 = byArray[4 * n2];
            if (n4 < 0) {
                n4 += 0x1000000;
            }
            if (n5 < 0) {
                n5 += 65536;
            }
            if (n6 < 0) {
                n6 += 256;
            }
            nArray[n2] = n3 | n4 | n5 | n6;
            ++n2;
        }
        return nArray;
    }

    public static int[] encodeRLE(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = 0;
            while (n3 < n && n4 == nArray[n3]) {
                ++n5;
                ++n3;
            }
            if (n5 < 4) {
                int n6 = 0;
                while (n6 < n5) {
                    nArray2[n2++] = n4;
                    ++n6;
                }
                continue;
            }
            nArray2[n2++] = Integer.MIN_VALUE;
            nArray2[n2++] = n4;
            nArray2[n2++] = n5;
        }
        int[] nArray3 = new int[n2];
        System.arraycopy(nArray2, 0, nArray3, 0, n2);
        return nArray3;
    }

    public static int[] decodeRLE(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == Integer.MIN_VALUE) {
                n += nArray[n2 + 2];
                n2 += 3;
                continue;
            }
            ++n;
            ++n2;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        n2 = 0;
        while (n2 < nArray.length) {
            int n4 = nArray[n2];
            if (n4 == Integer.MIN_VALUE) {
                int n5 = nArray[++n2];
                int n6 = nArray[++n2];
                int n7 = 0;
                while (n7 < n6) {
                    nArray2[n3++] = n5;
                    ++n7;
                }
            } else {
                nArray2[n3++] = n4;
            }
            ++n2;
        }
        return nArray2;
    }

    public static double getDouble(String string) {
        double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static float getFloat(String string) {
        float f = Float.NaN;
        if (string != null) {
            try {
                f = Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public static boolean getBoolean(String string) {
        if (string == null) {
            return false;
        }
        char c = string.trim().charAt(0);
        return c == 'T' || c == 't';
    }

    public static int getInt(String string) {
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static String shortString(double d) {
        int n;
        boolean bl = d < 0.0;
        double d2 = d;
        if ((d = Math.abs(d)) < 0.001) {
            n = 1;
            while (n < 30) {
                d *= 10.0;
                d2 *= 10.0;
                if (d >= 1.0) {
                    return Convert.shortString(d2) + "E-" + n;
                }
                ++n;
            }
        }
        n = 1;
        float f = 0.5f;
        int n2 = 3;
        while (n2 > 0) {
            n *= 10;
            f /= 10.0f;
            --n2;
        }
        long l = (long)((d + (double)f) * (double)n);
        long l2 = l / (long)n;
        int n3 = (int)(l % (long)n);
        String string = l2 <= Integer.MAX_VALUE ? Integer.toString((int)l2) : Long.toString(l2);
        if (n3 == 0) {
            if (bl && l2 != 0L) {
                return "-" + string;
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append(string);
        stringBuffer.append('.');
        string = Integer.toString(n3);
        int n4 = string.length();
        int n5 = 3;
        while (n5 > n4) {
            stringBuffer.append('0');
            --n5;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

