/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import visad.browser.Convert;
import visad.browser.RangeSlider;
import visad.browser.Slider;
import visad.browser.Widget;
import visad.browser.WidgetEvent;

public class ContourWidget
extends Widget
implements ActionListener,
ItemListener {
    Checkbox contours;
    Checkbox labels;
    Checkbox dashed;
    TextField interval;
    TextField base;
    Label surfaceLabel;
    Slider surface;
    ContourRangeSlider contourRange;
    private String cwName;
    private double cwMinValue;
    private double cwMaxValue;
    private boolean cwMainContours;
    private boolean cwLabels;
    private float cwSurfaceValue;
    private float cwContourInterval;
    private float cwLowLimit;
    private float cwHiLimit;
    private float cwBase;

    public String getName() {
        return this.cwName;
    }

    public void setName(String string) {
        this.cwName = string;
        this.contourRange.setName(string);
        this.refreshSurfaceLabel();
    }

    public double getMinValue() {
        return this.cwMinValue;
    }

    public double getMaxValue() {
        return this.cwMaxValue;
    }

    public void setRange(float f, float f2) {
        this.cwMinValue = f;
        this.cwMaxValue = f2;
        this.surface.setBounds(f, f2);
        this.contourRange.setBounds(f, f2);
    }

    public boolean getMainContours() {
        return this.cwMainContours;
    }

    public void setMainContours(boolean bl) {
        this.cwMainContours = bl;
        this.contours.setState(bl);
    }

    public boolean getLabels() {
        return this.cwLabels;
    }

    public void setLabels(boolean bl) {
        this.cwLabels = bl;
        this.labels.setState(bl);
    }

    public float getSurfaceValue() {
        return this.cwSurfaceValue;
    }

    public void setSurfaceValue(float f) {
        this.cwSurfaceValue = f;
        this.surface.setValue(f);
        this.refreshSurfaceLabel();
    }

    public float getContourInterval() {
        return this.cwContourInterval;
    }

    public void setContourInterval(float f) {
        this.cwContourInterval = f;
        this.interval.setText(Convert.shortString(Math.abs(f)));
        this.dashed.setState(f < 0.0f);
    }

    public float getLowLimit() {
        return this.cwLowLimit;
    }

    public float getHiLimit() {
        return this.cwHiLimit;
    }

    public void setLimits(float f, float f2) {
        this.cwLowLimit = f;
        this.cwHiLimit = f2;
        this.contourRange.setValues(f, f2);
    }

    public float getBase() {
        return this.cwBase;
    }

    public void setBase(float f) {
        this.cwBase = f;
        this.base.setText(Convert.shortString(f));
    }

    public String getSaveString() {
        return this.cwMainContours + " " + this.cwLabels + " " + this.cwSurfaceValue + " " + this.cwContourInterval + " " + this.cwLowLimit + " " + this.cwHiLimit + " " + this.cwBase;
    }

    public void setSaveString(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 7) {
            return;
        }
        boolean bl = Convert.getBoolean(stringTokenizer.nextToken());
        boolean bl2 = Convert.getBoolean(stringTokenizer.nextToken());
        float f = Convert.getFloat(stringTokenizer.nextToken());
        float f2 = Convert.getFloat(stringTokenizer.nextToken());
        float f3 = Convert.getFloat(stringTokenizer.nextToken());
        float f4 = Convert.getFloat(stringTokenizer.nextToken());
        float f5 = Convert.getFloat(stringTokenizer.nextToken());
        this.setMainContours(bl);
        this.setLabels(bl2);
        this.setSurfaceValue(f);
        this.setContourInterval(f2);
        this.setLimits(f3, f4);
        this.setBase(f5);
    }

    private void refreshSurfaceLabel() {
        this.surfaceLabel.setText((this.cwName == null ? "value" : this.cwName) + " = " + (Float.isNaN(this.cwSurfaceValue) ? "---" : Convert.shortString(this.cwSurfaceValue)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.interval) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.interval.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.interval.setText(Convert.shortString(Math.abs(this.cwContourInterval)));
            }
            if (f > 0.0f) {
                if (this.dashed.getState()) {
                    f = -f;
                }
                this.setContourInterval(f);
                this.contours.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (object == this.base) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.base.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.base.setText(Convert.shortString(this.cwBase));
            }
            if (f == f) {
                this.setBase(f);
                this.contours.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (object == this.surface) {
            float f = this.surface.getValue();
            this.setSurfaceValue(f);
            this.notifyListeners(new WidgetEvent(this));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.contours) {
            this.setMainContours(bl);
        } else if (itemSelectable == this.labels) {
            this.setLabels(bl);
        } else if (itemSelectable == this.dashed) {
            this.setContourInterval(-this.cwContourInterval);
        }
        this.notifyListeners(new WidgetEvent(this));
    }

    public static void main(String[] stringArray) {
        new ContourWidget().testWidget();
    }

    public ContourWidget() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.contours = new Checkbox("contours", this.cwMainContours);
        this.labels = new Checkbox("labels", this.cwLabels);
        this.dashed = new Checkbox("dashed lines below base", this.cwContourInterval < 0.0f);
        this.interval = new TextField(Convert.shortString(Math.abs(this.cwContourInterval)));
        this.base = new TextField(Convert.shortString(this.cwBase));
        this.surfaceLabel = new Label("value = 0");
        this.surface = new Slider(0.0f, 0.0f, 1.0f);
        this.contourRange = new ContourRangeSlider(0.0f, 1.0f, this);
        this.contours.addItemListener(this);
        this.labels.addItemListener(this);
        this.dashed.addItemListener(this);
        this.interval.addActionListener(this);
        this.base.addActionListener(this);
        this.surface.addActionListener(this);
        this.addComponent(this.contours, gridBagLayout, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.labels, gridBagLayout, 2, 0, 2, 1, 0.0, 0.0);
        this.addComponent(this.dashed, gridBagLayout, 1, 1, 3, 1, 0.0, 0.0);
        this.addComponent(new Label("interval:"), gridBagLayout, 0, 2, 1, 1, 0.0, 0.0);
        this.addComponent(this.interval, gridBagLayout, 1, 2, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("base:"), gridBagLayout, 2, 2, 1, 1, 0.0, 0.0);
        this.addComponent(this.base, gridBagLayout, 3, 2, 1, 1, 1.0, 0.0);
        this.addComponent(this.surfaceLabel, gridBagLayout, 0, 3, 4, 1, 1.0, 0.0);
        this.addComponent(this.surface, gridBagLayout, 0, 4, 4, 1, 1.0, 0.0);
        this.addComponent(this.contourRange, gridBagLayout, 0, 5, 4, 1, 1.0, 1.0);
    }

    class ContourRangeSlider
    extends RangeSlider {
        private ContourWidget widget;

        public void valuesUpdated() {
            this.widget.setLimits(this.minValue, this.maxValue);
            this.widget.notifyListeners(new WidgetEvent(this.widget));
        }

        ContourRangeSlider(float f, float f2, ContourWidget contourWidget2) {
            super("value", f, f2);
            this.widget = contourWidget2;
        }
    }
}

