/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Integer1DSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.VisADException;
import visad.VisADLineArray;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class TrackManipulation {
    private static int NE = 32;
    private static final int NUM = 4096;
    private DisplayImplJ3D display;
    private DataReference track1_ref;
    private DataReference track2_ref;
    private DataReference track3_ref;
    private RealTupleType latlonshape = null;
    private ScalarMap latmap = null;
    private ScalarMap lonmap = null;
    private CoordinateSystem coord = null;
    private int latindex = -1;
    private int lonindex = -1;
    private int otherindex = -1;
    private float othervalue = 0.0f;
    private ScalarMap shapemap = null;
    private ShapeControl shapecontrol = null;
    private float x_size;
    private float y_size;
    private float angle;
    private float[] x_ellipse = new float[NE + 1];
    private float[] y_ellipse = new float[NE + 1];

    private float getStep(float f, float f2) {
        double d = 2.0 * (double)(this.x_size + this.y_size);
        float f3 = -1.0f;
        int n = 0;
        while (n < NE + 1) {
            double d2 = Math.abs(f * this.y_ellipse[n] - f2 * this.x_ellipse[n]);
            if (d2 < d) {
                d = d2;
                f3 = (float)Math.sqrt(this.x_ellipse[n] * this.x_ellipse[n] + this.y_ellipse[n] * this.y_ellipse[n]);
            }
            ++n;
        }
        return f3;
    }

    private VisADLineArray makeTrack(float[][] fArray) {
        float f;
        float f2 = 0.112500004f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray[2][0];
        float f6 = fArray[0][1] - fArray[0][0];
        float f7 = fArray[1][1] - fArray[1][0];
        float f8 = f6 - f3;
        float f9 = f7 - f4;
        float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
        float f11 = f8 / f10;
        float f12 = f9 / f10;
        int n = 0;
        float[] fArray2 = new float[4096];
        float[] fArray3 = new float[4096];
        float[] fArray4 = new float[4096];
        int n2 = fArray2.length;
        fArray2[n] = f3;
        fArray3[n] = f4;
        fArray4[n] = f5;
        fArray2[++n] = f6;
        fArray3[n] = f7;
        fArray4[n] = f5;
        ++n;
        float f13 = f2 * f11;
        float f14 = f2 * f12;
        float f15 = f6 - 0.3f * (f13 - f14);
        float f16 = f7 - 0.3f * (f14 + f13);
        float f17 = f6 - 0.3f * (f13 + f14);
        float f18 = f7 - 0.3f * (f14 - f13);
        fArray2[n] = f6;
        fArray3[n] = f7;
        fArray4[n] = f5;
        fArray2[++n] = f15;
        fArray3[n] = f16;
        fArray4[n] = f5;
        fArray2[++n] = f6;
        fArray3[n] = f7;
        fArray4[n] = f5;
        fArray2[++n] = f17;
        fArray3[n] = f18;
        fArray4[n] = f5;
        ++n;
        float f19 = this.getStep(f8, f9);
        int n3 = (int)(f10 / f19);
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = (fArray2.length - n) / (2 * NE);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        float f20 = f8 / (float)n3;
        float f21 = f9 / (float)n3;
        boolean[] blArray = new boolean[NE + 1];
        int n5 = 0;
        while (n5 < NE + 1) {
            float f22 = this.x_ellipse[n5] + f20;
            float f23 = this.y_ellipse[n5] + f21;
            float f24 = this.getStep(f22, f23);
            f = (float)Math.sqrt(f22 * f22 + f23 * f23);
            blArray[n5] = f > f24;
            ++n5;
        }
        float[] fArray5 = new float[2 * NE];
        float[] fArray6 = new float[2 * NE];
        int n6 = 0;
        int n7 = 0;
        while (n7 < NE) {
            if (blArray[n7] && blArray[n7 + 1]) {
                fArray5[n6] = this.x_ellipse[n7];
                fArray6[n6] = this.y_ellipse[n7];
                fArray5[++n6] = this.x_ellipse[n7 + 1];
                fArray6[n6] = this.y_ellipse[n7 + 1];
                ++n6;
            }
            ++n7;
        }
        float f25 = f3;
        f = f4;
        int n8 = 0;
        while (n8 < NE) {
            fArray2[n] = this.x_ellipse[n8];
            fArray3[n] = this.y_ellipse[n8];
            fArray4[n] = f5;
            fArray2[++n] = this.x_ellipse[n8 + 1];
            fArray3[n] = this.y_ellipse[n8 + 1];
            fArray4[n] = f5;
            ++n;
            ++n8;
        }
        n8 = 0;
        while (n8 < n3) {
            f25 += f20;
            f += f21;
            int n9 = 0;
            while (n9 < n6) {
                fArray2[n] = f25 + fArray5[n9];
                fArray3[n] = f + fArray6[n9];
                fArray4[n] = f5;
                ++n;
                ++n9;
            }
            ++n8;
        }
        VisADLineArray visADLineArray = new VisADLineArray();
        visADLineArray.vertexCount = n;
        float[] fArray7 = new float[3 * n];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n) {
            fArray7[n10++] = fArray2[n11];
            fArray7[n10++] = fArray3[n11];
            fArray7[n10++] = fArray4[n11];
            ++n11;
        }
        visADLineArray.coordinates = fArray7;
        return visADLineArray;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        float[] fArray = new float[]{0.2f, 0.1f, 0.0f};
        int n = 0;
        while (n < stringArray.length) {
            try {
                fArray[n] = Float.parseFloat(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(RealType.Longitude, Display.XAxis);
        displayImplJ3D.addMap(scalarMap);
        scalarMap.setRange(-10.0, 10.0);
        ScalarMap scalarMap2 = new ScalarMap(RealType.Latitude, Display.YAxis);
        displayImplJ3D.addMap(scalarMap2);
        scalarMap2.setRange(-10.0, 10.0);
        TrackManipulation trackManipulation = new TrackManipulation(0.0f, 0.0f, 3.0f, 3.0f, displayImplJ3D, fArray[0], fArray[1], fArray[2]);
        JFrame jFrame = new JFrame("test TrackManipulation");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }

    public TrackManipulation(float f, float f2, float f3, float f4, DisplayImplJ3D displayImplJ3D, float f5, float f6, float f7) throws VisADException, RemoteException {
        Comparable comparable;
        RealTupleType realTupleType = new RealTupleType(RealType.Latitude, RealType.Longitude);
        RealTuple realTuple = new RealTuple(realTupleType, new double[]{f, f2});
        RealTuple realTuple2 = new RealTuple(realTupleType, new double[]{f3, f4});
        RealType realType = new RealType("shape");
        this.latlonshape = new RealTupleType(RealType.Latitude, RealType.Longitude, realType);
        RealTuple realTuple3 = new RealTuple(this.latlonshape, new double[]{f, f2, 0.0});
        this.track1_ref = new DataReferenceImpl("track1_ref");
        this.track2_ref = new DataReferenceImpl("track2_ref");
        this.track3_ref = new DataReferenceImpl("track3_ref");
        this.track1_ref.setData(realTuple);
        this.track2_ref.setData(realTuple2);
        this.track3_ref.setData(realTuple3);
        this.display = displayImplJ3D;
        this.x_size = Math.abs(f5);
        this.y_size = Math.abs(f6);
        this.angle = f7;
        float f8 = (float)Math.sin((double)f7 * (Math.PI / 180));
        float f9 = (float)Math.cos((double)f7 * (Math.PI / 180));
        int n = 0;
        while (n < NE + 1) {
            double d = Math.PI * 2 * (double)n / (double)NE;
            float f10 = (float)((double)this.x_size * Math.cos(d));
            float f11 = (float)((double)this.y_size * Math.sin(d));
            this.x_ellipse[n] = f9 * f10 + f8 * f11;
            this.y_ellipse[n] = f9 * f11 - f8 * f10;
            ++n;
        }
        Vector vector = this.display.getMapVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            comparable = (ScalarMap)enumeration.nextElement();
            if (RealType.Latitude.equals(((ScalarMap)comparable).getScalar())) {
                this.latmap = comparable;
                continue;
            }
            if (!RealType.Longitude.equals(((ScalarMap)comparable).getScalar())) continue;
            this.lonmap = comparable;
        }
        if (this.latmap == null || this.lonmap == null) {
            throw new DisplayException("Latitude and Longitude must be mapped in display");
        }
        comparable = this.latmap.getDisplayScalar();
        DisplayRealType displayRealType = this.lonmap.getDisplayScalar();
        DisplayTupleType displayTupleType = ((DisplayRealType)comparable).getTuple();
        DisplayTupleType displayTupleType2 = displayRealType.getTuple();
        if (displayTupleType == null || !displayTupleType.equals(displayTupleType2)) {
            throw new DisplayException("Latitude and Longitude must be mapped to spatial in display(1)");
        }
        this.latindex = ((DisplayRealType)comparable).getTupleIndex();
        this.lonindex = displayRealType.getTupleIndex();
        this.otherindex = 3 - (this.latindex + this.lonindex);
        DisplayRealType displayRealType2 = (DisplayRealType)displayTupleType.getComponent(this.otherindex);
        this.othervalue = (float)displayRealType2.getDefaultValue();
        this.coord = displayTupleType.getCoordinateSystem();
        if (!(displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || this.coord != null && this.coord.getReference().equals(Display.DisplaySpatialCartesianTuple))) {
            throw new DisplayException("Latitude and Longitude must be mapped to spatial in display(2)");
        }
        this.shapemap = new ScalarMap(realType, Display.Shape);
        this.display.addMap(this.shapemap);
        this.shapecontrol = (ShapeControl)this.shapemap.getControl();
        this.shapecontrol.setShapeSet(new Integer1DSet(1));
        this.display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.track1_ref);
        this.display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.track2_ref);
        this.display.addReference(this.track3_ref);
        TrackGetter trackGetter = new TrackGetter();
        trackGetter.addReference(this.track1_ref);
        trackGetter.addReference(this.track2_ref);
    }

    class TrackGetter
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            float[] fArray = new float[2];
            float[] fArray2 = new float[2];
            RealTuple realTuple = (RealTuple)TrackManipulation.this.track1_ref.getData();
            fArray[0] = (float)((Real)realTuple.getComponent(0)).getValue(RealType.Latitude.getDefaultUnit());
            fArray2[0] = (float)((Real)realTuple.getComponent(1)).getValue(RealType.Longitude.getDefaultUnit());
            float f = fArray[0];
            float f2 = fArray2[0];
            RealTuple realTuple2 = (RealTuple)TrackManipulation.this.track2_ref.getData();
            fArray[1] = (float)((Real)realTuple2.getComponent(0)).getValue(RealType.Latitude.getDefaultUnit());
            fArray2[1] = (float)((Real)realTuple2.getComponent(1)).getValue(RealType.Longitude.getDefaultUnit());
            fArray = TrackManipulation.this.latmap.scaleValues(fArray);
            fArray2 = TrackManipulation.this.lonmap.scaleValues(fArray2);
            float[][] fArray3 = new float[3][2];
            int n = 0;
            while (n < 2) {
                fArray3[((TrackManipulation)TrackManipulation.this).latindex][n] = fArray[n];
                fArray3[((TrackManipulation)TrackManipulation.this).lonindex][n] = fArray2[n];
                fArray3[((TrackManipulation)TrackManipulation.this).otherindex][n] = TrackManipulation.this.othervalue;
                ++n;
            }
            if (TrackManipulation.this.coord != null) {
                fArray3 = TrackManipulation.this.coord.toReference(fArray3);
            }
            TrackManipulation.this.display.disableAction();
            RealTuple realTuple3 = new RealTuple(TrackManipulation.this.latlonshape, new double[]{f, f2, 0.0});
            TrackManipulation.this.track3_ref.setData(realTuple3);
            VisADLineArray visADLineArray = TrackManipulation.this.makeTrack(fArray3);
            TrackManipulation.this.shapecontrol.setShape(0, visADLineArray);
            TrackManipulation.this.display.enableAction();
        }
    }
}

