/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.util.Util;

public class TCData {
    static RealType rtTime = RealType.Time;
    static RealType rtConfidence;
    static RealType rtLat;
    static RealType rtLon;
    static RealType rtError;
    static RealType rtLocationStyle;
    static RealTupleType locationTuple;
    static FunctionType locationFunction;
    static RealType rtWindMean;
    static RealType rtWindGust;
    static RealType rtCentralPressure;
    static RealType rtCategory;
    static RealType rtIntensityStyle;
    static RealType rtGaleRadius;
    static RealType rtStormRadius;
    static RealType rtHurricaneRadius;
    static RealType rtRadiusOfMaximumWinds;
    static RealType rtSizeStyle;
    static RealType rtDepth;
    static RealType rtEyeDiameter;
    static RealType rtPressureOfLastClosedIsobar;
    static RealType rtStructureStyle;
    static RealType rtTrackID;
    static TextType ttTrackType;
    static TextType ttTrackName;
    static RealType rtBaseDateTime;
    static RealType rtCreateDateTime;
    static TextType ttTrackStyle;
    static TupleType ttTrack;
    static FunctionType ftId2Track;
    static RealType rtDisturbanceID;
    static TextType ttCountry;
    static TextType ttState;
    static RealType rtYear;
    static RealType rtNumber;
    static TextType ttHistoricalName;
    static RealType rtOpenDate;
    static RealType rtCloseDate;
    static RealType rtArchiveMode;
    static RealType rtRealtimeMode;
    static TupleType ttDisturbance;
    static FunctionType ftId2Disturbance;
    static FunctionType mtTC;
    FieldImpl data = null;

    public FieldImpl getData() {
        return this.data;
    }

    public MathType getType() {
        return mtTC;
    }

    public synchronized void addLocation(int n, int n2, double d, RealTuple realTuple) throws VisADException, RemoteException {
        this.addToTrack(n, n2, d, 5, locationFunction, realTuple);
    }

    private void addToTrack(int n, int n2, double d, int n3, FunctionType functionType, RealTuple realTuple) throws VisADException, RemoteException {
        Tuple tuple = this.getDisturbance(n);
        if (tuple == null) {
            throw new VisADException("invalid disturbanceID");
        }
        Tuple tuple2 = this.getTrack(n2, tuple);
        if (tuple2 == null) {
            throw new VisADException("invalid trackID");
        }
        FlatField flatField = (FlatField)tuple2.getComponent(n3);
        Gridded1DDoubleSet gridded1DDoubleSet = (Gridded1DDoubleSet)flatField.getDomainSet();
        double[][] dArray = gridded1DDoubleSet.getDoubles(false);
        int n4 = gridded1DDoubleSet.getLength();
        double[][] dArray2 = new double[1][n4 + 1];
        float[][] fArray = flatField.getFloats(false);
        int n5 = fArray.length;
        float[][] fArray2 = new float[n5][n4 + 1];
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        while (n8 < n4 + 1) {
            int n9;
            if (Util.isApproximatelyEqual(d, dArray[0][n6])) {
                throw new VisADException("time " + d + " already used");
            }
            if (n7 < 0 && d < dArray[0][n6]) {
                dArray2[0][n8] = d;
                n9 = 0;
                while (n9 < n5) {
                    fArray2[n9][n8] = Float.NaN;
                    ++n9;
                }
                n7 = n8;
            } else {
                dArray2[0][n8] = dArray[0][n6];
                n9 = 0;
                while (n9 < n5) {
                    fArray2[n9][n8] = fArray[n9][n6];
                    ++n9;
                }
                ++n6;
            }
            ++n8;
        }
        Gridded1DDoubleSet gridded1DDoubleSet2 = new Gridded1DDoubleSet((MathType)rtTime, dArray2, n4 + 1);
        FlatField flatField2 = new FlatField(functionType, gridded1DDoubleSet2);
        flatField2.setSamples(fArray2, false);
        flatField2.setSample(n7, (Data)realTuple);
        Data[] dataArray = new Data[]{tuple2.getComponent(0), tuple2.getComponent(1), tuple2.getComponent(2), tuple2.getComponent(3), tuple2.getComponent(4), tuple2.getComponent(5)};
        dataArray[n3] = flatField2;
        Tuple tuple3 = new Tuple(new Data[]{dataArray[0], dataArray[1], dataArray[2], dataArray[3], dataArray[4], dataArray[5]});
        this.setTrack(n2, tuple3, tuple);
        this.setDisturbance(n, tuple);
    }

    public static FieldImpl makeTrackField(int n, Tuple tuple) throws VisADException, RemoteException {
        float f = n;
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)rtTrackID, new float[][]{{f}}, 1);
        FieldImpl fieldImpl = new FieldImpl(ftId2Track, gridded1DSet);
        fieldImpl.setSample(0, (Data)tuple);
        return fieldImpl;
    }

    public synchronized void addTrack(int n, int n2, Tuple tuple) throws VisADException, RemoteException {
        DataImpl dataImpl;
        Tuple tuple2 = this.getDisturbance(n);
        if (tuple2 == null) {
            throw new VisADException("invalid disturbanceID");
        }
        FieldImpl fieldImpl = (FieldImpl)tuple2.getComponent(9);
        float f = n2;
        FieldImpl fieldImpl2 = null;
        if (fieldImpl == null) {
            dataImpl = new Gridded1DSet((MathType)rtTrackID, new float[][]{{f}}, 1);
            fieldImpl2 = new FieldImpl(ftId2Track, (Set)dataImpl);
            fieldImpl2.setSample(0, (Data)tuple);
        } else {
            dataImpl = (Gridded1DSet)fieldImpl.getDomainSet();
            float[][] fArray = dataImpl.getSamples(false);
            int n3 = dataImpl.getLength();
            float[][] fArray2 = new float[1][n3 + 1];
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n3 + 1) {
                if (f == fArray[0][n4]) {
                    throw new VisADException("trackID " + n2 + " already used");
                }
                if (n5 < 0 && f < fArray[0][n4]) {
                    fArray2[0][n6] = f;
                    n5 = n6;
                } else {
                    fArray2[0][n6] = fArray[0][n4];
                    ++n4;
                }
                ++n6;
            }
            Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)rtTrackID, fArray2, n3 + 1);
            fieldImpl2 = new FieldImpl(ftId2Track, gridded1DSet);
            n4 = 0;
            int n7 = 0;
            while (n7 < n3 + 1) {
                if (n7 == n5) {
                    fieldImpl2.setSample(n7, (Data)tuple, false);
                } else {
                    fieldImpl2.setSample(n7, fieldImpl.getSample(n4), false);
                    ++n4;
                }
                ++n7;
            }
        }
        dataImpl = new Tuple(new Data[]{tuple2.getComponent(0), tuple2.getComponent(1), tuple2.getComponent(2), tuple2.getComponent(3), tuple2.getComponent(4), tuple2.getComponent(5), tuple2.getComponent(6), tuple2.getComponent(7), tuple2.getComponent(8), fieldImpl2});
        this.setDisturbance(n, (Tuple)dataImpl);
    }

    public synchronized void addDisturbance(int n, Tuple tuple) throws VisADException, RemoteException {
        float f = n;
        if (this.data == null) {
            Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)rtDisturbanceID, new float[][]{{f}}, 1);
            this.data = new FieldImpl(mtTC, gridded1DSet);
            this.data.setSample(0, (Data)tuple);
        } else {
            Gridded1DSet gridded1DSet = (Gridded1DSet)this.data.getDomainSet();
            float[][] fArray = gridded1DSet.getSamples(false);
            int n2 = gridded1DSet.getLength();
            float[][] fArray2 = new float[1][n2 + 1];
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < n2 + 1) {
                if (f == fArray[0][n3]) {
                    throw new VisADException("disturbanceID " + n + " already used");
                }
                if (n4 < 0 && f < fArray[0][n3]) {
                    fArray2[0][n5] = f;
                    n4 = n5;
                } else {
                    fArray2[0][n5] = fArray[0][n3];
                    ++n3;
                }
                ++n5;
            }
            Gridded1DSet gridded1DSet2 = new Gridded1DSet((MathType)rtDisturbanceID, fArray2, n2 + 1);
            FieldImpl fieldImpl = new FieldImpl(mtTC, gridded1DSet2);
            n3 = 0;
            int n6 = 0;
            while (n6 < n2 + 1) {
                if (n6 == n4) {
                    fieldImpl.setSample(n6, (Data)tuple, false);
                } else {
                    fieldImpl.setSample(n6, this.data.getSample(n3), false);
                    ++n3;
                }
                ++n6;
            }
            this.data = fieldImpl;
        }
    }

    private Tuple getDisturbance(int n) throws VisADException, RemoteException {
        int n2 = this.findDisturbance(n);
        if (n2 < 0) {
            return null;
        }
        return (Tuple)this.data.getSample(n2);
    }

    private void setDisturbance(int n, Tuple tuple) throws VisADException, RemoteException {
        int n2 = this.findDisturbance(n);
        if (n2 >= 0) {
            this.data.setSample(n2, (Data)tuple);
        }
    }

    private int findDisturbance(int n) throws VisADException, RemoteException {
        if (this.data == null) {
            return -1;
        }
        Gridded1DSet gridded1DSet = (Gridded1DSet)this.data.getDomainSet();
        float[][] fArray = gridded1DSet.getSamples(false);
        int n2 = gridded1DSet.getLength();
        float f = n;
        int n3 = 0;
        while (n3 < n2) {
            if (fArray[0][n3] == f) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private Tuple getTrack(int n, Tuple tuple) throws VisADException, RemoteException {
        int n2 = this.findTrack(n, tuple);
        if (n2 < 0) {
            return null;
        }
        FieldImpl fieldImpl = (FieldImpl)tuple.getComponent(9);
        return (Tuple)fieldImpl.getSample(n2);
    }

    private void setTrack(int n, Tuple tuple, Tuple tuple2) throws VisADException, RemoteException {
        int n2 = this.findTrack(n, tuple2);
        if (n2 >= 0) {
            FieldImpl fieldImpl = (FieldImpl)tuple2.getComponent(9);
            fieldImpl.setSample(n2, (Data)tuple);
        }
    }

    private int findTrack(int n, Tuple tuple) throws VisADException, RemoteException {
        if (tuple == null) {
            return -1;
        }
        FieldImpl fieldImpl = (FieldImpl)tuple.getComponent(9);
        if (fieldImpl == null) {
            return -1;
        }
        Gridded1DSet gridded1DSet = (Gridded1DSet)fieldImpl.getDomainSet();
        float[][] fArray = gridded1DSet.getSamples(false);
        int n2 = gridded1DSet.getLength();
        float f = n;
        int n3 = 0;
        while (n3 < n2) {
            if (fArray[0][n3] == f) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static Tuple makeDisturbance(String string, String string2, int n, int n2, String string3, double d, double d2, int n3, int n4, FieldImpl fieldImpl) throws VisADException, RemoteException {
        return new Tuple(new DataImpl[]{new Text(ttCountry, string), new Text(ttState, string2), new Real(rtYear, (double)n), new Real(rtNumber, (double)n2), new Text(ttHistoricalName, string3), new Real(rtOpenDate, d), new Real(rtCloseDate, d2), new Real(rtArchiveMode, (double)n3), new Real(rtRealtimeMode, (double)n4), fieldImpl});
    }

    public static Tuple makeTrack(String string, String string2, double d, double d2, String string3, FlatField flatField) throws VisADException, RemoteException {
        return new Tuple(new DataImpl[]{new Text(ttTrackType, string), new Text(ttTrackName, string2), new Real(rtBaseDateTime, d), new Real(rtCreateDateTime, d2), new Text(ttTrackStyle, string3), flatField});
    }

    public static FlatField makeLocations(double[] dArray, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray, int[] nArray2, float[] fArray4, float[] fArray5, float[] fArray6, int[] nArray3, int[] nArray4, float[] fArray7, float[] fArray8, float[] fArray9, float[] fArray10, int[] nArray5, float[] fArray11, float[] fArray12, float[] fArray13, int[] nArray6) throws VisADException, RemoteException {
        if (dArray == null || fArray == null || fArray2 == null || fArray3 == null || nArray == null || nArray2 == null || fArray4 == null || fArray5 == null || fArray6 == null || nArray3 == null || nArray4 == null || fArray7 == null || fArray8 == null || fArray9 == null || fArray10 == null || nArray5 == null || fArray11 == null || fArray12 == null || fArray13 == null || nArray6 == null) {
            throw new VisADException("arguments may not be null");
        }
        int n = dArray.length;
        if (fArray.length != n || fArray2.length != n || fArray3.length != n || nArray.length != n || nArray2.length != n) {
            throw new VisADException("argument lengths must match");
        }
        int[] nArray7 = QuickSort.sort(dArray);
        Gridded1DDoubleSet gridded1DDoubleSet = new Gridded1DDoubleSet((MathType)rtTime, new double[][]{dArray}, n);
        FlatField flatField = new FlatField(locationFunction, gridded1DDoubleSet);
        float[] fArray14 = new float[n];
        float[] fArray15 = new float[n];
        float[] fArray16 = new float[n];
        float[] fArray17 = new float[n];
        float[] fArray18 = new float[n];
        float[] fArray19 = new float[n];
        float[] fArray20 = new float[n];
        float[] fArray21 = new float[n];
        float[] fArray22 = new float[n];
        float[] fArray23 = new float[n];
        float[] fArray24 = new float[n];
        float[] fArray25 = new float[n];
        float[] fArray26 = new float[n];
        float[] fArray27 = new float[n];
        float[] fArray28 = new float[n];
        float[] fArray29 = new float[n];
        float[] fArray30 = new float[n];
        float[] fArray31 = new float[n];
        float[] fArray32 = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray14[n2] = fArray[nArray7[n2]];
            fArray15[n2] = fArray2[nArray7[n2]];
            fArray16[n2] = fArray3[nArray7[n2]];
            fArray17[n2] = nArray[nArray7[n2]];
            fArray18[n2] = nArray2[nArray7[n2]];
            fArray19[n2] = fArray4[nArray7[n2]];
            fArray20[n2] = fArray5[nArray7[n2]];
            fArray21[n2] = fArray6[nArray7[n2]];
            fArray22[n2] = nArray3[nArray7[n2]];
            fArray23[n2] = nArray4[nArray7[n2]];
            fArray24[n2] = fArray7[nArray7[n2]];
            fArray25[n2] = fArray8[nArray7[n2]];
            fArray26[n2] = fArray9[nArray7[n2]];
            fArray27[n2] = fArray10[nArray7[n2]];
            fArray28[n2] = nArray5[nArray7[n2]] < 0 ? Float.NaN : (float)nArray5[nArray7[n2]];
            fArray29[n2] = fArray11[nArray7[n2]];
            fArray30[n2] = fArray12[nArray7[n2]];
            fArray31[n2] = fArray13[nArray7[n2]];
            fArray32[n2] = nArray6[nArray7[n2]];
            ++n2;
        }
        float[][] fArray33 = new float[][]{fArray14, fArray15, fArray16, fArray17, fArray18, fArray19, fArray20, fArray21, fArray22, fArray23, fArray24, fArray25, fArray26, fArray27, fArray28, fArray29, fArray30, fArray31, fArray32};
        flatField.setSamples(fArray33, false);
        return flatField;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        TCData tCData = new TCData();
        MathType mathType = tCData.getType();
        System.out.println("MathType:\n" + mathType);
    }

    public TCData() throws VisADException {
        if (mtTC == null) {
            FunctionType functionType;
            rtTime = RealType.Time;
            rtConfidence = RealType.getRealType("CONFIDENCE", null, null);
            rtLat = RealType.Latitude;
            rtLon = RealType.Longitude;
            rtError = RealType.getRealType("ERROR", null, null);
            rtLocationStyle = RealType.getRealType("LOCATIONSTYLE", null, null);
            rtWindMean = RealType.getRealType("WINDMEAN", null, null);
            rtWindGust = RealType.getRealType("WINDGUST", null, null);
            rtCentralPressure = RealType.getRealType("CENTRALPRESSURE", null, null);
            rtCategory = RealType.getRealType("CATEGORY", null, null);
            rtIntensityStyle = RealType.getRealType("INTENSITYSTYLE", null, null);
            rtGaleRadius = RealType.getRealType("GALERADIUS", null, null);
            rtStormRadius = RealType.getRealType("STORMRADIUS", null, null);
            rtHurricaneRadius = RealType.getRealType("HURRICANERADIUS", null, null);
            rtRadiusOfMaximumWinds = RealType.getRealType("RADIUSOFMAXIMUMWINDS", null, null);
            rtSizeStyle = RealType.getRealType("SIZESTYLE", null, null);
            rtDepth = RealType.getRealType("DEPTH", null, null);
            rtEyeDiameter = RealType.getRealType("EYEDIAMETER", null, null);
            rtPressureOfLastClosedIsobar = RealType.getRealType("PRESSUREOFLASTCLOSEDISOBAR", null, null);
            rtStructureStyle = RealType.getRealType("STRUCTURESTYLE", null, null);
            RealTupleType realTupleType = new RealTupleType(new RealType[]{rtLat, rtLon, rtError, rtConfidence, rtLocationStyle, rtWindMean, rtWindGust, rtCentralPressure, rtCategory, rtIntensityStyle, rtGaleRadius, rtStormRadius, rtHurricaneRadius, rtRadiusOfMaximumWinds, rtSizeStyle, rtDepth, rtEyeDiameter, rtPressureOfLastClosedIsobar, rtStructureStyle});
            locationFunction = new FunctionType(rtTime, realTupleType);
            rtTrackID = RealType.getRealType("TRACKID", null, null);
            ttTrackType = TextType.getTextType("TRACKTYPE");
            ttTrackName = TextType.getTextType("TRACKNAME");
            rtBaseDateTime = RealType.getRealType("BASEDATETIME", null, null);
            rtCreateDateTime = RealType.getRealType("CREATEDATETIME", null, null);
            ttTrackStyle = TextType.getTextType("TRACKSTYLE");
            ttTrack = new TupleType(new MathType[]{ttTrackType, ttTrackName, rtBaseDateTime, rtCreateDateTime, ttTrackStyle, locationFunction});
            ftId2Track = new FunctionType(rtTrackID, ttTrack);
            rtDisturbanceID = RealType.getRealType("DISTURBANCEID", null, null);
            ttCountry = TextType.getTextType("COUNTRY");
            ttState = TextType.getTextType("STATE");
            ttHistoricalName = TextType.getTextType("HISTORICALNAME");
            rtYear = RealType.getRealType("YEAR", null, null);
            rtNumber = RealType.getRealType("NUM", null, null);
            rtOpenDate = RealType.getRealType("OPENDATE", null, null);
            rtCloseDate = RealType.getRealType("CLOSEDATE", null, null);
            rtArchiveMode = RealType.getRealType("ARCHIVEMODE", null, null);
            rtRealtimeMode = RealType.getRealType("REALTIMEMODE", null, null);
            TupleType tupleType = new TupleType(new MathType[]{ttCountry, ttState, rtYear, rtNumber, ttHistoricalName, rtOpenDate, rtCloseDate, rtArchiveMode, rtRealtimeMode, ftId2Track});
            mtTC = functionType = new FunctionType(rtDisturbanceID, tupleType);
        }
    }
}

