/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.UnitException;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.bom.WindPolarCoordinateSystem;
import visad.java3d.DisplayImplJ3D;

public class Swells
extends Exception {
    private static final int NDIRS = 721;
    private static final int NHEIGHTS = 51;
    private static final float SIZE = 0.05f;
    private static WindPolarCoordinateSystem wcs = null;
    private static float[][] arrow_zero = new float[][]{{0.0f, 0.0f, 7.0f, -7.0f}, {0.044999998f, 0.095f, 0.080000006f, 0.080000006f}};
    static final int N = 5;

    public static void setupSwellDisplay(RealType realType, RealType realType2, DisplayImpl displayImpl) throws VisADException, RemoteException {
        Object object;
        if (wcs == null) {
            wcs = new WindPolarCoordinateSystem();
        }
        if (!CommonUnit.degree.equals(realType.getDefaultUnit())) {
            throw new UnitException("swellDir Unit must be degree");
        }
        if (!CommonUnit.meter.equals(realType2.getDefaultUnit())) {
            throw new UnitException("swellHeight Unit must be meter");
        }
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realType, -360.0, 360.0, 721);
        float[][] fArray = linear1DSet.getSamples();
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[721];
        int n = 0;
        while (n < 721) {
            visADGeometryArrayArray[n] = new VisADLineArray();
            visADGeometryArrayArray[n].vertexCount = 6;
            object = new float[2][4];
            System.arraycopy(arrow_zero[0], 0, object[0], 0, 4);
            System.arraycopy(arrow_zero[1], 0, object[1], 0, 4);
            int n2 = 0;
            while (n2 < object[0].length) {
                float[] fArray2 = object[0];
                int n3 = n2++;
                fArray2[n3] = fArray2[n3] + (fArray[0][n] + 180.0f);
            }
            object = wcs.toReference((float[][])object);
            visADGeometryArrayArray[n].coordinates = new float[]{object[0][1], object[1][1], 0.0f, object[0][0], object[1][0], 0.0f, object[0][1], object[1][1], 0.0f, object[0][2], object[1][2], 0.0f, object[0][1], object[1][1], 0.0f, object[0][3], object[1][3], 0.0f};
            ++n;
        }
        Integer1DSet integer1DSet = new Integer1DSet((MathType)realType2, 51);
        object = new double[]{0.0, -0.025f, 0.0};
        double[] dArray = new double[]{0.05f, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.05f, 0.0};
        VisADGeometryArray[] visADGeometryArrayArray2 = new VisADGeometryArray[51];
        int n4 = 0;
        while (n4 < 51) {
            visADGeometryArrayArray2[n4] = PlotText.render_label(Integer.toString(n4), (double[])object, dArray, dArray2, true);
            ++n4;
        }
        ScalarMap scalarMap = new ScalarMap(realType, Display.Shape);
        displayImpl.addMap(scalarMap);
        ShapeControl shapeControl = (ShapeControl)scalarMap.getControl();
        shapeControl.setShapeSet(linear1DSet);
        shapeControl.setShapes(visADGeometryArrayArray);
        ScalarMap scalarMap2 = new ScalarMap(realType2, Display.Shape);
        displayImpl.addMap(scalarMap2);
        ShapeControl shapeControl2 = (ShapeControl)scalarMap2.getControl();
        shapeControl2.setShapeSet(integer1DSet);
        shapeControl2.setShapes(visADGeometryArrayArray2);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        double d = -30.0;
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealType realType3 = new RealType("red");
        RealType realType4 = new RealType("green");
        RealType realType5 = new RealType("index");
        RealType realType6 = new RealType("swell_dir", CommonUnit.degree, null);
        RealType realType7 = new RealType("swell_speed", CommonUnit.meter, null);
        RealTupleType realTupleType = new RealTupleType(new RealType[]{realType2, realType, realType6, realType7, realType3, realType4});
        FunctionType functionType = new FunctionType(realType5, realTupleType);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1");
        displayImplJ3D.addMap(new ScalarMap(realType2, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(realType, Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap(realType3, Display.Red));
        displayImplJ3D.addMap(new ScalarMap(realType4, Display.Green));
        displayImplJ3D.addMap(new ConstantMap(1.0, Display.Blue));
        Swells.setupSwellDisplay(realType6, realType7, displayImplJ3D);
        Integer1DSet integer1DSet = new Integer1DSet(25);
        double[][] dArray = new double[6][25];
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 5) {
                double d2 = 2.0 * (double)n2 / 4.0 - 1.0;
                double d3 = 2.0 * (double)n3 / 4.0 - 1.0;
                dArray[0][n] = 10.0 * d2;
                dArray[1][n] = 10.0 * d3 + d;
                double d4 = 10.0 * d2;
                double d5 = 10.0 * d3;
                dArray[2][n] = 57.29577951308232 * Math.atan2(d4, d5);
                dArray[3][n] = 1.0 + Math.sqrt(d4 * d4 + d5 * d5);
                dArray[4][n] = d2;
                dArray[5][n] = d3;
                ++n;
                ++n3;
            }
            ++n2;
        }
        FlatField flatField = new FlatField(functionType, integer1DSet);
        flatField.setSamples(dArray);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref");
        dataReferenceImpl.setData(flatField);
        displayImplJ3D.addReference(dataReferenceImpl);
        JFrame jFrame = new JFrame("test BarbRendererJ3D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }
}

