/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.swing.JFrame;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ConstantMap;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.data.gif.GIFForm;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.java3d.VisADBranchGroup;

public class ShadowImageFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    private static DisplayImpl display;
    private static BaseMapAdapter baseMap;
    private static ScalarMap lat_map;
    private static ScalarMap lon_map;
    private static ScalarMap xaxis;
    private static ScalarMap yaxis;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doTransform(Object object, Data data, float[] fArray, float[] fArray2, DataRenderer dataRenderer) throws VisADException, RemoteException {
        int n;
        DataDisplayLink dataDisplayLink = dataRenderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)dataRenderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType shadowFunctionOrSetType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl displayImpl = this.getDisplay();
        GraphicsModeControl graphicsModeControl = (GraphicsModeControl)displayImpl.getGraphicsModeControl().clone();
        boolean bl = shadowFunctionOrSetType.getAnyContour();
        boolean bl2 = shadowFunctionOrSetType.getAnyFlow();
        boolean bl3 = shadowFunctionOrSetType.getAnyShape();
        boolean bl4 = shadowFunctionOrSetType.getAnyText();
        if (bl || bl2 || bl3 || bl4) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int n2 = displayImpl.getValueArrayLength();
        int[] nArray = displayImpl.getValueToScalar();
        int[] nArray2 = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        float[][] fArray3 = new float[n2][];
        int[] nArray3 = shadowFunctionOrSetType.getInheritedValues();
        int n3 = 0;
        while (n3 < n2) {
            if (nArray3[n3] > 0) {
                fArray3[n3] = new float[1];
                fArray3[n3][0] = fArray[n3];
            }
            ++n3;
        }
        Set set = ((Field)data).getDomainSet();
        Unit[] unitArray = ((Function)data).getDomainUnits();
        CoordinateSystem coordinateSystem = ((Function)data).getDomainCoordinateSystem();
        Object var23_24 = null;
        Object var24_25 = null;
        ShadowRealTupleType shadowRealTupleType = shadowFunctionOrSetType.getDomain();
        Unit[] unitArray2 = ((RealTupleType)shadowRealTupleType.getType()).getDefaultUnits();
        try {
            n = set.getLength();
            int n4 = set.getDimension();
        }
        catch (SetException setException) {
            return false;
        }
        ShadowRealType[] shadowRealTypeArray = shadowFunctionOrSetType.getDomainComponents();
        if (shadowFunctionOrSetType.getIsTerminal()) {
            float[] fArray4;
            int n5;
            Object object2;
            float f;
            Object object3;
            Object object4;
            double[] dArray;
            int n6;
            int n7;
            float[][] fArray5;
            Object object5;
            float f2 = Float.NaN;
            float[] fArray6 = null;
            ShadowRealType[] shadowRealTypeArray2 = shadowFunctionOrSetType.getRangeComponents();
            int n8 = shadowRealTypeArray2.length;
            if (n8 != 1 && n8 != 3) {
                throw new BadMappingException("image values must single or triple");
            }
            ScalarMap scalarMap = null;
            ScalarMap[] scalarMapArray = null;
            int[] nArray4 = new int[]{-1, -1, -1};
            int n9 = 3;
            if (n8 == 1) {
                object5 = shadowRealTypeArray2[0].getSelectedMapVector();
                if (((Vector)object5).size() != 1) {
                    throw new BadMappingException("image values must be mapped to RGB only");
                }
                scalarMap = (ScalarMap)((Vector)object5).elementAt(0);
                if (Display.RGB.equals(scalarMap.getDisplayScalar())) {
                    n9 = 3;
                } else {
                    if (!Display.RGBA.equals(scalarMap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                    n9 = 4;
                }
            } else {
                scalarMapArray = new ScalarMap[3];
                int n10 = 0;
                while (n10 < 3) {
                    Vector vector2 = shadowRealTypeArray2[n10].getSelectedMapVector();
                    if (vector2.size() != 1) {
                        throw new BadMappingException("image values must be mapped to color only");
                    }
                    scalarMapArray[n10] = (ScalarMap)vector2.elementAt(0);
                    if (Display.Red.equals(scalarMapArray[n10].getDisplayScalar())) {
                        nArray4[0] = n10;
                    } else if (Display.Green.equals(scalarMapArray[n10].getDisplayScalar())) {
                        nArray4[1] = n10;
                    } else {
                        if (!Display.Blue.equals(scalarMapArray[n10].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                        nArray4[2] = n10;
                    }
                    ++n10;
                }
                if (nArray4[0] < 0 || nArray4[1] < 0 || nArray4[2] < 0) {
                    throw new BadMappingException("image values must be mapped to Red, Green and Blue");
                }
            }
            f2 = fArray2[displayImpl.getDisplayScalarIndex(Display.Alpha)];
            object5 = new int[n];
            if (scalarMap != null) {
                int n11;
                Object object6;
                BaseColorControl baseColorControl = (BaseColorControl)scalarMap.getControl();
                fArray5 = baseColorControl.getTable();
                byte[][] byArray = null;
                Set set2 = null;
                n7 = 0;
                if (data instanceof FlatField) {
                    Unit unit;
                    byArray = ((FlatField)data).grabBytes();
                    Set[] setArray = ((FlatField)data).getRangeSets();
                    if (setArray != null) {
                        set2 = setArray[0];
                    }
                    if ((unit = ((RealType)(object6 = (RealType)shadowRealTypeArray2[0].getType())).getDefaultUnit()) == null) {
                        n7 = 1;
                    } else {
                        Unit[][] unitArray3 = ((FlatField)data).getRangeUnits();
                        Unit unit2 = unitArray3 == null ? null : unitArray3[0][0];
                        n7 = unit.equals(unit2);
                    }
                }
                if (fArray5 != null) {
                    int[] nArray5 = new int[fArray5[0].length];
                    int n12 = (int)(255.0 * (double)(1.0f - f2));
                    n6 = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
                    n11 = 0;
                    while (n11 < fArray5[0].length) {
                        int n13;
                        n12 = (int)(255.0 * (double)fArray5[0][n11]);
                        int n14 = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
                        n12 = (int)(255.0 * (double)fArray5[1][n11]);
                        int n15 = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
                        n12 = (int)(255.0 * (double)fArray5[2][n11]);
                        int n16 = n12 < 0 ? 0 : (n13 = n12 > 255 ? 255 : n12);
                        if (n9 == 4) {
                            n12 = (int)(255.0 * (double)fArray5[3][n11]);
                            n6 = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
                        }
                        nArray5[n11] = n6 << 24 | n14 << 16 | n15 << 8 | n13;
                        ++n11;
                    }
                    n11 = fArray5[0].length - 1;
                    double d = fArray5[0].length;
                    if (byArray != null && byArray[0] != null && n7 != 0 && set2 != null && set2 instanceof Linear1DSet) {
                        double d2 = ((Linear1DSet)set2).getFirst();
                        double d3 = ((Linear1DSet)set2).getStep();
                        dArray = new double[2];
                        object4 = new double[2];
                        object3 = new double[2];
                        scalarMap.getScale(dArray, (double[])object4, (double[])object3);
                        double d4 = dArray[0];
                        double d5 = dArray[1];
                        f = (float)(d * d4 * d3);
                        float f3 = (float)(d * (d5 + d4 * d2));
                        object2 = new int[256];
                        int n17 = 0;
                        while (n17 < 256) {
                            int n18;
                            n5 = n17 - 1;
                            object2[n17] = n5 < 0 ? 0 : ((n18 = (int)(f3 + f * (float)n5)) < 0 ? nArray5[0] : (n18 > n11 ? nArray5[n11] : nArray5[n18]));
                            ++n17;
                        }
                        byte[] byArray2 = byArray[0];
                        n5 = 0;
                        while (n5 < n) {
                            object5[n5] = object2[byArray2[n5] - -128];
                            ++n5;
                        }
                        byArray = null;
                    } else {
                        byArray = null;
                        float[][] fArray7 = ((Field)data).getFloats(false);
                        fArray7[0] = scalarMap.scaleValues(fArray7[0]);
                        fArray4 = fArray7[0];
                        int n19 = 0;
                        while (n19 < n) {
                            int n20;
                            object5[n19] = fArray4[n19] != fArray4[n19] ? (Object)false : (Object)((n20 = (int)(d * (double)fArray4[n19])) < 0 ? nArray5[0] : (n20 > n11 ? nArray5[n11] : nArray5[n20]));
                            ++n19;
                        }
                        fArray7 = null;
                    }
                } else {
                    byArray = null;
                    float[][] fArray8 = ((Field)data).getFloats(false);
                    fArray8[0] = scalarMap.scaleValues(fArray8[0]);
                    object6 = baseColorControl.lookupValues(fArray8[0]);
                    n6 = (int)(255.0 * (double)(1.0f - f2));
                    n11 = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                    int n21 = 0;
                    while (n21 < n) {
                        if (fArray8[0][n21] != fArray8[0][n21]) {
                            object5[n21] = false;
                        } else {
                            int n22;
                            n6 = (int)(255.0 * (double)object6[0][n21]);
                            int n23 = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                            n6 = (int)(255.0 * (double)object6[1][n21]);
                            int n24 = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                            n6 = (int)(255.0 * (double)object6[2][n21]);
                            int n25 = n6 < 0 ? 0 : (n22 = n6 > 255 ? 255 : n6);
                            if (n9 == 4) {
                                n6 = (int)(255.0 * (double)object6[3][n21]);
                                n11 = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                            }
                            object5[n21] = n11 << 24 | n23 << 16 | n24 << 8 | n22;
                        }
                        ++n21;
                    }
                    Object var44_79 = null;
                    object6 = null;
                }
            } else {
                if (scalarMapArray == null) throw new BadMappingException("cmap == null and cmaps == null ??");
                float[][] fArray9 = ((Field)data).getFloats(false);
                fArray5 = new float[][]{scalarMapArray[nArray4[0]].scaleValues(fArray9[nArray4[0]]), scalarMapArray[nArray4[1]].scaleValues(fArray9[nArray4[1]]), scalarMapArray[nArray4[2]].scaleValues(fArray9[nArray4[2]])};
                float[][] fArray10 = fArray5;
                int n26 = (int)(255.0 * (double)(1.0f - f2));
                int n27 = n26 < 0 ? 0 : (n26 > 255 ? 255 : n26);
                int n28 = 0;
                while (n28 < n) {
                    if (fArray10[0][n28] != fArray10[0][n28] || fArray10[1][n28] != fArray10[1][n28] || fArray10[2][n28] != fArray10[2][n28]) {
                        object5[n28] = false;
                    } else {
                        int n29 = (int)(255.0 * (double)fArray10[0][n28]);
                        int n30 = n29 < 0 ? 0 : (n29 > 255 ? 255 : n29);
                        n29 = (int)(255.0 * (double)fArray10[1][n28]);
                        int n31 = n29 < 0 ? 0 : (n29 > 255 ? 255 : n29);
                        n29 = (int)(255.0 * (double)fArray10[2][n28]);
                        n7 = n29 < 0 ? 0 : (n29 > 255 ? 255 : n29);
                        object5[n28] = n27 << 24 | n30 << 16 | n31 << 8 | n7;
                    }
                    ++n28;
                }
                Object var39_57 = null;
            }
            if (!shadowRealTupleType.getAllSpatial() || shadowRealTupleType.getMultipleDisplayScalar()) {
                throw new BadMappingException("domain must be only spatial");
            }
            boolean bl5 = shadowFunctionOrSetType.getIsTextureMap() && (set instanceof Linear2DSet || set instanceof LinearNDSet && set.getDimension() == 2) && set.getManifoldDimension() == 2;
            int n32 = displayImpl.getGraphicsModeControl().getCurvedSize();
            boolean bl6 = shadowFunctionOrSetType.getCurvedTexture() && !bl5 && n32 > 0 && (set instanceof Gridded2DSet || set instanceof GriddedSet && set.getDimension() == 2) && set.getManifoldDimension() == 2;
            float[] fArray11 = null;
            float[] fArray12 = null;
            Object var44_83 = null;
            byte[] byArray = null;
            int n33 = 0;
            int n34 = 0;
            int n35 = 1;
            n6 = 1;
            Object var50_114 = null;
            Object var51_117 = null;
            Object var52_161 = null;
            Object var53_120 = null;
            fArray4 = null;
            Object var55_123 = null;
            Object var56_160 = null;
            dArray = null;
            if (bl5) {
                void var71_170;
                object4 = null;
                object3 = null;
                if (set instanceof Linear2DSet) {
                    object4 = ((Linear2DSet)set).getX();
                    object3 = ((Linear2DSet)set).getY();
                } else {
                    object4 = ((LinearNDSet)set).getLinear1DComponent(0);
                    object3 = ((LinearNDSet)set).getLinear1DComponent(1);
                }
                float[][] fArray13 = new float[2][2];
                fArray13[0][0] = (float)((Linear1DSet)object4).getFirst();
                fArray13[0][1] = (float)((Linear1DSet)object4).getLast();
                fArray13[1][0] = (float)((Linear1DSet)object3).getFirst();
                fArray13[1][1] = (float)((Linear1DSet)object3).getLast();
                fArray13 = Unit.convertTuple(fArray13, unitArray, unitArray2);
                n33 = ((Set)object4).getLength();
                n34 = ((Set)object3).getLength();
                n35 = this.textureWidth(n33);
                n6 = this.textureHeight(n34);
                int[] nArray6 = new int[3];
                if (shadowRealTypeArray.length != 2) {
                    throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
                }
                int n36 = 0;
                while (n36 < shadowRealTypeArray.length) {
                    Enumeration enumeration = shadowRealTypeArray[n36].getSelectedMapVector().elements();
                    ScalarMap scalarMap2 = (ScalarMap)enumeration.nextElement();
                    fArray13[n36] = scalarMap2.scaleValues(fArray13[n36]);
                    DisplayRealType displayRealType = scalarMap2.getDisplayScalar();
                    object2 = displayRealType.getTuple();
                    if (object2 == null || !((TupleType)object2).equals(Display.DisplaySpatialCartesianTuple)) {
                        throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
                    }
                    nArray6[n36] = displayRealType.getTupleIndex();
                    if (enumeration.hasMoreElements()) {
                        throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
                    }
                    ++n36;
                }
                nArray6[2] = 3 - (nArray6[0] + nArray6[1]);
                DisplayRealType displayRealType = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(nArray6[2]);
                int n37 = displayImpl.getDisplayScalarIndex(displayRealType);
                f = fArray2[n37];
                int n38 = 0;
                while (n38 < n2) {
                    if (nArray3[n38] > 0 && displayRealType.equals(displayImpl.getDisplayScalar(nArray[n38]))) {
                        f = fArray[n38];
                        break;
                    }
                    ++n38;
                }
                fArray11 = new float[12];
                fArray11[nArray6[0]] = fArray13[0][0];
                fArray11[nArray6[1]] = fArray13[1][0];
                fArray11[nArray6[2]] = f;
                fArray11[3 + nArray6[0]] = fArray13[0][1];
                fArray11[3 + nArray6[1]] = fArray13[1][0];
                fArray11[3 + nArray6[2]] = f;
                fArray11[6 + nArray6[0]] = fArray13[0][1];
                fArray11[6 + nArray6[1]] = fArray13[1][1];
                fArray11[6 + nArray6[2]] = f;
                fArray11[9 + nArray6[0]] = fArray13[0][0];
                fArray11[9 + nArray6[1]] = fArray13[1][1];
                fArray11[9 + nArray6[2]] = f;
                this.adjustZ(fArray11);
                fArray12 = new float[8];
                float f4 = (float)n33 / (float)n35;
                float f5 = (float)n34 / (float)n6;
                this.setTexCoords(fArray12, f4, f5);
                float[] fArray14 = new float[12];
                float f6 = (fArray11[5] - fArray11[2]) * (fArray11[7] - fArray11[1]) - (fArray11[4] - fArray11[1]) * (fArray11[8] - fArray11[2]);
                float f7 = (fArray11[3] - fArray11[0]) * (fArray11[8] - fArray11[2]) - (fArray11[5] - fArray11[2]) * (fArray11[6] - fArray11[0]);
                float f8 = (fArray11[4] - fArray11[1]) * (fArray11[6] - fArray11[0]) - (fArray11[3] - fArray11[0]) * (fArray11[7] - fArray11[1]);
                float f9 = (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8);
                fArray14[0] = f6 /= f9;
                fArray14[1] = f7 /= f9;
                fArray14[2] = f8 /= f9;
                fArray14[3] = f6;
                fArray14[4] = f7;
                fArray14[5] = f8;
                fArray14[6] = f6;
                fArray14[7] = f7;
                fArray14[8] = f8;
                fArray14[9] = f6;
                fArray14[10] = f7;
                fArray14[11] = f8;
                byArray = new byte[12];
                boolean bl7 = false;
                while (var71_170 < 12) {
                    byArray[var71_170] = 127;
                    ++var71_170;
                }
                VisADQuadArray visADQuadArray = new VisADQuadArray();
                visADQuadArray.vertexCount = 4;
                visADQuadArray.coordinates = fArray11;
                visADQuadArray.texCoords = fArray12;
                visADQuadArray.colors = byArray;
                visADQuadArray.normals = fArray14;
                BufferedImage bufferedImage = this.createImage(n33, n34, n35, n6, (int[])object5);
                this.textureToGroup(object, visADQuadArray, bufferedImage, graphicsModeControl, f2, fArray6, n35, n6);
            } else {
                int n39;
                Object object7;
                if (!bl6) throw new BadMappingException("must be texture map or curved texture map");
                object4 = ((GriddedSet)set).getLengths();
                n33 = object4[0];
                n34 = object4[1];
                n35 = this.textureWidth(n33);
                n6 = this.textureHeight(n34);
                int n40 = (n33 + n34) / 2;
                n32 = Math.max(2, Math.min(n32, n40 / 32));
                int n41 = 2 + (n33 - 1) / n32;
                int n42 = 2 + (n34 - 1) / n32;
                int n43 = n41 * n42;
                int[] nArray7 = new int[n41];
                int[] nArray8 = new int[n42];
                int n44 = 0;
                while (n44 < n41) {
                    nArray7[n44] = Math.min(n44 * n32, n33 - 1);
                    ++n44;
                }
                n44 = 0;
                while (n44 < n42) {
                    nArray8[n44] = Math.min(n44 * n32, n34 - 1);
                    ++n44;
                }
                int[] nArray9 = new int[n43];
                int n45 = 0;
                int n46 = 0;
                while (n46 < n42) {
                    n5 = 0;
                    while (n5 < n41) {
                        nArray9[n45] = nArray7[n5] + n33 * nArray8[n46];
                        ++n45;
                        ++n5;
                    }
                    ++n46;
                }
                float[][] fArray15 = set.indexToValue(nArray9);
                fArray15 = Unit.convertTuple(fArray15, unitArray, unitArray2);
                ShadowRealTupleType shadowRealTupleType2 = shadowRealTupleType.getReference();
                ShadowRealType[] shadowRealTypeArray3 = shadowRealTypeArray;
                if (shadowRealTupleType2 != null && shadowRealTupleType2.getMappedDisplayScalar()) {
                    object7 = (RealTupleType)shadowRealTupleType2.getType();
                    dataRenderer.setEarthSpatialData(shadowRealTupleType, shadowRealTupleType2, (RealTupleType)object7, ((RealTupleType)object7).getDefaultUnits(), (RealTupleType)shadowRealTupleType.getType(), new CoordinateSystem[]{coordinateSystem}, unitArray2);
                    fArray15 = CoordinateSystem.transformCoordinates((RealTupleType)object7, null, ((RealTupleType)object7).getDefaultUnits(), null, (RealTupleType)shadowRealTupleType.getType(), coordinateSystem, unitArray2, null, fArray15);
                    shadowRealTypeArray3 = shadowFunctionOrSetType.getDomainReferenceComponents();
                } else {
                    object7 = shadowRealTupleType2 == null ? null : (RealTupleType)shadowRealTupleType2.getType();
                    Unit[] unitArray4 = object7 == null ? null : ((RealTupleType)object7).getDefaultUnits();
                    dataRenderer.setEarthSpatialData(shadowRealTupleType, shadowRealTupleType2, (RealTupleType)object7, unitArray4, (RealTupleType)shadowRealTupleType.getType(), new CoordinateSystem[]{coordinateSystem}, unitArray2);
                }
                object7 = new int[3];
                int[] nArray10 = new int[]{-1, -1, -1};
                ScalarMap[] scalarMapArray2 = new ScalarMap[3];
                DisplayTupleType displayTupleType = null;
                int n47 = 0;
                while (n47 < shadowRealTypeArray3.length) {
                    Enumeration enumeration = shadowRealTypeArray3[n47].getSelectedMapVector().elements();
                    ScalarMap scalarMap3 = (ScalarMap)enumeration.nextElement();
                    DisplayRealType displayRealType = scalarMap3.getDisplayScalar();
                    displayTupleType = displayRealType.getTuple();
                    if (displayTupleType == null) {
                        throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
                    }
                    object7[n47] = displayRealType.getTupleIndex();
                    nArray10[object7[n47]] = scalarMap3.getValueIndex();
                    scalarMapArray2[object7[n47]] = scalarMap3;
                    if (enumeration.hasMoreElements()) {
                        throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
                    }
                    ++n47;
                }
                object7[2] = 3 - (object7[0] + object7[1]);
                DisplayRealType displayRealType = (DisplayRealType)displayTupleType.getComponent((int)object7[2]);
                int n48 = displayImpl.getDisplayScalarIndex(displayRealType);
                float f10 = fArray2[n48];
                int n49 = 0;
                while (n49 < n2) {
                    if (nArray3[n49] > 0 && displayRealType.equals(displayImpl.getDisplayScalar(nArray[n49]))) {
                        f10 = fArray[n49];
                        break;
                    }
                    ++n49;
                }
                float[][] fArray16 = new float[3][];
                fArray16[object7[0]] = fArray15[0];
                fArray16[object7[1]] = fArray15[1];
                fArray16[object7[2]] = new float[n43];
                int n50 = 0;
                while (n50 < n43) {
                    fArray16[object7[2]][n50] = f10;
                    ++n50;
                }
                n50 = 0;
                while (n50 < 3) {
                    if (scalarMapArray2[n50] != null) {
                        fArray16[n50] = scalarMapArray2[n50].scaleValues(fArray16[n50]);
                    }
                    ++n50;
                }
                if (displayTupleType.equals(Display.DisplaySpatialCartesianTuple)) {
                    dataRenderer.setEarthSpatialDisplay(null, displayTupleType, displayImpl, nArray10, fArray2, null);
                } else {
                    CoordinateSystem coordinateSystem2 = displayTupleType.getCoordinateSystem();
                    fArray16 = coordinateSystem2.toReference(fArray16);
                    dataRenderer.setEarthSpatialDisplay(coordinateSystem2, displayTupleType, displayImpl, nArray10, fArray2, null);
                }
                fArray11 = new float[3 * n43];
                n45 = 0;
                int n51 = 0;
                while (n51 < n43) {
                    fArray11[n45++] = fArray16[0][n51];
                    fArray11[n45++] = fArray16[1][n51];
                    fArray11[n45++] = fArray16[2][n51];
                    ++n51;
                }
                n51 = 1;
                int n52 = 0;
                while (n52 < 3 * n43) {
                    if (fArray11[n52] != fArray11[n52]) {
                        n51 = 0;
                    }
                    ++n52;
                }
                float[] fArray17 = Gridded3DSet.makeNormals(fArray11, n41, n42);
                byArray = new byte[3 * n43];
                n52 = 0;
                while (n52 < 3 * n43) {
                    byArray[n52] = 127;
                    ++n52;
                }
                float f11 = (float)n33 / (float)n35;
                float f12 = (float)n34 / (float)n6;
                int n53 = 0;
                fArray12 = new float[2 * n43];
                int n54 = 0;
                while (n54 < n42) {
                    n39 = 0;
                    while (n39 < n41) {
                        fArray12[n53++] = f11 * (float)nArray7[n39] / ((float)n33 - 1.0f);
                        fArray12[n53++] = 1.0f - f12 * (float)nArray8[n54] / ((float)n34 - 1.0f);
                        ++n39;
                    }
                    ++n54;
                }
                VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
                visADTriangleStripArray.stripVertexCounts = new int[n42 - 1];
                n39 = 0;
                while (n39 < n42 - 1) {
                    visADTriangleStripArray.stripVertexCounts[n39] = 2 * n41;
                    ++n39;
                }
                visADTriangleStripArray.vertexCount = n39 = (n42 - 1) * (2 * n41);
                visADTriangleStripArray.normals = new float[3 * n39];
                visADTriangleStripArray.coordinates = new float[3 * n39];
                visADTriangleStripArray.colors = new byte[3 * n39];
                visADTriangleStripArray.texCoords = new float[2 * n39];
                n45 = 0;
                int n55 = 0;
                int n56 = 3 * n41;
                int n57 = 2 * n41;
                int n58 = 0;
                while (n58 < n42 - 1) {
                    int n59 = n58 * n56;
                    n53 = n58 * n57;
                    int n60 = 0;
                    while (n60 < n41) {
                        visADTriangleStripArray.coordinates[n45] = fArray11[n59];
                        visADTriangleStripArray.coordinates[n45 + 1] = fArray11[n59 + 1];
                        visADTriangleStripArray.coordinates[n45 + 2] = fArray11[n59 + 2];
                        visADTriangleStripArray.coordinates[n45 + 3] = fArray11[n59 + n56];
                        visADTriangleStripArray.coordinates[n45 + 4] = fArray11[n59 + n56 + 1];
                        visADTriangleStripArray.coordinates[n45 + 5] = fArray11[n59 + n56 + 2];
                        visADTriangleStripArray.normals[n45] = fArray17[n59];
                        visADTriangleStripArray.normals[n45 + 1] = fArray17[n59 + 1];
                        visADTriangleStripArray.normals[n45 + 2] = fArray17[n59 + 2];
                        visADTriangleStripArray.normals[n45 + 3] = fArray17[n59 + n56];
                        visADTriangleStripArray.normals[n45 + 4] = fArray17[n59 + n56 + 1];
                        visADTriangleStripArray.normals[n45 + 5] = fArray17[n59 + n56 + 2];
                        visADTriangleStripArray.colors[n45] = byArray[n59];
                        visADTriangleStripArray.colors[n45 + 1] = byArray[n59 + 1];
                        visADTriangleStripArray.colors[n45 + 2] = byArray[n59 + 2];
                        visADTriangleStripArray.colors[n45 + 3] = byArray[n59 + n56];
                        visADTriangleStripArray.colors[n45 + 4] = byArray[n59 + n56 + 1];
                        visADTriangleStripArray.colors[n45 + 5] = byArray[n59 + n56 + 2];
                        visADTriangleStripArray.texCoords[n55] = fArray12[n53];
                        visADTriangleStripArray.texCoords[n55 + 1] = fArray12[n53 + 1];
                        visADTriangleStripArray.texCoords[n55 + 2] = fArray12[n53 + n57];
                        visADTriangleStripArray.texCoords[n55 + 3] = fArray12[n53 + n57 + 1];
                        n45 += 6;
                        n59 += 3;
                        n55 += 4;
                        n53 += 2;
                        ++n60;
                    }
                    ++n58;
                }
                if (n51 == 0) {
                    visADTriangleStripArray = (VisADTriangleStripArray)visADTriangleStripArray.removeMissing();
                }
                visADTriangleStripArray = (VisADTriangleStripArray)visADTriangleStripArray.adjustLongitude(dataRenderer);
                visADTriangleStripArray = (VisADTriangleStripArray)visADTriangleStripArray.adjustSeam(dataRenderer);
                BufferedImage bufferedImage = this.createImage(n33, n34, n35, n6, (int[])object5);
                this.textureToGroup(object, visADTriangleStripArray, bufferedImage, graphicsModeControl, f2, fArray6, n35, n6);
            }
        } else {
            Node node;
            void var31_37;
            Cloneable cloneable;
            Vector vector3 = shadowRealTypeArray[0].getSelectedMapVector();
            Object var31_35 = null;
            if (set.getDimension() == 1 && vector3.size() == 1 && Display.Animation.equals(((ScalarMap)(cloneable = (ScalarMap)vector3.elementAt(0))).getDisplayScalar())) {
                Cloneable cloneable2 = cloneable;
            }
            if (var31_37 == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            cloneable = (AnimationControlJ3D)var31_37.getControl();
            Switch switch_ = null;
            BranchGroup[] branchGroupArray = null;
            double[] dArray = null;
            boolean[] blArray = null;
            int n61 = 0;
            boolean bl8 = ((ImageRendererJ3D)dataRenderer).getReUseFrames();
            if (object instanceof BranchGroup && ((BranchGroup)object).numChildren() > 0 && (node = ((BranchGroup)object).getChild(0)) instanceof Switch && (n61 = (switch_ = (Switch)node).numChildren()) > 0) {
                branchGroupArray = new BranchGroup[n61];
                int n62 = 0;
                while (n62 < n61) {
                    branchGroupArray[n62] = (BranchGroup)switch_.getChild(n62);
                    ++n62;
                }
                n62 = 0;
                while (n62 < n61) {
                    branchGroupArray[n62].detach();
                    ++n62;
                }
                dArray = new double[n61];
                blArray = new boolean[n61];
                n62 = 0;
                while (n62 < n61) {
                    blArray[n62] = false;
                    dArray[n62] = branchGroupArray[n62] instanceof VisADBranchGroup && bl8 ? ((VisADBranchGroup)branchGroupArray[n62]).getTime() : Double.NaN;
                    ++n62;
                }
            }
            double[][] dArray2 = set.getDoubles();
            double[] dArray3 = dArray2[0];
            int n63 = dArray3.length;
            double d = Math.abs((dArray3[n63 - 1] - dArray3[0]) / (1000.0 * (double)n63));
            Object var44_86 = null;
            if (switch_ != null) {
                Switch switch_2 = switch_;
                ((AVControlJ3D)cloneable).addPair(switch_2, set, dataRenderer);
                ((AVControlJ3D)cloneable).init();
            } else {
                Switch switch_3 = (Switch)this.makeSwitch();
                switch_3.setCapability(14);
                switch_3.setCapability(12);
                switch_3.setCapability(13);
                this.addSwitch(object, switch_3, (Control)cloneable, set, dataRenderer);
            }
            VisADBranchGroup[] visADBranchGroupArray = new VisADBranchGroup[n63];
            boolean[] blArray2 = new boolean[n63];
            int n64 = 0;
            while (n64 < n63) {
                void var44_89;
                int n65 = 0;
                while (n65 < n61) {
                    if (!blArray[n65] && Math.abs(dArray3[n64] - dArray[n65]) < d) {
                        blArray[n65] = true;
                        visADBranchGroupArray[n64] = (VisADBranchGroup)branchGroupArray[n65];
                        break;
                    }
                    ++n65;
                }
                if (visADBranchGroupArray[n64] != null) {
                    blArray2[n64] = true;
                } else {
                    blArray2[n64] = false;
                    visADBranchGroupArray[n64] = new VisADBranchGroup(dArray3[n64]);
                    visADBranchGroupArray[n64].setCapability(17);
                    visADBranchGroupArray[n64].setCapability(14);
                    visADBranchGroupArray[n64].setCapability(12);
                    visADBranchGroupArray[n64].setCapability(13);
                    this.ensureNotEmpty((Object)visADBranchGroupArray[n64]);
                }
                this.addToSwitch(var44_89, (Object)visADBranchGroupArray[n64]);
                ++n64;
            }
            n64 = 0;
            while (n64 < n61) {
                if (!blArray[n64]) {
                    ((RendererJ3D)dataRenderer).flush((Group)branchGroupArray[n64]);
                }
                ++n64;
            }
            if (object instanceof BranchGroup) {
                ((ImageRendererJ3D)dataRenderer).setBranchEarly((BranchGroup)object);
            }
            if (((ImageRendererJ3D)dataRenderer).getReUseFrames() && ((ImageRendererJ3D)dataRenderer).getSetSetOnReUseFrames()) {
                ((AnimationControlJ3D)cloneable).setSet(set, true);
            }
            n64 = 0;
            while (n64 < n63) {
                if (!blArray2[n64]) {
                    BranchGroup branchGroup = (BranchGroup)this.makeBranch();
                    ((ImageRendererJ3D)dataRenderer).setVisADBranch(visADBranchGroupArray[n64]);
                    this.recurseRange(branchGroup, ((Field)data).getSample(n64), fArray, fArray2, dataRenderer);
                    ((ImageRendererJ3D)dataRenderer).setVisADBranch(null);
                    visADBranchGroupArray[n64].addChild((Node)branchGroup);
                }
                ++n64;
            }
        }
        this.ensureNotEmpty(object);
        return false;
    }

    public BufferedImage createImage(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        BufferedImage bufferedImage = null;
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n3, n4);
        bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        int[] nArray2 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2) {
            n5 = 0;
            while (n5 < n) {
                nArray2[n7++] = nArray[n6++];
                ++n5;
            }
            n5 = n;
            while (n5 < n3) {
                nArray2[n7++] = 0;
                ++n5;
            }
            ++n8;
        }
        n8 = n2;
        while (n8 < n4) {
            n5 = 0;
            while (n5 < n3) {
                nArray2[n7++] = 0;
                ++n5;
            }
            ++n8;
        }
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        String string = "OUTLSUPW";
        String string2 = "AREA2001";
        boolean bl = true;
        boolean bl2 = false;
        JFrame jFrame = new JFrame("Map Display");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        if (stringArray.length > 0 && !stringArray[0].equals("X")) {
            string2 = stringArray[0];
        }
        if (stringArray.length == 2) {
            bl = stringArray[1].indexOf("2") < 0;
            bl2 = stringArray[1].indexOf("2") < 0;
        }
        boolean bl3 = string2.endsWith("gif") || string2.endsWith("GIF") || string2.endsWith("jpg") || string2.endsWith("JPG");
        try {
            Set[] setArray;
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            baseMap = string.indexOf("://") > 0 ? new BaseMapAdapter(new URL(string)) : new BaseMapAdapter(string);
            if (bl3) {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.getRealType("ImageLine"), Display.YAxis);
                lon_map = new ScalarMap(RealType.getRealType("ImageElement"), Display.XAxis);
            } else if (bl) {
                display = new DisplayImplJ3D("display");
                lat_map = new ScalarMap(RealType.Latitude, Display.Latitude);
                lon_map = new ScalarMap(RealType.Longitude, Display.Longitude);
            } else {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.Latitude, Display.YAxis);
                lon_map = new ScalarMap(RealType.Longitude, Display.XAxis);
            }
            display.addMap(lat_map);
            display.addMap(lon_map);
            if (!bl3) {
                lat_map.setRange(-90.0, 90.0);
                lon_map.setRange(-180.0, 180.0);
            }
            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("MapLines");
            dataReferenceImpl.setData(baseMap.getData());
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.001, Display.Radius)};
            Object object4 = null;
            if (bl3) {
                object3 = new GIFForm();
                object4 = (FlatField)((GIFForm)object3).open(string2);
            } else {
                object3 = new AreaAdapter(string2);
                object4 = ((AreaAdapter)object3).getData();
            }
            object3 = (FunctionType)((DataImpl)object4).getType();
            RealTupleType realTupleType = ((FunctionType)object3).getDomain();
            RealTupleType realTupleType2 = (RealTupleType)((FunctionType)object3).getRange();
            if (bl2) {
                int n = 256;
                serializable = realTupleType.getCoordinateSystem().getReference();
                object2 = new Linear2DSet((MathType)serializable, -4.0, 70.0, n, -150.0, 5.0, n);
                object4 = (FlatField)((FlatField)object4).resample((Set)object2, 100, 202);
            }
            if (bl3) {
                object = new ScalarMap((RealType)realTupleType2.getComponent(0), Display.Red);
                display.addMap((ScalarMap)object);
                serializable = new ScalarMap((RealType)realTupleType2.getComponent(1), Display.Green);
                display.addMap((ScalarMap)serializable);
                object2 = new ScalarMap((RealType)realTupleType2.getComponent(2), Display.Blue);
                display.addMap((ScalarMap)object2);
            } else {
                object = new ScalarMap((RealType)realTupleType2.getComponent(0), Display.RGBA);
                display.addMap((ScalarMap)object);
                serializable = (BaseColorControl)((ScalarMap)object).getControl();
                ((BaseColorControl)serializable).initGreyWedge();
                object2 = ((BaseColorControl)serializable).getTable();
                int n = 0;
                while (n < ((Object)object2[3]).length) {
                    object2[3][n] = object2[0][n];
                    ++n;
                }
                ((BaseColorControl)serializable).setTable((float[][])object2);
            }
            object = new DataReferenceImpl("ref_image");
            if (bl3) {
                Set[] setArray2 = new Set[3];
                setArray2[0] = new Linear1DSet(0.0, 255.0, 255);
                setArray2[1] = new Linear1DSet(0.0, 255.0, 255);
                setArray = setArray2;
                setArray2[2] = new Linear1DSet(0.0, 255.0, 255);
            } else {
                Set[] setArray3 = new Set[1];
                setArray = setArray3;
                setArray3[0] = new Integer1DSet(255);
            }
            serializable = setArray;
            object2 = new FlatField((FunctionType)object3, ((FieldImpl)object4).getDomainSet(), null, null, (Set[])serializable, null);
            float[][] fArray = ((FlatField)object4).getFloats(false);
            ((FlatField)object2).setSamples(fArray);
            object4 = object2;
            ((DataReferenceImpl)object).setData((Data)object4);
            display.disableAction();
            display.addReferences((DataRenderer)new ImageRendererJ3D(), (DataReference)object);
            display.addReference(dataReferenceImpl, constantMapArray);
            display.enableAction();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        jFrame.getContentPane().add(display.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }

    public ShadowImageFunctionTypeJ3D(MathType mathType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        super(mathType, dataDisplayLink, shadowType);
    }
}

