/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import visad.DateTime;
import visad.VisADException;

public class RadarFile {
    static final char decimal = '.';
    static final char percent = '%';
    static final char[] A2NXlat = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', ' ', '!', '\"', '#', '$', '%', '&', '0', '1', '2', '3', '4', '5', '6', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', '`', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final int maxSize = 250;
    public DateTime dtTime;
    public double dRadarTime;
    public float rngres = 250.0f;
    public float startrng = 4000.0f;
    public float azimuthres = 1.0f;
    public float elev = 0.0f;
    private boolean fileok;
    private BufferedReader rf;
    private int size;
    private int az;
    public byte[][] radial;
    public byte[] bdata;
    public Vector pbvector = new Vector();
    public PolarByteData pbdata;
    public PolarByteData[] pbdataArray;

    public double getTime() {
        return this.dRadarTime;
    }

    public void setTime(String string) {
        try {
            this.dRadarTime = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Exception converting Radar Time in module visad.bom.RadarFile.getTime() " + numberFormatException);
            this.dRadarTime = 0.0;
        }
    }

    public DateTime getRadarTime() {
        return this.dtTime;
    }

    public void setRadarTime(String string) throws VisADException {
        String[] stringArray = TimeZone.getAvailableIDs(0);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, stringArray[0]);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        int n = Integer.valueOf(string.substring(0, 4));
        int n2 = Integer.valueOf(string.substring(4, 6));
        int n3 = Integer.valueOf(string.substring(6, 8));
        int n4 = Integer.valueOf(string.substring(8, 10));
        int n5 = Integer.valueOf(string.substring(10, 12));
        int n6 = Integer.valueOf(string.substring(12, 14));
        System.out.println("timeStamp: " + string);
        System.out.println("year,month,day,hour,mins,secs: " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + n6);
        gregorianCalendar.clear();
        gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        System.out.println("Initialized with date: " + gregorianCalendar.getTime().toString());
        this.dtTime = new DateTime(gregorianCalendar.getTime());
        System.out.println("Initialized with date: " + this.dtTime);
    }

    public void readHeader(char[] cArray) {
        String string = new String(cArray);
        if (string.startsWith("COUNTRY:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("NAME:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("STNID:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("DATE:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("TIME:")) {
            String string2 = new String(string.substring(6));
            System.out.println("radarTime = " + string2);
        } else if (string.startsWith("TIMESTAMP:")) {
            try {
                this.setRadarTime(string.substring(11));
            }
            catch (VisADException visADException) {
                System.out.println("error setting radar time " + visADException);
            }
        } else if (string.startsWith("VERS:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("RNGRES:")) {
            this.rngres = Float.valueOf(string.substring(8)).floatValue();
            System.out.println("rngres = " + this.rngres);
        } else if (string.startsWith("ANGRES:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("VIDRES:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("STARTRNG:")) {
            this.startrng = Float.valueOf(string.substring(10)).floatValue();
            System.out.println("startrng = " + this.startrng);
        } else if (string.startsWith("ENDRNG:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("PRODUCT:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("IMGFMT:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("ELEV:")) {
            this.elev = Float.valueOf(string.substring(6)).floatValue();
            System.out.println("elev = " + this.elev);
        } else if (string.startsWith("DBZLVL:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("CLEARAIR:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("DBZCALDLVL:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("DIGCALDLVL:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("BEAMWIDTH:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("PULSELENGTH:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("STCRANGE:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("TXFREQUENCY:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("TXPEAKPWR:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("ANTGAIN:")) {
            System.out.println("line = " + string);
        } else if (string.startsWith("NOISETHRESH:")) {
            System.out.println("line = " + string);
        }
    }

    public void readRadial() throws IOException {
        int n = 0;
        boolean bl = false;
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        this.bdata = new byte[250];
        String string = this.rf.readLine();
        if (string == null) {
            this.rf = null;
            return;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = cArray[n];
        if (37 != n3) {
            this.readHeader(cArray);
        }
        int n4 = ++n;
        ++n;
        n3 = cArray[n4];
        while (Character.isDigit((char)n3) || n3 == 46) {
            stringBuffer.append((char)n3);
            n3 = cArray[n++];
        }
        try {
            if (stringBuffer.length() != 0) {
                this.az = Math.round(Float.valueOf(stringBuffer.toString()).floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("error converting radial " + numberFormatException);
        }
        --n;
        while (!bl) {
            n3 = cArray[n];
            ++n;
            if ((n3 = n3 >= 65 && n3 <= 89 ? (int)((char)(n3 - 65)) : (n3 >= 97 && n3 <= 120 ? (int)((char)(n3 - 72)) : 255)) != 255) {
                n3 = A2NXlat[n3];
                int n5 = 0;
                if (n < cArray.length) {
                    while (Character.isDigit(cArray[n])) {
                        n5 = n5 * 10 + (cArray[n] - 48);
                        if (++n < cArray.length) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (n2 + ++n5 * 2 > 250) {
                    n5 = (250 - n2) / 2;
                    bl = true;
                }
                while (n5-- > 0) {
                    this.bdata[n2] = (byte)(n3 & 0xF);
                    this.bdata[n2 + 1] = (byte)(n3 >> 4);
                    n2 += 2;
                }
                continue;
            }
            bl = true;
            ++n;
        }
    }

    public RadarFile(String string) throws IOException {
        this.rf = new BufferedReader(new FileReader(string));
        this.fileok = true;
        this.size = 0;
        this.az = 0;
        boolean bl = false;
        while (this.rf != null) {
            this.readRadial();
            this.pbdata = new PolarByteData(this.az, this.bdata);
            System.arraycopy(this.bdata, 0, this.pbdata.bdata, 0, this.bdata.length);
            if (this.rf == null) continue;
            this.pbvector.addElement(this.pbdata);
        }
        this.pbdataArray = new PolarByteData[this.pbvector.size()];
        this.pbvector.copyInto(this.pbdataArray);
    }

    public class PolarByteData {
        public double azimuth;
        public byte[] bdata;

        public PolarByteData() {
            this.azimuth = 0.0;
            this.bdata = new byte[250];
        }

        public PolarByteData(double d, byte[] byArray) {
            this.azimuth = d;
            this.bdata = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.bdata, 0, byArray.length);
        }
    }
}

