/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.bom.RadarAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.util.LabeledColorWidget;

public class RadarDisplay {
    private static void setColorMap(ScalarMap scalarMap, float f, float f2) throws VisADException, RemoteException {
        float[][] fArray = new float[3][256];
        int n = 0;
        while (n < 256) {
            if (n <= 15) {
                fArray[0][n] = 0.0f;
                fArray[1][n] = 0.0f;
                fArray[2][n] = 0.0f;
            } else if (n > 15 && n <= 31) {
                fArray[0][n] = 0.0f;
                fArray[1][n] = 0.9411765f;
                fArray[2][n] = 0.9411765f;
            } else if (n > 31 && n <= 47) {
                fArray[0][n] = 0.0f;
                fArray[1][n] = 0.5647059f;
                fArray[2][n] = 0.5647059f;
            } else if (n > 47 && n <= 63) {
                fArray[0][n] = 0.50196075f;
                fArray[1][n] = 0.8784314f;
                fArray[2][n] = 0.3137255f;
            } else if (n > 63 && n <= 79) {
                fArray[0][n] = 0.39215687f;
                fArray[1][n] = 0.72156864f;
                fArray[2][n] = 0.25098038f;
            } else if (n > 79 && n <= 95) {
                fArray[0][n] = 0.28235295f;
                fArray[1][n] = 0.5647059f;
                fArray[2][n] = 0.1882353f;
            } else if (n > 95 && n <= 111) {
                fArray[0][n] = 0.17254902f;
                fArray[1][n] = 0.40784314f;
                fArray[2][n] = 0.12549019f;
            } else if (n > 111 && n <= 127) {
                fArray[0][n] = 0.062745094f;
                fArray[1][n] = 0.25098038f;
                fArray[2][n] = 0.062745094f;
            } else if (n > 127 && n <= 143) {
                fArray[0][n] = 0.9411765f;
                fArray[1][n] = 0.7529412f;
                fArray[2][n] = 0.062745094f;
            } else if (n > 143 && n <= 159) {
                fArray[0][n] = 0.9411765f;
                fArray[1][n] = 0.50196075f;
                fArray[2][n] = 0.12549019f;
            } else if (n > 159 && n <= 175) {
                fArray[0][n] = 0.9411765f;
                fArray[1][n] = 0.062745094f;
                fArray[2][n] = 0.12549019f;
            } else if (n > 175 && n <= 191) {
                fArray[0][n] = 0.5647059f;
                fArray[1][n] = 0.0f;
                fArray[2][n] = 0.0f;
            } else if (n > 191 && n <= 207) {
                fArray[0][n] = 0.6901961f;
                fArray[1][n] = 0.12549019f;
                fArray[2][n] = 0.50196075f;
            } else if (n > 207 && n <= 223) {
                fArray[0][n] = 0.7921569f;
                fArray[1][n] = 0.25098038f;
                fArray[2][n] = 0.627451f;
            } else if (n > 223 && n <= 239) {
                fArray[0][n] = 1.0f;
                fArray[1][n] = 1.0f;
                fArray[2][n] = 1.0f;
            } else if (n > 239 && n <= 255) {
                fArray[0][n] = 1.0f;
                fArray[1][n] = 0.50196075f;
                fArray[2][n] = 0.8784314f;
            }
            ++n;
        }
        LabeledColorWidget labeledColorWidget = new LabeledColorWidget(scalarMap, fArray);
        Frame frame = new Frame("VisAD Color Widget");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        frame.add(labeledColorWidget);
        ((Component)frame).setSize(labeledColorWidget.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    private static void mapDisplay(DisplayImplJ3D displayImplJ3D, String string) {
        try {
            BaseMapAdapter baseMapAdapter = new BaseMapAdapter(string);
            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("MapLines");
            dataReferenceImpl.setData(baseMapAdapter.getData());
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Blue), new ConstantMap(-0.99, Display.ZAxis)};
            displayImplJ3D.addReference(dataReferenceImpl, constantMapArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        ScalarMap scalarMap;
        float f = -34.9581f;
        float f2 = 138.5342f;
        float f3 = 6.0f;
        String string = "radar.dat";
        Object var5_5 = null;
        RadarAdapter radarAdapter = null;
        boolean bl = stringArray.length > 0;
        try {
            radarAdapter = new RadarAdapter(f, f2, string, bl);
        }
        catch (Exception exception) {
            System.err.println("Caught Exception for \"" + string + "\": " + exception);
            System.exit(1);
        }
        FlatField flatField = radarAdapter.getData();
        FunctionType functionType = (FunctionType)flatField.getType();
        RealTupleType realTupleType = functionType.getDomain();
        RealType realType = (RealType)functionType.getRange();
        RealType realType2 = (RealType)realTupleType.getComponent(1);
        RealType realType3 = (RealType)realTupleType.getComponent(0);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("radar");
        ScalarMap scalarMap2 = new ScalarMap(RealType.Longitude, Display.XAxis);
        scalarMap2.setRange(f2 - f3, f2 + f3);
        displayImplJ3D.addMap(scalarMap2);
        ScalarMap scalarMap3 = new ScalarMap(RealType.Latitude, Display.YAxis);
        displayImplJ3D.addMap(scalarMap3);
        scalarMap3.setRange(f - f3, f + f3);
        if (bl) {
            scalarMap = new ScalarMap(RealType.Altitude, Display.ZAxis);
            scalarMap.setRange(0.0, 30000.0);
            displayImplJ3D.addMap(scalarMap);
        } else {
            scalarMap = new ScalarMap(realType, Display.ZAxis);
            scalarMap.setRange(0.0, 6.0);
            displayImplJ3D.addMap(scalarMap);
        }
        scalarMap = new ScalarMap(realType, Display.RGB);
        displayImplJ3D.addMap(scalarMap);
        RadarDisplay.setColorMap(scalarMap, 0.0f, 6.0f);
        RadarDisplay.mapDisplay(displayImplJ3D, "OUTLAUST");
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("radar_ref");
        dataReferenceImpl.setData(flatField);
        displayImplJ3D.addReference(dataReferenceImpl);
        JFrame jFrame = new JFrame("VisAD BOM radar image");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.getContentPane().add(displayImplJ3D.getComponent());
        int n = 500;
        int n2 = 600;
        ((Component)jFrame).setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setVisible(true);
    }
}

