/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JFrame;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.MathType;
import visad.QuickSort;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.bom.RadarFile;
import visad.java3d.DisplayImplJ3D;

public class RadarAdapter {
    private static int objCount = 0;
    public RadarFile rf;
    private Vector pvector = new Vector();
    private PolarData pdata;
    public PolarData[] polar;
    public int numVectors;
    FlatField radar;

    public FlatField getData() {
        return this.radar;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        String string = "radar.dat";
        RadarAdapter radarAdapter = null;
        try {
            radarAdapter = new RadarAdapter(-34.9f, 138.5f, 4.0f, string, false);
        }
        catch (Exception exception) {
            System.err.println("Caught Exception for \"" + string + "\": " + exception);
            System.exit(1);
        }
        FlatField flatField = radarAdapter.getData();
        FunctionType functionType = (FunctionType)flatField.getType();
        RealTupleType realTupleType = functionType.getDomain();
        RealType realType = (RealType)functionType.getRange();
        RealType realType2 = (RealType)realTupleType.getComponent(1);
        RealType realType3 = (RealType)realTupleType.getComponent(0);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("radar");
        ScalarMap scalarMap = new ScalarMap(RealType.Longitude, Display.XAxis);
        displayImplJ3D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(RealType.Latitude, Display.YAxis);
        displayImplJ3D.addMap(scalarMap2);
        displayImplJ3D.addMap(new ScalarMap(RealType.Altitude, Display.ZAxis));
        ScalarMap scalarMap3 = new ScalarMap(realType, Display.RGB);
        displayImplJ3D.addMap(scalarMap3);
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("radar_ref");
        dataReferenceImpl.setData(flatField);
        displayImplJ3D.addReference(dataReferenceImpl);
        JFrame jFrame = new JFrame("VisAD BOM radar image");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.getContentPane().add(displayImplJ3D.getComponent());
        int n = 500;
        int n2 = 600;
        ((Component)jFrame).setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setVisible(true);
    }

    public RadarAdapter(float f, float f2, String string, boolean bl) throws IOException, VisADException {
        this(f, f2, 0.0f, string, bl);
    }

    public RadarAdapter(float f, float f2, float f3, String string, boolean bl) throws IOException, VisADException {
        int n;
        int n2;
        Object object;
        try {
            this.rf = new RadarFile(string);
        }
        catch (IOException iOException) {
            throw new VisADException("Problem with Radar file: " + iOException);
        }
        System.out.println("Radar Adapter : dtTime = " + this.rf.dtTime);
        int n3 = this.rf.pbdataArray.length;
        float[] fArray = new float[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = this.rf.pbdataArray[n5].bdata.length;
            if (n6 > n4) {
                n4 = n6;
            }
            fArray[n5] = (float)this.rf.pbdataArray[n5].azimuth;
            ++n5;
        }
        int[] nArray = QuickSort.sort(fArray);
        float f4 = this.rf.startrng;
        float f5 = this.rf.rngres;
        float f6 = fArray[0];
        float f7 = this.rf.azimuthres;
        int n7 = 1 + (int)((fArray[n3 - 1] - fArray[0]) / f7);
        int[] nArray2 = new int[n7];
        int n8 = 0;
        while (n8 < n7) {
            nArray2[n8] = 0;
            ++n8;
        }
        n8 = 0;
        while (n8 < n3) {
            int n9 = (int)((fArray[n8] - fArray[0]) / f7);
            if (n9 < 0) {
                n9 = 0;
            }
            if (n9 > n7 - 1) {
                n9 = n7 - 1;
            }
            nArray2[n9] = nArray[n8];
            ++n8;
        }
        Object var16_20 = null;
        Radar2DCoordinateSystem radar2DCoordinateSystem = null;
        Radar3DCoordinateSystem radar3DCoordinateSystem = null;
        float f8 = 0.5f;
        float f9 = 0.1f;
        int n10 = 1;
        if (bl) {
            radar3DCoordinateSystem = new Radar3DCoordinateSystem(f, f2, f3, f4, f5, f6, f7, f8, f9);
        } else {
            radar2DCoordinateSystem = new Radar2DCoordinateSystem(f, f2, f4, f5, f6, f7);
        }
        RealType realType = RealType.getRealType("azimuth", CommonUnit.degree, null);
        RealType realType2 = RealType.getRealType("range", CommonUnit.meter, null);
        RealType realType3 = RealType.getRealType("elevation", CommonUnit.degree, null);
        RealTupleType realTupleType = null;
        if (bl) {
            object = new RealType[]{realType2, realType, realType3};
            realTupleType = new RealTupleType((RealType[])object, (CoordinateSystem)radar3DCoordinateSystem, null);
        } else {
            object = new RealType[]{realType2, realType};
            realTupleType = new RealTupleType((RealType[])object, (CoordinateSystem)radar2DCoordinateSystem, null);
        }
        object = RealType.getRealType("reflection");
        FunctionType functionType = new FunctionType(realTupleType, (MathType)object);
        int n11 = n7;
        if (n7 == 360) {
            n11 = 361;
        }
        float[][] fArray2 = new float[1][n4 * n11];
        int n12 = 0;
        int n13 = 0;
        while (n13 < n7) {
            n2 = nArray2[n13];
            if (n2 >= 0) {
                byte[] byArray = this.rf.pbdataArray[nArray2[n13]].bdata;
                n = 0;
                while (n < n4) {
                    fArray2[0][n12] = byArray[n];
                    ++n12;
                    ++n;
                }
            } else {
                int n14 = 0;
                while (n14 < n4) {
                    fArray2[0][n12] = Float.NaN;
                    ++n12;
                    ++n14;
                }
            }
            ++n13;
        }
        if (n7 == 360) {
            n13 = n4 * n7;
            n2 = 0;
            while (n2 < n4) {
                fArray2[0][n13 + n2] = fArray2[0][n2];
                ++n2;
            }
        }
        if (bl) {
            if (n10 == 1) {
                float[][] fArray3 = new float[3][n4 * n11];
                n2 = 0;
                int n15 = 0;
                while (n15 < n11) {
                    n = 0;
                    while (n < n4) {
                        fArray3[0][n2] = n;
                        fArray3[1][n2] = n15;
                        fArray3[2][n2] = 0.0f;
                        ++n2;
                        ++n;
                    }
                    ++n15;
                }
                Gridded3DSet gridded3DSet = new Gridded3DSet((MathType)realTupleType, fArray3, n4, n11);
                this.radar = new FlatField(functionType, gridded3DSet);
            } else {
                Integer3DSet integer3DSet = new Integer3DSet((MathType)realTupleType, n4, n11, n10);
                this.radar = new FlatField(functionType, integer3DSet);
            }
        } else {
            Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, n4, n11);
            this.radar = new FlatField(functionType, integer2DSet);
        }
        this.radar.setSamples(fArray2);
    }

    public class PolarData {
        public double azimuth;
        public double range;
    }
}

