/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import visad.CommonUnit;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;

public class Radar3DCoordinateSystem
extends NavigatedCoordinateSystem {
    public static final double EARTH_RADIUS = 6367681.04774543;
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
    private float centlat;
    private float centlon;
    private float centalt;
    private float radlow;
    private float radres;
    private float azlow;
    private float azres;
    private float elevlow;
    private float elevres;
    private double coscentlat;
    private double lonscale;
    private double latscale;

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        double d = 6367681.04774543 + (double)this.centalt;
        int n2 = 0;
        while (n2 < n) {
            double d2 = (double)this.radlow + (double)this.radres * dArray[0][n2];
            if (d2 < 0.0) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
                dArray2[2][n2] = Double.NaN;
            } else {
                double d3 = (double)this.azlow + (double)this.azres * dArray[1][n2];
                double d4 = Math.cos(Math.PI / 180 * d3);
                double d5 = Math.sin(Math.PI / 180 * d3);
                double d6 = (double)this.elevlow + (double)this.elevres * dArray[2][n2];
                double d7 = Math.cos(Math.PI / 180 * d6);
                double d8 = Math.sin(Math.PI / 180 * d6);
                double d9 = Math.sqrt(d * d + d2 * d2 + 2.0 * d8 * d * d2);
                dArray2[2][n2] = d9 - d + (double)this.centalt;
                double d10 = Math.asin(d7 * d2 / d9);
                double d11 = d * d10;
                dArray2[0][n2] = (double)this.centlat + d4 * d11 / this.latscale;
                dArray2[1][n2] = (double)this.centlon + d5 * d11 / this.lonscale;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        double d = 6367681.04774543 + (double)this.centalt;
        int n2 = 0;
        while (n2 < n) {
            double d2 = (dArray[0][n2] - (double)this.centlat) * this.latscale;
            double d3 = (dArray[1][n2] - (double)this.centlon) * this.lonscale;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = d4 / d;
            double d6 = dArray[2][n2] - (double)this.centalt;
            double d7 = d + d6;
            double d8 = Math.sqrt(d * d + d7 * d7 - 2.0 * d7 * d * Math.cos(d5));
            double d9 = 57.29577951308232 * Math.acos(Math.sin(d5) * d7 / d8);
            if (d6 < 0.0) {
                d9 = -d9;
            }
            dArray2[0][n2] = (d8 - (double)this.radlow) / (double)this.radres;
            dArray2[1][n2] = (57.29577951308232 * Math.atan2(d3, d2) - (double)this.azlow) / (double)this.azres;
            dArray2[2][n2] = (d9 - (double)this.elevlow) / (double)this.elevres;
            if (dArray2[1][n2] < 0.0) {
                double[] dArray3 = dArray2[1];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + 360.0;
            }
            ++n2;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        double d = 6367681.04774543 + (double)this.centalt;
        int n2 = 0;
        while (n2 < n) {
            double d2 = this.radlow + this.radres * fArray[0][n2];
            if (d2 < 0.0) {
                fArray2[0][n2] = Float.NaN;
                fArray2[1][n2] = Float.NaN;
                fArray2[2][n2] = Float.NaN;
            } else {
                double d3 = this.azlow + this.azres * fArray[1][n2];
                double d4 = Math.cos(Math.PI / 180 * d3);
                double d5 = Math.sin(Math.PI / 180 * d3);
                double d6 = this.elevlow + this.elevres * fArray[2][n2];
                double d7 = Math.cos(Math.PI / 180 * d6);
                double d8 = Math.sin(Math.PI / 180 * d6);
                double d9 = Math.sqrt(d * d + d2 * d2 + 2.0 * d8 * d * d2);
                fArray2[2][n2] = (float)(d9 - d) + this.centalt;
                double d10 = Math.asin(d7 * d2 / d9);
                double d11 = d * d10;
                fArray2[0][n2] = (float)((double)this.centlat + d4 * d11 / this.latscale);
                fArray2[1][n2] = (float)((double)this.centlon + d5 * d11 / this.lonscale);
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        double d = 6367681.04774543 + (double)this.centalt;
        int n2 = 0;
        while (n2 < n) {
            double d2 = (double)(fArray[0][n2] - this.centlat) * this.latscale;
            double d3 = (double)(fArray[1][n2] - this.centlon) * this.lonscale;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = d4 / d;
            double d6 = fArray[2][n2] - this.centalt;
            double d7 = d + d6;
            double d8 = Math.sqrt(d * d + d7 * d7 - 2.0 * d7 * d * Math.cos(d5));
            double d9 = 57.29577951308232 * Math.acos(Math.sin(d5) * d7 / d8);
            if (d6 < 0.0) {
                d9 = -d9;
            }
            fArray2[0][n2] = (float)((d8 - (double)this.radlow) / (double)this.radres);
            fArray2[1][n2] = (float)((57.29577951308232 * Math.atan2(d3, d2) - (double)this.azlow) / (double)this.azres);
            fArray2[2][n2] = (float)((d9 - (double)this.elevlow) / (double)this.elevres);
            if (fArray2[1][n2] < 0.0f) {
                float[] fArray3 = fArray2[1];
                int n3 = n2;
                fArray3[n3] = fArray3[n3] + 360.0f;
            }
            ++n2;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof Radar3DCoordinateSystem;
    }

    public float[] getElevationParameters() {
        return new float[]{this.elevlow, this.elevres};
    }

    public float[] getAzimuthParameters() {
        return new float[]{this.azlow, this.azres};
    }

    public float[] getRangeParameters() {
        return new float[]{this.radlow, this.radres};
    }

    public float[] getCenterPoint() {
        return new float[]{this.centlat, this.centlon, this.centalt};
    }

    public Radar3DCoordinateSystem(float f, float f2, float f3) throws VisADException {
        this(new RealTupleType(RealType.Latitude, RealType.Longitude, RealType.Altitude), f, f2, f3, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public Radar3DCoordinateSystem(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) throws VisADException {
        this(new RealTupleType(RealType.Latitude, RealType.Longitude, RealType.Altitude), f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public Radar3DCoordinateSystem(RealTupleType realTupleType, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) throws VisADException {
        this(realTupleType, f, f2, 0.0f, f3, f4, f5, f6, f7, f8);
    }

    public Radar3DCoordinateSystem(RealTupleType realTupleType, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) throws VisADException {
        super(realTupleType, coordinate_system_units);
        this.centlat = f;
        this.centlon = f2;
        this.centalt = f3;
        this.radlow = f4;
        this.radres = f5;
        this.azlow = f6;
        this.azres = f7;
        this.elevlow = f8;
        this.elevres = f9;
        this.coscentlat = Math.cos(Math.PI / 180 * (double)this.centlat);
        this.lonscale = 111137.0 * this.coscentlat;
        this.latscale = 111137.0;
    }
}

