/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import visad.CommonUnit;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;

public class Radar2DCoordinateSystem
extends NavigatedCoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.meter, CommonUnit.degree};
    private float centlat;
    private float centlon;
    private float radlow;
    private float radres;
    private float azlow;
    private float azres;
    private double coscentlat;
    private double lonscale;
    private double latscale;

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = (double)this.radlow + (double)this.radres * dArray[0][n2];
            if (d < 0.0) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                double d2 = (double)this.azlow + (double)this.azres * dArray[1][n2];
                double d3 = Math.cos(Math.PI / 180 * d2);
                double d4 = Math.sin(Math.PI / 180 * d2);
                dArray2[0][n2] = (double)this.centlat + d3 * d / this.latscale;
                dArray2[1][n2] = (double)this.centlon + d4 * d / this.lonscale;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = (dArray[0][n2] - (double)this.centlat) * this.latscale;
            double d2 = (dArray[1][n2] - (double)this.centlon) * this.lonscale;
            dArray2[0][n2] = (Math.sqrt(d * d + d2 * d2) - (double)this.radlow) / (double)this.radres;
            dArray2[1][n2] = (57.29577951308232 * Math.atan2(d2, d) - (double)this.azlow) / (double)this.azres;
            if (dArray2[1][n2] < 0.0) {
                double[] dArray3 = dArray2[1];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + 360.0;
            }
            ++n2;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = this.radlow + this.radres * fArray[0][n2];
            if (d < 0.0) {
                fArray2[0][n2] = Float.NaN;
                fArray2[1][n2] = Float.NaN;
            } else {
                double d2 = this.azlow + this.azres * fArray[1][n2];
                double d3 = Math.cos(Math.PI / 180 * d2);
                double d4 = Math.sin(Math.PI / 180 * d2);
                fArray2[0][n2] = (float)((double)this.centlat + d3 * d / this.latscale);
                fArray2[1][n2] = (float)((double)this.centlon + d4 * d / this.lonscale);
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = (double)(fArray[0][n2] - this.centlat) * this.latscale;
            double d2 = (double)(fArray[1][n2] - this.centlon) * this.lonscale;
            fArray2[0][n2] = (float)((Math.sqrt(d * d + d2 * d2) - (double)this.radlow) / (double)this.radres);
            fArray2[1][n2] = (float)((57.29577951308232 * Math.atan2(d2, d) - (double)this.azlow) / (double)this.azres);
            if ((double)fArray2[1][n2] < 0.0) {
                float[] fArray3 = fArray2[1];
                int n3 = n2;
                fArray3[n3] = fArray3[n3] + 360.0f;
            }
            ++n2;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof Radar2DCoordinateSystem;
    }

    public float[] getAzimuthParameters() {
        return new float[]{this.azlow, this.azres};
    }

    public float[] getRangeParameters() {
        return new float[]{this.radlow, this.radres};
    }

    public float[] getCenterPoint() {
        return new float[]{this.centlat, this.centlon};
    }

    public Radar2DCoordinateSystem(float f, float f2) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, f, f2, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public Radar2DCoordinateSystem(float f, float f2, float f3, float f4, float f5, float f6) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, f, f2, f3, f4, f5, f6);
    }

    public Radar2DCoordinateSystem(RealTupleType realTupleType, float f, float f2, float f3, float f4, float f5, float f6) throws VisADException {
        super(realTupleType, coordinate_system_units);
        this.centlat = f;
        this.centlon = f2;
        this.radlow = f3;
        this.radres = f4;
        this.azlow = f5;
        this.azres = f6;
        this.coscentlat = Math.cos(Math.PI / 180 * (double)this.centlat);
        this.lonscale = 111137.0 * this.coscentlat;
        this.latscale = 111137.0;
    }
}

