/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.BadMappingException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ShadowType;
import visad.VisADError;
import visad.VisADException;
import visad.bom.ShadowImageFunctionTypeJ3D;
import visad.collab.CollabUtil;
import visad.data.netcdf.Plain;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.VisADBranchGroup;
import visad.util.Delay;

public class ImageRendererJ3D
extends DefaultRendererJ3D {
    private static MathType image_sequence_type;
    private static MathType image_type;
    private static MathType image_sequence_type2;
    private static MathType image_type2;
    private static MathType image_sequence_type3;
    private static MathType image_type3;
    private boolean reUseFrames = false;
    private boolean setSetOnReUseFrames = true;
    private VisADBranchGroup vbranch = null;

    public static boolean isImageType(MathType mathType) {
        return image_sequence_type.equalsExceptName(mathType) || image_sequence_type2.equalsExceptName(mathType) || image_sequence_type3.equalsExceptName(mathType) || image_type.equalsExceptName(mathType) || image_type2.equalsExceptName(mathType) || image_type3.equalsExceptName(mathType);
    }

    public static void verifyImageRendererUsable(MathType mathType, ScalarMap[] scalarMapArray) throws VisADException {
        ImageRendererJ3D.isRendererUsable(mathType, scalarMapArray);
    }

    public static boolean isRendererUsable(MathType mathType, ScalarMap[] scalarMapArray) throws VisADException {
        int n;
        Serializable serializable;
        RealType realType = null;
        RealTupleType realTupleType = null;
        RealTupleType realTupleType2 = null;
        RealType realType2 = null;
        RealType realType3 = null;
        RealType realType4 = null;
        RealType realType5 = null;
        RealType realType6 = null;
        RealType realType7 = null;
        RealType realType8 = null;
        RealType realType9 = null;
        if (!(mathType instanceof FunctionType)) {
            throw new VisADException("Not a FunctionType");
        }
        FunctionType functionType = (FunctionType)mathType;
        RealTupleType realTupleType3 = functionType.getDomain();
        MathType mathType2 = functionType.getRange();
        if (functionType.equalsExceptName(image_sequence_type) || functionType.equalsExceptName(image_sequence_type2) || functionType.equalsExceptName(image_sequence_type3)) {
            realType = (RealType)realTupleType3.getComponent(0);
            functionType = (FunctionType)mathType2;
            realTupleType3 = functionType.getDomain();
            mathType2 = functionType.getRange();
        }
        if (functionType.equalsExceptName(image_type) || functionType.equalsExceptName(image_type2) || functionType.equalsExceptName(image_type3)) {
            realTupleType = functionType.getDomain();
            serializable = functionType.getRange();
            realTupleType2 = serializable instanceof RealType ? new RealTupleType((RealType)serializable) : (RealTupleType)serializable;
        } else {
            throw new VisADException("Illegal MathType");
        }
        realType2 = (RealType)realTupleType.getComponent(0);
        realType3 = (RealType)realTupleType.getComponent(1);
        serializable = realTupleType.getCoordinateSystem();
        if (serializable != null) {
            RealTupleType realTupleType4 = ((CoordinateSystem)serializable).getReference();
            realType4 = (RealType)realTupleType4.getComponent(0);
            realType5 = (RealType)realTupleType4.getComponent(1);
        }
        if ((n = realTupleType2.getDimension()) == 1) {
            realType9 = (RealType)realTupleType2.getComponent(0);
        } else {
            realType6 = (RealType)realTupleType2.getComponent(0);
            realType7 = (RealType)realTupleType2.getComponent(1);
            realType8 = (RealType)realTupleType2.getComponent(2);
        }
        boolean bl = realType == null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        Boolean bl12 = null;
        DisplayRealType displayRealType = null;
        int n2 = 0;
        while (n2 < scalarMapArray.length) {
            RealType realType10;
            ScalarMap scalarMap = scalarMapArray[n2];
            ScalarType scalarType = scalarMap.getScalar();
            DisplayRealType displayRealType2 = scalarMap.getDisplayScalar();
            boolean bl13 = scalarType.equals(realType);
            boolean bl14 = scalarType.equals(realType2);
            boolean bl15 = scalarType.equals(realType3);
            boolean bl16 = scalarType.equals(realType4);
            boolean bl17 = scalarType.equals(realType5);
            boolean bl18 = scalarType.equals(realType6);
            boolean bl19 = scalarType.equals(realType7);
            boolean bl20 = scalarType.equals(realType8);
            boolean bl21 = scalarType.equals(realType9);
            if (bl13) {
                if (bl) {
                    throw new VisADException("Multiple Time mappings");
                }
                if (!displayRealType2.equals(Display.Animation)) {
                    throw new VisADException("Time mapped to something other than Animation");
                }
                bl = true;
            } else if (bl14 || bl15 || bl16 || bl17) {
                boolean bl22;
                if (bl14 && bl2 || bl15 && bl3 || bl16 && bl4 || bl17 && bl5) {
                    throw new VisADException("Duplicate spatial mappings");
                }
                if ((bl14 || bl15) && (bl4 || bl5) || (bl16 || bl17) && (bl2 || bl3)) {
                    throw new VisADException("reference and non-reference spatial mappings");
                }
                RealType realType11 = realType10 = bl14 ? realType2 : null;
                if (bl15) {
                    realType10 = realType3;
                }
                if (bl16) {
                    realType10 = realType4;
                }
                if (bl17) {
                    realType10 = realType5;
                }
                if (displayRealType2.equals(Display.XAxis) || displayRealType2.equals(Display.YAxis) || displayRealType2.equals(Display.ZAxis)) {
                    bl22 = false;
                } else if (displayRealType2.equals(Display.Latitude) || displayRealType2.equals(Display.Longitude) || displayRealType2.equals(Display.Radius)) {
                    bl22 = true;
                } else {
                    throw new VisADException("Illegal domain mapping");
                }
                if (bl12 == null) {
                    bl12 = new Boolean(bl22);
                    displayRealType = displayRealType2;
                } else {
                    if (bl12 != bl22) {
                        throw new VisADException("Multiple spatial coordinate systems");
                    }
                    if (displayRealType == displayRealType2) {
                        throw new VisADException("Multiple mappings to the same spatial DisplayRealType");
                    }
                }
                if (bl14) {
                    bl2 = true;
                } else if (bl15) {
                    bl3 = true;
                } else if (bl16) {
                    bl4 = true;
                } else if (bl17) {
                    bl5 = true;
                }
            } else if (bl21) {
                if (bl6 || bl7 || bl8) {
                    throw new VisADException("Duplicate color mappings");
                }
                if (realType9 == null || !displayRealType2.equals(Display.RGB)) {
                    throw new VisADException("Illegal RGB mapping");
                }
                bl11 = true;
                bl10 = true;
                bl9 = true;
                bl8 = true;
                bl7 = true;
                bl6 = true;
            } else if (bl18 || bl19 || bl20) {
                if (realType9 != null) {
                    throw new VisADException("Illegal RGB mapping");
                }
                RealType realType12 = bl18 ? realType6 : (realType10 = bl19 ? realType7 : realType8);
                if (displayRealType2.equals(Display.Red)) {
                    bl9 = true;
                } else if (displayRealType2.equals(Display.Green)) {
                    bl10 = true;
                } else if (displayRealType2.equals(Display.Blue)) {
                    bl11 = true;
                } else {
                    throw new VisADException("Illegal color mapping");
                }
                if (bl18) {
                    bl6 = true;
                } else if (bl19) {
                    bl7 = true;
                } else {
                    bl8 = true;
                }
            } else if (bl13 || bl14 || bl15 || bl16 || bl17 || bl18 || bl19 || bl20 || bl21) {
                throw new VisADException("Illegal mapping: " + scalarMap);
            }
            ++n2;
        }
        if (!(bl && (bl2 && bl3 || bl4 && bl5) && bl6 && bl7 && bl8 && bl9 && bl10 && bl11)) {
            throw new VisADException("Insufficient mappings");
        }
        return true;
    }

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowImageFunctionTypeJ3D(functionType, dataDisplayLink, shadowType);
    }

    public void setReUseFrames(boolean bl) {
        this.reUseFrames = bl;
    }

    public void setReUseFrames() {
        this.setReUseFrames(true);
    }

    public boolean getReUseFrames() {
        return this.reUseFrames;
    }

    public void setSetSetOnReUseFrames(boolean bl) {
        this.setSetOnReUseFrames = bl;
    }

    public boolean getSetSetOnReUseFrames() {
        return this.setSetOnReUseFrames;
    }

    void setVisADBranch(VisADBranchGroup visADBranchGroup) {
        this.vbranch = visADBranchGroup;
    }

    void markMissingVisADBranch() {
        if (this.vbranch != null) {
            this.vbranch.scratchTime();
        }
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] dataDisplayLinkArray;
        BranchGroup branchGroup = this.getBranch();
        if (branchGroup == null) {
            branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.setCapability(14);
            branchGroup.setCapability(12);
            branchGroup.setCapability(13);
        }
        if ((dataDisplayLinkArray = this.getLinks()) == null || dataDisplayLinkArray.length == 0) {
            return null;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        ShadowTypeJ3D shadowTypeJ3D = (ShadowTypeJ3D)dataDisplayLink.getShadow();
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = dataDisplayLink.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, dataDisplayLink);
                this.removeLink(dataDisplayLink);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            branchGroup = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            MathType mathType = dataDisplayLink.getType();
            if (!ImageRendererJ3D.isImageType(mathType)) {
                throw new BadMappingException("must be image or image sequence");
            }
            dataDisplayLink.start_time = System.currentTimeMillis();
            dataDisplayLink.time_flag = false;
            this.vbranch = null;
            try {
                shadowTypeJ3D.doTransform(branchGroup, data, fArray, dataDisplayLink.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, dataDisplayLink);
                    this.removeLink(dataDisplayLink);
                    return null;
                }
                throw remoteException;
            }
        }
        dataDisplayLink.clearData();
        return branchGroup;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        Object object;
        int n = 1000;
        int n2 = 3;
        if (stringArray.length > 0) {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 3;
            }
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (stringArray.length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1000;
            }
        }
        if (n < 1) {
            n = 1;
        }
        Plain plain = new Plain();
        Field field = null;
        try {
            field = (Field)((Object)plain.open("images.nc"));
        }
        catch (IOException iOException) {
            object = "To run this example, the images.nc file must be present in\nthe current directory.You can obtain this file from:\n  ftp://www.ssec.wisc.edu/pub/visad-2.0/images.nc.Z";
            System.out.println((String)object);
            System.exit(0);
        }
        FunctionType functionType = (FunctionType)field.getType();
        object = field.getDomainSet();
        float[][] fArray = ((Set)object).getSamples();
        int n3 = fArray[0].length;
        if (n3 != 4) {
            throw new VisADException("wrong number of images in sequence");
        }
        float f = 1.3333334f * (fArray[0][3] - fArray[0][0]);
        double[][] dArray = new double[1][n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray[0][n4] = fArray[0][n4 % n3] + f * (float)(n4 / n3);
            ++n4;
        }
        Gridded1DDoubleSet gridded1DDoubleSet = new Gridded1DDoubleSet(((DataImpl)object).getType(), dArray, n2);
        FieldImpl fieldImpl = new FieldImpl(functionType, gridded1DDoubleSet);
        int n5 = 0;
        while (n5 < n2) {
            fieldImpl.setSample(n5, field.getSample(n5 % n3));
            ++n5;
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("image");
        dataReferenceImpl.setData(fieldImpl);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("image display");
        FunctionType functionType2 = (FunctionType)functionType.getRange();
        RealTupleType realTupleType = functionType2.getDomain();
        displayImplJ3D.addMap(new ScalarMap((RealType)realTupleType.getComponent(0), Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap((RealType)realTupleType.getComponent(1), Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap((RealType)functionType2.getRange(), Display.RGB));
        RealType realType = (RealType)functionType.getDomain().getComponent(0);
        ScalarMap scalarMap = new ScalarMap(realType, Display.Animation);
        displayImplJ3D.addMap(scalarMap);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap.getControl());
        animationControl.setStep(n);
        animationControl.setOn(true);
        JFrame jFrame = new JFrame("ImageRendererJ3D test");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
        System.out.println("first animation sequence");
        ImageRendererJ3D imageRendererJ3D = new ImageRendererJ3D();
        displayImplJ3D.addReferences((DataRenderer)imageRendererJ3D, dataReferenceImpl);
        new Delay(n2 * 1000);
        int n6 = 0;
        while (n6 < n2) {
            dArray[0][n6] = fArray[0][(n6 + 1) % n3] + f * (float)((n6 + 1) / n3);
            ++n6;
        }
        gridded1DDoubleSet = new Gridded1DDoubleSet(((DataImpl)object).getType(), dArray, n2);
        FieldImpl fieldImpl2 = new FieldImpl(functionType, gridded1DDoubleSet);
        int n7 = 0;
        while (n7 < n2) {
            fieldImpl2.setSample(n7, field.getSample((n7 + 1) % n3));
            ++n7;
        }
        System.out.println("second animation sequence");
        imageRendererJ3D.setReUseFrames(true);
        dataReferenceImpl.setData(fieldImpl2);
    }

    static {
        try {
            image_type = MathType.stringToType("((ImageElement, ImageLine) -> ImageValue)");
            image_sequence_type = new FunctionType(RealType.Time, image_type);
            image_type2 = MathType.stringToType("((ImageElement, ImageLine) -> (ImageValue))");
            image_sequence_type2 = new FunctionType(RealType.Time, image_type2);
            image_type3 = MathType.stringToType("((ImageElement, ImageLine) -> (Red, Green, Blue))");
            image_sequence_type3 = new FunctionType(RealType.Time, image_type3);
        }
        catch (VisADException visADException) {
            throw new VisADError(visADException.getMessage());
        }
    }
}

