/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Irregular2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnionSet;
import visad.VisADError;
import visad.VisADException;
import visad.bom.FrontActionListener;
import visad.bom.FrontManipulationRendererJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;

public class FrontDrawer
implements ControlListener {
    private static boolean debug = true;
    private static Object type_lock = new Object();
    private static SetType curve_type = null;
    private static FunctionType fronts_type = null;
    private static FunctionType front_type = null;
    private static FunctionType front_inner = null;
    private static RealType front_index = null;
    private static RealType front_red = null;
    private static RealType front_green = null;
    private static RealType front_blue = null;
    public static final int COLD_FRONT = 0;
    public static final int WARM_FRONT = 1;
    public static final int OCCLUDED_FRONT = 2;
    public static final int STATIONARY_FRONT = 3;
    public static final int CONVERGENCE = 4;
    public static final int FRONTOGENESIS = 5;
    public static final int FRONTOLYSIS = 6;
    public static final int UPPER_COLD_FRONT = 7;
    public static final int UPPER_WARM_FRONT = 8;
    public static final int TROUGH = 9;
    public static final int RIDGE = 10;
    public static final int MOISTURE = 11;
    public static final int LOW_LEVEL_JET = 12;
    public static final int UPPER_LEVEL_JET = 13;
    public static final int DRY_LINE = 14;
    public static final int TOTAL_TOTALS = 15;
    public static final int LIFTED_INDEX = 16;
    public static final int ISOTHERMS = 17;
    public static final int THICKNESS_RIDGE = 18;
    public static final int LOWER_THERMAL_TROUGH = 19;
    public static final int UPPER_THERMAL_TROUGH = 20;
    private static final float[] segmentarray = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.05f, 0.1f, 0.05f, 0.2f, 0.2f, 0.1f, 0.05f, 0.1f, 0.15f, 0.1f, 0.05f, 0.1f};
    private static final float[][][][] rshapesarray = new float[][][][]{{{{0.0f, 0.025f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.04f, 0.01f}}}, {{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.07f, 0.0525f, 0.035f, 0.0175f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f}}}, {{{0.0f, 0.025f, 0.05f, 0.07f, 0.105f, 0.14f, 0.17f, 0.2f, 0.2f, 0.17f, 0.14f, 0.1225f, 0.105f, 0.0875f, 0.07f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.04f, 0.01f}}}, {{{0.09f, 0.11f, 0.1275f, 0.145f, 0.1625f, 0.18f, 0.2f, 0.2f, 0.1775f, 0.155f, 0.1175f, 0.09f}, {0.0f, 0.0f, -0.02f, -0.027f, -0.02f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, {{0.0f, 0.02f, 0.045f, 0.07f, 0.09f, 0.09f, 0.07f, 0.045f, 0.02f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.04f, 0.01f, 0.0f}}}, {{{0.0f, 0.03f, 0.035f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.11f, 0.135f, 0.13f, 0.1f, 0.05f, 0.0f}, {0.01f, 0.04f, 0.035f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.0f, 0.0f, 0.0f, -0.025f, -0.03f, 0.0f, 0.0f, 0.0f}}}, {{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, {{0.16f, 0.19f, 0.19f, 0.16f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, {{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, {{0.16f, 0.17f, 0.17f, 0.18f, 0.18f, 0.19f, 0.19f, 0.18f, 0.18f, 0.17f, 0.17f, 0.16f}, {0.0f, 0.0f, -0.01f, -0.01f, 0.0f, 0.0f, 0.01f, 0.01f, 0.02f, 0.02f, 0.01f, 0.01f}}}, {{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, {{0.0f, 0.03f, 0.06f, 0.05f, 0.03f, 0.01f}, {0.01f, 0.04f, 0.01f, 0.01f, 0.03f, 0.01f}}}, {{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, {{0.0f, 0.015f, 0.03f, 0.045f, 0.06f, 0.05f, 0.04f, 0.03f, 0.02f, 0.01f}, {0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.023f, 0.027f, 0.023f, 0.01f}}}, {{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, {{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.04f, -0.06f, 0.04f, 0.06f, -0.04f, 0.06f}}}, {{{0.0f, 0.0f, 0.01f, 0.01f, 0.05f, 0.05f, 0.0f}, {0.01f, 0.05f, 0.05f, 0.01f, 0.01f, 0.0f, 0.0f}}}, {{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}}, {{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {-0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f}}}, {{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, {{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, {{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, {{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, {{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, {{{0.0f, 0.0f, 0.04f, 0.08f, 0.08f, 0.04f, 0.0f, 0.0f, 0.02f, 0.02f, 0.06f, 0.06f, 0.02f, 0.02f}, {0.0f, -0.02f, -0.02f, -0.02f, 0.02f, 0.02f, 0.02f, 0.0f, 0.0f, 0.01f, 0.01f, -0.01f, -0.01f, 0.0f}}}, {{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.01f, -0.06f, 0.01f, 0.06f, -0.01f, 0.06f}}}, {{{0.0f, 0.045f, 0.045f, 0.0f}, {-0.01f, -0.01f, 0.02f, 0.02f}}}, {{{0.0f, 0.04f, 0.02f}, {0.0f, 0.0f, 0.04f}}}};
    private static final float[][] rredarray = new float[][]{{0.0f}, {1.0f}, {1.0f}, {1.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.5f}, {0.5f}, {1.0f}, {0.5f}, {0.5f}, {0.5f, 0.5f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}};
    private static final float[][] rgreenarray = new float[][]{{0.0f}, {0.0f}, {0.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.3f}, {0.3f}, {1.0f}, {0.5f}, {0.5f}, {0.3f, 0.3f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}};
    private static final float[][] rbluearray = new float[][]{{1.0f}, {0.0f}, {1.0f}, {0.0f, 1.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.0f}, {0.0f}, {1.0f}, {1.0f}, {1.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}};
    private static final float[][][][] fshapesarray = new float[][][][]{null, null, null, null, null, null, null, null, null, null, null, null, {{{0.0f, 0.07f, 0.075f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.01f, 0.075f, 0.07f, 0.0f}, {0.0f, -0.07f, -0.065f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.075f, 0.08f, 0.01f}}}, {{{0.0f, 0.06f, 0.077f, 0.04f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.04f, 0.077f, 0.06f, 0.0f}, {-0.001f, -0.06f, -0.04f, -0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f, 0.05f, 0.07f, 0.02f}}}, null, null, null, null, null, null, null};
    private static final float[][] fredarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null};
    private static final float[][] fgreenarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null};
    private static final float[][] fbluearray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {1.0f}, {1.0f}, null, null, null, null, null, null, null};
    private static final float CLIP_DELTA = 0.001f;
    private Object data_lock = new Object();
    private DataReferenceImpl front_ref;
    private DefaultRendererJ3D front_renderer;
    private DataReferenceImpl curve_ref = null;
    private FrontManipulationRendererJ3D front_manipulation_renderer;
    private ReleaseCell release_cell;
    private DataReferenceImpl release_ref;
    private ZoomCell zoom_cell;
    private DataReferenceImpl zoom_ref;
    private ProjectionControl pcontrol = null;
    private ProjectionControlListener pcl = null;
    private float zoom = 1.0f;
    private AnimationControl acontrol = null;
    private DisplayImplJ3D display;
    private ScalarMap lat_map = null;
    private ScalarMap lon_map = null;
    private int ntimes = 0;
    private int current_time_step = -1;
    private UnionSet init_curve = null;
    private int lat_index = 0;
    private int lon_index = 1;
    private float[][][] curves = null;
    private boolean[] flips = null;
    private FieldImpl fronts = null;
    private FieldImpl front = null;
    private int nfshapes = -1;
    private float[][][] first_shapes = null;
    private int[][][] first_tris = null;
    private float[] first_red = null;
    private float[] first_green = null;
    private float[] first_blue = null;
    private int nrshapes = -1;
    private float[][][] repeat_shapes = null;
    private int[][][] repeat_tris = null;
    private float[] repeat_red = null;
    private float[] repeat_green = null;
    private float[] repeat_blue = null;
    private float segment_length;
    private int profile_length = -1;
    private int filter_window = 1;
    float[][][] ccs = null;
    FieldImpl ffs = null;
    private Gridded2DSet last_curve_set = null;
    private boolean pfirst = true;
    private float last_zoom = 1.0f;
    private static /* synthetic */ Class class$Lvisad$AnimationControl;

    private void setupAnimationSet(Set set) throws VisADException {
        this.ntimes = set.getLength();
        this.current_time_step = this.acontrol.getCurrent();
        if (this.ccs == null) {
            this.curves = new float[this.ntimes][][];
        } else {
            this.curves = this.ccs;
            if (this.ccs.length != this.ntimes) {
                throw new VisADException("cs bad number of times " + this.ccs.length + " != " + this.ntimes);
            }
        }
        this.flips = new boolean[this.ntimes];
        if (this.ffs == null) {
            this.fronts = new FieldImpl(fronts_type, set);
        } else {
            this.fronts = this.ffs;
            if (!set.equals(this.ffs.getDomainSet())) {
                throw new VisADException("fs bad time Set " + this.ffs.getDomainSet() + " != " + set);
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) {
        if (this.fronts == null) {
            try {
                Set set = this.acontrol.getSet();
                if (set != null) {
                    this.setupAnimationSet(set);
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public DefaultRendererJ3D getFrontRenderer() {
        return this.front_renderer;
    }

    public static void initColormaps(DisplayImplJ3D displayImplJ3D) throws VisADException, RemoteException {
        FrontDrawer.setupTypes();
        ScalarMap scalarMap = new ScalarMap(front_red, Display.Red);
        scalarMap.setRange(0.0, 1.0);
        displayImplJ3D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(front_green, Display.Green);
        scalarMap2.setRange(0.0, 1.0);
        displayImplJ3D.addMap(scalarMap2);
        ScalarMap scalarMap3 = new ScalarMap(front_blue, Display.Blue);
        scalarMap3.setRange(0.0, 1.0);
        displayImplJ3D.addMap(scalarMap3);
    }

    private static void setupTypes() throws VisADException {
        Object object = type_lock;
        synchronized (object) {
            if (curve_type == null) {
                RealTupleType realTupleType = new RealTupleType(RealType.Latitude, RealType.Longitude);
                curve_type = new SetType(realTupleType);
                front_index = RealType.getRealType("front_index");
                front_red = RealType.getRealType("front_red");
                front_green = RealType.getRealType("front_green");
                front_blue = RealType.getRealType("front_blue");
                RealTupleType realTupleType2 = new RealTupleType(front_red, front_green, front_blue);
                front_inner = new FunctionType(realTupleType, realTupleType2);
                front_type = new FunctionType(front_index, front_inner);
                fronts_type = new FunctionType(RealType.Time, front_type);
            }
        }
    }

    private FieldImpl robustCurveToFront(float[][] fArray, boolean bl) throws RemoteException {
        float f = this.segment_length / ((float)this.profile_length * this.zoom);
        float[][] fArray2 = FrontDrawer.resample_curve(fArray, f);
        int n = this.filter_window;
        int n2 = 0;
        while (n2 < 12) {
            fArray = FrontDrawer.smooth_curve(fArray2, n);
            fArray = FrontDrawer.resample_curve(fArray, f);
            try {
                this.front = this.curveToFront(fArray, bl);
                break;
            }
            catch (VisADException visADException) {
                int n3;
                fArray2 = fArray;
                if (n2 > 4 && (n3 = fArray2[0].length) > 2) {
                    float[][] fArray3 = new float[2][n3 - 2];
                    System.arraycopy(fArray2[0], 1, fArray3[0], 0, n3 - 2);
                    System.arraycopy(fArray2[1], 1, fArray3[1], 0, n3 - 2);
                    fArray2 = fArray3;
                }
                if (n2 > 8) {
                    n = 2 * n;
                }
                if (n2 == 9) {
                    System.out.println("cannot smooth curve");
                    this.front = null;
                }
                ++n2;
            }
        }
        return this.front;
    }

    public Gridded2DSet getCurve() {
        return this.last_curve_set;
    }

    public void release() {
        block4: {
            try {
                this.release_ref.setData(null);
            }
            catch (VisADException visADException) {
                if (debug) {
                    System.out.println("release fail: " + visADException.toString());
                }
            }
            catch (RemoteException remoteException) {
                if (!debug) break block4;
                System.out.println("release fail: " + remoteException.toString());
            }
        }
    }

    public void endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            if (this.curve_ref != null) {
                this.display.removeReference(this.curve_ref);
            }
            this.curve_ref = null;
        }
    }

    public Vector endItAll() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            if (this.curve_ref != null) {
                this.display.removeReference(this.curve_ref);
            }
            this.curve_ref = null;
            if (this.front_ref != null) {
                this.display.removeReference(this.front_ref);
                this.pcontrol.removeControlListener(this.pcl);
                this.release_cell.removeReference(this.release_ref);
                this.zoom_cell.removeReference(this.zoom_ref);
            }
            this.front_ref = null;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.fronts);
        vector.addElement(this.curves);
        return vector;
    }

    private FieldImpl curveToFront(float[][] fArray, boolean bl) throws VisADException, RemoteException {
        int n;
        float f;
        int n2;
        int n3;
        int n4 = fArray[0].length;
        if (n4 < 2) {
            return null;
        }
        float[] fArray2 = new float[n4 - 1];
        float f2 = FrontDrawer.curveLength(fArray, fArray2);
        float f3 = f2 / (float)(n4 - 1);
        float f4 = (float)this.profile_length * this.zoom / this.segment_length;
        float f5 = f3 * f4;
        float[][] fArray3 = new float[2][n4];
        int n5 = 0;
        while (n5 < n4) {
            n3 = n5 - 1;
            n2 = n5 + 1;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 > n4 - 1) {
                n2 = n4 - 1;
            }
            f = fArray[0][n2] - fArray[0][n3];
            float f6 = fArray[1][n2] - fArray[1][n3];
            f6 = -f6;
            float f7 = (float)Math.sqrt(f6 * f6 + f * f);
            if (bl) {
                f7 = -f7;
            }
            fArray3[0][n5] = f6 /= f7;
            fArray3[1][n5] = f /= f7;
            ++n5;
        }
        Vector<FlatField> vector = new Vector<FlatField>();
        n3 = 0;
        while (true) {
            n2 = 0;
            f = 0.0f;
            int n6 = n3 * this.profile_length;
            n = n6 + this.profile_length;
            if (n6 > n4 - 1) break;
            if (n > n4 - 1) {
                n2 = 1;
                n = n4 - 1;
                f = (float)(n - n6) / f4;
            }
            int n7 = this.nrshapes;
            float[][][] fArray4 = this.repeat_shapes;
            int[][][] nArray = this.repeat_tris;
            float[] fArray5 = this.repeat_red;
            float[] fArray6 = this.repeat_green;
            float[] fArray7 = this.repeat_blue;
            if (n3 == 0) {
                n7 = this.nfshapes;
                fArray4 = this.first_shapes;
                nArray = this.first_tris;
                fArray5 = this.first_red;
                fArray6 = this.first_green;
                fArray7 = this.first_blue;
            }
            int n8 = 0;
            while (n8 < n7) {
                Object object;
                Object object2;
                float f8;
                float f9;
                float f10;
                float[][] fArray8;
                float[][] fArray9 = fArray4[n8];
                Object object3 = nArray[n8];
                if (fArray9 == null || fArray9[0].length < 1) break;
                Object object4 = this.mapShape(fArray9, n4, n6, f4, f5, fArray, fArray3);
                object3 = DelaunayCustom.fill(object4);
                if (n2 != 0) {
                    float[][] fArray10 = new float[][]{{f, f, f - 0.001f}, {0.001f, -0.001f, 0.0f}};
                    fArray8 = this.mapShape(fArray10, n4, n6, f4, f5, fArray, fArray3);
                    f10 = fArray10[0][1] * fArray10[1][0] - fArray10[0][0] * fArray10[1][1];
                    f9 = (fArray10[1][0] - fArray10[1][1]) / f10;
                    f8 = (fArray10[0][1] - fArray10[0][0]) / f10;
                    float f11 = 1.0f;
                    if (f9 * fArray10[0][2] + f8 * fArray10[1][2] > f11) {
                        f9 = -f9;
                        f8 = -f8;
                        f11 = -f11;
                    }
                    object2 = new float[1][][];
                    object = new int[1][][];
                    DelaunayCustom.clip(object4, object3, f9, f8, f11, (float[][][])object2, (int[][][])object);
                    object4 = object2[0];
                    object3 = object[0];
                }
                if (object4 == null) break;
                int n9 = object4[0].length;
                fArray8 = new float[3][n9];
                f10 = fArray5[n8];
                f9 = fArray6[n8];
                f8 = fArray7[n8];
                int n10 = 0;
                while (n10 < n9) {
                    fArray8[0][n10] = f10;
                    fArray8[1][n10] = f9;
                    fArray8[2][n10] = f8;
                    ++n10;
                }
                DelaunayCustom delaunayCustom = new DelaunayCustom((float[][])object4, (int[][])object3);
                object2 = new Irregular2DSet(curve_type, (float[][])object4, null, null, null, delaunayCustom);
                object = new FlatField(front_inner, (Set)object2);
                ((FlatField)object).setSamples(fArray8, false);
                vector.addElement((FlatField)object);
                ++n8;
            }
            ++n3;
        }
        n3 = vector.size();
        Integer1DSet integer1DSet = new Integer1DSet((MathType)front_index, n3);
        FieldImpl fieldImpl = new FieldImpl(front_type, integer1DSet);
        Data[] dataArray = new FlatField[n3];
        n = 0;
        while (n < n3) {
            dataArray[n] = (FlatField)vector.elementAt(n);
            ++n;
        }
        fieldImpl.setSamples(dataArray, false);
        return fieldImpl;
    }

    private float[][] mapShape(float[][] fArray, int n, int n2, float f, float f2, float[][] fArray2, float[][] fArray3) {
        int n3 = fArray[0].length;
        float[][] fArray4 = new float[2][n3];
        int n4 = 0;
        while (n4 < n3) {
            float f3;
            float f4 = (float)n2 + f * fArray[0][n4] / this.zoom;
            int n5 = (int)f4;
            int n6 = n5 + 1;
            if (n5 < 0) {
                n5 = 0;
                n6 = n5 + 1;
            }
            if (n6 > n - 1) {
                n6 = n - 1;
                n5 = n6 - 1;
            }
            if ((f3 = f4 - (float)n5) < -1.0f) {
                f3 = -1.0f;
            }
            if (f3 > 2.0f) {
                f3 = 2.0f;
            }
            float f5 = 1.0f - f3;
            float f6 = fArray2[0][n5] + f2 * fArray[1][n4] * fArray3[0][n5] / this.zoom;
            float f7 = fArray2[1][n5] + f2 * fArray[1][n4] * fArray3[1][n5] / this.zoom;
            float f8 = fArray2[0][n6] + f2 * fArray[1][n4] * fArray3[0][n6] / this.zoom;
            float f9 = fArray2[1][n6] + f2 * fArray[1][n4] * fArray3[1][n6] / this.zoom;
            fArray4[0][n4] = f5 * f6 + f3 * f8;
            fArray4[1][n4] = f5 * f7 + f3 * f9;
            ++n4;
        }
        fArray4[this.lat_index] = this.lat_map.inverseScaleValues(fArray4[0]);
        fArray4[this.lon_index] = this.lon_map.inverseScaleValues(fArray4[1]);
        return fArray4;
    }

    public static float[][] smooth_curve(float[][] fArray, int n) {
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[2][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n;
            if (n3 < n5) {
                n5 = n3;
            }
            if ((n4 = n2 - 1 - n3) < n5) {
                n5 = n4;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            int n6 = n3 - n5;
            while (n6 <= n3 + n5) {
                f += fArray[0][n6];
                f2 += fArray[1][n6];
                ++n6;
            }
            fArray2[0][n3] = f / (float)(2 * n5 + 1);
            fArray2[1][n3] = f2 / (float)(2 * n5 + 1);
            ++n3;
        }
        return fArray2;
    }

    public static float[][] resample_curve(float[][] fArray, float f) {
        int n = fArray[0].length;
        float[] fArray2 = new float[n - 1];
        float f2 = FrontDrawer.curveLength(fArray, fArray2);
        int n2 = 1 + (int)(f2 / f);
        float f3 = f2 / (float)(n2 - 1);
        float[][] fArray3 = new float[2][n2];
        fArray3[0][0] = fArray[0][0];
        fArray3[1][0] = fArray[1][0];
        if (n2 < 2) {
            return fArray3;
        }
        int n3 = 0;
        float f4 = fArray2[n3];
        int n4 = 1;
        while (n4 < n2 - 1) {
            float f5;
            for (f5 = f3; f4 < f5; f5 -= f4) {
                if (++n3 > n - 2) {
                    throw new VisADError("k = " + n3 + " i = " + n4);
                }
                f4 = fArray2[n3];
            }
            float f6 = (f4 -= f5) / fArray2[n3];
            fArray3[0][n4] = f6 * fArray[0][n3] + (1.0f - f6) * fArray[0][n3 + 1];
            fArray3[1][n4] = f6 * fArray[1][n3] + (1.0f - f6) * fArray[1][n3 + 1];
            ++n4;
        }
        fArray3[0][n2 - 1] = fArray[0][n - 1];
        fArray3[1][n2 - 1] = fArray[1][n - 1];
        return fArray3;
    }

    public static float curveLength(float[][] fArray, float[] fArray2) {
        int n = fArray[0].length;
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n - 1) {
            fArray2[n2] = (float)Math.sqrt((fArray[0][n2 + 1] - fArray[0][n2]) * (fArray[0][n2 + 1] - fArray[0][n2]) + (fArray[1][n2 + 1] - fArray[1][n2]) * (fArray[1][n2 + 1] - fArray[1][n2]));
            f += fArray2[n2];
            ++n2;
        }
        return f;
    }

    private void setScale() throws VisADException, RemoteException {
        double[] dArray = this.pcontrol.getMatrix();
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[3];
        MouseBehaviorJ3D.unmake_matrix(dArray2, dArray3, dArray4, dArray);
        this.zoom = (float)dArray3[0];
        float f = this.zoom / this.last_zoom;
        if (f < 0.95f || 1.05f < f) {
            this.last_zoom = this.zoom;
            if (this.zoom_ref != null) {
                this.zoom_ref.setData(null);
            }
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        SetType setType = new SetType(new RealTupleType(realType, realType2));
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(realType2, Display.XAxis);
        displayImplJ3D.addMap(scalarMap);
        scalarMap.setRange(0.0, 20.0);
        ScalarMap scalarMap2 = new ScalarMap(realType, Display.YAxis);
        displayImplJ3D.addMap(scalarMap2);
        scalarMap2.setRange(-40.0, -20.0);
        ScalarMap scalarMap3 = new ScalarMap(RealType.Time, Display.Animation);
        displayImplJ3D.addMap(scalarMap3);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap3.getControl());
        animationControl.setSet(new Integer1DSet((MathType)RealType.Time, 4));
        FrontDrawer.initColormaps(displayImplJ3D);
        JFrame jFrame = new JFrame("test FrontDrawer");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        jPanel.add(new AnimationWidget(scalarMap3));
        int n = 0;
        try {
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        FrontDrawer frontDrawer = new FrontDrawer(null, null, displayImplJ3D, 8, n);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        JButton jButton = new JButton("detach");
        FrontActionListener frontActionListener = new FrontActionListener(frontDrawer, jButton, displayImplJ3D, n);
        jButton.addActionListener(frontActionListener);
        jButton.setActionCommand("detach");
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        ((Component)jFrame).setSize(500, 700);
        ((Component)jFrame).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FrontDrawer(FieldImpl fieldImpl, float[][][] fArray, DisplayImplJ3D displayImplJ3D, int n, int n2, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7) throws VisADException, RemoteException {
        this(fieldImpl, fArray, displayImplJ3D, n, segmentarray[n2], fshapesarray[n2], fArray2, fArray3, fArray4, rshapesarray[n2], fArray5, fArray6, fArray7);
    }

    public FrontDrawer(FieldImpl fieldImpl, float[][][] fArray, DisplayImplJ3D displayImplJ3D, int n, int n2) throws VisADException, RemoteException {
        this(fieldImpl, fArray, displayImplJ3D, n, segmentarray[n2], fshapesarray[n2], fredarray[n2], fgreenarray[n2], fbluearray[n2], rshapesarray[n2], rredarray[n2], rgreenarray[n2], rbluearray[n2]);
    }

    public FrontDrawer(FieldImpl fieldImpl, float[][][] fArray, DisplayImplJ3D displayImplJ3D, int n, float f, float[][][] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[][][] fArray6, float[] fArray7, float[] fArray8, float[] fArray9) throws VisADException, RemoteException {
        Object object;
        int n2;
        SampledSet[] sampledSetArray;
        try {
            FrontDrawer.initColormaps(displayImplJ3D);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        this.ccs = fArray;
        this.ffs = fieldImpl;
        this.curve_ref = new DataReferenceImpl("curve_ref");
        Gridded2DSet gridded2DSet = null;
        gridded2DSet = fArray == null || fArray[0] == null ? new Gridded2DSet((MathType)curve_type, new float[][]{{0.0f}, {0.0f}}, 1) : new Gridded2DSet((MathType)curve_type, fArray[0], fArray[0][0].length);
        this.init_curve = new UnionSet((MathType)curve_type, new Gridded2DSet[]{gridded2DSet});
        Data data = this.curve_ref.getData();
        DataImpl dataImpl = null;
        if (data != null && data instanceof UnionSet && (sampledSetArray = ((UnionSet)data).getSets())[0] instanceof Gridded2DSet) {
            dataImpl = (Gridded2DSet)sampledSetArray[0];
        }
        if (dataImpl == null) {
            this.curve_ref.setData(this.init_curve);
        } else {
            sampledSetArray = (SampledSet[])dataImpl.getType();
            if (!sampledSetArray.equals(curve_type)) {
                SetType setType = new SetType(new RealTupleType(RealType.Longitude, RealType.Latitude));
                if (!sampledSetArray.equals(setType)) {
                    throw new SetException("cr data bad MathType");
                }
                this.lat_index = 1;
                this.lon_index = 0;
            }
        }
        this.display = displayImplJ3D;
        this.filter_window = n;
        this.segment_length = f;
        if (fArray6 == null) {
            throw new VisADException("bad rshapes");
        }
        this.nrshapes = fArray6.length;
        int n3 = 0;
        while (n3 < this.nrshapes) {
            if (fArray6[n3] == null || fArray6[n3].length != 2 || fArray6[n3][0] == null || fArray6[n3][1] == null || fArray6[n3][0].length != fArray6[n3][1].length) {
                throw new VisADException("bad rshapes[" + n3 + "]");
            }
            ++n3;
        }
        if (fArray7 == null || fArray7.length != this.nrshapes || fArray8 == null || fArray8.length != this.nrshapes || fArray9 == null || fArray9.length != this.nrshapes) {
            throw new VisADException("bad rcolors");
        }
        this.repeat_tris = new int[this.nrshapes][][];
        n3 = 0;
        while (n3 < this.nrshapes) {
            this.repeat_tris[n3] = DelaunayCustom.fill(fArray6[n3]);
            ++n3;
        }
        this.repeat_shapes = new float[this.nrshapes][2][];
        n3 = 0;
        int n4 = 0;
        while (n4 < this.nrshapes) {
            n2 = fArray6[n4][0].length;
            n3 += n2;
            this.repeat_shapes[n4][0] = new float[n2];
            this.repeat_shapes[n4][1] = new float[n2];
            System.arraycopy(fArray6[n4][0], 0, this.repeat_shapes[n4][0], 0, n2);
            System.arraycopy(fArray6[n4][1], 0, this.repeat_shapes[n4][1], 0, n2);
            ++n4;
        }
        this.profile_length = n3;
        this.repeat_red = new float[this.nrshapes];
        this.repeat_green = new float[this.nrshapes];
        this.repeat_blue = new float[this.nrshapes];
        System.arraycopy(fArray7, 0, this.repeat_red, 0, this.nrshapes);
        System.arraycopy(fArray8, 0, this.repeat_green, 0, this.nrshapes);
        System.arraycopy(fArray9, 0, this.repeat_blue, 0, this.nrshapes);
        if (fArray2 == null) {
            this.nfshapes = this.nrshapes;
            this.first_tris = this.repeat_tris;
            this.first_shapes = this.repeat_shapes;
            this.first_red = this.repeat_red;
            this.first_green = this.repeat_green;
            this.first_blue = this.repeat_blue;
        } else {
            this.nfshapes = fArray2.length;
            n4 = 0;
            while (n4 < this.nfshapes) {
                if (fArray2[n4] == null || fArray2[n4].length != 2 || fArray2[n4][0] == null || fArray2[n4][1] == null || fArray2[n4][0].length != fArray2[n4][1].length) {
                    throw new VisADException("bad fshapes[" + n4 + "]");
                }
                ++n4;
            }
            if (fArray3 == null || fArray3.length != this.nfshapes || fArray4 == null || fArray4.length != this.nfshapes || fArray5 == null || fArray5.length != this.nfshapes) {
                throw new VisADException("bad fcolors");
            }
            this.first_tris = new int[this.nfshapes][][];
            n4 = 0;
            while (n4 < this.nfshapes) {
                this.first_tris[n4] = DelaunayCustom.fill(fArray2[n4]);
                ++n4;
            }
            this.first_shapes = new float[this.nfshapes][2][];
            n4 = 0;
            n2 = 0;
            while (n2 < this.nfshapes) {
                int n5 = fArray2[n2][0].length;
                n4 += n5;
                this.first_shapes[n2][0] = new float[n5];
                this.first_shapes[n2][1] = new float[n5];
                System.arraycopy(fArray2[n2][0], 0, this.first_shapes[n2][0], 0, n5);
                System.arraycopy(fArray2[n2][1], 0, this.first_shapes[n2][1], 0, n5);
                ++n2;
            }
            if (this.profile_length < n4) {
                this.profile_length = n4;
            }
            this.first_red = new float[this.nfshapes];
            this.first_green = new float[this.nfshapes];
            this.first_blue = new float[this.nfshapes];
            System.arraycopy(fArray3, 0, this.first_red, 0, this.nfshapes);
            System.arraycopy(fArray4, 0, this.first_green, 0, this.nfshapes);
            System.arraycopy(fArray5, 0, this.first_blue, 0, this.nfshapes);
        }
        if (this.profile_length < 5) {
            this.profile_length = 5;
        }
        this.pcontrol = this.display.getProjectionControl();
        this.pcl = new ProjectionControlListener();
        this.pcontrol.addControlListener(this.pcl);
        this.acontrol = (AnimationControl)((Object)this.display.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = FrontDrawer.class$("visad.AnimationControl"))));
        if (this.acontrol == null) {
            throw new DisplayException("display must include ScalarMap to Animation");
        }
        Vector vector = this.display.getMapVector();
        n2 = 0;
        while (n2 < vector.size()) {
            ScalarMap scalarMap = (ScalarMap)vector.elementAt(n2);
            object = scalarMap.getControl();
            if (this.acontrol.equals(object) && !RealType.Time.equals(scalarMap.getScalar())) {
                throw new DisplayException("must be Time mapped to Animation " + scalarMap.getScalar());
            }
            ++n2;
        }
        Set set = this.acontrol.getSet();
        if (set != null) {
            this.setupAnimationSet(set);
        } else {
            this.acontrol.addControlListener(this);
        }
        this.lat_map = null;
        this.lon_map = null;
        Vector vector2 = this.display.getMapVector();
        object = vector2.elements();
        while (object.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)object.nextElement();
            DisplayRealType displayRealType = scalarMap.getDisplayScalar();
            DisplayTupleType displayTupleType = displayRealType.getTuple();
            if (displayTupleType == null || !displayTupleType.equals(Display.DisplaySpatialCartesianTuple) && (displayTupleType.getCoordinateSystem() == null || !displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (RealType.Latitude.equals(scalarMap.getScalar())) {
                this.lat_map = scalarMap;
                continue;
            }
            if (!RealType.Longitude.equals(scalarMap.getScalar())) continue;
            this.lon_map = scalarMap;
        }
        if (this.lat_map == null || this.lon_map == null) {
            throw new DisplayException("Latitude and Longitude must be mapped");
        }
        int n6 = 0;
        int n7 = 0;
        this.front_manipulation_renderer = new FrontManipulationRendererJ3D(this, n6, n7);
        this.display.addReferences((DataRenderer)this.front_manipulation_renderer, this.curve_ref);
        this.front_ref = new DataReferenceImpl("front");
        this.front_ref.setData(this.fronts);
        this.front_renderer = new DefaultRendererJ3D();
        this.front_renderer.suppressExceptions(true);
        this.display.addReferences((DataRenderer)this.front_renderer, this.front_ref);
        this.release_ref = new DataReferenceImpl("release");
        this.release_cell = new ReleaseCell();
        this.release_cell.addReference(this.release_ref);
        this.zoom_ref = new DataReferenceImpl("zoom");
        this.zoom_cell = new ZoomCell();
        this.zoom_cell.addReference(this.zoom_ref);
        this.setScale();
    }

    class ReleaseCell
    extends CellImpl {
        private boolean first = true;

        public void doAction() throws VisADException, RemoteException {
            if (this.first) {
                this.first = false;
                return;
            }
            if (FrontDrawer.this.acontrol.getOn()) {
                return;
            }
            FrontDrawer.this.current_time_step = FrontDrawer.this.acontrol.getCurrent();
            if (FrontDrawer.this.current_time_step < 0 || FrontDrawer.this.current_time_step >= FrontDrawer.this.ntimes) {
                return;
            }
            Object object = FrontDrawer.this.data_lock;
            synchronized (object) {
                Object object2;
                Data data = null;
                if (FrontDrawer.this.curve_ref != null) {
                    data = FrontDrawer.this.curve_ref.getData();
                }
                Gridded2DSet gridded2DSet = null;
                if (data == null || !(data instanceof UnionSet)) {
                    if (debug) {
                        System.out.println("data null or not UnionSet");
                    }
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    gridded2DSet = FrontDrawer.this.last_curve_set;
                } else {
                    object2 = ((UnionSet)data).getSets();
                    if (object2 == null || ((SampledSet[])object2).length == 0 || !(object2[0] instanceof Gridded2DSet)) {
                        if (debug) {
                            System.out.println("data not Gridded2DSet");
                        }
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        gridded2DSet = FrontDrawer.this.last_curve_set;
                    } else if (object2[0].getManifoldDimension() != 1) {
                        if (debug) {
                            System.out.println("ManifoldDimension != 1");
                        }
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        gridded2DSet = FrontDrawer.this.last_curve_set;
                    } else {
                        gridded2DSet = (Gridded2DSet)object2[0];
                    }
                }
                if (gridded2DSet == null) {
                    if (debug) {
                        System.out.println("curve_set is null");
                    }
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    Object var2_5 = null;
                    return;
                }
                object2 = null;
                try {
                    object2 = gridded2DSet.getSamples(false);
                    if (object2 == null || ((SampledSet)object2[0]).length < 2) {
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        throw new VisADException("bad curve_samples");
                    }
                }
                catch (VisADException visADException) {
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    gridded2DSet = FrontDrawer.this.last_curve_set;
                    try {
                        if (gridded2DSet != null) {
                            object2 = gridded2DSet.getSamples(false);
                        }
                        if ((object2 == null || ((SampledSet)object2[0]).length < 2) && FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                    }
                    catch (VisADException visADException2) {
                        if (debug) {
                            System.out.println("release " + visADException2);
                        }
                        Object var2_6 = null;
                        return;
                    }
                }
                FrontDrawer.this.last_curve_set = gridded2DSet;
                boolean bl = false;
                double[] dArray = FrontDrawer.this.lat_map.getRange();
                double[] dArray2 = FrontDrawer.this.lon_map.getRange();
                if (dArray[1] < dArray[0]) {
                    boolean bl2 = bl = !bl;
                }
                if (dArray2[1] < dArray2[0]) {
                    boolean bl3 = bl = !bl;
                }
                if ((double)object2[FrontDrawer.this.lat_index][0] < 0.0) {
                    boolean bl4 = bl = !bl;
                }
                if (FrontDrawer.this.lon_index < FrontDrawer.this.lat_index) {
                    bl = !bl;
                }
                float[][] fArray = new float[][]{FrontDrawer.this.lat_map.scaleValues((float[])object2[FrontDrawer.this.lat_index]), FrontDrawer.this.lon_map.scaleValues((float[])object2[FrontDrawer.this.lon_index])};
                FrontDrawer.this.front = FrontDrawer.this.robustCurveToFront(fArray, bl);
                ((FrontDrawer)FrontDrawer.this).curves[((FrontDrawer)FrontDrawer.this).current_time_step] = fArray;
                ((FrontDrawer)FrontDrawer.this).flips[((FrontDrawer)FrontDrawer.this).current_time_step] = bl;
                if (FrontDrawer.this.front != null) {
                    FrontDrawer.this.fronts.setSample(FrontDrawer.this.current_time_step, (Data)FrontDrawer.this.front);
                }
                FrontDrawer.this.front_ref.setData(FrontDrawer.this.fronts);
                if (FrontDrawer.this.curve_ref != null) {
                    FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                }
            }
        }
    }

    class ZoomCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            Object object = FrontDrawer.this.data_lock;
            synchronized (object) {
                int n = 0;
                while (n < FrontDrawer.this.ntimes) {
                    if (FrontDrawer.this.curves[n] != null) {
                        FrontDrawer.this.front = FrontDrawer.this.robustCurveToFront(FrontDrawer.this.curves[n], FrontDrawer.this.flips[n]);
                        if (FrontDrawer.this.front != null) {
                            FrontDrawer.this.fronts.setSample(n, (Data)FrontDrawer.this.front);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    class ProjectionControlListener
    implements ControlListener {
        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            FrontDrawer.this.setScale();
        }

        ProjectionControlListener() {
        }
    }
}

