/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.ShapeControl;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;
import visad.bom.CollectiveBarbException;
import visad.bom.EndManipFTM;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.Util;

public class FlexibleTrackManipulation {
    private static final int NTIMES = 8;
    private Object data_lock = new Object();
    private int ntimes = 0;
    private Tuple[] tuples;
    private boolean[] tuple_change;
    private int which_time = -1;
    private Set time_set = null;
    private double[] times;
    private float[] lats;
    private float[] lons;
    private float[] shapes;
    private float[] old_lats;
    private float[] old_lons;
    private DataReferenceImpl track_ref;
    private DataReferenceImpl[] track_refs;
    private DirectManipulationRendererJ3D[] direct_manipulation_renderers;
    private ConstantMap[][] constant_maps;
    private TrackMonitor[] track_monitors;
    private AnimationControl acontrol = null;
    private ShapeControl shape_control1 = null;
    private ShapeControl shape_control2 = null;
    private ProjectionControl pcontrol = null;
    private DisplayImplJ3D display;
    private FieldImpl storm_track;
    private FunctionType storm_track_type = null;
    private DataMonitor data_monitor = null;
    private int shape_index;
    private int lat_index;
    private int lon_index;
    private float[] shapeColour;
    private int last_time = -1;
    private boolean pfirst = true;
    private boolean afirst = true;
    private boolean direct_on = false;
    private static /* synthetic */ Class class$Lvisad$AnimationControl;

    private void init(DataReferenceImpl dataReferenceImpl, DisplayImplJ3D displayImplJ3D, ScalarMap scalarMap, ScalarMap scalarMap2, boolean bl, float f, VisADGeometryArray[][] visADGeometryArrayArray) throws VisADException, RemoteException {
        Serializable serializable;
        Object object;
        this.track_ref = dataReferenceImpl;
        this.storm_track = (FlatField)this.track_ref.getData();
        this.display = displayImplJ3D;
        this.pcontrol = this.display.getProjectionControl();
        ProjectionControlListener projectionControlListener = new ProjectionControlListener();
        this.pcontrol.addControlListener(projectionControlListener);
        this.acontrol = (AnimationControl)((Object)this.display.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = FlexibleTrackManipulation.class$("visad.AnimationControl"))));
        if (this.acontrol != null) {
            object = new AnimationControlListener();
            this.acontrol.addControlListener((ControlListener)object);
        }
        this.storm_track_type = (FunctionType)this.storm_track.getType();
        object = null;
        try {
            serializable = (RealType)this.storm_track_type.getDomain().getComponent(0);
            if (!RealType.Time.equals(serializable)) {
                throw new DisplayException("storm_track bad MathType: " + serializable + " must be RealType.Time");
            }
            object = (TupleType)this.storm_track_type.getRange();
            if (!((TupleType)object).getFlat()) {
                throw new DisplayException("storm_track bad MathType: " + object + " must be flat");
            }
        }
        catch (ClassCastException classCastException) {
            throw new DisplayException("storm_track bad MathType: " + this.storm_track_type);
        }
        this.shape_index = -1;
        this.lat_index = -1;
        this.lon_index = -1;
        serializable = this.display.getMapVector();
        int n = ((TupleType)object).getDimension();
        RealType[] realTypeArray = ((TupleType)object).getRealComponents();
        int n2 = 0;
        while (n2 < n) {
            RealType realType = realTypeArray[n2];
            if (RealType.Latitude.equals(realType)) {
                this.lat_index = n2;
            } else if (RealType.Longitude.equals(realType)) {
                this.lon_index = n2;
            } else {
                Enumeration enumeration = ((Vector)serializable).elements();
                while (enumeration.hasMoreElements()) {
                    DisplayRealType displayRealType;
                    ScalarMap scalarMap3 = (ScalarMap)enumeration.nextElement();
                    if (!realType.equals(scalarMap3.getScalar()) || !Display.Shape.equals(displayRealType = scalarMap3.getDisplayScalar())) continue;
                    this.shape_index = n2;
                }
            }
            ++n2;
        }
        if (this.lat_index < 0 || this.lon_index < 0 || this.shape_index < 0) {
            throw new DisplayException("storm track data must include Latitude and Longitude and a RealType mapped to Shape " + this.lat_index + " " + this.lon_index + " " + this.shape_index);
        }
        this.setupData(this.storm_track, true, true);
        this.shape_control1 = (ShapeControl)scalarMap.getControl();
        this.shape_control1.setShapeSet(new Integer1DSet(8));
        this.shape_control1.setShapes(visADGeometryArrayArray[0]);
        this.shape_control2 = (ShapeControl)scalarMap2.getControl();
        this.shape_control2.setShapeSet(new Integer1DSet(8));
        this.shape_control2.setShapes(visADGeometryArrayArray[1]);
        this.which_time = -1;
        if (bl) {
            this.data_monitor = new DataMonitor();
            this.data_monitor.addReference(this.track_ref);
        }
        if (this.acontrol != null) {
            this.acontrol.setCurrent(0);
            this.display.addReference(this.track_ref);
        }
    }

    private void setupData(FieldImpl fieldImpl, boolean bl, boolean bl2) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            Object[] objectArray;
            int n;
            boolean bl3;
            if (this.storm_track_type == null) {
                this.storm_track_type = (FunctionType)fieldImpl.getType();
            } else if (!this.storm_track_type.equals(fieldImpl.getType())) {
                throw new DisplayException("storm track MathType changed");
            }
            boolean bl4 = bl3 = bl && !bl2;
            if (this.track_refs != null && !bl3) {
                n = 0;
                while (n < this.track_refs.length) {
                    this.display.removeReference(this.track_refs[n]);
                    this.track_monitors[n].removeReference(this.track_refs[n]);
                    this.track_monitors[n].stop();
                    ++n;
                }
            }
            n = this.ntimes;
            try {
                this.ntimes = fieldImpl.getLength();
                this.tuples = new Tuple[this.ntimes];
                this.tuple_change = new boolean[this.ntimes];
                this.lats = new float[this.ntimes];
                this.lons = new float[this.ntimes];
                this.old_lats = new float[this.ntimes];
                this.old_lons = new float[this.ntimes];
                this.shapes = new float[this.ntimes];
                this.time_set = fieldImpl.getDomainSet();
                int n2 = 0;
                while (n2 < this.ntimes) {
                    this.tuples[n2] = (Tuple)fieldImpl.getSample(n2);
                    this.tuple_change[n2] = false;
                    objectArray = this.tuples[n2].getRealComponents();
                    this.lats[n2] = (float)((Real)objectArray[this.lat_index]).getValue();
                    this.lons[n2] = (float)((Real)objectArray[this.lon_index]).getValue();
                    this.old_lats[n2] = this.lats[n2];
                    this.old_lons[n2] = this.lons[n2];
                    this.shapes[n2] = (float)((Real)objectArray[this.shape_index]).getValue();
                    ++n2;
                }
            }
            catch (ClassCastException classCastException) {
                throw new DisplayException("storm track bad MathType: " + this.storm_track_type);
            }
            if (this.acontrol == null) {
                DataReferenceImpl[] dataReferenceImplArray = this.track_refs;
                objectArray = this.direct_manipulation_renderers;
                TrackMonitor[] trackMonitorArray = this.track_monitors;
                ConstantMap[][] constantMapArray = this.constant_maps;
                this.track_refs = new DataReferenceImpl[this.ntimes];
                this.direct_manipulation_renderers = new DirectManipulationRendererJ3D[this.ntimes];
                this.track_monitors = new TrackMonitor[this.ntimes];
                this.constant_maps = new ConstantMap[this.ntimes][];
                int n3 = 0;
                while (n3 < this.ntimes) {
                    if (!bl3 || n3 >= n) {
                        this.track_refs[n3] = new DataReferenceImpl("station_ref" + n3);
                        this.track_refs[n3].setData(this.tuples[n3]);
                        this.direct_manipulation_renderers[n3] = new FTMDirectManipulationRendererJ3D(this);
                        ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(this.shapeColour[0], Display.Red), new ConstantMap(this.shapeColour[1], Display.Green), new ConstantMap(this.shapeColour[2], Display.Blue)};
                        this.constant_maps[n3] = constantMapArray2;
                        this.display.addReferences((DataRenderer)this.direct_manipulation_renderers[n3], this.track_refs[n3], this.constant_maps[n3]);
                        this.track_monitors[n3] = new TrackMonitor(this.track_refs[n3], n3);
                        this.track_monitors[n3].addReference(this.track_refs[n3]);
                    } else {
                        this.track_refs[n3] = dataReferenceImplArray[n3];
                        this.direct_manipulation_renderers[n3] = objectArray[n3];
                        this.constant_maps[n3] = constantMapArray[n3];
                        this.track_monitors[n3] = trackMonitorArray[n3];
                    }
                    ++n3;
                }
            } else if (!bl3) {
                this.track_refs = new DataReferenceImpl[1];
                this.direct_manipulation_renderers = new DirectManipulationRendererJ3D[1];
                this.track_monitors = new TrackMonitor[1];
                this.constant_maps = new ConstantMap[1][];
                this.track_refs[0] = new DataReferenceImpl("station_ref");
                this.track_refs[0].setData(this.tuples[0]);
                this.direct_manipulation_renderers[0] = new FTMDirectManipulationRendererJ3D(this);
                this.constant_maps[0] = new ConstantMap[]{new ConstantMap(this.shapeColour[0], Display.Red), new ConstantMap(this.shapeColour[1], Display.Green), new ConstantMap(this.shapeColour[2], Display.Blue)};
                this.display.addReferences((DataRenderer)this.direct_manipulation_renderers[0], this.track_refs[0], this.constant_maps[0]);
                this.track_monitors[0] = new TrackMonitor(this.track_refs[0], 0);
                this.track_monitors[0].addReference(this.track_refs[0]);
            }
        }
    }

    private void setupTuples(FieldImpl fieldImpl) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = 0;
            while (n < this.ntimes) {
                this.tuples[n] = (Tuple)fieldImpl.getSample(n);
                ++n;
            }
        }
    }

    public static VisADGeometryArray[][] makeStormShapes(int n, float f) throws VisADException {
        VisADLineArray visADLineArray = new VisADLineArray();
        visADLineArray.vertexCount = 2 * n;
        float[] fArray = new float[3 * visADLineArray.vertexCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d = Math.PI * 2 * (double)n3 / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d);
            fArray[n2++] = 0.5f * f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            double d2 = Math.PI * 2 * (double)(n3 + 1) / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d2);
            fArray[n2++] = 0.5f * f * (float)Math.sin(d2);
            fArray[n2++] = 0.0f;
            ++n3;
        }
        visADLineArray.coordinates = fArray;
        VisADTriangleArray visADTriangleArray = new VisADTriangleArray();
        visADTriangleArray.vertexCount = 3 * n;
        fArray = new float[3 * visADTriangleArray.vertexCount];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            double d = Math.PI * 2 * (double)n4 / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d);
            fArray[n2++] = 0.5f * f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            double d3 = Math.PI * 2 * (double)(n4 + 1) / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d3);
            fArray[n2++] = 0.5f * f * (float)Math.sin(d3);
            fArray[n2++] = 0.0f;
            ++n4;
        }
        visADTriangleArray.coordinates = fArray;
        float[] fArray2 = new float[3 * visADTriangleArray.vertexCount];
        n2 = 0;
        int n5 = 0;
        while (n5 < 3 * n) {
            fArray2[n2++] = 0.0f;
            fArray2[n2++] = 0.0f;
            fArray2[n2++] = 1.0f;
            ++n5;
        }
        visADTriangleArray.normals = fArray2;
        VisADLineArray visADLineArray2 = new VisADLineArray();
        visADLineArray2.vertexCount = 8;
        visADLineArray2.coordinates = new float[]{-0.25f * f, 0.5f * f, 0.0f, 0.0f, 0.5f * f, 0.0f, -0.12f * f, 0.5f * f, 0.0f, -0.12f * f, -0.5f * f, 0.0f, -0.12f * f, -0.5f * f, 0.0f, 0.5f * f, -0.5f * f, 0.0f, 0.5f * f, -0.5f * f, 0.0f, 0.5f * f, -0.37f * f, 0.0f};
        VisADLineArray visADLineArray3 = new VisADLineArray();
        visADLineArray3.vertexCount = 2 * n;
        fArray = new float[3 * visADLineArray3.vertexCount];
        n2 = 0;
        int n6 = 0;
        while (n6 < n / 2) {
            double d = Math.PI * (double)n6 / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d);
            fArray[n2++] = f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            double d4 = Math.PI * (double)(n6 + 1) / (double)n;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d4);
            fArray[n2++] = f * (float)Math.sin(d4);
            fArray[n2++] = 0.0f;
            fArray[n2++] = -0.5f * f * (float)Math.cos(d);
            fArray[n2++] = -f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            fArray[n2++] = -0.5f * f * (float)Math.cos(d4);
            fArray[n2++] = -f * (float)Math.sin(d4);
            fArray[n2++] = 0.0f;
            ++n6;
        }
        visADLineArray3.coordinates = fArray;
        VisADLineArray visADLineArray4 = new VisADLineArray();
        visADLineArray4.vertexCount = 2 * n;
        fArray = new float[3 * visADLineArray4.vertexCount];
        n2 = 0;
        int n7 = 0;
        while (n7 < n / 2) {
            double d = Math.PI * (double)n7 / (double)n;
            fArray[n2++] = -0.5f * f * (float)Math.cos(d);
            fArray[n2++] = f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            double d5 = Math.PI * (double)(n7 + 1) / (double)n;
            fArray[n2++] = -0.5f * f * (float)Math.cos(d5);
            fArray[n2++] = f * (float)Math.sin(d5);
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d);
            fArray[n2++] = -f * (float)Math.sin(d);
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.5f * f * (float)Math.cos(d5);
            fArray[n2++] = -f * (float)Math.sin(d5);
            fArray[n2++] = 0.0f;
            ++n7;
        }
        visADLineArray4.coordinates = fArray;
        VisADLineArray visADLineArray5 = VisADLineArray.merge(new VisADLineArray[]{visADLineArray, visADLineArray3});
        VisADLineArray visADLineArray6 = VisADLineArray.merge(new VisADLineArray[]{visADLineArray, visADLineArray4});
        VisADGeometryArray[][] visADGeometryArrayArray = new VisADGeometryArray[][]{{null, visADLineArray2, visADLineArray, null, visADLineArray5, visADLineArray3, visADLineArray6, visADLineArray4}, {null, null, null, visADTriangleArray, null, visADTriangleArray, null, visADTriangleArray}};
        return visADGeometryArrayArray;
    }

    public void endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = 0;
            while (n < this.track_refs.length) {
                this.display.removeReference(this.track_refs[n]);
                ++n;
            }
            this.display.addReference(this.track_ref);
        }
    }

    public DataRenderer[] getManipulationRenderers() {
        return this.direct_manipulation_renderers;
    }

    public void release() {
        Object object = this.data_lock;
        synchronized (object) {
            try {
                int n = 0;
                while (n < this.ntimes) {
                    if (this.tuple_change[n]) {
                        this.tuple_change[n] = false;
                        this.storm_track.setSample(n, (Data)this.tuples[n]);
                    }
                    ++n;
                }
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.direct_on = false;
        }
    }

    public void start() {
        Object object = this.data_lock;
        synchronized (object) {
            this.direct_on = true;
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        Object object;
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealType realType3 = new RealType("shape");
        RealType realType4 = RealType.Time;
        double d = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realType4, d, d + 3000.0, 8);
        RealTupleType realTupleType = null;
        realTupleType = new RealTupleType(realType2, realType, realType3);
        FunctionType functionType = new FunctionType(realType4, realTupleType);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(realType2, Display.XAxis);
        displayImplJ3D.addMap(scalarMap);
        scalarMap.setRange(-10.0, 10.0);
        ScalarMap scalarMap2 = new ScalarMap(realType, Display.YAxis);
        displayImplJ3D.addMap(scalarMap2);
        scalarMap2.setRange(-10.0, 10.0);
        ScalarMap scalarMap3 = new ScalarMap(realType3, Display.Shape);
        displayImplJ3D.addMap(scalarMap3);
        ScalarMap scalarMap4 = new ScalarMap(realType3, Display.Shape);
        displayImplJ3D.addMap(scalarMap4);
        ScalarMap scalarMap5 = null;
        if (stringArray.length > 0) {
            scalarMap5 = new ScalarMap(realType4, Display.Animation);
            displayImplJ3D.addMap(scalarMap5);
            object = (AnimationControl)((Object)scalarMap5.getControl());
            object.setStep(500);
        }
        object = new FlatField(functionType, linear1DSet);
        double[][] dArray = new double[3][8];
        int n = 0;
        while (n < 8) {
            dArray[0][n] = 2.0 * (double)n - 8.0;
            dArray[1][n] = 2.0 * (double)n - 8.0;
            int n2 = n % 8;
            if (4 <= n2 && n2 < 6) {
                if (dArray[1][n] >= 0.0) {
                    n2 += 2;
                }
            } else if (6 <= n2 && n2 < 8 && dArray[1][n] < 0.0) {
                n2 -= 2;
            }
            dArray[2][n] = n2;
            ++n;
        }
        ((FlatField)object).setSamples(dArray);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("track_ref");
        dataReferenceImpl.setData((Data)object);
        JFrame jFrame = new JFrame("test FlexibleTrackManipulation");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        if (scalarMap5 != null) {
            jPanel.add(new AnimationWidget(scalarMap5));
        }
        FlexibleTrackManipulation flexibleTrackManipulation = new FlexibleTrackManipulation(dataReferenceImpl, displayImplJ3D, scalarMap3, scalarMap4, true, 0.05f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        EndManipFTM endManipFTM = new EndManipFTM(flexibleTrackManipulation, dataReferenceImpl);
        JButton jButton = new JButton("end manip");
        jButton.addActionListener(endManipFTM);
        jButton.setActionCommand("end");
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("add to track");
        jButton2.addActionListener(endManipFTM);
        jButton2.setActionCommand("add");
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        ((Component)jFrame).setSize(500, 700);
        ((Component)jFrame).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FlexibleTrackManipulation(DataReferenceImpl dataReferenceImpl, DisplayImplJ3D displayImplJ3D, ScalarMap scalarMap, ScalarMap scalarMap2, boolean bl) throws VisADException, RemoteException {
        float f = 0.1f;
        int n = 16;
        VisADGeometryArray[][] visADGeometryArrayArray = FlexibleTrackManipulation.makeStormShapes(n, 0.1f);
        this.shapeColour = new float[]{1.0f, 1.0f, 1.0f};
        this.init(dataReferenceImpl, displayImplJ3D, scalarMap, scalarMap2, bl, 0.1f, visADGeometryArrayArray);
    }

    public FlexibleTrackManipulation(DataReferenceImpl dataReferenceImpl, DisplayImplJ3D displayImplJ3D, ScalarMap scalarMap, ScalarMap scalarMap2, boolean bl, float f) throws VisADException, RemoteException {
        int n = 16;
        VisADGeometryArray[][] visADGeometryArrayArray = FlexibleTrackManipulation.makeStormShapes(n, f);
        this.shapeColour = new float[]{1.0f, 1.0f, 1.0f};
        this.init(dataReferenceImpl, displayImplJ3D, scalarMap, scalarMap2, bl, f, visADGeometryArrayArray);
    }

    public FlexibleTrackManipulation(DataReferenceImpl dataReferenceImpl, DisplayImplJ3D displayImplJ3D, ScalarMap scalarMap, ScalarMap scalarMap2, boolean bl, float f, VisADGeometryArray[][] visADGeometryArrayArray, float[] fArray) throws VisADException, RemoteException {
        this.shapeColour = fArray;
        this.init(dataReferenceImpl, displayImplJ3D, scalarMap, scalarMap2, bl, f, visADGeometryArrayArray);
    }

    class DataMonitor
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                FieldImpl fieldImpl = (FieldImpl)FlexibleTrackManipulation.this.track_ref.getData();
                boolean bl = false;
                boolean bl2 = false;
                if (!FlexibleTrackManipulation.this.storm_track_type.equals(fieldImpl.getType())) {
                    throw new VisADException("storm_track MathType may not change");
                }
                if (FlexibleTrackManipulation.this.ntimes != fieldImpl.getLength()) {
                    bl = true;
                }
                if (fieldImpl.getLength() >= FlexibleTrackManipulation.this.ntimes) {
                    int n = 0;
                    while (n < FlexibleTrackManipulation.this.ntimes) {
                        Real[] realArray = ((Tuple)fieldImpl.getSample(n)).getRealComponents();
                        if (!(Util.isApproximatelyEqual(FlexibleTrackManipulation.this.lats[n], (float)realArray[FlexibleTrackManipulation.this.lat_index].getValue()) && Util.isApproximatelyEqual(FlexibleTrackManipulation.this.lons[n], (float)realArray[FlexibleTrackManipulation.this.lon_index].getValue()) && Util.isApproximatelyEqual(FlexibleTrackManipulation.this.shapes[n], (float)realArray[FlexibleTrackManipulation.this.shape_index].getValue()))) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                    }
                } else {
                    bl2 = true;
                }
                FlexibleTrackManipulation.this.storm_track = fieldImpl;
                if (bl || bl2) {
                    FlexibleTrackManipulation.this.setupData(FlexibleTrackManipulation.this.storm_track, bl, bl2);
                } else {
                    FlexibleTrackManipulation.this.setupTuples(FlexibleTrackManipulation.this.storm_track);
                }
            }
        }

        DataMonitor() {
        }
    }

    class ProjectionControlListener
    implements ControlListener {
        private double base_scale = 0.65;
        private float last_cscale = 1.0f;

        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            double[] dArray = FlexibleTrackManipulation.this.pcontrol.getMatrix();
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[3];
            MouseBehaviorJ3D.unmake_matrix(dArray2, dArray3, dArray4, dArray);
            float f = (float)(this.base_scale / dArray3[0]);
            float f2 = f / this.last_cscale;
            if (f2 < 0.95f || 1.05f < f2) {
                this.last_cscale = f;
                if (FlexibleTrackManipulation.this.shape_control1 != null) {
                    FlexibleTrackManipulation.this.shape_control1.setScale(f);
                }
                if (FlexibleTrackManipulation.this.shape_control2 != null) {
                    FlexibleTrackManipulation.this.shape_control2.setScale(f);
                }
            }
        }

        ProjectionControlListener() {
        }
    }

    class AnimationControlListener
    implements ControlListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                FlexibleTrackManipulation.this.which_time = -1;
                if (FlexibleTrackManipulation.this.direct_manipulation_renderers == null) {
                    return;
                }
                if (FlexibleTrackManipulation.this.direct_manipulation_renderers[0] == null) {
                    return;
                }
                FlexibleTrackManipulation.this.direct_manipulation_renderers[0].stop_direct();
                Set set = FlexibleTrackManipulation.this.acontrol.getSet();
                if (set == null) {
                    return;
                }
                if (!FlexibleTrackManipulation.this.time_set.equals(set)) {
                    throw new CollectiveBarbException("time Set changed");
                }
                int n = FlexibleTrackManipulation.this.acontrol.getCurrent();
                if (n < 0) return;
                FlexibleTrackManipulation.this.which_time = n;
                FlexibleTrackManipulation.this.track_refs[0].setData(FlexibleTrackManipulation.this.tuples[n]);
                if (!FlexibleTrackManipulation.this.afirst) return;
                FlexibleTrackManipulation.this.afirst = false;
                if (FlexibleTrackManipulation.this.acontrol == null) return;
                FlexibleTrackManipulation.this.display.removeReference(FlexibleTrackManipulation.this.track_ref);
                return;
            }
        }

        AnimationControlListener() {
        }
    }

    class TrackMonitor
    extends CellImpl {
        private static final float EPS = 0.01f;
        DataReferenceImpl ref;
        int this_time;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                int n = this.this_time;
                if (FlexibleTrackManipulation.this.acontrol != null) {
                    n = FlexibleTrackManipulation.this.which_time;
                }
                if (n < 0) {
                    return;
                }
                Tuple tuple = (Tuple)this.ref.getData();
                Real[] realArray = tuple.getRealComponents();
                float f = (float)realArray[FlexibleTrackManipulation.this.lat_index].getValue();
                float f2 = (float)realArray[FlexibleTrackManipulation.this.lon_index].getValue();
                if (Util.isApproximatelyEqual(f, FlexibleTrackManipulation.this.lats[n], 0.01f) && Util.isApproximatelyEqual(f2, FlexibleTrackManipulation.this.lons[n], 0.01f)) {
                    return;
                }
                if (FlexibleTrackManipulation.this.afirst) {
                    FlexibleTrackManipulation.this.afirst = false;
                    FlexibleTrackManipulation.this.display.removeReference(FlexibleTrackManipulation.this.track_ref);
                }
                if (FlexibleTrackManipulation.this.last_time != n) {
                    FlexibleTrackManipulation.this.last_time = n;
                    int n2 = 0;
                    while (n2 < FlexibleTrackManipulation.this.ntimes) {
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).old_lats[n2] = FlexibleTrackManipulation.this.lats[n2];
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).old_lons[n2] = FlexibleTrackManipulation.this.lons[n2];
                        ++n2;
                    }
                }
                float f3 = f - FlexibleTrackManipulation.this.old_lats[n];
                float f4 = f2 - FlexibleTrackManipulation.this.old_lons[n];
                int n3 = FlexibleTrackManipulation.this.direct_manipulation_renderers[this.this_time].getLastMouseModifiers();
                int n4 = n3 & 2;
                int n5 = n4 != 0 ? FlexibleTrackManipulation.this.ntimes : n + 1;
                int n6 = n;
                while (true) {
                    if (n6 >= n5) {
                        return;
                    }
                    double d = FlexibleTrackManipulation.this.old_lats[n6] + f3;
                    double d2 = FlexibleTrackManipulation.this.old_lons[n6] + f4;
                    int n7 = (int)((double)FlexibleTrackManipulation.this.shapes[n6] + 0.01);
                    double d3 = n7;
                    if (4 <= n7 && n7 < 6) {
                        if (d >= 0.0) {
                            d3 = n7 + 2;
                        }
                    } else if (6 <= n7 && n7 < 8 && d < 0.0) {
                        d3 = n7 - 2;
                    }
                    Tuple tuple2 = FlexibleTrackManipulation.this.tuples[n6];
                    if (tuple2 instanceof RealTuple) {
                        realArray = tuple2.getRealComponents();
                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lat_index] = realArray[FlexibleTrackManipulation.this.lat_index].cloneButValue(d);
                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lon_index] = realArray[FlexibleTrackManipulation.this.lon_index].cloneButValue(d2);
                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shape_index] = realArray[FlexibleTrackManipulation.this.shape_index].cloneButValue(d3);
                        tuple = new RealTuple((RealTupleType)tuple2.getType(), realArray, ((RealTuple)tuple2).getCoordinateSystem());
                    } else {
                        int n8 = tuple2.getDimension();
                        int n9 = 0;
                        Data[] dataArray = new Data[n8];
                        int n10 = 0;
                        while (true) {
                            if (n10 >= n8) {
                                tuple = new Tuple((TupleType)tuple2.getType(), dataArray, false);
                                break;
                            }
                            dataArray[n10] = tuple2.getComponent(n10);
                            if (dataArray[n10] instanceof Real) {
                                if (n9 == FlexibleTrackManipulation.this.lat_index) {
                                    dataArray[n10] = ((Real)dataArray[n10]).cloneButValue(d);
                                }
                                if (n9 == FlexibleTrackManipulation.this.lon_index) {
                                    dataArray[n10] = ((Real)dataArray[n10]).cloneButValue(d2);
                                }
                                if (n9 == FlexibleTrackManipulation.this.shape_index) {
                                    dataArray[n10] = ((Real)dataArray[n10]).cloneButValue(d3);
                                }
                                ++n9;
                            } else {
                                int n11 = ((RealTuple)dataArray[n10]).getDimension();
                                if (n9 <= FlexibleTrackManipulation.this.lat_index && FlexibleTrackManipulation.this.lat_index < n9 + n11 || n9 <= FlexibleTrackManipulation.this.lon_index && FlexibleTrackManipulation.this.lon_index < n9 + n11 || n9 <= FlexibleTrackManipulation.this.shape_index && FlexibleTrackManipulation.this.shape_index < n9 + n11) {
                                    realArray = ((RealTuple)dataArray[n10]).getRealComponents();
                                    if (n9 <= FlexibleTrackManipulation.this.lat_index && FlexibleTrackManipulation.this.lat_index < n9 + n11) {
                                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lat_index - n9] = realArray[FlexibleTrackManipulation.this.lat_index - n9].cloneButValue(d);
                                    }
                                    if (n9 <= FlexibleTrackManipulation.this.lon_index && FlexibleTrackManipulation.this.lon_index < n9 + n11) {
                                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lon_index - n9] = realArray[FlexibleTrackManipulation.this.lon_index - n9].cloneButValue(d2);
                                    }
                                    if (n9 <= FlexibleTrackManipulation.this.shape_index && FlexibleTrackManipulation.this.shape_index < n9 + n11) {
                                        realArray[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shape_index - n9] = realArray[FlexibleTrackManipulation.this.shape_index - n9].cloneButValue(d3);
                                    }
                                    dataArray[n10] = new RealTuple((RealTupleType)dataArray[n10].getType(), realArray, ((RealTuple)dataArray[n10]).getCoordinateSystem());
                                }
                                n9 += n11;
                            }
                            ++n10;
                        }
                    }
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lats[n6] = (float)d;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lons[n6] = (float)d2;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shapes[n6] = (float)d3;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).tuples[n6] = tuple;
                    if (FlexibleTrackManipulation.this.direct_on) {
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).tuple_change[n6] = true;
                    } else {
                        FlexibleTrackManipulation.this.storm_track.setSample(n6, (Data)FlexibleTrackManipulation.this.tuples[n6]);
                    }
                    if (FlexibleTrackManipulation.this.acontrol == null) {
                        FlexibleTrackManipulation.this.track_refs[n6].setData(FlexibleTrackManipulation.this.tuples[n6]);
                    }
                    ++n6;
                }
            }
        }

        public TrackMonitor(DataReferenceImpl dataReferenceImpl, int n) {
            this.ref = dataReferenceImpl;
            this.this_time = n;
        }
    }

    class FTMDirectManipulationRendererJ3D
    extends DirectManipulationRendererJ3D {
        FlexibleTrackManipulation ftm;

        public void release_direct() {
            this.ftm.release();
        }

        public void drag_direct(VisADRay visADRay, boolean bl, int n) {
            if (bl) {
                this.ftm.start();
            }
            super.drag_direct(visADRay, bl, n);
        }

        FTMDirectManipulationRendererJ3D(FlexibleTrackManipulation flexibleTrackManipulation2) {
            this.ftm = flexibleTrackManipulation2;
        }
    }
}

