/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.java3d.MouseBehaviorJ3D;

public class DiscoverableZoom
implements ControlListener {
    private boolean pfirst = true;
    private double base_scale = 1.0;
    private float last_cscale = 1.0f;
    private float latmul;
    private float lonmul;
    private DataRenderer[] renderers = null;
    private boolean[] enabled = null;
    private int nrenderers = -1;
    private float[] lons = null;
    private float[] lats = null;

    public void setRenderers(DataRenderer[] dataRendererArray, float f) throws VisADException, RemoteException {
        this.renderers = dataRendererArray;
        if (this.renderers != null) {
            Object object;
            Object object2;
            Real[] realArray;
            Object object3;
            Object object4;
            this.nrenderers = this.renderers.length;
            if (this.nrenderers == 0) {
                this.nrenderers = -1;
                return;
            }
            this.lons = new float[this.nrenderers];
            this.lats = new float[this.nrenderers];
            this.enabled = new boolean[this.nrenderers];
            int n = 0;
            while (n < this.nrenderers) {
                this.lons[n] = Float.NaN;
                this.lats[n] = Float.NaN;
                this.enabled[n] = true;
                object4 = this.renderers[n].getLinks();
                if (object4 != null && ((DataDisplayLink[])object4).length != 0 && (object3 = object4[0].getData()) != null && object3 instanceof Tuple && (realArray = ((Tuple)object3).getRealComponents()) != null && realArray.length != 0) {
                    int n2 = 0;
                    while (n2 < realArray.length) {
                        if (RealType.Latitude.equals(realArray[n2].getType())) {
                            this.lats[n] = (float)realArray[n2].getValue();
                        } else if (RealType.Longitude.equals(realArray[n2].getType())) {
                            this.lons[n] = (float)realArray[n2].getValue();
                        }
                        ++n2;
                    }
                    if (this.lats[n] != this.lats[n] || this.lons[n] != this.lons[n]) {
                        this.lons[n] = Float.NaN;
                        this.lats[n] = Float.NaN;
                    }
                }
                ++n;
            }
            DisplayImpl displayImpl = this.renderers[0].getDisplay();
            if (displayImpl == null) {
                this.nrenderers = -1;
                return;
            }
            object4 = null;
            object3 = null;
            realArray = displayImpl.getMapVector();
            Enumeration enumeration = realArray.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (ScalarMap)enumeration.nextElement();
                object = ((ScalarMap)object2).getScalar();
                DisplayRealType displayRealType = ((ScalarMap)object2).getDisplayScalar();
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                if (displayTupleType == null || !displayTupleType.equals(Display.DisplaySpatialCartesianTuple) && (displayTupleType.getCoordinateSystem() == null || !displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                if (RealType.Latitude.equals(object)) {
                    object4 = object2;
                    continue;
                }
                if (!RealType.Longitude.equals(object)) continue;
                object3 = object2;
            }
            if (object4 == null || object3 == null) {
                this.nrenderers = -1;
                return;
            }
            object2 = object4.getRange();
            object = ((ScalarMap)object3).getRange();
            this.latmul = (float)(1.0 / (Math.abs((double)(object2[1] - object2[0])) * (double)f));
            this.lonmul = (float)(1.0 / (Math.abs((double)(object[1] - object[0])) * (double)f));
            if (this.latmul != this.latmul || this.lonmul != this.lonmul) {
                this.nrenderers = -1;
                return;
            }
        } else {
            this.nrenderers = -1;
            return;
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        ProjectionControl projectionControl = (ProjectionControl)controlEvent.getControl();
        double[] dArray = projectionControl.getMatrix();
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[3];
        MouseBehaviorJ3D.unmake_matrix(dArray2, dArray3, dArray4, dArray);
        if (this.pfirst) {
            this.pfirst = false;
            this.base_scale = dArray3[0];
            this.last_cscale = 1.0f;
        } else {
            if (this.nrenderers < 0) {
                return;
            }
            float f = (float)(this.base_scale / dArray3[0]);
            float f2 = f / this.last_cscale;
            if (f2 < 0.95f || 1.05f < f2) {
                this.last_cscale = f;
                int n = 0;
                while (n < this.nrenderers) {
                    boolean bl = true;
                    if (this.lats[n] == this.lats[n] && this.lons[n] == this.lons[n]) {
                        int n2 = 0;
                        while (n2 < n) {
                            float f3;
                            float f4;
                            float f5;
                            if (this.enabled[n2] && this.lats[n2] == this.lats[n2] && this.lons[n2] == this.lons[n2] && (f5 = (f4 = this.latmul * (this.lats[n2] - this.lats[n]) / f) * f4 + (f3 = this.lonmul * (this.lons[n2] - this.lons[n]) / f) * f3) < 1.0f) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    this.enabled[n] = bl;
                    this.renderers[n].toggle(bl);
                    ++n;
                }
            }
        }
    }
}

