/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.EarthVectorType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ReferenceException;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.bom.BoxDragRendererJ3D;
import visad.bom.RubberBandBoxRendererJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;
import visad.util.LabeledColorWidget;
import visad.util.Util;
import visad.util.VisADSlider;

public class CutAndPasteFields
implements ActionListener {
    private static final int NSTAS = 64;
    private static final int NTIMES = 10;
    private boolean debug = true;
    private Field grids = null;
    private DisplayImpl display = null;
    private int blend = 0;
    private Object lock = new Object();
    private RealType t = null;
    private RealType x = null;
    private RealType y = null;
    private RealTupleType xy = null;
    private MathType range = null;
    private int rangedim = 0;
    private int nts = 0;
    Set tset = null;
    Set xyset = null;
    int nx;
    int ny;
    int rx;
    int ry;
    float[][] cut = null;
    float[][] replaced = null;
    FlatField replacedff = null;
    int replacedixlow;
    int replacedixhi;
    int replacediylow;
    int replacediyhi;
    AnimationControl acontrol = null;
    ScalarMap tmap = null;
    ScalarMap xmap = null;
    ScalarMap ymap = null;
    private double xlow;
    private double xhi;
    private double ylow;
    private double yhi;
    private int ixlow;
    private int ixhi;
    private int iylow;
    private int iyhi;
    private CellImpl cell_rbb = null;
    private CellImpl cell_xlyl = null;
    private CellImpl cell_xlyh = null;
    private CellImpl cell_xhyl = null;
    private CellImpl cell_xhyh = null;
    private DataReferenceImpl ref_rbb = null;
    private DataReferenceImpl ref_xlyl = null;
    private DataReferenceImpl ref_xlyh = null;
    private DataReferenceImpl ref_xhyl = null;
    private DataReferenceImpl ref_xhyh = null;
    private DataReferenceImpl ref_rect = null;
    private RubberBandBoxRendererJ3D rbbr = null;
    private BoxDragRendererJ3D xlylr = null;
    private BoxDragRendererJ3D xlyhr = null;
    private BoxDragRendererJ3D xhylr = null;
    private BoxDragRendererJ3D xhyhr = null;
    private DefaultRendererJ3D rectr = null;
    private CutAndPasteFields thiscp = null;

    public void start() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            this.cell_rbb.addReference(this.ref_rbb);
            Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)this.xy, null, 1);
            this.ref_rbb.setData(gridded2DSet);
            this.rbbr.toggle(true);
        }
    }

    public void stop() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            this.display.disableAction();
            this.rbbr.toggle(false);
            this.xlylr.toggle(false);
            this.xlyhr.toggle(false);
            this.xhylr.toggle(false);
            this.xhyhr.toggle(false);
            this.rectr.toggle(false);
            this.ref_xlyl.setData(null);
            this.ref_xlyh.setData(null);
            this.ref_xhyl.setData(null);
            this.ref_xhyh.setData(null);
            this.ref_rect.setData(null);
            this.display.enableAction();
            try {
                this.cell_rbb.removeReference(this.ref_rbb);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
            try {
                this.cell_xlyl.removeReference(this.ref_xlyl);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
            try {
                this.cell_xlyh.removeReference(this.ref_xlyh);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
            try {
                this.cell_xhyl.removeReference(this.ref_xhyl);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
            try {
                this.cell_xhyh.removeReference(this.ref_xhyh);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
        }
    }

    public void undo() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.replacedff != null) {
                float[][] fArray = this.replacedff.getFloats(false);
                int n = this.replacedixlow;
                while (n <= this.replacedixhi) {
                    int n2 = this.replacediylow;
                    while (n2 <= this.replacediyhi) {
                        int n3 = n + this.nx * n2;
                        int n4 = n - this.replacedixlow + this.rx * (n2 - this.replacediylow);
                        int n5 = 0;
                        while (n5 < this.rangedim) {
                            fArray[n5][n3] = this.replaced[n5][n4];
                            ++n5;
                        }
                        ++n2;
                    }
                    ++n;
                }
                this.replacedff.setSamples(fArray, false);
            }
            this.replacedff = null;
        }
        this.stop();
    }

    public void setBlend(int n) {
        if (n >= 0) {
            this.blend = n;
        }
    }

    private boolean getIndices(boolean bl) throws VisADException {
        int n;
        float[][] fArray = new float[][]{{(float)this.xlow, (float)this.xhi}, {(float)this.ylow, (float)this.yhi}};
        int[] nArray = this.xyset.valueToIndex(fArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        if (bl) {
            fArray = this.xyset.indexToValue(nArray);
            this.xlow = fArray[0][0];
            this.ylow = fArray[1][0];
            this.xhi = fArray[0][1];
            this.yhi = fArray[1][1];
        }
        if (n2 > n3) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        this.iylow = n2 / this.nx;
        this.ixlow = n2 % this.nx;
        this.iyhi = n3 / this.nx;
        this.ixhi = n3 % this.nx;
        if (this.ixlow > this.ixhi) {
            n = this.ixlow;
            this.ixlow = this.ixhi;
            this.ixhi = n;
        }
        if (this.iylow > this.iyhi) {
            n = this.iylow;
            this.iylow = this.iyhi;
            this.iyhi = n;
        }
        if (bl) {
            this.rx = this.ixhi - this.ixlow + 1;
            this.ry = this.iyhi - this.iylow + 1;
        } else {
            n = this.ixhi - this.ixlow + 1;
            int n4 = this.iyhi - this.iylow + 1;
            if (this.rx != n) {
                if (this.ixlow + this.rx - 1 < this.nx) {
                    this.ixhi = this.ixlow + this.rx - 1;
                } else {
                    this.ixlow = this.ixhi - (this.rx - 1);
                }
            }
            if (this.ry != n4) {
                if (this.iylow + this.ry - 1 < this.ny) {
                    this.iyhi = this.iylow + this.ry - 1;
                } else {
                    this.iylow = this.iyhi - (this.ry - 1);
                }
            }
        }
        return true;
    }

    private void getRect() throws VisADException, RemoteException {
        FlatField flatField = null;
        if (this.t != null) {
            int n = this.getAnimationIndex();
            if (n < 0 || n >= this.nts) {
                return;
            }
            flatField = (FlatField)this.grids.getSample(n);
        } else {
            flatField = (FlatField)this.grids;
        }
        float[][] fArray = flatField.getFloats(false);
        this.cut = new float[this.rangedim][this.rx * this.ry];
        int n = this.ixlow;
        while (n <= this.ixhi) {
            int n2 = this.iylow;
            while (n2 <= this.iyhi) {
                int n3 = n + this.nx * n2;
                int n4 = n - this.ixlow + this.rx * (n2 - this.iylow);
                int n5 = 0;
                while (n5 < this.rangedim) {
                    this.cut[n5][n4] = fArray[n5][n3];
                    ++n5;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void replaceRect() throws VisADException, RemoteException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5 = 0;
        if (this.t != null && ((n5 = this.getAnimationIndex()) < 0 || n5 >= this.nts)) {
            return;
        }
        if (!this.getIndices(false)) {
            System.out.println("bad box");
            return;
        }
        if (this.replacedff != null) {
            object = this.replacedff.getFloats(false);
            int n6 = this.replacedixlow;
            while (n6 <= this.replacedixhi) {
                n4 = this.replacediylow;
                while (n4 <= this.replacediyhi) {
                    n3 = n6 + this.nx * n4;
                    n2 = n6 - this.replacedixlow + this.rx * (n4 - this.replacediylow);
                    n = 0;
                    while (n < this.rangedim) {
                        object[n][n3] = this.replaced[n][n2];
                        ++n;
                    }
                    ++n4;
                }
                ++n6;
            }
            this.replacedff.setSamples((float[][])object, false);
        }
        object = null;
        object = this.t != null ? (Object)((FlatField)this.grids.getSample(n5)) : (Object)((FlatField)this.grids);
        float[][] fArray = ((FlatField)object).getFloats(false);
        this.replaced = new float[this.rangedim][this.rx * this.ry];
        n4 = this.ixlow;
        while (n4 <= this.ixhi) {
            n3 = this.iylow;
            while (n3 <= this.iyhi) {
                n2 = n4 + this.nx * n3;
                n = n4 - this.ixlow + this.rx * (n3 - this.iylow);
                int n7 = 0;
                while (n7 < this.rangedim) {
                    this.replaced[n7][n] = fArray[n7][n2];
                    ++n7;
                }
                if (this.blend == 0) {
                    n7 = 0;
                    while (n7 < this.rangedim) {
                        fArray[n7][n2] = this.cut[n7][n];
                        ++n7;
                    }
                } else {
                    n7 = n4 - this.ixlow;
                    if (this.ixhi - n4 < n7) {
                        n7 = this.ixhi - n4;
                    }
                    if (n3 - this.iylow < n7) {
                        n7 = n3 - this.iylow;
                    }
                    if (this.iyhi - n3 < n7) {
                        n7 = this.iyhi - n3;
                    }
                    if (n7 > this.blend) {
                        int n8 = 0;
                        while (n8 < this.rangedim) {
                            fArray[n8][n2] = this.cut[n8][n];
                            ++n8;
                        }
                    } else {
                        float f = (float)n7 / (float)this.blend;
                        float f2 = 1.0f - f;
                        int n9 = 0;
                        while (n9 < this.rangedim) {
                            fArray[n9][n2] = f2 * fArray[n9][n2] + f * this.cut[n9][n];
                            ++n9;
                        }
                    }
                }
                ++n3;
            }
            ++n4;
        }
        ((FlatField)object).setSamples(fArray, false);
        this.replacedff = object;
        this.replacedixlow = this.ixlow;
        this.replacedixhi = this.ixhi;
        this.replacediylow = this.iylow;
        this.replacediyhi = this.iyhi;
    }

    private int getAnimationIndex() throws VisADException {
        int[] nArray = new int[]{this.acontrol.getCurrent()};
        Set set = this.acontrol.getSet();
        double[][] dArray = set.indexToDouble(nArray);
        int[] nArray2 = this.tset.doubleToIndex(dArray);
        return nArray2[0];
    }

    private void drag() throws VisADException, RemoteException {
        this.display.disableAction();
        this.ref_xlyl.setData(new RealTuple(this.xy, new double[]{this.xlow, this.ylow}));
        this.ref_xlyh.setData(new RealTuple(this.xy, new double[]{this.xlow, this.yhi}));
        this.ref_xhyl.setData(new RealTuple(this.xy, new double[]{this.xhi, this.ylow}));
        this.ref_xhyh.setData(new RealTuple(this.xy, new double[]{this.xhi, this.yhi}));
        float[][] fArray = new float[][]{{(float)this.xlow, (float)this.xlow, (float)this.xhi, (float)this.xhi, (float)this.xlow}, {(float)this.ylow, (float)this.yhi, (float)this.yhi, (float)this.ylow, (float)this.ylow}};
        this.ref_rect.setData(new Gridded2DSet((MathType)this.xy, fArray, 5));
        this.display.enableAction();
    }

    void drag_release() {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                try {
                    this.replaceRect();
                }
                catch (VisADException visADException) {
                    if (this.debug) {
                        System.out.println("release fail: " + visADException.toString());
                    }
                }
                catch (RemoteException remoteException) {
                    if (!this.debug) break block7;
                    System.out.println("release fail: " + remoteException.toString());
                }
            }
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        Object object;
        RealType realType = new RealType("x");
        RealType realType2 = new RealType("y");
        RealType realType3 = RealType.Latitude;
        RealType realType4 = RealType.Longitude;
        RealTupleType realTupleType = new RealTupleType(realType, realType2);
        RealType realType5 = new RealType("windx", CommonUnit.meterPerSecond, null);
        RealType realType6 = new RealType("windy", CommonUnit.meterPerSecond, null);
        RealType realType7 = new RealType("red");
        RealType realType8 = new RealType("green");
        EarthVectorType earthVectorType = new EarthVectorType(realType5, realType6);
        RealType realType9 = RealType.Time;
        double d = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realType9, d, d + 2700.0, 10);
        Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, 64, 64);
        RealTupleType realTupleType2 = new RealTupleType(new RealType[]{realType4, realType3, realType5, realType6, realType7, realType8});
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FunctionType functionType2 = new FunctionType(realType9, functionType);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(realType2, Display.YAxis);
        displayImplJ3D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(realType, Display.XAxis);
        displayImplJ3D.addMap(scalarMap2);
        ScalarMap scalarMap3 = null;
        scalarMap3 = stringArray.length > 0 ? new ScalarMap(realType6, Display.RGB) : new ScalarMap(realType6, Display.IsoContour);
        displayImplJ3D.addMap(scalarMap3);
        ScalarMap scalarMap4 = new ScalarMap(realType9, Display.Animation);
        displayImplJ3D.addMap(scalarMap4);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap4.getControl());
        animationControl.setStep(500);
        FieldImpl fieldImpl = new FieldImpl(functionType2, linear1DSet);
        double[][] dArray = new double[6][4096];
        int n = 0;
        while (n < 10) {
            object = new FlatField(functionType, integer2DSet);
            int n2 = 0;
            int n3 = 0;
            while (n3 < 64) {
                int n4 = 0;
                while (n4 < 64) {
                    double d2 = 2.0 * (double)n3 / 63.0 - 1.0;
                    double d3 = 2.0 * (double)n4 / 63.0 - 1.0;
                    dArray[0][n2] = 10.0 * d2;
                    dArray[1][n2] = 10.0 * d3 - 40.0;
                    double d4 = (double)n + 30.0 * d2;
                    double d5 = 30.0 * d3;
                    double d6 = 57.29577951308232 * Math.atan2(-d4, -d5) + (double)n * 15.0;
                    double d7 = Math.sqrt(d4 * d4 + d5 * d5);
                    dArray[2][n2] = d6;
                    dArray[3][n2] = d7;
                    dArray[4][n2] = d2;
                    dArray[5][n2] = d3;
                    ++n2;
                    ++n4;
                }
                ++n3;
            }
            ((FlatField)object).setSamples(dArray);
            fieldImpl.setSample(n, (Data)object);
            ++n;
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("seq");
        dataReferenceImpl.setData(fieldImpl);
        displayImplJ3D.addReference(dataReferenceImpl);
        object = new CutAndPasteFields(fieldImpl, displayImplJ3D);
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("blend_ref");
        VisADSlider visADSlider = new VisADSlider("blend", 0, 10, 0, 1.0, dataReferenceImpl2, RealType.Generic);
        CellImpl cellImpl = new CellImpl(dataReferenceImpl2, (CutAndPasteFields)object){
            private final /* synthetic */ DataReferenceImpl val$blend_ref;
            private final /* synthetic */ CutAndPasteFields val$cp;

            public void doAction() throws VisADException, RemoteException {
                int n = (int)((Real)this.val$blend_ref.getData()).getValue();
                this.val$cp.setBlend(n);
            }
            {
                this.val$blend_ref = dataReferenceImpl;
                this.val$cp = cutAndPasteFields;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        cellImpl.addReference(dataReferenceImpl2);
        JFrame jFrame = new JFrame("test CollectiveBarbManipulation");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.add(displayImplJ3D.getComponent());
        jPanel2.setMaximumSize(new Dimension(400, 600));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        JButton jButton = new JButton("start");
        jButton.addActionListener((ActionListener)object);
        jButton.setActionCommand("start");
        JButton jButton2 = new JButton("stop");
        jButton2.addActionListener((ActionListener)object);
        jButton2.setActionCommand("stop");
        JButton jButton3 = new JButton("undo");
        jButton3.addActionListener((ActionListener)object);
        jButton3.setActionCommand("undo");
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jPanel3.add(new AnimationWidget(scalarMap4));
        if (stringArray.length > 0) {
            LabeledColorWidget labeledColorWidget = new LabeledColorWidget(scalarMap3);
            labeledColorWidget.setMaximumSize(new Dimension(400, 200));
            jPanel3.add(labeledColorWidget);
        } else {
            ContourWidget contourWidget = new ContourWidget(scalarMap3);
            contourWidget.setMaximumSize(new Dimension(400, 200));
            jPanel3.add(contourWidget);
        }
        jPanel3.add(new JLabel(" "));
        jPanel3.add(visADSlider);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(jPanel4);
        jPanel3.setMaximumSize(new Dimension(400, 600));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(800, 600);
        ((Component)jFrame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("start")) {
            try {
                this.start();
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("stop")) {
            try {
                this.stop();
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("undo")) {
            try {
                this.undo();
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    static /* synthetic */ Object access$0(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.lock;
    }

    static /* synthetic */ DataReferenceImpl access$1(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ref_xlyl;
    }

    static /* synthetic */ double access$2(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xlow;
    }

    static /* synthetic */ double access$3(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ylow;
    }

    static /* synthetic */ double access$4(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xhi;
    }

    static /* synthetic */ void access$5(CutAndPasteFields cutAndPasteFields, double d) {
        cutAndPasteFields.xhi = d;
    }

    static /* synthetic */ double access$6(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.yhi;
    }

    static /* synthetic */ void access$7(CutAndPasteFields cutAndPasteFields, double d) {
        cutAndPasteFields.yhi = d;
    }

    static /* synthetic */ void access$8(CutAndPasteFields cutAndPasteFields, double d) {
        cutAndPasteFields.xlow = d;
    }

    static /* synthetic */ void access$9(CutAndPasteFields cutAndPasteFields, double d) {
        cutAndPasteFields.ylow = d;
    }

    static /* synthetic */ void access$10(CutAndPasteFields cutAndPasteFields) throws VisADException, RemoteException {
        cutAndPasteFields.drag();
    }

    static /* synthetic */ DataReferenceImpl access$11(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ref_xlyh;
    }

    static /* synthetic */ DataReferenceImpl access$12(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ref_xhyl;
    }

    static /* synthetic */ DataReferenceImpl access$13(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ref_xhyh;
    }

    static /* synthetic */ DataReferenceImpl access$14(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.ref_rbb;
    }

    static /* synthetic */ boolean access$15(CutAndPasteFields cutAndPasteFields, boolean bl) throws VisADException {
        return cutAndPasteFields.getIndices(bl);
    }

    static /* synthetic */ void access$16(CutAndPasteFields cutAndPasteFields) throws VisADException, RemoteException {
        cutAndPasteFields.getRect();
    }

    static /* synthetic */ CellImpl access$17(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.cell_rbb;
    }

    static /* synthetic */ CellImpl access$18(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.cell_xlyl;
    }

    static /* synthetic */ CellImpl access$19(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.cell_xlyh;
    }

    static /* synthetic */ CellImpl access$20(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.cell_xhyl;
    }

    static /* synthetic */ CellImpl access$21(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.cell_xhyh;
    }

    static /* synthetic */ DisplayImpl access$22(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.display;
    }

    static /* synthetic */ BoxDragRendererJ3D access$23(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xlylr;
    }

    static /* synthetic */ BoxDragRendererJ3D access$24(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xlyhr;
    }

    static /* synthetic */ BoxDragRendererJ3D access$25(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xhylr;
    }

    static /* synthetic */ BoxDragRendererJ3D access$26(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.xhyhr;
    }

    static /* synthetic */ DefaultRendererJ3D access$27(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.rectr;
    }

    static /* synthetic */ RubberBandBoxRendererJ3D access$28(CutAndPasteFields cutAndPasteFields) {
        return cutAndPasteFields.rbbr;
    }

    public CutAndPasteFields(Field field, DisplayImplJ3D displayImplJ3D) throws VisADException, RemoteException {
        this(field, displayImplJ3D, 0);
    }

    public CutAndPasteFields(Field field, DisplayImplJ3D displayImplJ3D, int n) throws VisADException, RemoteException {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        this.grids = field;
        this.display = displayImplJ3D;
        if (n >= 0) {
            this.blend = n;
        }
        this.thiscp = this;
        FunctionType functionType = (FunctionType)field.getType();
        RealTupleType realTupleType = functionType.getDomain();
        int n2 = realTupleType.getDimension();
        if (n2 == 1) {
            this.t = (RealType)realTupleType.getComponent(0);
            this.tset = field.getDomainSet();
            serializable3 = (FunctionType)functionType.getRange();
            this.xy = ((FunctionType)serializable3).getDomain();
            int n3 = this.xy.getDimension();
            if (n3 != 2) {
                throw new VisADException("bad grid Field domain dimension: " + n3);
            }
            this.range = ((FunctionType)serializable3).getRange();
            this.nts = this.tset.getLength();
            int n4 = 0;
            while (n4 < this.nts) {
                serializable2 = (FlatField)field.getSample(n4);
                serializable = ((FieldImpl)serializable2).getDomainSet();
                if (this.xyset == null) {
                    this.xyset = serializable;
                } else if (!this.xyset.equals(serializable)) {
                    throw new VisADException("grid sets must match in animation");
                }
                ++n4;
            }
        } else if (n2 == 2) {
            this.t = null;
            this.tset = null;
            this.xy = realTupleType;
            this.range = functionType.getRange();
            this.xyset = field.getDomainSet();
        } else {
            throw new VisADException("bad grid Field domain dimension: " + n2);
        }
        this.x = (RealType)this.xy.getComponent(0);
        this.y = (RealType)this.xy.getComponent(1);
        if (!(this.xyset instanceof LinearSet)) {
            throw new VisADException("grid set must be LinearSet");
        }
        this.nx = ((LinearSet)((Object)this.xyset)).getLinear1DComponent(0).getLength();
        this.ny = ((LinearSet)((Object)this.xyset)).getLinear1DComponent(1).getLength();
        if (this.range instanceof RealType) {
            this.rangedim = 1;
        } else if (this.range instanceof RealTupleType) {
            this.rangedim = ((RealTupleType)this.range).getDimension();
        } else {
            throw new VisADException("bad grid Field range type: " + this.range);
        }
        serializable3 = this.display.getMapVector();
        Enumeration enumeration = ((Vector)serializable3).elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
            serializable2 = scalarMap.getScalar();
            serializable = scalarMap.getDisplayScalar();
            if (((ScalarType)serializable2).equals(this.t)) {
                if (!Display.Animation.equals(serializable)) continue;
                this.tmap = scalarMap;
                this.acontrol = (AnimationControl)((Object)this.tmap.getControl());
                continue;
            }
            if (((ScalarType)serializable2).equals(this.x)) {
                if (!Display.XAxis.equals(serializable) && !Display.YAxis.equals(serializable) && !Display.ZAxis.equals(serializable)) continue;
                this.xmap = scalarMap;
                continue;
            }
            if (!((ScalarType)serializable2).equals(this.y) || !Display.XAxis.equals(serializable) && !Display.YAxis.equals(serializable) && !Display.ZAxis.equals(serializable)) continue;
            this.ymap = scalarMap;
        }
        if (this.xmap == null || this.ymap == null) {
            throw new VisADException("grid domain RealType must be mapped to XAxis, YAxis or ZAxis");
        }
        if (this.t != null && this.tmap == null) {
            throw new VisADException("grid sequence must be mapped to Animation");
        }
        this.ref_rbb = new DataReferenceImpl("rbb");
        this.ref_xlyl = new DataReferenceImpl("xlyl");
        this.ref_xlyh = new DataReferenceImpl("xlyh");
        this.ref_xhyl = new DataReferenceImpl("xhyl");
        this.ref_xhyh = new DataReferenceImpl("xhyh");
        this.ref_rect = new DataReferenceImpl("rect");
        this.rbbr = new RubberBandBoxRendererJ3D(this.x, this.y);
        this.display.addReferences((DataRenderer)this.rbbr, this.ref_rbb);
        this.rbbr.suppressExceptions(true);
        this.rbbr.toggle(false);
        this.xlylr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xlylr, this.ref_xlyl);
        this.xlylr.suppressExceptions(true);
        this.xlylr.toggle(false);
        this.xlyhr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xlyhr, this.ref_xlyh);
        this.xlyhr.suppressExceptions(true);
        this.xlyhr.toggle(false);
        this.xhylr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xhylr, this.ref_xhyl);
        this.xhylr.suppressExceptions(true);
        this.xhylr.toggle(false);
        this.xhyhr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xhyhr, this.ref_xhyh);
        this.xhyhr.suppressExceptions(true);
        this.xhyhr.toggle(false);
        this.rectr = new DefaultRendererJ3D();
        this.display.addReferences((DataRenderer)this.rectr, this.ref_rect);
        this.rectr.suppressExceptions(true);
        this.rectr.toggle(false);
        this.cell_xlyl = new CellImpl(this){
            private final /* synthetic */ CutAndPasteFields this$0;

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.access$0(this.this$0);
                synchronized (object) {
                    RealTuple realTuple = (RealTuple)CutAndPasteFields.access$1(this.this$0).getData();
                    if (realTuple == null) {
                        Object var2_3 = null;
                        return;
                    }
                    double d = ((Real)realTuple.getComponent(0)).getValue();
                    double d2 = ((Real)realTuple.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(d, CutAndPasteFields.access$2(this.this$0)) || !Util.isApproximatelyEqual(d2, CutAndPasteFields.access$3(this.this$0))) {
                        CutAndPasteFields cutAndPasteFields = this.this$0;
                        CutAndPasteFields.access$5(cutAndPasteFields, CutAndPasteFields.access$4(cutAndPasteFields) + (d - CutAndPasteFields.access$2(this.this$0)));
                        CutAndPasteFields cutAndPasteFields2 = this.this$0;
                        CutAndPasteFields.access$7(cutAndPasteFields2, CutAndPasteFields.access$6(cutAndPasteFields2) + (d2 - CutAndPasteFields.access$3(this.this$0)));
                        CutAndPasteFields.access$8(this.this$0, d);
                        CutAndPasteFields.access$9(this.this$0, d2);
                        CutAndPasteFields.access$10(this.this$0);
                    }
                }
            }
            {
                this.this$0 = cutAndPasteFields;
                this.constructor$0(cutAndPasteFields);
            }

            private final void constructor$0(CutAndPasteFields cutAndPasteFields) {
            }
        };
        this.cell_xlyh = new CellImpl(this){
            private final /* synthetic */ CutAndPasteFields this$0;

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.access$0(this.this$0);
                synchronized (object) {
                    RealTuple realTuple = (RealTuple)CutAndPasteFields.access$11(this.this$0).getData();
                    if (realTuple == null) {
                        Object var2_3 = null;
                        return;
                    }
                    double d = ((Real)realTuple.getComponent(0)).getValue();
                    double d2 = ((Real)realTuple.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(d, CutAndPasteFields.access$2(this.this$0)) || !Util.isApproximatelyEqual(d2, CutAndPasteFields.access$6(this.this$0))) {
                        CutAndPasteFields cutAndPasteFields = this.this$0;
                        CutAndPasteFields.access$5(cutAndPasteFields, CutAndPasteFields.access$4(cutAndPasteFields) + (d - CutAndPasteFields.access$2(this.this$0)));
                        CutAndPasteFields cutAndPasteFields2 = this.this$0;
                        CutAndPasteFields.access$9(cutAndPasteFields2, CutAndPasteFields.access$3(cutAndPasteFields2) + (d2 - CutAndPasteFields.access$6(this.this$0)));
                        CutAndPasteFields.access$8(this.this$0, d);
                        CutAndPasteFields.access$7(this.this$0, d2);
                        CutAndPasteFields.access$10(this.this$0);
                    }
                }
            }
            {
                this.this$0 = cutAndPasteFields;
                this.constructor$0(cutAndPasteFields);
            }

            private final void constructor$0(CutAndPasteFields cutAndPasteFields) {
            }
        };
        this.cell_xhyl = new CellImpl(this){
            private final /* synthetic */ CutAndPasteFields this$0;

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.access$0(this.this$0);
                synchronized (object) {
                    RealTuple realTuple = (RealTuple)CutAndPasteFields.access$12(this.this$0).getData();
                    if (realTuple == null) {
                        Object var2_3 = null;
                        return;
                    }
                    double d = ((Real)realTuple.getComponent(0)).getValue();
                    double d2 = ((Real)realTuple.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(d, CutAndPasteFields.access$4(this.this$0)) || !Util.isApproximatelyEqual(d2, CutAndPasteFields.access$3(this.this$0))) {
                        CutAndPasteFields cutAndPasteFields = this.this$0;
                        CutAndPasteFields.access$8(cutAndPasteFields, CutAndPasteFields.access$2(cutAndPasteFields) + (d - CutAndPasteFields.access$4(this.this$0)));
                        CutAndPasteFields cutAndPasteFields2 = this.this$0;
                        CutAndPasteFields.access$7(cutAndPasteFields2, CutAndPasteFields.access$6(cutAndPasteFields2) + (d2 - CutAndPasteFields.access$3(this.this$0)));
                        CutAndPasteFields.access$5(this.this$0, d);
                        CutAndPasteFields.access$9(this.this$0, d2);
                        CutAndPasteFields.access$10(this.this$0);
                    }
                }
            }
            {
                this.this$0 = cutAndPasteFields;
                this.constructor$0(cutAndPasteFields);
            }

            private final void constructor$0(CutAndPasteFields cutAndPasteFields) {
            }
        };
        this.cell_xhyh = new CellImpl(this){
            private final /* synthetic */ CutAndPasteFields this$0;

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.access$0(this.this$0);
                synchronized (object) {
                    RealTuple realTuple = (RealTuple)CutAndPasteFields.access$13(this.this$0).getData();
                    if (realTuple == null) {
                        Object var2_3 = null;
                        return;
                    }
                    double d = ((Real)realTuple.getComponent(0)).getValue();
                    double d2 = ((Real)realTuple.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(d, CutAndPasteFields.access$4(this.this$0)) || !Util.isApproximatelyEqual(d2, CutAndPasteFields.access$6(this.this$0))) {
                        CutAndPasteFields cutAndPasteFields = this.this$0;
                        CutAndPasteFields.access$8(cutAndPasteFields, CutAndPasteFields.access$2(cutAndPasteFields) + (d - CutAndPasteFields.access$4(this.this$0)));
                        CutAndPasteFields cutAndPasteFields2 = this.this$0;
                        CutAndPasteFields.access$9(cutAndPasteFields2, CutAndPasteFields.access$3(cutAndPasteFields2) + (d2 - CutAndPasteFields.access$6(this.this$0)));
                        CutAndPasteFields.access$5(this.this$0, d);
                        CutAndPasteFields.access$7(this.this$0, d2);
                        CutAndPasteFields.access$10(this.this$0);
                    }
                }
            }
            {
                this.this$0 = cutAndPasteFields;
                this.constructor$0(cutAndPasteFields);
            }

            private final void constructor$0(CutAndPasteFields cutAndPasteFields) {
            }
        };
        this.cell_rbb = new CellImpl(this){
            private final /* synthetic */ CutAndPasteFields this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.access$0(this.this$0);
                synchronized (object) {
                    double d;
                    Set set = (Set)CutAndPasteFields.access$14(this.this$0).getData();
                    if (set == null) {
                        return;
                    }
                    float[][] fArray = set.getSamples();
                    if (fArray == null) {
                        return;
                    }
                    CutAndPasteFields.access$8(this.this$0, fArray[0][0]);
                    CutAndPasteFields.access$9(this.this$0, fArray[1][0]);
                    CutAndPasteFields.access$5(this.this$0, fArray[0][1]);
                    CutAndPasteFields.access$7(this.this$0, fArray[1][1]);
                    if (CutAndPasteFields.access$2(this.this$0) > CutAndPasteFields.access$4(this.this$0)) {
                        d = CutAndPasteFields.access$2(this.this$0);
                        CutAndPasteFields.access$8(this.this$0, CutAndPasteFields.access$4(this.this$0));
                        CutAndPasteFields.access$5(this.this$0, d);
                    }
                    if (CutAndPasteFields.access$3(this.this$0) > CutAndPasteFields.access$6(this.this$0)) {
                        d = CutAndPasteFields.access$3(this.this$0);
                        CutAndPasteFields.access$9(this.this$0, CutAndPasteFields.access$6(this.this$0));
                        CutAndPasteFields.access$7(this.this$0, d);
                    }
                    if (CutAndPasteFields.access$15(this.this$0, true)) {
                        CutAndPasteFields.access$16(this.this$0);
                        this.this$0.replacedff = null;
                        CutAndPasteFields.access$17(this.this$0).removeReference(CutAndPasteFields.access$14(this.this$0));
                        CutAndPasteFields.access$10(this.this$0);
                        CutAndPasteFields.access$18(this.this$0).addReference(CutAndPasteFields.access$1(this.this$0));
                        CutAndPasteFields.access$19(this.this$0).addReference(CutAndPasteFields.access$11(this.this$0));
                        CutAndPasteFields.access$20(this.this$0).addReference(CutAndPasteFields.access$12(this.this$0));
                        CutAndPasteFields.access$21(this.this$0).addReference(CutAndPasteFields.access$13(this.this$0));
                        CutAndPasteFields.access$22(this.this$0).disableAction();
                        CutAndPasteFields.access$23(this.this$0).toggle(true);
                        CutAndPasteFields.access$24(this.this$0).toggle(true);
                        CutAndPasteFields.access$25(this.this$0).toggle(true);
                        CutAndPasteFields.access$26(this.this$0).toggle(true);
                        CutAndPasteFields.access$27(this.this$0).toggle(true);
                        CutAndPasteFields.access$28(this.this$0).toggle(false);
                        CutAndPasteFields.access$22(this.this$0).enableAction();
                        return;
                    }
                    System.out.println("bad box");
                    return;
                }
            }
            {
                this.this$0 = cutAndPasteFields;
                this.constructor$0(cutAndPasteFields);
            }

            private final void constructor$0(CutAndPasteFields cutAndPasteFields) {
            }
        };
    }
}

