/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.AnimationControl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayRealType;
import visad.EarthVectorType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.BarbManipulationRendererJ3D;
import visad.bom.BarbRenderer;
import visad.bom.BarbRendererJ3D;
import visad.bom.CBMKeyboardBehaviorJ3D;
import visad.bom.CollectiveBarbException;
import visad.bom.CurveManipulationRendererJ3D;
import visad.bom.DiscoverableZoom;
import visad.bom.EndManipCBM;
import visad.bom.PointManipulationRendererJ3D;
import visad.bom.SwellManipulationRendererJ3D;
import visad.bom.SwellRendererJ3D;
import visad.bom.WindPolarCoordinateSystem;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.Util;
import visad.util.VisADSlider;

public class CollectiveBarbManipulation {
    private static final int NCIRCLE = 24;
    private static final float DEGREE_EPS = 0.1f;
    private static final float MPS_EPS = 0.01f;
    private static final double five_knots = 5.0;
    private static final int NSTAS = 5;
    private static final int NTIMES = 10;
    private FunctionType wind_field_type = null;
    private TupleType wind_type = null;
    private RealType station_index = null;
    private FunctionType wind_station_type = null;
    private RealType time = null;
    private int nindex = 0;
    private int[] ntimes;
    private Tuple[][] tuples;
    private Tuple[][] tuples2;
    private FlatField[] wind_stations;
    private Set[] time_sets;
    private double[][] times;
    private int which_time = -1;
    private int[] which_times;
    private Set time_set = null;
    private int global_ntimes = 0;
    private double[] global_times;
    private int[][] global_to_station;
    private int[][] station_to_global;
    private float[] lats;
    private float[] lons;
    private DataReferenceImpl stations_ref;
    private DataReferenceImpl[] station_refs;
    private DataRenderer barb_renderer;
    private DataRenderer[] barb_manipulation_renderers;
    private BarbMonitor[] barb_monitors;
    private WindMonitor wind_monitor = null;
    private AnimationControl acontrol = null;
    private ProjectionControl pcontrol = null;
    private DisplayImplJ3D display1;
    private DisplayImplJ3D display2;
    private FieldImpl wind_field;
    private boolean absolute;
    private float inner_distance;
    private float outer_distance;
    private double inner_time;
    private double outer_time;
    private DataReference curve_ref = null;
    private boolean barbs;
    private boolean force_station;
    private boolean knots;
    private ConstantMap[] cmaps;
    private int azimuth_index;
    private int radial_index;
    private int azimuth_index2;
    private int radial_index2;
    private int lat_index;
    private int lon_index;
    private int last_sta = -1;
    private int last_time = -1;
    private int last_display = -1;
    private boolean last_curve = true;
    private float[][] azimuths;
    private float[][] radials;
    private float[][] old_azimuths;
    private float[][] old_radials;
    private int station = -1;
    private DataReferenceImpl[] time_refs = null;
    private DataRenderer[] barb_manipulation_renderers2 = null;
    private BarbMonitor2[] barb_monitors2 = null;
    private Object data_lock = new Object();
    private boolean ended = false;
    private int time_dir = 0;
    private DataRenderer[] circle_renderer = null;
    private DataReferenceImpl[] circle_ref = null;
    private boolean circle_enable = false;
    private Releaser releaser = null;
    private DataReferenceImpl releaser_ref = null;
    private Stepper stepper = null;
    private DataReferenceImpl stepper_ref = null;
    private boolean dzoom = false;
    private DiscoverableZoom pcl = null;
    private boolean afirst = true;
    private boolean afirst_real = true;
    private RealTupleType circle_type = null;
    private int current_index = 0;
    private static /* synthetic */ Class class$Lvisad$AnimationControl;

    private void setupData() throws VisADException, RemoteException {
        Data[] dataArray;
        int n;
        Object object;
        int n2;
        try {
            this.nindex = this.wind_field.getLength();
            this.ntimes = new int[this.nindex];
            this.tuples = new Tuple[this.nindex][];
            this.tuples2 = new Tuple[this.nindex][];
            this.which_times = new int[this.nindex];
            this.wind_stations = new FlatField[this.nindex];
            this.time_sets = new Set[this.nindex];
            this.times = new double[this.nindex][];
            this.azimuths = new float[this.nindex][];
            this.radials = new float[this.nindex][];
            this.old_azimuths = new float[this.nindex][];
            this.old_radials = new float[this.nindex][];
            n2 = 0;
            while (n2 < this.nindex) {
                this.wind_stations[n2] = (FlatField)this.wind_field.getSample(n2);
                this.ntimes[n2] = this.wind_stations[n2].getLength();
                this.time_sets[n2] = this.wind_stations[n2].getDomainSet();
                double[][] dArray = Set.floatToDouble(this.time_sets[n2].getSamples());
                this.times[n2] = dArray[0];
                this.time_set = n2 == 0 ? this.time_sets[n2] : this.time_set.merge1DSets(this.time_sets[n2]);
                this.tuples[n2] = new Tuple[this.ntimes[n2]];
                this.tuples2[n2] = new Tuple[this.ntimes[n2]];
                this.azimuths[n2] = new float[this.ntimes[n2]];
                this.radials[n2] = new float[this.ntimes[n2]];
                this.old_azimuths[n2] = new float[this.ntimes[n2]];
                this.old_radials[n2] = new float[this.ntimes[n2]];
                object = this.wind_stations[n2].domainEnumeration();
                int n3 = 0;
                while (n3 < this.ntimes[n2]) {
                    this.tuples[n2][n3] = (Tuple)this.wind_stations[n2].getSample(n3);
                    n = this.tuples[n2][n3].getDimension();
                    dataArray = new Data[n + 1];
                    int n4 = 0;
                    while (n4 < n) {
                        dataArray[n4] = this.tuples[n2][n3].getComponent(n4);
                        ++n4;
                    }
                    dataArray[n] = ((RealTuple)object.nextElement()).getComponent(0);
                    this.tuples2[n2][n3] = new Tuple(dataArray);
                    ++n3;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_field_type);
        }
        this.global_ntimes = this.time_set.getLength();
        this.global_times = new double[this.global_ntimes];
        this.global_to_station = new int[this.nindex][this.global_ntimes];
        this.station_to_global = new int[this.nindex][];
        n2 = 0;
        while (n2 < this.nindex) {
            this.station_to_global[n2] = new int[this.ntimes[n2]];
            int n5 = 0;
            while (n5 < this.ntimes[n2]) {
                this.station_to_global[n2][n5] = -1;
                ++n5;
            }
            ++n2;
        }
        RealTupleType realTupleType = ((SetType)this.time_set.getType()).getDomain();
        int n6 = 0;
        while (n6 < this.global_ntimes) {
            object = new int[]{n6};
            double[][] dArray = this.time_set.indexToDouble((int[])object);
            this.global_times[n6] = dArray[0][0];
            n = 0;
            while (n < this.nindex) {
                dataArray = ((SetType)this.time_sets[n].getType()).getDomain();
                double[][] dArray2 = CoordinateSystem.transformCoordinates((RealTupleType)dataArray, this.time_sets[n].getCoordinateSystem(), this.time_sets[n].getSetUnits(), null, realTupleType, this.time_set.getCoordinateSystem(), this.time_set.getSetUnits(), null, dArray);
                object = this.time_sets[n].getLength() == 1 ? new int[]{0} : this.time_sets[n].doubleToIndex(dArray2);
                this.global_to_station[n][n6] = object[0];
                this.station_to_global[n][object[0]] = n6;
                ++n;
            }
            ++n6;
        }
        this.lats = new float[this.nindex];
        this.lons = new float[this.nindex];
        n6 = 0;
        while (n6 < this.nindex) {
            object = this.wind_stations[n6].getFloats(false);
            this.lats[n6] = object[this.lat_index][0];
            this.lons[n6] = object[this.lon_index][0];
            ++n6;
        }
        n6 = 0;
        while (n6 < this.nindex) {
            int n7 = 0;
            while (n7 < this.ntimes[n6]) {
                Real[] realArray = this.tuples[n6][n7].getRealComponents();
                this.azimuths[n6][n7] = (float)realArray[this.azimuth_index].getValue();
                this.radials[n6][n7] = (float)realArray[this.radial_index].getValue();
                this.old_azimuths[n6][n7] = this.azimuths[n6][n7];
                this.old_radials[n6][n7] = this.radials[n6][n7];
                ++n7;
            }
            ++n6;
        }
    }

    private void setupStations() throws VisADException, RemoteException {
        int n;
        if (this.station_refs != null) {
            n = 0;
            while (n < this.station_refs.length) {
                this.display1.removeReference(this.station_refs[n]);
                this.barb_monitors[n].removeReference(this.station_refs[n]);
                this.barb_monitors[n].stop();
                ++n;
            }
        }
        this.which_time = -1;
        this.station_refs = new DataReferenceImpl[this.nindex];
        this.barb_manipulation_renderers = new DataRenderer[this.nindex];
        this.barb_monitors = new BarbMonitor[this.nindex];
        n = 0;
        while (n < this.nindex) {
            this.station_refs[n] = new DataReferenceImpl("station_ref" + n);
            this.station_refs[n].setData(this.tuples[n][0]);
            this.which_times[n] = -1;
            this.barb_manipulation_renderers[n] = this.barbs ? new CBarbManipulationRendererJ3D(this, n) : new CSwellManipulationRendererJ3D(this, n);
            ((BarbRenderer)((Object)this.barb_manipulation_renderers[n])).setKnotsConvert(this.knots);
            this.display1.addReferences(this.barb_manipulation_renderers[n], this.station_refs[n], this.constantMaps());
            this.barb_monitors[n] = new BarbMonitor(this.station_refs[n], n);
            this.barb_monitors[n].addReference(this.station_refs[n]);
            ++n;
        }
        if (this.pcl != null) {
            this.pcl.setRenderers(this.barb_manipulation_renderers, 0.2f);
        }
    }

    public void addStation(float f, float f2) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            FlatField flatField = new FlatField(this.wind_station_type, this.time_set);
            int n = this.time_set.getLength();
            int n2 = this.wind_type.getNumberOfRealComponents();
            float[][] fArray = new float[n2][n];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    fArray[n4][n3] = 0.0f;
                    ++n4;
                }
                fArray[this.lat_index][n3] = f;
                fArray[this.lon_index][n3] = f2;
                ++n3;
            }
            flatField.setSamples(fArray, false);
            this.addStation(flatField);
        }
    }

    public void addStation(FlatField flatField) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            FunctionType functionType = (FunctionType)flatField.getType();
            if (!this.wind_station_type.equals(functionType)) {
                throw new CollectiveBarbException("station type doesn't match");
            }
            int n = this.wind_field.getLength();
            int n2 = n + 1;
            Integer1DSet integer1DSet = new Integer1DSet(n2);
            FieldImpl fieldImpl = new FieldImpl(this.wind_field_type, integer1DSet);
            int n3 = 0;
            while (n3 < n) {
                fieldImpl.setSample(n3, this.wind_field.getSample(n3), false);
                ++n3;
            }
            fieldImpl.setSample(n, (Data)flatField, false);
            this.wind_field = fieldImpl;
            this.stations_ref.setData(this.wind_field);
            try {
                this.setupData();
                this.setupStations();
            }
            catch (VisADException visADException) {
                throw visADException;
            }
            catch (RemoteException remoteException) {
                throw remoteException;
            }
        }
        this.stepper.doAction();
    }

    public void setCollectiveParameters(boolean bl, float f, float f2, float f3, float f4) throws VisADException, RemoteException {
        this.absolute = bl;
        if ((double)f3 < 0.0 || f4 < f3) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        if ((double)f < 0.0 || f2 < f) {
            throw new CollectiveBarbException("outer_distance must be greater than distance_time");
        }
        this.inner_distance = f;
        this.outer_distance = f2;
        this.curve_ref = null;
        this.inner_time = f3;
        this.outer_time = f4;
    }

    public void setCollectiveTimeParameters(boolean bl, float f, float f2) throws VisADException, RemoteException {
        this.absolute = bl;
        if ((double)f < 0.0 || f2 < f) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        this.inner_time = f;
        this.outer_time = f2;
    }

    public void setTimeDir(int n) {
        this.time_dir = n;
    }

    public void setCollectiveCurve(boolean bl, DataReference dataReference, float f, float f2) throws VisADException, RemoteException {
        this.absolute = bl;
        if ((double)f < 0.0 || f2 < f) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        this.curve_ref = dataReference;
        this.inner_time = f;
        this.outer_time = f2;
    }

    public void setStation(int n) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n2;
            int n3;
            if (this.display2 == null) {
                throw new CollectiveBarbException("display2 cannot be null");
            }
            if (n < 0 || n >= this.nindex) {
                throw new CollectiveBarbException("bad station index " + n);
            }
            if (n == this.station) {
                Object var3_3 = null;
                return;
            }
            this.station = n;
            if (this.time_refs != null && this.time_refs.length != this.ntimes[this.station]) {
                n3 = this.time_refs.length;
                n2 = 0;
                while (n2 < n3) {
                    this.display2.removeReference(this.time_refs[n2]);
                    this.barb_monitors2[n2].removeReference(this.time_refs[n2]);
                    this.barb_monitors2[n2].stop();
                    ++n2;
                }
                this.time_refs = null;
            }
            if (this.time_refs == null) {
                n3 = this.ntimes[this.station];
                this.time_refs = new DataReferenceImpl[n3];
                this.barb_manipulation_renderers2 = new DataRenderer[n3];
                this.barb_monitors2 = new BarbMonitor2[n3];
                n2 = 0;
                while (n2 < n3) {
                    this.time_refs[n2] = new DataReferenceImpl("time_ref" + n2);
                    this.time_refs[n2].setData(this.tuples2[this.station][n2]);
                    this.barb_manipulation_renderers2[n2] = this.ended ? (this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D()) : (this.barbs ? new BarbManipulationRendererJ3D() : new SwellManipulationRendererJ3D());
                    ((BarbRenderer)((Object)this.barb_manipulation_renderers2[n2])).setKnotsConvert(this.knots);
                    this.display2.addReferences(this.barb_manipulation_renderers2[n2], this.time_refs[n2], this.constantMaps());
                    this.barb_monitors2[n2] = new BarbMonitor2(this.time_refs[n2], n2);
                    this.barb_monitors2[n2].addReference(this.time_refs[n2]);
                    ++n2;
                }
            } else {
                n3 = this.ntimes[this.station];
                n2 = 0;
                while (n2 < n3) {
                    this.time_refs[n2].setData(this.tuples2[this.station][n2]);
                    ++n2;
                }
            }
        }
    }

    public DataRenderer[] getManipulationRenderers() {
        return this.barb_manipulation_renderers;
    }

    public DataRenderer[] getManipulationRenderers2() {
        return this.barb_manipulation_renderers2;
    }

    private ConstantMap[] constantMaps() {
        if (this.cmaps == null || this.cmaps.length == 0) {
            return null;
        }
        int n = this.cmaps.length;
        ConstantMap[] constantMapArray = new ConstantMap[n];
        int n2 = 0;
        while (n2 < n) {
            constantMapArray[n2] = (ConstantMap)this.cmaps[n2].clone();
            ++n2;
        }
        return constantMapArray;
    }

    public FieldImpl endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n;
            this.ended = true;
            if (this.display1 != null) {
                n = 0;
                while (n < this.nindex) {
                    this.display1.removeReference(this.station_refs[n]);
                    this.barb_monitors[n].removeReference(this.station_refs[n]);
                    this.barb_monitors[n].stop();
                    ++n;
                }
                this.barb_renderer = this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D();
                ((BarbRenderer)((Object)this.barb_renderer)).setKnotsConvert(this.knots);
                this.display1.addReferences(this.barb_renderer, this.stations_ref, this.constantMaps());
            }
            if (this.display2 != null && this.time_refs != null) {
                n = this.time_refs.length;
                int n2 = 0;
                while (n2 < n) {
                    this.display2.removeReference(this.time_refs[n2]);
                    this.barb_monitors2[n2].removeReference(this.time_refs[n2]);
                    this.barb_monitors2[n2].stop();
                    ++n2;
                }
                this.time_refs = null;
                this.setStation(this.station);
            }
            FieldImpl fieldImpl = this.wind_field;
            Object var2_5 = null;
            return fieldImpl;
        }
    }

    private Tuple modifyWind(Tuple tuple, double d, double d2) throws VisADException, RemoteException {
        Tuple tuple2 = null;
        Real[] realArray = null;
        if (tuple instanceof RealTuple) {
            realArray = tuple.getRealComponents();
            realArray[this.azimuth_index] = realArray[this.azimuth_index].cloneButValue(d);
            realArray[this.radial_index] = realArray[this.radial_index].cloneButValue(d2);
            tuple2 = new RealTuple((RealTupleType)tuple.getType(), realArray, ((RealTuple)tuple).getCoordinateSystem());
        } else {
            int n = tuple.getDimension();
            int n2 = 0;
            Data[] dataArray = new Data[n];
            int n3 = 0;
            while (n3 < n) {
                dataArray[n3] = tuple.getComponent(n3);
                if (dataArray[n3] instanceof Real) {
                    if (n2 == this.azimuth_index) {
                        dataArray[n3] = ((Real)dataArray[n3]).cloneButValue(d);
                    }
                    if (n2 == this.radial_index) {
                        dataArray[n3] = ((Real)dataArray[n3]).cloneButValue(d2);
                    }
                    ++n2;
                } else {
                    int n4 = ((RealTuple)dataArray[n3]).getDimension();
                    if (n2 <= this.azimuth_index && this.azimuth_index < n2 + n4 || n2 <= this.radial_index && this.radial_index < n2 + n4) {
                        realArray = ((RealTuple)dataArray[n3]).getRealComponents();
                        if (n2 <= this.azimuth_index && this.azimuth_index < n2 + n4) {
                            realArray[this.azimuth_index - n2] = realArray[this.azimuth_index - n2].cloneButValue(d);
                        }
                        if (n2 <= this.radial_index && this.radial_index < n2 + n4) {
                            realArray[this.radial_index - n2] = realArray[this.radial_index - n2].cloneButValue(d2);
                        }
                        dataArray[n3] = new RealTuple((RealTupleType)dataArray[n3].getType(), realArray, ((RealTuple)dataArray[n3]).getCoordinateSystem());
                    }
                    n2 += n4;
                }
                ++n3;
            }
            tuple2 = new Tuple((TupleType)tuple.getType(), dataArray, false);
        }
        return tuple2;
    }

    private void collectiveAdjust(int n, int n2, DataReferenceImpl dataReferenceImpl, int n3) throws VisADException, RemoteException {
        int n4;
        int n5;
        boolean bl;
        Tuple tuple = (Tuple)dataReferenceImpl.getData();
        Real[] realArray = tuple.getRealComponents();
        float f = (float)realArray[this.azimuth_index].getValue();
        float f2 = (float)realArray[this.radial_index].getValue();
        if (Util.isApproximatelyEqual(f, this.azimuths[n][n2], 0.1f) && Util.isApproximatelyEqual(f2, this.radials[n][n2], 0.01f)) {
            return;
        }
        if (n3 == 1 && this.curve_ref == null) {
            this.makeCircles(n);
        }
        boolean bl2 = bl = this.curve_ref != null;
        if (this.last_sta != n || this.last_time != n2 || this.last_display != n3 || this.last_curve != bl) {
            if (this.force_station && n != this.station) {
                this.setStation(n);
            }
            this.last_sta = n;
            this.last_time = n2;
            this.last_display = n3;
            this.last_curve = bl;
            n5 = 0;
            while (n5 < this.nindex) {
                n4 = 0;
                while (n4 < this.ntimes[n5]) {
                    this.old_azimuths[n5][n4] = this.azimuths[n5][n4];
                    this.old_radials[n5][n4] = this.radials[n5][n4];
                    ++n4;
                }
                ++n5;
            }
        }
        if (this.wind_monitor != null) {
            this.wind_monitor.disableAction();
        }
        n5 = 1;
        n4 = 1;
        float f3 = f - this.old_azimuths[n][n2];
        float f4 = f2 - this.old_radials[n][n2];
        float f5 = this.lats[n];
        float f6 = this.lons[n];
        double d = this.times[n][n2];
        int n6 = 0;
        while (n6 < this.nindex) {
            block32: {
                double d2;
                double d3;
                double d4;
                double d5;
                block30: {
                    block31: {
                        d5 = 0.0;
                        if (this.curve_ref == null) break block31;
                        try {
                            Object object;
                            SampledSet[] sampledSetArray;
                            Data data = this.curve_ref.getData();
                            Gridded2DSet gridded2DSet = null;
                            if (data instanceof Gridded2DSet) {
                                gridded2DSet = (Gridded2DSet)data;
                            } else if (data instanceof UnionSet && (sampledSetArray = ((UnionSet)(object = (UnionSet)this.curve_ref.getData())).getSets()).length > 0 && sampledSetArray[sampledSetArray.length - 1] instanceof Gridded2DSet) {
                                gridded2DSet = (Gridded2DSet)sampledSetArray[sampledSetArray.length - 1];
                            }
                            if (gridded2DSet != null && DelaunayCustom.inside((float[][])(object = (Object)gridded2DSet.getSamples()), f5, f6) && DelaunayCustom.inside((float[][])object, this.lats[n6], this.lons[n6])) {
                                d5 = 1.0;
                            }
                            break block30;
                        }
                        catch (VisADException visADException) {
                            d5 = 0.0;
                        }
                        break block30;
                    }
                    double d6 = Math.abs(f5 - this.lats[n6]);
                    double d7 = 0.5 * (double)(f5 + this.lats[n6]);
                    d4 = Math.cos(Math.PI / 180 * d7);
                    d3 = (double)Math.abs(f6 - this.lons[n6]) * d4;
                    d2 = 111137.0 * Math.sqrt(d3 * d3 + d6 * d6);
                    if (d2 > (double)this.outer_distance) break block32;
                    d5 = d2 <= (double)this.inner_distance ? 1.0 : ((double)this.outer_distance - d2) / (double)(this.outer_distance - this.inner_distance);
                }
                int n7 = 0;
                while (n7 < this.ntimes[n6]) {
                    int n8 = this.station_to_global[n6][n7];
                    double d8 = Math.abs(d - this.times[n6][n7]);
                    if (!(d8 > this.outer_time)) {
                        double d9 = d4 = d8 <= this.inner_time ? 1.0 : (this.outer_time - d8) / (this.outer_time - this.inner_time);
                        if (!(this.time_dir > 0 && this.times[n6][n7] < d || this.time_dir < 0 && d < this.times[n6][n7])) {
                            d3 = d5 * d4;
                            if (n6 == n && n7 == n2) {
                                d3 = 1.0;
                            }
                            d2 = 0.0;
                            double d10 = 0.0;
                            if (this.absolute) {
                                d2 = f - this.old_azimuths[n6][n7];
                                d10 = f2 - this.old_radials[n6][n7];
                            } else {
                                d2 = f - this.old_azimuths[n][n2];
                                d10 = f2 - this.old_radials[n][n2];
                            }
                            if (d2 < -180.0) {
                                d2 += 360.0;
                            }
                            if (d2 > 180.0) {
                                d2 -= 360.0;
                            }
                            double d11 = (double)this.old_azimuths[n6][n7] + d3 * d2;
                            double d12 = (double)this.old_radials[n6][n7] + d3 * d10;
                            if (d12 < 0.0) {
                                d12 = 0.0;
                            }
                            Tuple tuple2 = this.modifyWind(this.tuples[n6][n7], d11, d12);
                            Tuple tuple3 = this.modifyWind(this.tuples2[n6][n7], d11, d12);
                            this.azimuths[n6][n7] = (float)d11;
                            this.radials[n6][n7] = (float)d12;
                            this.wind_stations[n6].setSample(n7, (Data)tuple2);
                            this.tuples[n6][n7] = tuple2;
                            if (this.station_refs != null && n7 == this.which_times[n6]) {
                                this.station_refs[n6].setData(this.tuples[n6][n7]);
                            }
                            this.tuples2[n6][n7] = tuple3;
                            if (this.time_refs != null && n6 == this.station) {
                                this.time_refs[n7].setData(this.tuples2[n6][n7]);
                            }
                        }
                    }
                    ++n7;
                }
            }
            ++n6;
        }
        if (this.wind_monitor != null) {
            this.wind_monitor.enableAction();
        }
    }

    private void makeCircles(int n) {
        if (this.circle_ref[0] == null && this.circle_ref[1] == null || !this.circle_enable) {
            return;
        }
        try {
            if (this.circle_type == null) {
                this.circle_type = new RealTupleType(RealType.Latitude, RealType.Longitude);
            }
            float f = this.lats[n];
            float f2 = this.lons[n];
            float[] fArray = new float[]{this.inner_distance / 111137.0f, this.outer_distance / 111137.0f};
            float[][] fArray2 = new float[2][25];
            float f3 = (float)Math.cos(Math.PI / 180 * (double)f);
            int n2 = 0;
            while (n2 < 2) {
                if (this.circle_ref[n2] != null) {
                    int n3 = 0;
                    while (n3 <= 24) {
                        double d = Math.PI * 2 * (double)n3 / 24.0;
                        float f4 = (float)Math.cos(d);
                        float f5 = (float)Math.sin(d);
                        fArray2[0][n3] = f + fArray[n2] * f4;
                        fArray2[1][n3] = f2 + fArray[n2] * f5 / f3;
                        ++n3;
                    }
                    Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)this.circle_type, fArray2, 25);
                    this.circle_renderer[n2].toggle(true);
                    this.circle_ref[n2].setData(gridded2DSet);
                }
                ++n2;
            }
        }
        catch (VisADException visADException) {
            System.out.println("makeCircles " + visADException);
        }
        catch (RemoteException remoteException) {
            System.out.println("makeCircles " + remoteException);
        }
    }

    void circleEnable() {
        this.circle_enable = true;
    }

    public void release() {
        this.circle_enable = false;
        try {
            this.releaser_ref.setData(null);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void plusAngle() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = this.which_times[this.current_index];
            Tuple tuple = this.tuples[this.current_index][n];
            double d = this.azimuths[this.current_index][n];
            double d2 = this.radials[this.current_index][n];
            d += 10.0;
            if (d > 360.0) {
                d -= 360.0;
            }
            Tuple tuple2 = this.modifyWind(tuple, d, d2);
            this.wind_stations[this.current_index].setSample(n, (Data)tuple2);
            this.tuples[this.current_index][n] = tuple2;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][n]);
            }
        }
    }

    void minusAngle() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = this.which_times[this.current_index];
            Tuple tuple = this.tuples[this.current_index][n];
            double d = this.azimuths[this.current_index][n];
            double d2 = this.radials[this.current_index][n];
            d -= 10.0;
            if (d < 0.0) {
                d += 360.0;
            }
            Tuple tuple2 = this.modifyWind(tuple, d, d2);
            this.wind_stations[this.current_index].setSample(n, (Data)tuple2);
            this.tuples[this.current_index][n] = tuple2;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][n]);
            }
        }
    }

    void plusSpeed() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = this.which_times[this.current_index];
            Tuple tuple = this.tuples[this.current_index][n];
            double d = this.azimuths[this.current_index][n];
            double d2 = this.radials[this.current_index][n];
            Tuple tuple2 = this.modifyWind(tuple, d, d2 += 5.0);
            this.wind_stations[this.current_index].setSample(n, (Data)tuple2);
            this.tuples[this.current_index][n] = tuple2;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][n]);
            }
        }
    }

    void minusSpeed() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int n = this.which_times[this.current_index];
            Tuple tuple = this.tuples[this.current_index][n];
            double d = this.azimuths[this.current_index][n];
            double d2 = this.radials[this.current_index][n];
            d2 -= 5.0;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            Tuple tuple2 = this.modifyWind(tuple, d, d2);
            this.wind_stations[this.current_index].setSample(n, (Data)tuple2);
            this.tuples[this.current_index][n] = tuple2;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][n]);
            }
        }
    }

    void nextWind() {
        int n = this.nindex;
        this.current_index = this.current_index < 0 ? 0 : (this.current_index + 1) % n;
    }

    void previousWind() {
        int n = this.nindex;
        this.current_index = this.current_index < 0 ? n - 1 : (this.current_index + (n - 1)) % n;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        CollectiveBarbManipulation[] collectiveBarbManipulationArray;
        Object object;
        Object object2;
        Object object3;
        ConstantMap[] constantMapArray;
        Object object4;
        ConstantMap[] constantMapArray2;
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealTupleType realTupleType = new RealTupleType(realType, realType2);
        RealType realType3 = new RealType("windx", CommonUnit.meterPerSecond, null);
        RealType realType4 = new RealType("windy", CommonUnit.meterPerSecond, null);
        RealType realType5 = new RealType("red");
        RealType realType6 = new RealType("green");
        EarthVectorType earthVectorType = new EarthVectorType(realType3, realType4);
        RealType realType7 = new RealType("wind_dir", CommonUnit.degree, null);
        RealType realType8 = new RealType("wind_speed", CommonUnit.meterPerSecond, null);
        RealTupleType realTupleType2 = null;
        realTupleType2 = new RealTupleType(new RealType[]{realType7, realType8}, (CoordinateSystem)new WindPolarCoordinateSystem(earthVectorType), null);
        RealType realType9 = new RealType("station");
        Integer1DSet integer1DSet = new Integer1DSet((MathType)realType9, 25);
        RealType realType10 = RealType.Time;
        double d = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realType10, d, d + 2700.0, 10);
        Linear1DSet linear1DSet2 = new Linear1DSet((MathType)realType10, d + 150.0, d + 2850.0, 10);
        TupleType tupleType = null;
        tupleType = new TupleType(new MathType[]{realType2, realType, realTupleType2, realType5, realType6});
        FunctionType functionType = new FunctionType(realType10, tupleType);
        FunctionType functionType2 = new FunctionType(realType9, functionType);
        int n = 128;
        RealType realType11 = new RealType("value");
        FunctionType functionType3 = new FunctionType(realTupleType, realType11);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType, -50.0, -30.0, n, -10.0, 10.0, n);
        FlatField flatField = new FlatField(functionType3, linear2DSet);
        float[][] fArray = new float[1][n * n];
        int n2 = 0;
        while (n2 < n * n) {
            fArray[0][n2] = 947 * n2 % 677;
            ++n2;
        }
        fArray[0][0] = 5101.0f;
        flatField.setSamples(fArray);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(realType2, Display.XAxis);
        displayImplJ3D.addMap(scalarMap);
        scalarMap.setRange(-10.0, 10.0);
        ScalarMap scalarMap2 = new ScalarMap(realType, Display.YAxis);
        displayImplJ3D.addMap(scalarMap2);
        scalarMap2.setRange(-50.0, -30.0);
        ScalarMap scalarMap3 = new ScalarMap(realType8, Display.Flow1Radial);
        displayImplJ3D.addMap(scalarMap3);
        scalarMap3.setRange(0.0, 1.0);
        ScalarMap scalarMap4 = new ScalarMap(realType7, Display.Flow1Azimuth);
        displayImplJ3D.addMap(scalarMap4);
        scalarMap4.setRange(0.0, 360.0);
        FlowControl flowControl = (FlowControl)scalarMap4.getControl();
        flowControl.setFlowScale(0.15f);
        ScalarMap scalarMap5 = new ScalarMap(realType10, Display.Animation);
        displayImplJ3D.addMap(scalarMap5);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap5.getControl());
        animationControl.setStep(1000);
        displayImplJ3D.addMap(new ScalarMap(realType11, Display.RGB));
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("image");
        dataReferenceImpl.setData(flatField);
        DisplayImplJ3D displayImplJ3D2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap6 = new ScalarMap(realType8, Display.Flow1Radial);
        displayImplJ3D2.addMap(scalarMap6);
        scalarMap6.setRange(0.0, 1.0);
        ScalarMap scalarMap7 = new ScalarMap(realType7, Display.Flow1Azimuth);
        displayImplJ3D2.addMap(scalarMap7);
        scalarMap7.setRange(0.0, 360.0);
        FlowControl flowControl2 = (FlowControl)scalarMap7.getControl();
        flowControl2.setFlowScale(0.15f);
        ScalarMap scalarMap8 = new ScalarMap(realType10, Display.XAxis);
        displayImplJ3D2.addMap(scalarMap8);
        scalarMap8.setRange(d, d + 3000.0);
        FieldImpl fieldImpl = new FieldImpl(functionType2, integer1DSet);
        FieldImpl fieldImpl2 = new FieldImpl(functionType2, integer1DSet);
        FieldImpl fieldImpl3 = new FieldImpl(functionType2, integer1DSet);
        int n3 = 0;
        int n4 = 0;
        while (n4 < 5) {
            int n5 = 0;
            while (n5 < 5) {
                constantMapArray2 = new FlatField(functionType, linear1DSet);
                object4 = new FlatField(functionType, linear1DSet2);
                constantMapArray = new FlatField(functionType, linear1DSet2);
                object3 = new double[6][10];
                object2 = new double[6][10];
                object = new double[6][10];
                int n6 = 0;
                while (n6 < 10) {
                    double d2 = 2.0 * (double)n4 / 4.0 - 1.0;
                    double d3 = 2.0 * (double)n5 / 4.0 - 1.0;
                    object3[0][n6] = 10.0 * d2;
                    object3[1][n6] = 10.0 * d3 - 40.0;
                    double d4 = 30.0 * d2;
                    double d5 = 30.0 * d3;
                    double d6 = 57.29577951308232 * Math.atan2(-d4, -d5) + (double)n6 * 15.0;
                    double d7 = Math.sqrt(d4 * d4 + d5 * d5);
                    object3[2][n6] = d6;
                    object3[3][n6] = d7;
                    object3[4][n6] = d2;
                    object3[5][n6] = d3;
                    object2[0][n6] = 10.0 * d2 + 2.5;
                    object2[1][n6] = 10.0 * d3 - 40.0 + 2.5;
                    object2[2][n6] = d6;
                    object2[3][n6] = d7;
                    object2[4][n6] = d2;
                    object2[5][n6] = d3;
                    object[0][n6] = 10.0 * d2 + 2.5;
                    object[1][n6] = 10.0 * d3 - 40.0 - 2.5;
                    object[2][n6] = d6;
                    object[3][n6] = d7;
                    object[4][n6] = d2;
                    object[5][n6] = d3;
                    ++n6;
                }
                constantMapArray2.setSamples((double[][])object3);
                fieldImpl.setSample(n3, (Data)constantMapArray2);
                ((FlatField)object4).setSamples((double[][])object2);
                fieldImpl2.setSample(n3, (Data)object4);
                constantMapArray.setSamples((double[][])object);
                fieldImpl3.setSample(n3, (Data)constantMapArray);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("barb");
        dataReferenceImpl2.setData(fieldImpl3);
        BarbRendererJ3D barbRendererJ3D = new BarbRendererJ3D();
        displayImplJ3D.addReferences((DataRenderer)barbRendererJ3D, dataReferenceImpl2);
        constantMapArray2 = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        object4 = new CollectiveBarbManipulation(fieldImpl, displayImplJ3D, displayImplJ3D2, constantMapArray2, false, 500000.0f, 1000000.0f, 0.0f, 1000.0f, 0, false, true, true, false, true, new double[]{0.0, 0.5, 0.5}, 1, new double[]{0.5, 0.5, 0.0}, 2);
        constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        object3 = stringArray.length > 0 ? new CollectiveBarbManipulation(fieldImpl2, displayImplJ3D, displayImplJ3D2, constantMapArray, false, 500000.0f, 1000000.0f, 0.0f, 1000.0f, 0, false, false, true, false, true, new double[]{0.0, 0.5, 0.5}, 1, new double[]{0.5, 0.5, 0.0}, 2) : null;
        if (object3 == null) {
            CollectiveBarbManipulation[] collectiveBarbManipulationArray2 = new CollectiveBarbManipulation[1];
            collectiveBarbManipulationArray = collectiveBarbManipulationArray2;
            collectiveBarbManipulationArray2[0] = object4;
        } else {
            CollectiveBarbManipulation[] collectiveBarbManipulationArray3 = new CollectiveBarbManipulation[2];
            collectiveBarbManipulationArray3[0] = object4;
            collectiveBarbManipulationArray = collectiveBarbManipulationArray3;
            collectiveBarbManipulationArray3[1] = object3;
        }
        object2 = collectiveBarbManipulationArray;
        object = (DisplayRendererJ3D)displayImplJ3D.getDisplayRenderer();
        CBMKeyboardBehaviorJ3D cBMKeyboardBehaviorJ3D = new CBMKeyboardBehaviorJ3D((DisplayRendererJ3D)object);
        ((DisplayRendererJ3D)object).addKeyboardBehavior(cBMKeyboardBehaviorJ3D);
        cBMKeyboardBehaviorJ3D.setWhichCBM((CollectiveBarbManipulation)object4);
        Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)realTupleType, new float[][]{{0.0f}, {0.0f}}, 1);
        SampledSet[] sampledSetArray = new Gridded2DSet[]{gridded2DSet};
        UnionSet unionSet = new UnionSet((MathType)realTupleType, sampledSetArray);
        DataReferenceImpl dataReferenceImpl3 = new DataReferenceImpl("set_ref");
        dataReferenceImpl3.setData(unionSet);
        int n7 = 3;
        CurveManipulationRendererJ3D curveManipulationRendererJ3D = new CurveManipulationRendererJ3D(n7, n7, true);
        displayImplJ3D.addReferences((DataRenderer)curveManipulationRendererJ3D, dataReferenceImpl3);
        RealTuple realTuple = new RealTuple(realTupleType, new double[]{Double.NaN, Double.NaN});
        DataReferenceImpl dataReferenceImpl4 = new DataReferenceImpl("point_ref");
        dataReferenceImpl4.setData(realTuple);
        PointManipulationRendererJ3D pointManipulationRendererJ3D = new PointManipulationRendererJ3D(realType, realType2, n7, n7);
        displayImplJ3D.addReferences((DataRenderer)pointManipulationRendererJ3D, dataReferenceImpl4);
        pointManipulationRendererJ3D.toggle(false);
        JFrame jFrame = new JFrame("test CollectiveBarbManipulation");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = (JPanel)displayImplJ3D.getComponent();
        JPanel jPanel4 = (JPanel)displayImplJ3D2.getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        jPanel3.setBorder(compoundBorder);
        jPanel4.setBorder(compoundBorder);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.setMaximumSize(new Dimension(400, 800));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(new AnimationWidget(scalarMap5));
        DataReferenceImpl dataReferenceImpl5 = new DataReferenceImpl("station_select_ref");
        VisADSlider visADSlider = new VisADSlider("station", 0, 24, 0, 1.0, dataReferenceImpl5, RealType.Generic);
        jPanel5.add(visADSlider);
        CellImpl cellImpl = new CellImpl(dataReferenceImpl5, (CollectiveBarbManipulation)object4, (CollectiveBarbManipulation)object3){
            private final /* synthetic */ DataReferenceImpl val$station_select_ref;
            private final /* synthetic */ CollectiveBarbManipulation val$cbm;
            private final /* synthetic */ CollectiveBarbManipulation val$cbm2;

            public void doAction() throws VisADException, RemoteException {
                int n = (int)((Real)this.val$station_select_ref.getData()).getValue();
                if (n >= 0 && n < 25) {
                    this.val$cbm.setStation(n);
                }
                if (n >= 0 && n < 25 && this.val$cbm2 != null) {
                    this.val$cbm2.setStation(n);
                }
            }
            {
                this.val$station_select_ref = dataReferenceImpl;
                this.val$cbm = collectiveBarbManipulation;
                this.val$cbm2 = collectiveBarbManipulation2;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        cellImpl.addReference(dataReferenceImpl5);
        CellImpl cellImpl2 = new CellImpl(dataReferenceImpl3, (CollectiveBarbManipulation)object4, (CollectiveBarbManipulation)object3){
            private final /* synthetic */ DataReferenceImpl val$set_ref;
            private final /* synthetic */ CollectiveBarbManipulation val$cbm;
            private final /* synthetic */ CollectiveBarbManipulation val$cbm2;

            public void doAction() throws VisADException, RemoteException {
                float[][] fArray;
                UnionSet unionSet = (UnionSet)this.val$set_ref.getData();
                SampledSet[] sampledSetArray = unionSet.getSets();
                if (sampledSetArray.length > 0 && (fArray = sampledSetArray[sampledSetArray.length - 1].getSamples()) != null && fArray[0].length > 2) {
                    this.val$cbm.setCollectiveCurve(false, this.val$set_ref, 0.0f, 1000.0f);
                    if (this.val$cbm2 != null) {
                        this.val$cbm2.setCollectiveCurve(false, this.val$set_ref, 0.0f, 1000.0f);
                    }
                }
            }
            {
                this.val$set_ref = dataReferenceImpl;
                this.val$cbm = collectiveBarbManipulation;
                this.val$cbm2 = collectiveBarbManipulation2;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        cellImpl2.addReference(dataReferenceImpl3);
        JButton jButton = new JButton("add");
        CellImpl cellImpl3 = new CellImpl(dataReferenceImpl4, (CollectiveBarbManipulation)object4, curveManipulationRendererJ3D, pointManipulationRendererJ3D, jButton){
            private final /* synthetic */ DataReferenceImpl val$point_ref;
            private final /* synthetic */ CollectiveBarbManipulation val$cbm;
            private final /* synthetic */ CurveManipulationRendererJ3D val$cmr;
            private final /* synthetic */ PointManipulationRendererJ3D val$pmr;
            private final /* synthetic */ JButton val$add;

            public void doAction() throws VisADException, RemoteException {
                RealTuple realTuple = (RealTuple)this.val$point_ref.getData();
                float f = (float)((Real)realTuple.getComponent(0)).getValue();
                float f2 = (float)((Real)realTuple.getComponent(1)).getValue();
                if (f == f && f2 == f2) {
                    this.val$cbm.addStation(f, f2);
                    this.val$cmr.toggle(true);
                    this.val$pmr.toggle(false);
                    this.val$add.setText("add");
                }
            }
            {
                this.val$point_ref = dataReferenceImpl;
                this.val$cbm = collectiveBarbManipulation;
                this.val$cmr = curveManipulationRendererJ3D;
                this.val$pmr = pointManipulationRendererJ3D;
                this.val$add = jButton;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        cellImpl3.addReference(dataReferenceImpl4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setAlignmentY(0.0f);
        jPanel6.setAlignmentX(0.0f);
        EndManipCBM endManipCBM = new EndManipCBM((CollectiveBarbManipulation)object4, (CollectiveBarbManipulation)object3, dataReferenceImpl3, jButton, curveManipulationRendererJ3D, pointManipulationRendererJ3D);
        JButton jButton2 = new JButton("end manip");
        jButton2.addActionListener(endManipCBM);
        jButton2.setActionCommand("end");
        jPanel6.add(jButton2);
        JButton jButton3 = new JButton("delete curve");
        jButton3.addActionListener(endManipCBM);
        jButton3.setActionCommand("del");
        jPanel6.add(jButton3);
        jButton.addActionListener(endManipCBM);
        jButton.setActionCommand("add");
        jPanel6.add(jButton);
        JButton jButton4 = new JButton("time dir");
        jButton4.addActionListener(endManipCBM);
        jButton4.setActionCommand("dir");
        jPanel6.add(jButton4);
        jPanel5.add(jPanel6);
        jPanel5.setMaximumSize(new Dimension(400, 800));
        jPanel.add(jPanel2);
        jPanel.add(jPanel5);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(800, 800);
        ((Component)jFrame).setVisible(true);
    }

    static /* synthetic */ int access$0() {
        return NSTAS;
    }

    static /* synthetic */ int access$6(CollectiveBarbManipulation collectiveBarbManipulation) {
        return collectiveBarbManipulation.which_time;
    }

    static /* synthetic */ float access$23() {
        return DEGREE_EPS;
    }

    static /* synthetic */ float access$25() {
        return MPS_EPS;
    }

    static /* synthetic */ int access$32(CollectiveBarbManipulation collectiveBarbManipulation) {
        return collectiveBarbManipulation.current_index;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public CollectiveBarbManipulation(FieldImpl fieldImpl, DisplayImplJ3D displayImplJ3D, DisplayImplJ3D displayImplJ3D2, ConstantMap[] constantMapArray, boolean bl, float f, float f2, float f3, float f4, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, double[] dArray, int n2, double[] dArray2, int n3) throws VisADException, RemoteException {
        DisplayRealType displayRealType;
        ScalarMap scalarMap;
        Object object;
        Comparable comparable;
        int n4;
        Vector vector;
        this.wind_field = fieldImpl;
        this.display1 = displayImplJ3D;
        this.display2 = displayImplJ3D2;
        this.cmaps = constantMapArray;
        this.absolute = bl;
        this.inner_distance = f;
        this.outer_distance = f2;
        this.inner_time = f3;
        this.outer_time = f4;
        this.curve_ref = null;
        this.barbs = bl3;
        this.force_station = bl4;
        this.knots = bl5;
        this.dzoom = bl6;
        if (this.display1 == null && this.display2 == null) {
            throw new CollectiveBarbException("display1 and display2 cannot both be null");
        }
        this.wind_field_type = (FunctionType)this.wind_field.getType();
        this.wind_type = null;
        this.station_index = null;
        try {
            this.station_index = (RealType)this.wind_field_type.getDomain().getComponent(0);
            if (RealType.Time.equals(this.station_index)) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.station_index + " cannot be RealType.Time");
            }
            this.wind_station_type = (FunctionType)this.wind_field_type.getRange();
            this.time = (RealType)this.wind_station_type.getDomain().getComponent(0);
            if (!RealType.Time.equals(this.time)) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.time + " must be RealType.Time");
            }
            this.wind_type = (TupleType)this.wind_station_type.getRange();
            if (!this.wind_type.getFlat()) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_type + " must be flat");
            }
        }
        catch (ClassCastException classCastException) {
            throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_field_type);
        }
        this.lat_index = -1;
        this.lon_index = -1;
        RealType[] realTypeArray = this.wind_type.getRealComponents();
        int n5 = realTypeArray.length;
        int n6 = 0;
        while (n6 < n5) {
            RealType realType = realTypeArray[n6];
            if (RealType.Latitude.equals(realType)) {
                this.lat_index = n6;
            } else if (RealType.Longitude.equals(realType)) {
                this.lon_index = n6;
            }
            ++n6;
        }
        if (this.lat_index < 0 || this.lon_index < 0) {
            throw new CollectiveBarbException("wind data must include Latitude and Longitude " + this.lat_index + " " + this.lon_index);
        }
        this.azimuth_index = -1;
        this.radial_index = -1;
        n6 = -1;
        int n7 = -2;
        if (this.display1 != null) {
            vector = this.display1.getMapVector();
            n4 = 0;
            while (n4 < n5) {
                comparable = realTypeArray[n4];
                object = vector.elements();
                while (object.hasMoreElements()) {
                    scalarMap = (ScalarMap)object.nextElement();
                    if (!((RealType)comparable).equals(scalarMap.getScalar())) continue;
                    displayRealType = scalarMap.getDisplayScalar();
                    if (Display.Flow1Azimuth.equals(displayRealType)) {
                        this.azimuth_index = n4;
                        n6 = 1;
                        continue;
                    }
                    if (Display.Flow2Azimuth.equals(displayRealType)) {
                        this.azimuth_index = n4;
                        n6 = 2;
                        continue;
                    }
                    if (Display.Flow1Radial.equals(displayRealType)) {
                        this.radial_index = n4;
                        n7 = 1;
                        continue;
                    }
                    if (!Display.Flow2Radial.equals(displayRealType)) continue;
                    this.radial_index = n4;
                    n7 = 2;
                }
                ++n4;
            }
            if (this.azimuth_index < 0 || this.radial_index < 0 || n6 != n7) {
                throw new CollectiveBarbException("wind data must include two RealTypes mapped to Flow1Azimuth and Flow1Radial, or to Flow2Azimuth and Flow2Radial, in display1 " + this.azimuth_index + " " + this.radial_index);
            }
        }
        this.azimuth_index2 = -1;
        this.radial_index2 = -1;
        n6 = -1;
        n7 = -2;
        if (this.display2 != null) {
            vector = this.display2.getMapVector();
            n4 = 0;
            while (n4 < n5) {
                comparable = realTypeArray[n4];
                object = vector.elements();
                while (object.hasMoreElements()) {
                    scalarMap = (ScalarMap)object.nextElement();
                    if (!((RealType)comparable).equals(scalarMap.getScalar())) continue;
                    displayRealType = scalarMap.getDisplayScalar();
                    if (Display.Flow1Azimuth.equals(displayRealType)) {
                        this.azimuth_index2 = n4;
                        n6 = 1;
                        continue;
                    }
                    if (Display.Flow2Azimuth.equals(displayRealType)) {
                        this.azimuth_index2 = n4;
                        n6 = 2;
                        continue;
                    }
                    if (Display.Flow1Radial.equals(displayRealType)) {
                        this.radial_index2 = n4;
                        n7 = 1;
                        continue;
                    }
                    if (!Display.Flow2Radial.equals(displayRealType)) continue;
                    this.radial_index2 = n4;
                    n7 = 2;
                }
                ++n4;
            }
            if (this.azimuth_index2 < 0 || this.radial_index2 < 0 || n6 != n7) {
                throw new CollectiveBarbException("wind data must include two RealTypes mapped to Flow1Azimuth and Flow1Radial, or to Flow2Azimuth and Flow2Radial, in display2 " + this.azimuth_index2 + " " + this.radial_index2);
            }
            if (this.display1 != null) {
                if (this.azimuth_index2 != this.azimuth_index) {
                    throw new CollectiveBarbException("same RealTypes must be mapped to Flow1Azimuth in display1 and display2 " + realTypeArray[this.azimuth_index] + " " + realTypeArray[this.azimuth_index2]);
                }
                if (this.radial_index2 != this.radial_index) {
                    throw new CollectiveBarbException("same RealTypes must be mapped to Flow1Radial in display1 and display2 " + realTypeArray[this.radial_index] + " " + realTypeArray[this.radial_index2]);
                }
            } else {
                this.azimuth_index = this.azimuth_index2;
                this.radial_index = this.radial_index2;
            }
        }
        if (this.inner_time < 0.0 || this.outer_time < this.inner_time) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        if ((double)this.inner_distance < 0.0 || this.outer_distance < this.inner_distance) {
            throw new CollectiveBarbException("outer_distance must be greater than distance_time");
        }
        this.setupData();
        if (this.display1 != null) {
            this.pcontrol = this.display1.getProjectionControl();
            if (this.dzoom) {
                this.pcl = new DiscoverableZoom();
                this.pcontrol.addControlListener(this.pcl);
            }
            this.setupStations();
        }
        this.stepper_ref = new DataReferenceImpl("stepper");
        this.stepper = new Stepper();
        this.stepper.addReference(this.stepper_ref);
        if (this.display1 != null) {
            this.acontrol = (AnimationControl)((Object)this.display1.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = CollectiveBarbManipulation.class$("visad.AnimationControl"))));
            if (this.acontrol == null) {
                throw new CollectiveBarbException("display must include ScalarMap to Animation");
            }
            vector = this.display1.getMapVector();
            n4 = 0;
            while (n4 < vector.size()) {
                comparable = (ScalarMap)vector.elementAt(n4);
                object = ((ScalarMap)comparable).getControl();
                if (this.acontrol.equals(object) && !RealType.Time.equals(((ScalarMap)comparable).getScalar())) {
                    throw new CollectiveBarbException("must be Time mapped to Animation " + ((ScalarMap)comparable).getScalar());
                }
                ++n4;
            }
            AnimationControlListener animationControlListener = new AnimationControlListener();
            this.acontrol.addControlListener(animationControlListener);
            this.stations_ref = new DataReferenceImpl("stations_ref");
            this.stations_ref.setData(this.wind_field);
            this.barb_renderer = this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D();
            ((BarbRenderer)((Object)this.barb_renderer)).setKnotsConvert(this.knots);
            this.display1.addReferences(this.barb_renderer, this.stations_ref, this.constantMaps());
            if (bl2) {
                this.wind_monitor = new WindMonitor();
                this.wind_monitor.addReference(this.stations_ref);
            }
            this.acontrol.setCurrent(0);
        }
        if (this.display2 != null) {
            this.setStation(n);
        }
        this.time_dir = 0;
        this.circle_ref = new DataReferenceImpl[]{null, null};
        this.circle_renderer = new DefaultRendererJ3D[]{null, null};
        if (this.display1 != null && dArray != null) {
            double d = n2 > 0 ? n2 : 1;
            comparable = new ConstantMap[]{new ConstantMap(dArray[0], Display.Red), new ConstantMap(dArray[1], Display.Green), new ConstantMap(dArray[2], Display.Blue), new ConstantMap(d, Display.LineWidth)};
            this.circle_ref[0] = new DataReferenceImpl("inner_circle");
            this.circle_ref[0].setData(null);
            this.circle_renderer[0] = new DefaultRendererJ3D();
            this.display1.addReferences(this.circle_renderer[0], this.circle_ref[0], (ConstantMap[])comparable);
            this.circle_renderer[0].toggle(false);
            this.circle_renderer[0].suppressExceptions(true);
        }
        if (this.display1 != null && dArray2 != null) {
            double d = n3 > 0 ? n3 : 1;
            comparable = new ConstantMap[]{new ConstantMap(dArray2[0], Display.Red), new ConstantMap(dArray2[1], Display.Green), new ConstantMap(dArray2[2], Display.Blue), new ConstantMap(d, Display.LineWidth)};
            this.circle_ref[1] = new DataReferenceImpl("outer_circle");
            this.circle_ref[1].setData(null);
            this.circle_renderer[1] = new DefaultRendererJ3D();
            this.display1.addReferences(this.circle_renderer[1], this.circle_ref[1], (ConstantMap[])comparable);
            this.circle_renderer[1].toggle(false);
            this.circle_renderer[1].suppressExceptions(true);
        }
        this.releaser_ref = new DataReferenceImpl("releaser");
        this.releaser = new Releaser();
        this.releaser.addReference(this.releaser_ref);
    }

    class AnimationControlListener
    implements ControlListener {
        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            if (CollectiveBarbManipulation.this.afirst) {
                CollectiveBarbManipulation.this.afirst = false;
            }
            if (CollectiveBarbManipulation.this.stepper_ref != null) {
                CollectiveBarbManipulation.this.stepper_ref.setData(null);
            }
        }

        AnimationControlListener() {
        }
    }

    class Stepper
    extends CellImpl {
        int old_current = -1;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doAction() throws VisADException, RemoteException {
            if (CollectiveBarbManipulation.this.afirst) return;
            if (CollectiveBarbManipulation.this.acontrol == null) {
                return;
            }
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int n;
                CollectiveBarbManipulation.this.which_time = -1;
                int n2 = CollectiveBarbManipulation.this.acontrol.getCurrent();
                if (n2 < 0) {
                    return;
                }
                CollectiveBarbManipulation.this.which_time = n2;
                if (n2 != this.old_current) {
                    if (CollectiveBarbManipulation.this.barb_manipulation_renderers == null) return;
                    n = 0;
                    while (n < CollectiveBarbManipulation.this.nindex) {
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).which_times[n] = -1;
                        if (CollectiveBarbManipulation.this.barb_manipulation_renderers[n] != null) {
                            CollectiveBarbManipulation.this.barb_manipulation_renderers[n].stop_direct();
                        }
                        ++n;
                    }
                }
                if (n2 != this.old_current) {
                    n = 0;
                    while (n < CollectiveBarbManipulation.this.nindex) {
                        int n3 = CollectiveBarbManipulation.this.global_to_station[n][n2];
                        if (n3 < CollectiveBarbManipulation.this.tuples[n].length && CollectiveBarbManipulation.this.station_refs[n] != null) {
                            CollectiveBarbManipulation.this.station_refs[n].setData(CollectiveBarbManipulation.this.tuples[n][n3]);
                            ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).which_times[n] = n3;
                        }
                        ++n;
                    }
                }
                this.old_current = n2;
                if (!CollectiveBarbManipulation.this.afirst_real) return;
                CollectiveBarbManipulation.this.afirst_real = false;
                CollectiveBarbManipulation.this.display1.removeReference(CollectiveBarbManipulation.this.stations_ref);
                return;
            }
        }

        Stepper() {
        }
    }

    class WindMonitor
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                if (CollectiveBarbManipulation.this.nindex != CollectiveBarbManipulation.this.wind_field.getLength()) {
                    throw new CollectiveBarbException("number of stations changed");
                }
                int n = 0;
                while (n < CollectiveBarbManipulation.this.nindex) {
                    FlatField flatField = (FlatField)CollectiveBarbManipulation.this.wind_field.getSample(n);
                    if (CollectiveBarbManipulation.this.ntimes[n] != flatField.getLength()) {
                        throw new CollectiveBarbException("number of times changed");
                    }
                    Enumeration enumeration = flatField.domainEnumeration();
                    int n2 = 0;
                    while (n2 < CollectiveBarbManipulation.this.ntimes[n]) {
                        Tuple tuple = (Tuple)flatField.getSample(n2);
                        Real[] realArray = tuple.getRealComponents();
                        float f = (float)realArray[CollectiveBarbManipulation.this.azimuth_index].getValue();
                        float f2 = (float)realArray[CollectiveBarbManipulation.this.radial_index].getValue();
                        if (!Util.isApproximatelyEqual(f, CollectiveBarbManipulation.this.azimuths[n][n2], 0.1f) || !Util.isApproximatelyEqual(f2, CollectiveBarbManipulation.this.radials[n][n2], 0.01f)) {
                            ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).azimuths[n][n2] = f;
                            ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).radials[n][n2] = f2;
                            ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).tuples[n][n2] = tuple;
                            if (CollectiveBarbManipulation.this.station_refs != null && n2 == CollectiveBarbManipulation.this.which_times[n]) {
                                CollectiveBarbManipulation.this.station_refs[n].setData(CollectiveBarbManipulation.this.tuples[n][n2]);
                            }
                            int n3 = tuple.getDimension();
                            Data[] dataArray = new Data[n3 + 1];
                            int n4 = 0;
                            while (n4 < n3) {
                                dataArray[n4] = tuple.getComponent(n4);
                                ++n4;
                            }
                            dataArray[n3] = ((RealTuple)enumeration.nextElement()).getComponent(0);
                            ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).tuples2[n][n2] = new Tuple(dataArray);
                            if (CollectiveBarbManipulation.this.time_refs != null && n == CollectiveBarbManipulation.this.station) {
                                CollectiveBarbManipulation.this.time_refs[n2].setData(CollectiveBarbManipulation.this.tuples2[n][n2]);
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }

        WindMonitor() {
        }
    }

    class Releaser
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            int n = 0;
            while (n < 2) {
                if (CollectiveBarbManipulation.this.circle_ref[n] != null) {
                    CollectiveBarbManipulation.this.circle_renderer[n].toggle(false);
                    CollectiveBarbManipulation.this.circle_ref[n].setData(null);
                }
                ++n;
            }
        }

        Releaser() {
        }
    }

    class BarbMonitor
    extends CellImpl {
        DataReferenceImpl ref;
        int sta_index;

        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int n = CollectiveBarbManipulation.this.which_times[this.sta_index];
                if (n < 0) {
                    Object var2_3 = null;
                    return;
                }
                CollectiveBarbManipulation.this.collectiveAdjust(this.sta_index, n, this.ref, 1);
            }
        }

        public BarbMonitor(DataReferenceImpl dataReferenceImpl, int n) {
            this.ref = dataReferenceImpl;
            this.sta_index = n;
        }
    }

    class BarbMonitor2
    extends CellImpl {
        DataReferenceImpl ref;
        int time_index;

        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int n = CollectiveBarbManipulation.this.station;
                if (n < 0) {
                    Object var2_3 = null;
                    return;
                }
                CollectiveBarbManipulation.this.collectiveAdjust(n, this.time_index, this.ref, 2);
            }
        }

        public BarbMonitor2(DataReferenceImpl dataReferenceImpl, int n) {
            this.ref = dataReferenceImpl;
            this.time_index = n;
        }
    }

    class CBarbManipulationRendererJ3D
    extends BarbManipulationRendererJ3D {
        CollectiveBarbManipulation cbm;
        int index;

        public void release_direct() {
            this.cbm.release();
        }

        public void drag_direct(VisADRay visADRay, boolean bl, int n) {
            if (bl) {
                this.cbm.circleEnable();
                CollectiveBarbManipulation.this.current_index = this.index;
            }
            super.drag_direct(visADRay, bl, n);
        }

        CBarbManipulationRendererJ3D(CollectiveBarbManipulation collectiveBarbManipulation2, int n) {
            this.cbm = collectiveBarbManipulation2;
            this.index = n;
        }
    }

    class CSwellManipulationRendererJ3D
    extends SwellManipulationRendererJ3D {
        CollectiveBarbManipulation cbm;
        int index;

        public void release_direct() {
            this.cbm.release();
        }

        public void drag_direct(VisADRay visADRay, boolean bl, int n) {
            if (bl) {
                this.cbm.circleEnable();
                CollectiveBarbManipulation.this.current_index = this.index;
            }
            super.drag_direct(visADRay, bl, n);
        }

        CSwellManipulationRendererJ3D(CollectiveBarbManipulation collectiveBarbManipulation2, int n) {
            this.cbm = collectiveBarbManipulation2;
            this.index = n;
        }
    }
}

