/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.EarthVectorType;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.VisADException;
import visad.bom.BarbRenderer;
import visad.bom.ShadowBarbFunctionTypeJ2D;
import visad.bom.ShadowBarbRealTupleTypeJ2D;
import visad.bom.ShadowBarbRealTypeJ2D;
import visad.bom.ShadowBarbSetTypeJ2D;
import visad.bom.ShadowBarbTupleTypeJ2D;
import visad.bom.WindPolarCoordinateSystem;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayImplJ2D;

public class BarbRendererJ2D
extends DefaultRendererJ2D
implements BarbRenderer {
    static final int N = 5;
    private boolean knotsConvert = true;

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbFunctionTypeJ2D(functionType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType realTupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbRealTupleTypeJ2D(realTupleType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealType(RealType realType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbRealTypeJ2D(realType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowSetType(SetType setType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbSetTypeJ2D(setType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTupleType(TupleType tupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbTupleTypeJ2D(tupleType, dataDisplayLink, shadowType);
    }

    public float[] makeVector(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray, float[] fArray4, float[] fArray5, float[] fArray6, int[] nArray2) {
        return null;
    }

    public void setKnotsConvert(boolean bl) {
        this.knotsConvert = bl;
    }

    public boolean getKnotsConvert() {
        return this.knotsConvert;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        FlowControl flowControl;
        Object object;
        Cloneable cloneable;
        MathType mathType;
        double d = -10.0;
        if (stringArray.length > 0) {
            try {
                d = Double.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealType realType3 = new RealType("flowx", CommonUnit.meterPerSecond, null);
        RealType realType4 = new RealType("flowy", CommonUnit.meterPerSecond, null);
        RealType realType5 = new RealType("red");
        RealType realType6 = new RealType("green");
        RealType realType7 = new RealType("index");
        EarthVectorType earthVectorType = new EarthVectorType(realType3, realType4);
        TupleType tupleType = null;
        RealType realType8 = new RealType("flow_degree", CommonUnit.degree, null);
        RealType realType9 = new RealType("flow_speed", CommonUnit.meterPerSecond, null);
        if (stringArray.length > 1) {
            System.out.println("polar winds");
            mathType = new RealTupleType(new RealType[]{realType8, realType9}, (CoordinateSystem)new WindPolarCoordinateSystem(earthVectorType), null);
            tupleType = new TupleType(new MathType[]{realType2, realType, mathType, realType5, realType6});
        } else {
            System.out.println("Cartesian winds");
            tupleType = new TupleType(new MathType[]{realType2, realType, earthVectorType, realType5, realType6});
        }
        mathType = new FunctionType(realType7, tupleType);
        DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("display1");
        ScalarMap scalarMap = new ScalarMap(realType2, Display.XAxis);
        displayImplJ2D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(realType, Display.YAxis);
        displayImplJ2D.addMap(scalarMap2);
        if (stringArray.length > 1) {
            cloneable = new ScalarMap(realType8, Display.Flow1Azimuth);
            displayImplJ2D.addMap((ScalarMap)cloneable);
            cloneable.setRange(0.0, 360.0);
            object = new ScalarMap(realType9, Display.Flow1Radial);
            displayImplJ2D.addMap((ScalarMap)object);
            ((ScalarMap)object).setRange(0.0, 1.0);
            flowControl = (FlowControl)((ScalarMap)object).getControl();
            flowControl.setFlowScale(0.1f);
        } else {
            cloneable = new ScalarMap(realType3, Display.Flow1X);
            displayImplJ2D.addMap((ScalarMap)cloneable);
            cloneable.setRange(-1.0, 1.0);
            object = new ScalarMap(realType4, Display.Flow1Y);
            displayImplJ2D.addMap((ScalarMap)object);
            ((ScalarMap)object).setRange(-1.0, 1.0);
            flowControl = (FlowControl)((ScalarMap)object).getControl();
            flowControl.setFlowScale(0.1f);
        }
        displayImplJ2D.addMap(new ScalarMap(realType5, Display.Red));
        displayImplJ2D.addMap(new ScalarMap(realType6, Display.Green));
        displayImplJ2D.addMap(new ConstantMap(1.0, Display.Blue));
        cloneable = new Integer1DSet(25);
        object = new double[6][25];
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 5) {
                double d2 = 2.0 * (double)n2 / 4.0 - 1.0;
                double d3 = 2.0 * (double)n3 / 4.0 - 1.0;
                object[0][n] = 10.0 * d2;
                object[1][n] = 10.0 * d3 + d;
                double d4 = 30.0 * d2;
                double d5 = 30.0 * d3;
                if (stringArray.length > 1) {
                    object[2][n] = 57.29577951308232 * Math.atan2(-d4, -d5);
                    object[3][n] = Math.sqrt(d4 * d4 + d5 * d5);
                } else {
                    object[2][n] = d4;
                    object[3][n] = d5;
                }
                object[4][n] = d2;
                object[5][n] = d3;
                ++n;
                ++n3;
            }
            ++n2;
        }
        FlatField flatField = new FlatField((FunctionType)mathType, (Set)cloneable);
        flatField.setSamples((double[][])object);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref");
        dataReferenceImpl.setData(flatField);
        BarbRendererJ2D barbRendererJ2D = new BarbRendererJ2D();
        barbRendererJ2D.setKnotsConvert(true);
        displayImplJ2D.addReferences((DataRenderer)barbRendererJ2D, dataReferenceImpl);
        JFrame jFrame = new JFrame("test BarbRendererJ2D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ2D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }
}

