/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.FlowControl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.BarbRenderer;
import visad.bom.ShadowBarbFunctionTypeJ2D;
import visad.bom.ShadowBarbRealTupleTypeJ2D;
import visad.bom.ShadowBarbRealTypeJ2D;
import visad.bom.ShadowBarbSetTypeJ2D;
import visad.bom.ShadowBarbTupleTypeJ2D;
import visad.bom.WindGetterJ2D;
import visad.bom.WindPolarCoordinateSystem;
import visad.collab.CollabUtil;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;

public class BarbManipulationRendererJ2D
extends DirectManipulationRendererJ2D
implements BarbRenderer {
    private static final String notFlatTupleType = "not Flat Tuple";
    private static final String multipleFlowTuples = "mappings to both Flow1 and Flow2";
    private static final String multipleFlowMapping = "RealType with multiple flow mappings";
    private static final String noFlow = "must be RealTypes mapped to flow X and flow Y";
    private static final String nonCartesian = "non-Cartesian spatial mapping";
    private static final float EPS = 0.2f;
    private static final int OFFSET_COUNT_INIT = 30;
    static final int N = 5;
    private boolean knotsConvert = true;
    private String whyNotDirect = null;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient MathType type = null;
    private transient ShadowTupleType shadow = null;
    private CoordinateSystem coord = null;
    private float point_x;
    private float point_y;
    private float point_z;
    private float line_x;
    private float line_y;
    private float line_z;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private int[] flowToComponent = new int[]{-1, -1, -1};
    private ScalarMap[] directMap = new ScalarMap[]{null, null, null};
    private float[] barbValues = null;
    private int which_barb = -1;
    private float[] data_flow = new float[]{0.0f, 0.0f, 0.0f};
    private float data_speed = 0.0f;
    private float display_speed = 0.0f;
    private boolean refirst = false;
    private boolean stop = false;
    private float offsetx = 0.0f;
    private float offsety = 0.0f;
    private float offsetz = 0.0f;
    private int offset_count = 0;

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbFunctionTypeJ2D(functionType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType realTupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbRealTupleTypeJ2D(realTupleType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealType(RealType realType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbRealTypeJ2D(realType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowSetType(SetType setType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbSetTypeJ2D(setType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTupleType(TupleType tupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowBarbTupleTypeJ2D(tupleType, dataDisplayLink, shadowType);
    }

    public float[] makeVector(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray, float[] fArray4, float[] fArray5, float[] fArray6, int[] nArray2) {
        return null;
    }

    public void setKnotsConvert(boolean bl) {
        this.knotsConvert = bl;
    }

    public boolean getKnotsConvert() {
        return this.knotsConvert;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl displayImpl = this.getDisplay();
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            this.link = null;
            return;
        }
        this.link = dataDisplayLinkArray[0];
        this.ref = this.link.getDataReference();
        this.type = this.link.getType();
        if (!(this.type instanceof TupleType) || !((TupleType)this.type).getFlat()) {
            this.whyNotDirect = notFlatTupleType;
            return;
        }
        this.flowToComponent = new int[]{-1, -1, -1};
        this.directMap = new ScalarMap[]{null, null, null};
        this.shadow = (ShadowTupleType)this.link.getShadow().getAdaptedShadowType();
        DisplayTupleType[] displayTupleTypeArray = new DisplayTupleType[]{null};
        this.whyNotDirect = this.findFlow(this.shadow, displayImpl, displayTupleTypeArray, this.flowToComponent);
        if (this.whyNotDirect != null) {
            return;
        }
        if (this.coord == null) {
            if (displayTupleTypeArray[0] == null || this.flowToComponent[0] < 0 || this.flowToComponent[1] < 0) {
                this.whyNotDirect = noFlow;
                return;
            }
        } else if (displayTupleTypeArray[0] == null || this.flowToComponent[1] < 0 || this.flowToComponent[2] < 0) {
            this.whyNotDirect = noFlow;
            return;
        }
        ShadowRealType[] shadowRealTypeArray = this.shadow.getRealComponents();
        int n = 0;
        while (n < shadowRealTypeArray.length) {
            DisplayTupleType displayTupleType = shadowRealTypeArray[n].getDisplaySpatialTuple();
            if (displayTupleType != null && !Display.DisplaySpatialCartesianTuple.equals(displayTupleType)) {
                this.whyNotDirect = nonCartesian;
                return;
            }
            ++n;
        }
        this.setIsDirectManipulation(true);
    }

    private String findFlow(ShadowTupleType shadowTupleType, DisplayImpl displayImpl, DisplayTupleType[] displayTupleTypeArray, int[] nArray) {
        ShadowRealType[] shadowRealTypeArray = shadowTupleType.getRealComponents();
        int n = 0;
        while (n < shadowRealTypeArray.length) {
            int n2 = 0;
            Enumeration enumeration = shadowRealTypeArray[n].getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                int n3;
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                if (Display.DisplayFlow1Tuple.equals(displayTupleType) || Display.DisplayFlow2Tuple.equals(displayTupleType)) {
                    if (displayTupleTypeArray[0] != null) {
                        if (!displayTupleTypeArray[0].equals(displayTupleType)) {
                            return multipleFlowTuples;
                        }
                    } else {
                        displayTupleTypeArray[0] = displayTupleType;
                    }
                    if (++n2 > 1) {
                        return multipleFlowMapping;
                    }
                    n3 = displayRealType.getTupleIndex();
                    nArray[n3] = n;
                    this.directMap[n3] = scalarMap;
                    continue;
                }
                if (!Display.DisplayFlow1SphericalTuple.equals(displayTupleType) && !Display.DisplayFlow2SphericalTuple.equals(displayTupleType)) continue;
                if (displayTupleTypeArray[0] != null) {
                    if (!displayTupleTypeArray[0].equals(displayTupleType)) {
                        return multipleFlowTuples;
                    }
                } else {
                    displayTupleTypeArray[0] = displayTupleType;
                    this.coord = displayTupleType.getCoordinateSystem();
                }
                if (++n2 > 1) {
                    return multipleFlowMapping;
                }
                n3 = displayRealType.getTupleIndex();
                nArray[n3] = n;
                this.directMap[n3] = scalarMap;
            }
            ++n;
        }
        return null;
    }

    public void addPoint(float[] fArray) throws VisADException {
    }

    public synchronized void setVectorSpatialValues(float[] fArray, int n) {
        this.barbValues = fArray;
        this.which_barb = n;
    }

    public synchronized void setSpatialValues(float[][] fArray) {
    }

    public synchronized float checkClose(double[] dArray, double[] dArray2) {
        if (this.barbValues == null) {
            return Float.MAX_VALUE;
        }
        float f = (float)dArray[0];
        float f2 = (float)dArray[1];
        float f3 = (float)dArray[2];
        float f4 = (float)dArray2[0];
        float f5 = (float)dArray2[1];
        float f6 = (float)dArray2[2];
        float f7 = this.barbValues[2] - f;
        float f8 = this.barbValues[3] - f2;
        float f9 = 0.0f - f3;
        float f10 = f7 * f4 + f8 * f5 + f9 * f6;
        this.offsetx = f7 -= f10 * f4;
        this.offsety = f8 -= f10 * f5;
        this.offsetz = f9 -= f10 * f6;
        return (float)Math.sqrt(f7 * f7 + f8 * f8 + f9 * f9);
    }

    public synchronized void release_direct() {
    }

    public void stop_direct() {
        this.stop = true;
    }

    public synchronized void drag_direct(VisADRay visADRay, boolean bl, int n) {
        if (this.barbValues == null || this.ref == null || this.shadow == null) {
            return;
        }
        if (bl) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        int n2 = n & 1;
        int n3 = n & 2;
        float f = (float)visADRay.position[0];
        float f2 = (float)visADRay.position[1];
        float f3 = (float)visADRay.position[2];
        float f4 = (float)visADRay.vector[0];
        float f5 = (float)visADRay.vector[1];
        float f6 = (float)visADRay.vector[2];
        if (bl) {
            this.offset_count = 30;
        } else if (this.offset_count > 0) {
            --this.offset_count;
        }
        if (this.offset_count > 0) {
            float f7 = (float)this.offset_count / 30.0f;
            f += f7 * this.offsetx;
            f2 += f7 * this.offsety;
            f3 += f7 * this.offsetz;
        }
        if (bl || this.refirst) {
            this.point_x = this.barbValues[2];
            this.point_y = this.barbValues[3];
            this.point_z = 0.0f;
            this.line_x = 0.0f;
            this.line_y = 0.0f;
            this.line_z = 1.0f;
        }
        float[] fArray = new float[3];
        float f8 = (this.point_x - f) * this.line_x + (this.point_y - f2) * this.line_y + (this.point_z - f3) * this.line_z;
        float f9 = f4 * this.line_x + f5 * this.line_y + f6 * this.line_z;
        if ((double)f9 == 0.0) {
            return;
        }
        fArray[0] = f + (f8 /= f9) * f4;
        fArray[1] = f2 + f8 * f5;
        fArray[2] = f3 + f8 * f6;
        try {
            Object object;
            Data data;
            float f10;
            Object object2;
            Tuple tuple;
            try {
                tuple = (Tuple)this.link.getData();
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return;
                }
                throw remoteException;
            }
            int n4 = ((TupleType)tuple.getType()).getNumberOfRealComponents();
            Real[] realArray = new Real[n4];
            int n5 = 0;
            int n6 = tuple.getDimension();
            int n7 = 0;
            while (n7 < n6) {
                object2 = tuple.getComponent(n7);
                if (object2 instanceof Real) {
                    realArray[n5++] = (Real)object2;
                } else if (object2 instanceof RealTuple) {
                    int n8 = 0;
                    while (n8 < ((RealTuple)object2).getDimension()) {
                        realArray[n5++] = (Real)((RealTuple)object2).getComponent(n8);
                        ++n8;
                    }
                }
                ++n7;
            }
            if (bl || this.refirst) {
                n7 = 0;
                while (n7 < 3) {
                    int n9 = this.flowToComponent[n7];
                    this.data_flow[n7] = n9 >= 0 ? (float)realArray[n9].getValue() : 0.0f;
                    ++n7;
                }
                if (this.coord != null) {
                    float[][] fArray2 = new float[][]{{this.data_flow[0]}, {this.data_flow[1]}, {this.data_flow[2]}};
                    fArray2 = this.coord.toReference(fArray2);
                    this.data_flow[0] = fArray2[0][0];
                    this.data_flow[1] = fArray2[1][0];
                    this.data_flow[2] = fArray2[2][0];
                }
                this.data_speed = (float)Math.sqrt(this.data_flow[0] * this.data_flow[0] + this.data_flow[1] * this.data_flow[1] + this.data_flow[2] * this.data_flow[2]);
                float f11 = this.barbValues[2] - this.barbValues[0];
                float f12 = this.barbValues[3] - this.barbValues[1];
            }
            if (this.getRealVectorTypes(this.which_barb) instanceof EarthVectorType) {
                float f13 = 1.0E-4f;
                object2 = new float[][]{{this.barbValues[0], this.barbValues[0] + f13 * (fArray[0] - this.barbValues[0])}, {this.barbValues[1], this.barbValues[1] + f13 * (fArray[1] - this.barbValues[1])}, {0.0f, 0.0f}};
                float[][] fArray3 = this.spatialToEarth((float[][])object2);
                if (fArray3 == null) {
                    return;
                }
                fArray[2] = 0.0f;
                fArray[0] = (fArray3[1][1] - fArray3[1][0]) * (float)Math.cos(Math.PI / 180 * (double)fArray3[0][0]);
                fArray[1] = fArray3[0][1] - fArray3[0][0];
            } else {
                fArray[0] = fArray[0] - this.barbValues[0];
                fArray[1] = fArray[1] - this.barbValues[1];
                double[] dArray = this.getRanges();
                int n10 = 0;
                while (n10 < 3) {
                    int n11 = n10;
                    fArray[n11] = (float)((double)fArray[n11] / dArray[n10]);
                    ++n10;
                }
            }
            fArray[0] = -fArray[0];
            fArray[1] = -fArray[1];
            fArray[2] = -fArray[2];
            float f14 = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
            if (f14 < 1.0E-6f) {
                f14 = 1.0E-6f;
            }
            if (bl || this.refirst) {
                this.display_speed = f14;
            }
            this.refirst = false;
            if (n2 != 0) {
                f10 = this.data_speed / f14;
                fArray[0] = fArray[0] * f10;
                fArray[1] = fArray[1] * f10;
                fArray[2] = fArray[2] * f10;
            } else if (n3 != 0) {
                f10 = f14 / this.display_speed;
                if (this.data_speed < 0.2f) {
                    this.data_flow[0] = 0.4f;
                    this.refirst = true;
                }
                fArray[0] = f10 * this.data_flow[0];
                fArray[1] = f10 * this.data_flow[1];
                fArray[2] = f10 * this.data_flow[2];
            } else {
                f10 = this.data_speed / this.display_speed;
                if (this.data_speed < 0.2f) {
                    this.data_flow[0] = 0.4f;
                    fArray[0] = this.data_flow[0];
                    fArray[1] = this.data_flow[1];
                    fArray[2] = this.data_flow[2];
                    this.refirst = true;
                } else {
                    fArray[0] = fArray[0] * f10;
                    fArray[1] = fArray[1] * f10;
                    fArray[2] = fArray[2] * f10;
                }
            }
            if (this.coord != null) {
                float[][] fArray4 = new float[][]{{fArray[0]}, {fArray[1]}, {fArray[2]}};
                fArray4 = this.coord.fromReference(fArray4);
                fArray[0] = fArray4[0][0];
                fArray[1] = fArray4[1][0];
                fArray[2] = fArray4[2][0];
            }
            Vector<String> vector = new Vector<String>();
            int n12 = 0;
            while (n12 < 3) {
                int n13 = this.flowToComponent[n12];
                if (n13 >= 0) {
                    RealType realType = (RealType)realArray[n13].getType();
                    realArray[n13] = new Real(realType, (double)fArray[n12], realType.getDefaultUnit(), null);
                    data = realArray[n13];
                    object = this.directMap[n12].getOverrideUnit();
                    Unit unit = realType.getDefaultUnit();
                    if (object != null && !((Unit)object).equals(unit) && !RealType.Time.equals(realType)) {
                        double d = (float)((Unit)object).toThis(fArray[0], unit);
                        data = new Real(realType, d, (Unit)object);
                        String string = ((Real)data).toValueString();
                        vector.addElement(realType.getName() + " = " + string);
                    } else {
                        vector.addElement(realType.getName() + " = " + fArray[n12]);
                    }
                }
                ++n12;
            }
            this.getDisplayRenderer().setCursorStringVector(vector);
            Tuple tuple2 = null;
            if (tuple instanceof RealTuple) {
                tuple2 = new RealTuple((RealTupleType)tuple.getType(), realArray, ((RealTuple)tuple).getCoordinateSystem());
            } else {
                Data[] dataArray = new Data[n6];
                n5 = 0;
                int n14 = 0;
                while (n14 < n6) {
                    data = tuple.getComponent(n14);
                    if (data instanceof Real) {
                        dataArray[n14] = realArray[n5++];
                    } else if (data instanceof RealTuple) {
                        object = new Real[((RealTuple)data).getDimension()];
                        int n15 = 0;
                        while (n15 < ((RealTuple)data).getDimension()) {
                            object[n15] = realArray[n5++];
                            ++n15;
                        }
                        dataArray[n14] = new RealTuple((RealTupleType)data.getType(), (Real[])object, ((RealTuple)data).getCoordinateSystem());
                    }
                    ++n14;
                }
                tuple2 = new Tuple(dataArray, false);
            }
            this.ref.setData(tuple2);
        }
        catch (VisADException visADException) {
            System.out.println("drag_direct " + visADException);
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            System.out.println("drag_direct " + remoteException);
            remoteException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        FlowControl flowControl;
        ScalarMap scalarMap;
        DataReferenceImpl[] dataReferenceImplArray;
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealType realType3 = new RealType("windx", CommonUnit.meterPerSecond, null);
        RealType realType4 = new RealType("windy", CommonUnit.meterPerSecond, null);
        RealType realType5 = new RealType("red");
        RealType realType6 = new RealType("green");
        EarthVectorType earthVectorType = new EarthVectorType(realType3, realType4);
        RealType realType7 = new RealType("wind_dir", CommonUnit.degree, null);
        RealType realType8 = new RealType("wind_speed", CommonUnit.meterPerSecond, null);
        RealTupleType realTupleType = null;
        if (stringArray.length > 0) {
            System.out.println("polar winds");
            realTupleType = new RealTupleType(new RealType[]{realType7, realType8}, (CoordinateSystem)new WindPolarCoordinateSystem(earthVectorType), null);
        }
        DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("display1");
        ScalarMap scalarMap2 = new ScalarMap(realType2, Display.XAxis);
        displayImplJ2D.addMap(scalarMap2);
        ScalarMap scalarMap3 = new ScalarMap(realType, Display.YAxis);
        displayImplJ2D.addMap(scalarMap3);
        if (stringArray.length > 0) {
            dataReferenceImplArray = new ScalarMap(realType8, Display.Flow1Radial);
            displayImplJ2D.addMap((ScalarMap)dataReferenceImplArray);
            dataReferenceImplArray.setRange(0.0, 1.0);
            scalarMap = new ScalarMap(realType7, Display.Flow1Azimuth);
            displayImplJ2D.addMap(scalarMap);
            scalarMap.setRange(0.0, 360.0);
            flowControl = (FlowControl)scalarMap.getControl();
            flowControl.setFlowScale(0.15f);
        } else {
            dataReferenceImplArray = new ScalarMap(realType3, Display.Flow1X);
            displayImplJ2D.addMap((ScalarMap)dataReferenceImplArray);
            dataReferenceImplArray.setRange(-1.0, 1.0);
            scalarMap = new ScalarMap(realType4, Display.Flow1Y);
            displayImplJ2D.addMap(scalarMap);
            scalarMap.setRange(-1.0, 1.0);
            flowControl = (FlowControl)scalarMap.getControl();
            flowControl.setFlowScale(0.15f);
        }
        displayImplJ2D.addMap(new ScalarMap(realType5, Display.Red));
        displayImplJ2D.addMap(new ScalarMap(realType6, Display.Green));
        displayImplJ2D.addMap(new ConstantMap(1.0, Display.Blue));
        dataReferenceImplArray = new DataReferenceImpl[25];
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 5) {
                Tuple tuple;
                double d = 2.0 * (double)n2 / 4.0 - 1.0;
                double d2 = 2.0 * (double)n3 / 4.0 - 1.0;
                double d3 = 30.0 * d;
                double d4 = 30.0 * d2;
                if (stringArray.length > 0) {
                    double d5 = 57.29577951308232 * Math.atan2(-d3, -d4);
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4);
                    tuple = new Tuple(new Data[]{new Real(realType2, 10.0 * d), new Real(realType, 10.0 * d2 - 40.0), new RealTuple(realTupleType, new double[]{d5, d6}), new Real(realType5, d), new Real(realType6, d2)});
                } else {
                    tuple = new Tuple(new Data[]{new Real(realType2, 10.0 * d), new Real(realType, 10.0 * d2 - 40.0), new RealTuple(earthVectorType, new double[]{d3, d4}), new Real(realType5, d), new Real(realType6, d2)});
                }
                dataReferenceImplArray[n] = new DataReferenceImpl("ref_" + n);
                dataReferenceImplArray[n].setData(tuple);
                BarbManipulationRendererJ2D barbManipulationRendererJ2D = new BarbManipulationRendererJ2D();
                barbManipulationRendererJ2D.setKnotsConvert(true);
                displayImplJ2D.addReferences((DataRenderer)barbManipulationRendererJ2D, dataReferenceImplArray[n]);
                WindGetterJ2D windGetterJ2D = new WindGetterJ2D(dataReferenceImplArray[n]);
                windGetterJ2D.addReference(dataReferenceImplArray[n]);
                ++n;
                ++n3;
            }
            ++n2;
        }
        JFrame jFrame = new JFrame("test BarbManipulationRendererJ2D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ2D.getComponent());
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }
}

