/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.bio.SeriesFileFilter;
import visad.util.Util;

public class SeriesChooser
extends JPanel
implements ActionListener {
    private static String[] types = new String[]{"PIC", "tiff", "gif", "jpg"};
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private JTextField prefix;
    private JTextField count;
    private JComboBox type;
    private JButton ok;
    private JDialog dialog;
    private int rval;

    public int showDialog(Frame frame) {
        this.dialog = new JDialog(frame, "Open file series", true);
        this.dialog.getRootPane().setDefaultButton(this.ok);
        this.prefix.setText("");
        this.count.setText("");
        this.type.setSelectedItem(types[0]);
        this.dialog.setContentPane(this);
        this.dialog.pack();
        Util.centerWindow(this.dialog);
        ((Component)this.dialog).setVisible(true);
        return this.rval;
    }

    public File[] getSeries() {
        boolean bl;
        String string = this.prefix.getText();
        String string2 = this.count.getText();
        String string3 = (String)this.type.getSelectedItem();
        int n = 1;
        try {
            n = Integer.parseInt(string2);
            if (n < 1) {
                n = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl2 = bl = string3 != null && !string3.equals("");
        if (bl) {
            string3 = "." + string3;
        }
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            String string4 = string + (n2 + 1) + (bl ? string3 : "");
            fileArray[n2] = new File(string4);
            ++n2;
        }
        return fileArray;
    }

    public String getPrefix() {
        return this.prefix.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("select")) {
            String string2;
            String string3;
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            SeriesFileFilter seriesFileFilter = new SeriesFileFilter();
            jFileChooser.setFileFilter(seriesFileFilter);
            int n2 = jFileChooser.showOpenDialog(this.dialog);
            if (n2 != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            String string4 = file.getPath();
            int n3 = string4.lastIndexOf(".");
            if (n3 >= 0) {
                int n4 = n3;
                while (n4 != 0 && (n = string4.charAt(--n4)) >= 48 && n <= 57) {
                }
                string3 = string4.substring(0, n4 + 1);
                string2 = string4.substring(n3 + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            File file2 = file.getParentFile();
            n = file2.list(seriesFileFilter).length;
            int n5 = 1;
            int n6 = n / 2;
            int n7 = n;
            String string5 = (string2.equals("") ? "" : ".") + string2;
            while (n5 != n7) {
                File file3 = new File(string3 + n6 + string5);
                File file4 = new File(string3 + (n6 + 1) + string5);
                boolean bl = file3.exists();
                boolean bl2 = file4.exists();
                if (!bl) {
                    n7 = n6;
                } else {
                    if (!bl2) break;
                    n5 = n6;
                }
                n6 = (n5 + n7) / 2;
            }
            this.prefix.setText(string3);
            this.count.setText("" + n6);
            this.type.setSelectedItem(string2);
            if (this.type.getSelectedItem() == null) {
                this.type.addItem(string2);
            }
        } else if (string.equals("ok")) {
            this.rval = 1;
            ((Component)this.dialog).setVisible(false);
        } else if (string.equals("cancel")) {
            this.rval = 2;
            ((Component)this.dialog).setVisible(false);
        }
    }

    public SeriesChooser() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("File prefix");
        JLabel jLabel2 = new JLabel("Count");
        JLabel jLabel3 = new JLabel("Type");
        jLabel.setForeground(Color.black);
        jLabel2.setForeground(Color.black);
        jLabel3.setForeground(Color.black);
        this.prefix = new JTextField();
        this.count = new JTextField();
        Vector<String> vector = new Vector<String>(types.length);
        int n = 0;
        while (n < types.length) {
            vector.add(types[n]);
            ++n;
        }
        this.type = new JComboBox(vector);
        this.prefix.setAlignmentX(0.0f);
        this.count.setAlignmentX(0.0f);
        this.type.setAlignmentX(0.0f);
        Util.adjustTextField(this.prefix);
        this.type.setEditable(true);
        JButton jButton = new JButton("Choose file");
        this.ok = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        jButton.setMnemonic('f');
        this.ok.setMnemonic('o');
        jButton2.setMnemonic('c');
        jButton.setActionCommand("select");
        this.ok.setActionCommand("ok");
        jButton2.setActionCommand("cancel");
        jButton.addActionListener(this);
        this.ok.addActionListener(this);
        jButton2.addActionListener(this);
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        jPanel.add(jLabel);
        jPanel.add(this.prefix);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel3.add(jButton);
        jPanel3.add(this.ok);
        jPanel3.add(jButton2);
        jPanel4.add(jLabel2);
        jPanel4.add(this.count);
        jPanel5.add(jLabel3);
        jPanel5.add(this.type);
    }
}

