/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.ConstantMap;
import visad.Control;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Scalar;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.bom.RubberBandLineRendererJ3D;
import visad.data.DefaultFamily;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.VisADSlider;

public class MultiLUT
implements ActionListener {
    private static final int NFILES = 17;
    private TextType text = null;
    private RealType element = null;
    private RealType line = null;
    private RealType value = null;
    private TupleType text_tuple = null;
    private float[][] data_values = null;
    private float[][] values = null;
    private float[][] wedge_samples = null;
    private FlatField data = null;
    private FieldImpl text_field = null;
    private FlatField wedge = null;
    private DataReferenceImpl[] value_refs = null;
    private DataReferenceImpl[] hue_refs = null;
    private int npixels = 0;
    private JLabel minmax = null;
    private DisplayImplJ3D display1 = null;
    ScalarMap vmap = null;
    ScalarMap hmap = null;
    ScalarMap huexmap = null;
    private DataReferenceImpl line_ref = null;

    public static void main(String[] stringArray) throws IOException, VisADException, RemoteException {
        MultiLUT multiLUT = new MultiLUT();
        multiLUT.go(stringArray);
    }

    public void go(String[] stringArray) throws IOException, VisADException, RemoteException {
        Object object;
        Object object2;
        Serializable serializable;
        FieldImpl fieldImpl;
        Serializable serializable2;
        String string = "";
        String string2 = System.getProperty("file.separator");
        if (stringArray.length > 0 && !(string = stringArray[0]).endsWith(string2)) {
            string = string + string2;
        }
        RealTupleType realTupleType = null;
        Unit unit = null;
        String string3 = null;
        Set set = null;
        RealType[] realTypeArray = new RealType[17];
        this.values = new float[17][];
        DefaultFamily defaultFamily = new DefaultFamily("loader");
        int n = 0;
        while (n < 17) {
            serializable2 = (Tuple)defaultFamily.open(string + "SPB" + (n + 1) + ".PIC");
            fieldImpl = (FieldImpl)((Tuple)serializable2).getComponent(0);
            serializable = (FlatField)fieldImpl.getSample(0);
            set = ((FieldImpl)serializable).getDomainSet();
            if (n == 0) {
                object2 = (FunctionType)((DataImpl)serializable).getType();
                realTupleType = ((FunctionType)object2).getDomain();
                this.element = (RealType)realTupleType.getComponent(0);
                this.line = (RealType)realTupleType.getComponent(1);
                this.value = (RealType)((FunctionType)object2).getRange();
                unit = this.value.getDefaultUnit();
                string3 = this.value.getName();
            }
            realTypeArray[n] = RealType.getRealType(string3 + (n + 1), unit);
            object2 = ((FlatField)serializable).getFloats(false);
            this.values[n] = (float[])object2[0];
            ++n;
        }
        this.npixels = this.values[0].length;
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray);
        serializable2 = new FunctionType(realTupleType, realTupleType2);
        fieldImpl = new FlatField((FunctionType)serializable2, set);
        ((FlatField)fieldImpl).setSamples(this.values, false);
        serializable = RealType.getRealType("hue");
        object2 = RealType.getRealType("HUE");
        RealTupleType realTupleType3 = new RealTupleType(this.value, (RealType)serializable);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType3);
        this.data = new FlatField(functionType, set);
        this.data_values = new float[2][this.npixels];
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref1");
        dataReferenceImpl.setData(this.data);
        this.text = TextType.getTextType("text");
        RealType[] realTypeArray2 = new RealType[]{RealType.Time};
        RealTupleType realTupleType4 = new RealTupleType(realTypeArray2);
        MathType[] mathTypeArray = new MathType[]{this.element, this.line, this.text};
        this.text_tuple = new TupleType(mathTypeArray);
        FunctionType functionType2 = new FunctionType(RealType.Time, this.text_tuple);
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realTupleType4, 0.0, 1.0, 2);
        this.text_field = new FieldImpl(functionType2, linear1DSet);
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("text_ref");
        dataReferenceImpl2.setData(this.text_field);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType, 0.0, 767.0, 768, 550.0, 570.0, 21);
        this.wedge = new FlatField(functionType, linear2DSet);
        this.wedge_samples = new float[2][16128];
        DataReferenceImpl dataReferenceImpl3 = new DataReferenceImpl("wedge_ref");
        dataReferenceImpl3.setData(this.wedge);
        DataReferenceImpl dataReferenceImpl4 = new DataReferenceImpl("xref");
        this.display1 = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(this.element, Display.XAxis);
        this.display1.addMap(scalarMap);
        this.huexmap = new ScalarMap((ScalarType)object2, Display.XAxis);
        this.display1.addMap(this.huexmap);
        ScalarMap scalarMap2 = new ScalarMap(this.line, Display.YAxis);
        this.display1.addMap(scalarMap2);
        scalarMap2.setRange(0.0, 511.0);
        this.vmap = new ScalarMap(this.value, Display.Value);
        this.display1.addMap(this.vmap);
        this.hmap = new ScalarMap((ScalarType)serializable, Display.Hue);
        this.display1.addMap(this.hmap);
        ScalarMap scalarMap3 = new ScalarMap(this.text, Display.Text);
        this.display1.addMap(scalarMap3);
        this.display1.addMap(new ConstantMap(1.0, Display.Saturation));
        Control control = scalarMap3.getControl();
        if (control != null && control instanceof TextControl) {
            object = (TextControl)control;
            ((TextControl)object).setSize(1.0);
            ((TextControl)object).setJustification(TextControl.Justification.CENTER);
            ((TextControl)object).setAutoSize(true);
        }
        this.display1.addReference(dataReferenceImpl);
        object = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)object, dataReferenceImpl4);
        ((DataRenderer)object).suppressExceptions(true);
        DefaultRendererJ3D defaultRendererJ3D = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)defaultRendererJ3D, dataReferenceImpl2);
        defaultRendererJ3D.suppressExceptions(true);
        DefaultRendererJ3D defaultRendererJ3D2 = new DefaultRendererJ3D();
        this.display1.addReferences((DataRenderer)defaultRendererJ3D2, dataReferenceImpl3);
        defaultRendererJ3D2.suppressExceptions(true);
        this.line_ref = new DataReferenceImpl("line");
        Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)realTupleType, null, 1);
        this.line_ref.setData(gridded2DSet);
        this.display1.addReferences((DataRenderer)new RubberBandLineRendererJ3D(this.element, this.line), this.line_ref);
        RealType realType = RealType.getRealType("channel");
        RealType realType2 = RealType.getRealType("point");
        RealType realType3 = RealType.getRealType("intensity");
        FunctionType functionType3 = new FunctionType(realType, realType3);
        FunctionType functionType4 = new FunctionType(realType2, functionType3);
        FunctionType functionType5 = new FunctionType(realType2, realType3);
        FunctionType functionType6 = new FunctionType(realType, functionType5);
        DataReferenceImpl dataReferenceImpl5 = new DataReferenceImpl("ref2");
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display2");
        ScalarMap scalarMap4 = new ScalarMap(realType, Display.XAxis);
        displayImplJ3D.addMap(scalarMap4);
        ScalarMap scalarMap5 = new ScalarMap(realType3, Display.YAxis);
        displayImplJ3D.addMap(scalarMap5);
        ScalarMap scalarMap6 = new ScalarMap(realType2, Display.ZAxis);
        displayImplJ3D.addMap(scalarMap6);
        displayImplJ3D.getGraphicsModeControl().setScaleEnable(true);
        DefaultRendererJ3D defaultRendererJ3D3 = new DefaultRendererJ3D();
        displayImplJ3D.addReferences((DataRenderer)defaultRendererJ3D3, dataReferenceImpl5);
        defaultRendererJ3D3.suppressExceptions(true);
        RealTupleType realTupleType5 = realTupleType;
        CellImpl cellImpl = new CellImpl(this, realTupleType5, dataReferenceImpl4, (FlatField)fieldImpl, realType2, realType, functionType4, functionType3, functionType6, functionType5, dataReferenceImpl5){
            private final /* synthetic */ MultiLUT this$0;
            private final /* synthetic */ RealTupleType val$fdomain;
            private final /* synthetic */ DataReferenceImpl val$xref;
            private final /* synthetic */ FlatField val$big_data;
            private final /* synthetic */ RealType val$point;
            private final /* synthetic */ RealType val$channel;
            private final /* synthetic */ FunctionType val$spectra_type;
            private final /* synthetic */ FunctionType val$spectrum_type;
            private final /* synthetic */ FunctionType val$lines_type;
            private final /* synthetic */ FunctionType val$line_type;
            private final /* synthetic */ DataReferenceImpl val$ref2;

            public void doAction() throws VisADException, RemoteException {
                Object object;
                Set set = (Set)MultiLUT.access$0(this.this$0).getData();
                if (set == null) {
                    return;
                }
                float[][] fArray = set.getSamples();
                if (fArray == null) {
                    return;
                }
                float f = fArray[0][0];
                float f2 = fArray[0][1];
                float f3 = fArray[1][0];
                float f4 = fArray[1][1];
                double d = Math.sqrt((f - f2) * (f - f2) + (f3 - f4) * (f3 - f4));
                int n = (int)(d + 1.0);
                if (n < 2) {
                    n = 2;
                }
                float[][] fArray2 = new float[2][n];
                int n2 = 0;
                while (n2 < n) {
                    float f5 = (float)n2 / ((float)n - 1.0f);
                    fArray2[0][n2] = f + f5 * (f2 - f);
                    fArray2[1][n2] = f3 + f5 * (f4 - f3);
                    ++n2;
                }
                Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)this.val$fdomain, fArray2, n);
                this.val$xref.setData(gridded2DSet);
                FlatField flatField = (FlatField)this.val$big_data.resample(gridded2DSet, 100, 202);
                float[][] fArray3 = flatField.getFloats(false);
                Linear1DSet linear1DSet = new Linear1DSet((MathType)this.val$point, 0.0, 1.0, n);
                Integer1DSet integer1DSet = new Integer1DSet((MathType)this.val$channel, 17);
                FieldImpl fieldImpl = new FieldImpl(this.val$spectra_type, linear1DSet);
                int n3 = 0;
                while (n3 < n) {
                    FlatField flatField2 = new FlatField(this.val$spectrum_type, integer1DSet);
                    object = new float[1][17];
                    int n4 = 0;
                    while (n4 < 17) {
                        object[0][n4] = fArray3[n4][n3];
                        ++n4;
                    }
                    flatField2.setSamples((float[][])object, false);
                    fieldImpl.setSample(n3, (Data)flatField2);
                    ++n3;
                }
                FieldImpl fieldImpl2 = new FieldImpl(this.val$lines_type, integer1DSet);
                int n5 = 0;
                while (n5 < 17) {
                    object = new FlatField(this.val$line_type, linear1DSet);
                    float[][] fArray4 = new float[1][n];
                    int n6 = 0;
                    while (n6 < n) {
                        fArray4[0][n6] = fArray3[n5][n6];
                        ++n6;
                    }
                    ((FlatField)object).setSamples(fArray4, false);
                    fieldImpl2.setSample(n5, (Data)object);
                    ++n5;
                }
                this.val$ref2.setData(new Tuple(new Data[]{fieldImpl, fieldImpl2}));
            }
            {
                this.val$fdomain = realTupleType;
                this.val$xref = dataReferenceImpl;
                this.val$big_data = flatField;
                this.val$point = realType;
                this.val$channel = realType2;
                this.val$spectra_type = functionType;
                this.val$spectrum_type = functionType2;
                this.val$lines_type = functionType3;
                this.val$line_type = functionType4;
                this.val$ref2 = dataReferenceImpl2;
                this.this$0 = multiLUT;
                this.constructor$0(multiLUT);
            }

            private final void constructor$0(MultiLUT multiLUT) {
            }
        };
        cellImpl.addReference(this.line_ref);
        VisADSlider[] visADSliderArray = new VisADSlider[17];
        VisADSlider[] visADSliderArray2 = new VisADSlider[17];
        this.value_refs = new DataReferenceImpl[17];
        this.hue_refs = new DataReferenceImpl[17];
        JFrame jFrame = new JFrame("VisAD MultiLUT");
        jFrame.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ MultiLUT this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = multiLUT;
                this.constructor$0(multiLUT);
            }

            private final void constructor$0(MultiLUT multiLUT) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        Dimension dimension = new Dimension(300, 1000);
        jPanel2.setMaximumSize(dimension);
        jPanel3.setMaximumSize(dimension);
        int n2 = 0;
        while (n2 < 17) {
            this.value_refs[n2] = new DataReferenceImpl("value" + n2);
            this.value_refs[n2].setData(new Real(1.0));
            visADSliderArray[n2] = new VisADSlider("value" + n2, -100, 100, 100, 0.01, this.value_refs[n2], RealType.Generic);
            jPanel2.add(visADSliderArray[n2]);
            this.hue_refs[n2] = new DataReferenceImpl("hue" + n2);
            this.hue_refs[n2].setData(new Real(1.0));
            visADSliderArray2[n2] = new VisADSlider("hue" + n2, -100, 100, 100, 0.01, this.hue_refs[n2], RealType.Generic);
            jPanel3.add(visADSliderArray2[n2]);
            ++n2;
        }
        JButton jButton = new JButton("Zero values");
        jButton.addActionListener(this);
        jButton.setActionCommand("value_clear");
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("One values");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("value_set");
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("Zero hues");
        jButton3.addActionListener(this);
        jButton3.setActionCommand("hue_clear");
        jPanel3.add(Box.createVerticalStrut(10));
        jPanel3.add(jButton3);
        JButton jButton4 = new JButton("One hues");
        jButton4.addActionListener(this);
        jButton4.setActionCommand("hue_set");
        jPanel3.add(jButton4);
        jPanel4.add(this.display1.getComponent());
        jPanel4.add(displayImplJ3D.getComponent());
        this.minmax = new JLabel(" ");
        jPanel2.add(Box.createVerticalStrut(30));
        jPanel2.add(this.minmax);
        JButton jButton5 = new JButton("Compute");
        jButton5.addActionListener(this);
        jButton5.setActionCommand("compute");
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jButton5);
        int n3 = 1200;
        int n4 = 1000;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension2.width / 2 - n3 / 2, dimension2.height / 2 - n4 / 2);
        ((Component)jFrame).setSize(n3, n4);
        ((Component)jFrame).setVisible(true);
        this.doit();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("compute")) {
            this.doit();
        } else if (string.equals("value_clear")) {
            try {
                int n = 0;
                while (n < 17) {
                    this.value_refs[n].setData(new Real(0.0));
                    ++n;
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("value_set")) {
            try {
                int n = 0;
                while (n < 17) {
                    this.value_refs[n].setData(new Real(1.0));
                    ++n;
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("hue_clear")) {
            try {
                int n = 0;
                while (n < 17) {
                    this.hue_refs[n].setData(new Real(0.0));
                    ++n;
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("hue_set")) {
            try {
                int n = 0;
                while (n < 17) {
                    this.hue_refs[n].setData(new Real(1.0));
                    ++n;
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public void doit() {
        try {
            float f;
            float[] fArray = new float[17];
            float[] fArray2 = new float[17];
            int n = 0;
            while (n < 17) {
                Real real = (Real)this.value_refs[n].getData();
                fArray[n] = (float)real.getValue();
                real = (Real)this.hue_refs[n].getData();
                fArray2[n] = (float)real.getValue();
                ++n;
            }
            float f2 = Float.MAX_VALUE;
            float f3 = Float.MIN_VALUE;
            float f4 = Float.MAX_VALUE;
            float f5 = Float.MIN_VALUE;
            int n2 = 0;
            while (n2 < this.npixels) {
                f = 0.0f;
                float f6 = 0.0f;
                int n3 = 0;
                while (n3 < 17) {
                    f += fArray[n3] * this.values[n3][n2];
                    f6 += fArray2[n3] * this.values[n3][n2];
                    ++n3;
                }
                this.data_values[0][n2] = f;
                this.data_values[1][n2] = f6;
                if (f < f2) {
                    f2 = f;
                }
                if (f > f3) {
                    f3 = f;
                }
                if (f6 < f4) {
                    f4 = f6;
                }
                if (f6 > f5) {
                    f5 = f6;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < 768) {
                f = f4 + (float)n2 / 767.0f * (f5 - f4);
                int n4 = n2;
                while (n4 < 16128) {
                    this.wedge_samples[0][n4] = f3;
                    this.wedge_samples[1][n4] = f;
                    n4 += 768;
                }
                ++n2;
            }
            this.minmax.setText("vmin = " + f2 + "; vmax = " + f3);
            double d = 0.0;
            double d2 = 767.0;
            double d3 = 525.0;
            this.text_field.setSample(0, (Data)new Tuple(this.text_tuple, new Scalar[]{new Real(this.element, d), new Real(this.line, d3), new Text(this.text, "" + f4)}));
            this.text_field.setSample(1, (Data)new Tuple(this.text_tuple, new Scalar[]{new Real(this.element, d2), new Real(this.line, d3), new Text(this.text, "" + f5)}));
            this.display1.disableAction();
            this.vmap.setRange(f2, f3);
            this.hmap.setRange(f4, f5);
            this.huexmap.setRange(f4, f5);
            this.data.setSamples(this.data_values, false);
            this.wedge.setSamples(this.wedge_samples, false);
            this.display1.enableAction();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    static /* synthetic */ DataReferenceImpl access$0(MultiLUT multiLUT) {
        return multiLUT.line_ref;
    }

    static /* synthetic */ int access$1() {
        return NFILES;
    }
}

