/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import visad.Real;
import visad.RealTuple;
import visad.VisADException;
import visad.bio.MeasureGroup;
import visad.bio.MeasureThing;

public class Measurement {
    protected RealTuple[] values;
    protected Vector things;
    protected Color color;
    protected MeasureGroup group;
    int stdId = -1;

    public void setValues(RealTuple[] realTupleArray) {
        if (realTupleArray.length != this.values.length) {
            System.err.println("Warning: measurement lengths don't match");
            return;
        }
        double[][] dArray = Measurement.doubleValues(realTupleArray);
        double[][] dArray2 = Measurement.doubleValues(this.values);
        int n = realTupleArray.length;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            System.err.println("Warning: measurement dimensions don't match");
            return;
        }
        this.values = realTupleArray;
        this.refreshThings();
    }

    void addThing(MeasureThing measureThing) {
        Vector vector = this.things;
        synchronized (vector) {
            this.things.add(measureThing);
        }
    }

    void removeThing(MeasureThing measureThing) {
        Vector vector = this.things;
        synchronized (vector) {
            this.things.remove(measureThing);
        }
    }

    void removeAllThings() {
        Vector vector = this.things;
        synchronized (vector) {
            this.things.removeAllElements();
        }
    }

    protected void refreshThings() {
        Vector vector = this.things;
        synchronized (vector) {
            Object[] objectArray = new MeasureThing[this.things.size()];
            this.things.copyInto(objectArray);
            SwingUtilities.invokeLater(new Runnable(this, (MeasureThing[])objectArray){
                private final /* synthetic */ Measurement this$0;
                private final /* synthetic */ MeasureThing[] val$t;

                public void run() {
                    int n = 0;
                    while (n < this.val$t.length) {
                        this.val$t[n].refresh();
                        ++n;
                    }
                }
                {
                    this.val$t = measureThingArray;
                    this.this$0 = measurement;
                    this.constructor$0(measurement);
                }

                private final void constructor$0(Measurement measurement) {
                }
            });
        }
    }

    public void setGroup(MeasureGroup measureGroup) {
        this.group = measureGroup;
    }

    public void setColor(Color color) {
        if (this.color.equals(color)) {
            return;
        }
        this.color = color;
        this.refreshThings();
    }

    public RealTuple[] getValues() {
        return this.values;
    }

    public MeasureGroup getGroup() {
        return this.group;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLength() {
        return this.values.length;
    }

    public int getDimension() {
        return this.values == null ? -1 : this.values[0].getDimension();
    }

    public boolean isPoint() {
        return this.values.length == 1;
    }

    public double getDistance() {
        double[][] dArray = this.doubleValues();
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            double d2 = dArray[n][1] - dArray[n][0];
            d += d2 * d2;
            ++n;
        }
        return Math.sqrt(d);
    }

    public double[][] doubleValues() {
        return Measurement.doubleValues(this.values);
    }

    private static double[][] doubleValues(RealTuple[] realTupleArray) {
        int n = realTupleArray.length;
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            if (realTupleArray[n2] == null) {
                return null;
            }
            ++n2;
        }
        n2 = realTupleArray[0].getDimension();
        double[][] dArray = new double[n2][n];
        try {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    Real real = (Real)realTupleArray[n4].getComponent(n3);
                    dArray[n3][n4] = real.getValue();
                    ++n4;
                }
                ++n3;
            }
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return dArray;
    }

    public Object clone() {
        RealTuple[] realTupleArray = new RealTuple[this.values.length];
        System.arraycopy(this.values, 0, realTupleArray, 0, this.values.length);
        Measurement measurement = new Measurement(realTupleArray, this.color, this.group);
        measurement.stdId = this.stdId;
        return measurement;
    }

    public Measurement(RealTuple[] realTupleArray) {
        this(realTupleArray, Color.white, null);
    }

    public Measurement(RealTuple[] realTupleArray, Color color, MeasureGroup measureGroup) {
        this.values = realTupleArray;
        this.things = new Vector();
        this.color = color;
        this.group = measureGroup;
    }
}

