/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.CellImpl;
import visad.DataReference;
import visad.VisADException;
import visad.bio.ColorRenderer;
import visad.bio.FileSeriesWidget;
import visad.bio.GroupDialog;
import visad.bio.ImageStackWidget;
import visad.bio.MeasureFrame;
import visad.bio.MeasureGroup;
import visad.bio.MeasureLine;
import visad.bio.MeasureList;
import visad.bio.MeasureThing;
import visad.bio.Measurement;
import visad.browser.Convert;
import visad.browser.Divider;

public class MeasureToolbar
extends JPanel
implements SwingConstants {
    private static final Color[] COLORS = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, Color.pink};
    private static final String INFO_LABEL = "   (000.000, 000.000)-(000.000, 000.000): distance=000.000";
    static int maxId = 0;
    private GroupDialog groupBox = new GroupDialog();
    private MeasureThing thing;
    private MeasureFrame frame;
    private FileSeriesWidget horiz;
    private ImageStackWidget vert;
    private CellImpl cell;
    boolean ignoreNextStandard = false;
    private boolean ignoreGroup = false;
    private JLabel mPixLabel;
    private JTextField micronsPerPixel;
    private JLabel sliceDistLabel;
    private JTextField sliceDistance;
    private JButton addLine;
    private JButton addMarker;
    private JCheckBox grayscale;
    private JLabel brightnessLabel;
    private JSlider brightness;
    private JLabel measureInfo;
    private JCheckBox setStandard;
    private JButton removeThing;
    private JLabel colorLabel;
    private JComboBox colorList;
    private JLabel groupLabel;
    private JComboBox groupList;
    private JButton newGroup;
    private JLabel descriptionLabel;
    private JTextArea descriptionBox;

    public void setEnabled(boolean bl) {
        this.addLine.setEnabled(bl);
        this.addMarker.setEnabled(bl);
        this.grayscale.setEnabled(bl);
        this.brightnessLabel.setEnabled(bl);
        this.brightness.setEnabled(bl);
    }

    public void select(MeasureThing measureThing) {
        Object object;
        this.thing = measureThing;
        boolean bl = measureThing != null;
        boolean bl2 = measureThing instanceof MeasureLine;
        this.setStandard.setEnabled(bl);
        this.removeThing.setEnabled(bl);
        this.colorLabel.setEnabled(bl && bl2);
        this.colorList.setEnabled(bl && bl2);
        this.groupLabel.setEnabled(bl);
        this.groupList.setEnabled(bl);
        this.newGroup.setEnabled(bl);
        this.descriptionLabel.setEnabled(bl);
        this.descriptionBox.setEnabled(bl);
        if (bl) {
            object = measureThing.getMeasurement();
            this.ignoreNextStandard = true;
            this.setStandard.setSelected(((Measurement)object).stdId >= 0);
            this.colorList.setSelectedItem(((Measurement)object).getColor());
            this.groupList.setSelectedItem(((Measurement)object).getGroup());
        }
        object = this.cell;
        synchronized (object) {
            try {
                this.cell.disableAction();
                this.cell.removeAllReferences();
                if (bl) {
                    DataReference[] dataReferenceArray = measureThing.getReferences();
                    int n = 0;
                    while (n < dataReferenceArray.length) {
                        this.cell.addReference(dataReferenceArray[n]);
                        ++n;
                    }
                }
                this.cell.enableAction();
                if (!bl) {
                    this.cell.doAction();
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public double getMicronsPerPixel() {
        double d;
        try {
            d = Double.parseDouble(this.micronsPerPixel.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    public double getSliceDistance() {
        double d;
        try {
            d = Double.parseDouble(this.sliceDistance.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    void updateGroupList() {
        this.ignoreGroup = true;
        this.groupList.removeAllItems();
        int n = MeasureGroup.groups.size();
        int n2 = 0;
        while (n2 < n) {
            MeasureGroup measureGroup = (MeasureGroup)MeasureGroup.groups.elementAt(n2);
            this.groupList.addItem(measureGroup);
            ++n2;
        }
        this.ignoreGroup = false;
    }

    private void updateMenuItems() {
        boolean bl = false;
        try {
            double d = Double.parseDouble(this.micronsPerPixel.getText());
            double d2 = Double.parseDouble(this.sliceDistance.getText());
            if (d == d && d > 0.0 && d2 == d2 && d2 > 0.0) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.frame.getMenuItem("File", "Restore lines (microns)...").setEnabled(bl);
        this.frame.getMenuItem("File", "Save lines (microns)...").setEnabled(bl);
    }

    private void updateMeasureInfo() {
        String string = " ";
        if (this.thing != null) {
            String string2;
            String string3;
            Measurement measurement = this.thing.getMeasurement();
            double[][] dArray = measurement.doubleValues();
            if (this.thing instanceof MeasureLine) {
                string3 = Convert.shortString(dArray[0][0]);
                string2 = Convert.shortString(dArray[1][0]);
                String string4 = Convert.shortString(dArray[0][1]);
                String string5 = Convert.shortString(dArray[1][1]);
                String string6 = Convert.shortString(measurement.getDistance());
                string = "(" + string3 + ", " + string2 + ")-(" + string4 + ", " + string5 + "): " + "distance=" + string6;
            } else {
                string3 = Convert.shortString(dArray[0][0]);
                string2 = Convert.shortString(dArray[1][0]);
                string = "(" + string3 + ", " + string2 + ")";
            }
            int n = (INFO_LABEL.length() - string.length()) / 2;
            int n2 = 0;
            while (n2 < n) {
                string = " " + string + " ";
                ++n2;
            }
        }
        this.measureInfo.setText("   " + string);
    }

    private MeasureList getList() {
        int n = this.horiz.getValue() - 1;
        int n2 = this.vert.getValue() - 1;
        return this.horiz.getMatrix().getMeasureList(n, n2);
    }

    private JPanel pad(Component component) {
        JPanel jPanel;
        if (component instanceof JPanel) {
            jPanel = (JPanel)component;
            jPanel.add(Box.createHorizontalGlue(), 0);
            jPanel.add(Box.createHorizontalStrut(5), 0);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(Box.createHorizontalStrut(5));
        } else {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(component);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(Box.createHorizontalStrut(5));
        }
        return jPanel;
    }

    static /* synthetic */ void access$0(MeasureToolbar measureToolbar) {
        measureToolbar.updateMenuItems();
    }

    static /* synthetic */ MeasureList access$1(MeasureToolbar measureToolbar) {
        return measureToolbar.getList();
    }

    static /* synthetic */ JCheckBox access$2(MeasureToolbar measureToolbar) {
        return measureToolbar.grayscale;
    }

    static /* synthetic */ ImageStackWidget access$3(MeasureToolbar measureToolbar) {
        return measureToolbar.vert;
    }

    static /* synthetic */ JSlider access$4(MeasureToolbar measureToolbar) {
        return measureToolbar.brightness;
    }

    static /* synthetic */ String access$5() {
        return INFO_LABEL;
    }

    static /* synthetic */ CellImpl access$6(MeasureToolbar measureToolbar) {
        return measureToolbar.cell;
    }

    static /* synthetic */ MeasureThing access$7(MeasureToolbar measureToolbar) {
        return measureToolbar.thing;
    }

    static /* synthetic */ JLabel access$8(MeasureToolbar measureToolbar) {
        return measureToolbar.measureInfo;
    }

    static /* synthetic */ JCheckBox access$9(MeasureToolbar measureToolbar) {
        return measureToolbar.setStandard;
    }

    static /* synthetic */ FileSeriesWidget access$10(MeasureToolbar measureToolbar) {
        return measureToolbar.horiz;
    }

    static /* synthetic */ JComboBox access$11(MeasureToolbar measureToolbar) {
        return measureToolbar.colorList;
    }

    static /* synthetic */ Color[] access$12() {
        return COLORS;
    }

    static /* synthetic */ boolean access$13(MeasureToolbar measureToolbar) {
        return measureToolbar.ignoreGroup;
    }

    static /* synthetic */ JComboBox access$14(MeasureToolbar measureToolbar) {
        return measureToolbar.groupList;
    }

    static /* synthetic */ JTextArea access$15(MeasureToolbar measureToolbar) {
        return measureToolbar.descriptionBox;
    }

    static /* synthetic */ GroupDialog access$16(MeasureToolbar measureToolbar) {
        return measureToolbar.groupBox;
    }

    public MeasureToolbar(MeasureFrame measureFrame, FileSeriesWidget fileSeriesWidget, ImageStackWidget imageStackWidget) {
        this.frame = measureFrame;
        this.horiz = fileSeriesWidget;
        this.vert = imageStackWidget;
        this.setLayout(new BoxLayout(this, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add(Box.createHorizontalStrut(10));
        this.add(jPanel);
        this.add(Box.createHorizontalStrut(10));
        JPanel jPanel2 = new JPanel(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        };
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(30));
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.mPixLabel = new JLabel("Microns per pixel: ");
        jPanel3.add(this.mPixLabel);
        this.micronsPerPixel = new JTextField();
        MeasureToolbar measureToolbar = this;
        this.micronsPerPixel.getDocument().addDocumentListener(new DocumentListener(this, measureToolbar){
            private final /* synthetic */ MeasureToolbar this$0;
            private final /* synthetic */ MeasureToolbar val$toolbar;

            public void changedUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }
            {
                this.val$toolbar = measureToolbar2;
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        jPanel3.add(this.micronsPerPixel);
        jPanel2.add(this.pad(jPanel3));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.sliceDistLabel = new JLabel("Microns between slices: ");
        jPanel3.add(this.sliceDistLabel);
        this.sliceDistance = new JTextField();
        this.sliceDistance.getDocument().addDocumentListener(new DocumentListener(this, measureToolbar){
            private final /* synthetic */ MeasureToolbar this$0;
            private final /* synthetic */ MeasureToolbar val$toolbar;

            public void changedUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MeasureToolbar.access$0(this.val$toolbar);
            }
            {
                this.val$toolbar = measureToolbar2;
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        jPanel3.add(this.sliceDistance);
        jPanel2.add(this.pad(jPanel3));
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.addLine = new JButton("New line");
        this.addLine.addActionListener(new ActionListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureList measureList = MeasureToolbar.access$1(this.this$0);
                if (measureList != null) {
                    measureList.addMeasurement();
                }
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.addLine.setEnabled(false);
        jPanel3.add(this.addLine);
        jPanel3.add(Box.createHorizontalStrut(5));
        this.addMarker = new JButton("New marker");
        this.addMarker.addActionListener(new ActionListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureList measureList = MeasureToolbar.access$1(this.this$0);
                if (measureList != null) {
                    measureList.addMeasurement(true);
                }
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.addMarker.setEnabled(false);
        jPanel3.add(this.addMarker);
        jPanel2.add(this.pad(jPanel3));
        jPanel2.add(Box.createVerticalStrut(5));
        this.grayscale = new JCheckBox("Grayscale");
        this.grayscale.setSelected(true);
        this.grayscale.addItemListener(new ItemListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = MeasureToolbar.access$2(this.this$0).isSelected();
                MeasureToolbar.access$3(this.this$0).setGrayscale(bl);
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.grayscale.setEnabled(false);
        jPanel2.add(this.pad(this.grayscale));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.brightnessLabel = new JLabel("Brightness: ");
        this.brightnessLabel.setEnabled(false);
        jPanel3.add(this.brightnessLabel);
        this.brightness = new JSlider(1, 100, 50);
        this.brightness.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                MeasureToolbar.access$3(this.this$0).setBrightness(MeasureToolbar.access$4(this.this$0).getValue());
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.brightness.setEnabled(false);
        jPanel3.add(this.brightness);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(new Divider());
        jPanel2.add(Box.createVerticalStrut(10));
        this.measureInfo = new JLabel(this, " "){
            private final /* synthetic */ MeasureToolbar this$0;

            public Dimension getPreferredSize() {
                FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
                int n = fontMetrics.stringWidth("       (000.000, 000.000)-(000.000, 000.000): distance=000.000");
                Dimension dimension = super.getPreferredSize();
                return new Dimension(n, dimension.height);
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar, string);
            }

            private final void constructor$0(MeasureToolbar measureToolbar, String string) {
            }
        };
        this.cell = new CellImpl(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void doAction() {
                CellImpl cellImpl = MeasureToolbar.access$6(this.this$0);
                synchronized (cellImpl) {
                    String string = " ";
                    if (MeasureToolbar.access$7(this.this$0) != null) {
                        String string2;
                        String string3;
                        Measurement measurement = MeasureToolbar.access$7(this.this$0).getMeasurement();
                        double[][] dArray = measurement.doubleValues();
                        if (MeasureToolbar.access$7(this.this$0) instanceof MeasureLine) {
                            string3 = Convert.shortString(dArray[0][0]);
                            string2 = Convert.shortString(dArray[1][0]);
                            String string4 = Convert.shortString(dArray[0][1]);
                            String string5 = Convert.shortString(dArray[1][1]);
                            String string6 = Convert.shortString(measurement.getDistance());
                            string = "(" + string3 + ", " + string2 + ")-" + "(" + string4 + ", " + string5 + "): distance=" + string6;
                        } else {
                            string3 = Convert.shortString(dArray[0][0]);
                            string2 = Convert.shortString(dArray[1][0]);
                            string = "(" + string3 + ", " + string2 + ")";
                        }
                        int n = ("   (000.000, 000.000)-(000.000, 000.000): distance=000.000".length() - string.length()) / 2;
                        int n2 = 0;
                        while (n2 < n) {
                            string = " " + string + " ";
                            ++n2;
                        }
                    }
                    MeasureToolbar.access$8(this.this$0).setText("   " + string);
                }
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        };
        jPanel2.add(this.pad(this.measureInfo));
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.setStandard = new JCheckBox("Set standard");
        this.setStandard.addItemListener(new ItemListener(this, measureToolbar){
            private final /* synthetic */ MeasureToolbar this$0;
            private final /* synthetic */ MeasureToolbar val$toolbar;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.this$0.ignoreNextStandard) {
                    this.this$0.ignoreNextStandard = false;
                    return;
                }
                boolean bl = MeasureToolbar.access$9(this.this$0).isSelected();
                Measurement measurement = MeasureToolbar.access$7(this.this$0).getMeasurement();
                int n = MeasureToolbar.access$10(this.this$0).getValue() - 1;
                int n2 = MeasureToolbar.access$3(this.this$0).getValue() - 1;
                if (bl) {
                    measurement.stdId = maxId++;
                    MeasureList[][] measureListArray = MeasureToolbar.access$10(this.this$0).getMatrix().getMeasureLists();
                    int n3 = 0;
                    while (n3 < measureListArray.length) {
                        int n4 = 0;
                        while (n4 < measureListArray[n3].length) {
                            if (n3 != n || n4 != n2) {
                                measureListArray[n3][n4].addMeasurement((Measurement)measurement.clone(), false);
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                } else {
                    int n5 = JOptionPane.showConfirmDialog(this.val$toolbar, "Are you sure?", "Unset standard", 0, 3);
                    if (n5 != 0) {
                        this.this$0.ignoreNextStandard = true;
                        MeasureToolbar.access$9(this.this$0).setSelected(true);
                        return;
                    }
                    int n6 = measurement.stdId;
                    measurement.stdId = -1;
                    MeasureList[][] measureListArray = MeasureToolbar.access$10(this.this$0).getMatrix().getMeasureLists();
                    int n7 = 0;
                    while (n7 < measureListArray.length) {
                        int n8 = 0;
                        while (n8 < measureListArray[n7].length) {
                            if (n7 != n || n8 != n2) {
                                Measurement[] measurementArray = measureListArray[n7][n8].getMeasurements();
                                int n9 = 0;
                                while (n9 < measurementArray.length) {
                                    if (measurementArray[n9].stdId == n6) {
                                        measureListArray[n7][n8].removeMeasurement(measurementArray[n9], false);
                                        break;
                                    }
                                    ++n9;
                                }
                            }
                            ++n8;
                        }
                        ++n7;
                    }
                }
            }
            {
                this.val$toolbar = measureToolbar2;
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.setStandard.addActionListener(new ActionListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void actionPerformed(ActionEvent actionEvent) {
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.setStandard.setEnabled(false);
        jPanel3.add(this.setStandard);
        jPanel3.add(Box.createHorizontalStrut(5));
        this.removeThing = new JButton("Remove");
        this.removeThing.addActionListener(new ActionListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolbar.access$1(this.this$0).removeMeasurement(MeasureToolbar.access$7(this.this$0).getMeasurement());
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.removeThing.setEnabled(false);
        jPanel3.add(this.removeThing);
        jPanel2.add(this.pad(jPanel3));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.colorLabel = new JLabel("Color: ");
        this.colorLabel.setEnabled(false);
        jPanel3.add(this.colorLabel);
        this.colorList = new JComboBox<Color>(COLORS);
        this.colorList.setRenderer(new ColorRenderer());
        this.colorList.addItemListener(new ItemListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (MeasureToolbar.access$7(this.this$0) instanceof MeasureLine) {
                    MeasureLine measureLine = (MeasureLine)MeasureToolbar.access$7(this.this$0);
                    int n = MeasureToolbar.access$11(this.this$0).getSelectedIndex();
                    measureLine.setColor(MeasureToolbar.access$12()[n]);
                }
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.colorList.setEnabled(false);
        jPanel3.add(this.colorList);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.groupLabel = new JLabel("Group: ");
        this.groupLabel.setEnabled(false);
        jPanel3.add(this.groupLabel);
        this.groupList = new JComboBox();
        this.groupList.addItem(new MeasureGroup("NONE"));
        this.groupList.addItemListener(new ItemListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (MeasureToolbar.access$13(this.this$0)) {
                    return;
                }
                MeasureGroup measureGroup = (MeasureGroup)MeasureToolbar.access$14(this.this$0).getSelectedItem();
                MeasureToolbar.access$7(this.this$0).setGroup(measureGroup);
                MeasureToolbar.access$15(this.this$0).setText(measureGroup.getDescription());
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.groupList.setEnabled(false);
        jPanel3.add(this.groupList);
        this.newGroup = new JButton("New");
        this.newGroup.addActionListener(new ActionListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MeasureToolbar.access$16(this.this$0).showDialog(null);
                if (n == 1) {
                    String string = MeasureToolbar.access$16(this.this$0).getGroupName();
                    MeasureGroup measureGroup = new MeasureGroup(string);
                    MeasureToolbar.access$14(this.this$0).addItem(measureGroup);
                    MeasureToolbar.access$14(this.this$0).setSelectedItem(measureGroup);
                }
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.newGroup.setEnabled(false);
        jPanel3.add(this.newGroup);
        jPanel2.add(jPanel3);
        this.descriptionLabel = new JLabel("Description");
        this.descriptionLabel.setAlignmentX(2.0f);
        this.descriptionLabel.setEnabled(false);
        jPanel2.add(this.pad(this.descriptionLabel));
        this.descriptionBox = new JTextArea();
        this.descriptionBox.setRows(4);
        this.descriptionBox.setLineWrap(true);
        this.descriptionBox.setWrapStyleWord(true);
        this.descriptionBox.getDocument().addDocumentListener(new DocumentListener(this){
            private final /* synthetic */ MeasureToolbar this$0;

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void update(DocumentEvent documentEvent) {
                MeasureGroup measureGroup = (MeasureGroup)MeasureToolbar.access$14(this.this$0).getSelectedItem();
                measureGroup.setDescription(MeasureToolbar.access$15(this.this$0).getText());
            }
            {
                this.this$0 = measureToolbar;
                this.constructor$0(measureToolbar);
            }

            private final void constructor$0(MeasureToolbar measureToolbar) {
            }
        });
        this.descriptionBox.setEnabled(false);
        jPanel2.add(new JScrollPane(this.descriptionBox));
        this.updateMenuItems();
    }
}

