/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.rmi.RemoteException;
import visad.CellImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.bio.MeasureGroup;
import visad.bio.Measurement;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public abstract class MeasureThing {
    protected DisplayImpl display;
    protected DataRenderer[] renderers;
    protected DataReferenceImpl[] refs;
    protected boolean visible;
    protected Measurement m;
    protected CellImpl cell;
    protected RealTupleType dtype;
    protected RealType[] ptypes;
    protected RealTuple[] values;
    protected int len;
    protected int dim;
    protected Object dataLock = new Object();

    public static DataRenderer addDirectManipRef(DisplayImpl displayImpl, DataReferenceImpl dataReferenceImpl) throws VisADException, RemoteException {
        DataRenderer dataRenderer = displayImpl instanceof DisplayImplJ3D ? new DirectManipulationRendererJ3D() : new DirectManipulationRendererJ2D();
        displayImpl.addReferences(dataRenderer, new DataReference[]{dataReferenceImpl}, null);
        return dataRenderer;
    }

    public abstract void setDisplay(DisplayImpl var1) throws VisADException, RemoteException;

    public abstract void setColor(Color var1);

    public void setGroup(MeasureGroup measureGroup) {
        if (this.m != null) {
            this.m.setGroup(measureGroup);
        }
    }

    protected void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        if (this.renderers != null) {
            int n = 0;
            while (n < this.renderers.length) {
                this.renderers[n].toggle(bl);
                ++n;
            }
        }
    }

    public void hide() {
        this.setMeasurement(null);
    }

    public void setType(RealTupleType realTupleType) throws VisADException, RemoteException {
        this.setType(realTupleType, true);
    }

    private void setType(RealTupleType realTupleType, boolean bl) throws VisADException, RemoteException {
        this.dtype = realTupleType;
        this.ptypes = new RealType[this.dim];
        int n = 0;
        while (n < this.dim) {
            this.ptypes[n] = (RealType)realTupleType.getComponent(n);
            ++n;
        }
        if (bl) {
            Real[] realArray = new Real[this.dim];
            int n2 = 0;
            while (n2 < this.dim) {
                realArray[n2] = new Real(this.ptypes[n2], Double.NaN);
                ++n2;
            }
            RealTuple realTuple = new RealTuple(realArray);
            RealTuple[] realTupleArray = new RealTuple[this.len];
            int n3 = 0;
            while (n3 < this.len) {
                realTupleArray[n3] = realTuple;
                ++n3;
            }
            this.setValues(realTupleArray, false);
        }
    }

    public void setMeasurement(Measurement measurement) {
        if (this.m != measurement && this.m != null) {
            this.m.removeThing(this);
        }
        if (measurement != null) {
            measurement.addThing(this);
        }
        this.m = measurement;
        this.refresh();
    }

    public void refresh() {
        if (this.m == null) {
            this.setVisible(false);
        } else {
            double[][] dArray = this.m.doubleValues();
            double[][] dArray2 = new double[this.dim][this.len];
            int n = dArray.length < this.dim ? dArray.length : this.dim;
            int n2 = 0;
            while (n2 < n) {
                System.arraycopy(dArray[n2], 0, dArray2[n2], 0, this.len);
                ++n2;
            }
            this.setValues(dArray2);
            this.setColor(this.m.getColor());
            this.setVisible(true);
        }
    }

    public void setValues(double[][] dArray) {
        if (dArray.length != this.dim) {
            System.err.println("MeasureThing.setValues: invalid dimension");
            return;
        }
        int n = 0;
        while (n < this.dim) {
            if (dArray[n].length != this.len) {
                System.err.println("MeasureThing.setValues: invalid length");
                return;
            }
            ++n;
        }
        Real[][] realArray = new Real[this.len][this.dim];
        try {
            RealTuple[] realTupleArray = new RealTuple[this.len];
            int n2 = 0;
            while (n2 < this.len) {
                int n3 = 0;
                while (n3 < this.dim) {
                    realArray[n2][n3] = new Real(this.ptypes[n3], dArray[n3][n2]);
                    ++n3;
                }
                realTupleArray[n2] = new RealTuple(realArray[n2]);
                ++n2;
            }
            this.setValues(realTupleArray, false);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setValues(RealTuple[] realTupleArray) {
        this.setValues(realTupleArray, true);
    }

    protected void setValues(RealTuple[] realTupleArray, boolean bl) {
        if (realTupleArray.length != this.len) {
            System.err.println("MeasureThing.setValues: invalid length");
            return;
        }
        boolean bl2 = true;
        int n = 0;
        while (n < this.len) {
            if (!realTupleArray[n].equals(this.values[n])) {
                bl2 = false;
                break;
            }
            ++n;
        }
        if (bl2) {
            return;
        }
        try {
            if (bl) {
                this.setType((RealTupleType)realTupleArray[0].getType(), false);
            }
            this.cell.disableAction();
            Object object = this.dataLock;
            synchronized (object) {
                int n2 = 0;
                while (n2 < this.len) {
                    int n3 = realTupleArray[n2].getDimension();
                    if (n3 != this.dim) {
                        System.err.println("MeasureThing.setValues: dimension doesn't match (" + n3 + " != " + this.dim + ")");
                    }
                    this.refs[n2].setData(realTupleArray[n2]);
                    ++n2;
                }
            }
            this.cell.enableAction();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public Measurement getMeasurement() {
        return this.m;
    }

    public RealTuple[] getValues() {
        return this.values;
    }

    public RealTupleType getDomain() {
        return this.dtype;
    }

    public DataReference[] getReferences() {
        return this.refs;
    }

    public MeasureThing(int n, int n2) throws VisADException, RemoteException {
        this.len = n;
        this.dim = n2;
        this.refs = new DataReferenceImpl[this.len];
        this.visible = true;
        this.values = new RealTuple[this.len];
        this.cell = new CellImpl(this){
            private final /* synthetic */ MeasureThing this$0;

            public void doAction() {
                if (this.this$0.m != null) {
                    Object object = this.this$0.dataLock;
                    synchronized (object) {
                        int n = 0;
                        while (n < this.this$0.len) {
                            this.this$0.values[n] = (RealTuple)this.this$0.refs[n].getData();
                            ++n;
                        }
                    }
                    RealTuple[] realTupleArray = new RealTuple[this.this$0.values.length];
                    System.arraycopy(this.this$0.values, 0, realTupleArray, 0, this.this$0.values.length);
                    this.this$0.m.setValues(realTupleArray);
                }
            }
            {
                this.this$0 = measureThing;
                this.constructor$0(measureThing);
            }

            private final void constructor$0(MeasureThing measureThing) {
            }
        };
        this.cell.disableAction();
        int n3 = 0;
        while (n3 < this.len) {
            this.refs[n3] = new DataReferenceImpl("p" + n3);
            this.cell.addReference(this.refs[n3]);
            ++n3;
        }
        this.cell.enableAction();
    }
}

