/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.MouseBehavior;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.VisADRay;
import visad.bio.MeasureLine;
import visad.bio.MeasurePoint;
import visad.bio.MeasureThing;
import visad.bio.MeasureToolbar;
import visad.bio.Measurement;
import visad.bio.SelectionBox;

public class MeasurePool
implements DisplayListener {
    static final int MINIMUM_SIZE = 16;
    private static final int PICKING_THRESHOLD = 10;
    private DisplayImpl display;
    private MeasureToolbar toolbar;
    private SelectionBox box;
    private int dim;
    private int blockSize;
    private int size;
    private Vector lines = new Vector();
    private int lnUsed;
    int maxLnId = 0;
    private Vector points = new Vector();
    private int ptUsed;
    int maxPtId = 0;
    private int cursor_x;
    private int cursor_y;

    public void expand(int n) {
        this.expand(n, true);
    }

    public void expand(int n, boolean bl) {
        if (this.size == 0) {
            System.err.println("MeasurePool.expand: warning: Cannot expand from zero without domain type");
            return;
        }
        MeasureLine measureLine = (MeasureLine)this.lines.elementAt(0);
        RealTupleType realTupleType = measureLine.getDomain();
        this.expand(n, realTupleType, bl);
    }

    public void expand(int n, RealTupleType realTupleType) {
        this.expand(n, realTupleType, true);
    }

    public void expand(int n, RealTupleType realTupleType, boolean bl) {
        if (n <= this.size) {
            return;
        }
        int n2 = n - this.size;
        if (n2 % this.blockSize > 0) {
            n2 += this.blockSize - n2 % this.blockSize;
        }
        MeasureLine[] measureLineArray = new MeasureLine[n2];
        MeasurePoint[] measurePointArray = new MeasurePoint[n2];
        try {
            int n3 = 0;
            while (n3 < n2) {
                measureLineArray[n3] = new MeasureLine(this.dim, this);
                measureLineArray[n3].setType(realTupleType);
                measureLineArray[n3].hide();
                this.lines.add(measureLineArray[n3]);
                measurePointArray[n3] = new MeasurePoint(this.dim, this);
                measurePointArray[n3].setType(realTupleType);
                measurePointArray[n3].hide();
                this.points.add(measurePointArray[n3]);
                ++n3;
            }
            MeasurePool measurePool = this;
            synchronized (measurePool) {
                if (bl) {
                    this.display.disableAction();
                    if (this.box == null) {
                        this.box = new SelectionBox();
                        this.box.setDisplay(this.display);
                    }
                }
                int n4 = 0;
                while (n4 < n2) {
                    try {
                        measureLineArray[n4].setDisplay(this.display);
                        measurePointArray[n4].setDisplay(this.display);
                    }
                    catch (VisADException visADException) {
                        visADException.printStackTrace();
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                    ++n4;
                }
                if (bl) {
                    this.display.enableAction();
                }
            }
            this.size += n2;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void set(Measurement[] measurementArray) {
        MeasureThing measureThing;
        int n = measurementArray.length;
        if (this.box != null) {
            this.box.select(null);
        }
        if (this.toolbar != null) {
            this.toolbar.select(null);
        }
        this.expand(n);
        this.lnUsed = 0;
        this.ptUsed = 0;
        int n2 = 0;
        while (n2 < n) {
            if (measurementArray[n2].isPoint()) {
                measureThing = (MeasurePoint)this.points.elementAt(this.ptUsed++);
                measureThing.setMeasurement(measurementArray[n2]);
            } else {
                measureThing = (MeasureLine)this.lines.elementAt(this.lnUsed++);
                ((MeasureLine)measureThing).setMeasurement(measurementArray[n2]);
            }
            ++n2;
        }
        n2 = this.ptUsed;
        while (n2 < this.size) {
            measureThing = (MeasurePoint)this.points.elementAt(n2);
            measureThing.hide();
            ++n2;
        }
        n2 = this.lnUsed;
        while (n2 < this.size) {
            measureThing = (MeasureLine)this.lines.elementAt(n2);
            measureThing.hide();
            ++n2;
        }
    }

    public void add(Measurement measurement) {
        if (measurement.isPoint()) {
            this.expand(this.ptUsed + 1);
            MeasurePoint measurePoint = (MeasurePoint)this.points.elementAt(this.ptUsed);
            measurePoint.setMeasurement(measurement);
            ++this.ptUsed;
        } else {
            this.expand(this.lnUsed + 1);
            MeasureLine measureLine = (MeasureLine)this.lines.elementAt(this.lnUsed);
            measureLine.setMeasurement(measurement);
            ++this.lnUsed;
        }
    }

    public void displayChanged(DisplayEvent displayEvent) {
        int n = displayEvent.getId();
        int n2 = displayEvent.getX();
        int n3 = displayEvent.getY();
        if (n == 5) {
            this.cursor_x = n2;
            this.cursor_y = n3;
        } else if (n == 9 && n2 == this.cursor_x && n3 == this.cursor_y && (this.ptUsed > 0 || this.lnUsed > 0)) {
            Object object;
            double[] dArray = this.cursorToDomain(this.pixelToCursor(n2, n3));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            double[] dArray2 = this.cursorToDomain(this.pixelToCursor(0, 0));
            double[] dArray3 = this.cursorToDomain(this.pixelToCursor(10, 0));
            double d = dArray3[0] - dArray2[0];
            int n6 = -1;
            double d2 = Double.MAX_VALUE;
            MouseBehavior mouseBehavior = this.display.getMouseBehavior();
            int n7 = 0;
            while (n7 < this.lnUsed) {
                MeasureLine measureLine = (MeasureLine)this.lines.elementAt(n7);
                object = measureLine.getMeasurement().doubleValues();
                double d3 = this.distance(object[0][0], (double)object[1][0], (double)object[0][1], (double)object[1][1], dArray[0], dArray[1]);
                if (d3 < d2) {
                    d2 = d3;
                    n6 = n7;
                }
                ++n7;
            }
            n7 = 0;
            int n8 = 0;
            while (n8 < this.ptUsed) {
                double d4;
                object = (MeasurePoint)this.points.elementAt(n8);
                double[][] dArray4 = object.getMeasurement().doubleValues();
                double d5 = dArray4[0][0] - dArray[0];
                double d6 = Math.sqrt(d5 * d5 + (d4 = dArray4[1][0] - dArray[1]) * d4);
                if (d6 < d2) {
                    n7 = 1;
                    d2 = d6;
                    n6 = n8;
                }
                ++n8;
            }
            if (d2 > d) {
                if (this.box != null) {
                    this.box.select(null);
                }
                if (this.toolbar != null) {
                    this.toolbar.select(null);
                }
            } else if (n7 != 0) {
                MeasurePoint measurePoint = (MeasurePoint)this.points.elementAt(n6);
                if (this.box != null) {
                    this.box.select(measurePoint);
                }
                if (this.toolbar != null) {
                    this.toolbar.select(measurePoint);
                }
            } else {
                MeasureLine measureLine = (MeasureLine)this.lines.elementAt(n6);
                if (this.box != null) {
                    this.box.select(measureLine);
                }
                if (this.toolbar != null) {
                    this.toolbar.select(measureLine);
                }
            }
        }
    }

    private double[] pixelToCursor(int n, int n2) {
        MouseBehavior mouseBehavior = this.display.getDisplayRenderer().getMouseBehavior();
        VisADRay visADRay = mouseBehavior.findRay(n, n2);
        return visADRay.position;
    }

    private double[] cursorToDomain(double[] dArray) {
        Object object;
        Object object2;
        Vector vector = this.display.getMapVector();
        int n = vector.size();
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        int n2 = 0;
        while (n2 < n) {
            if (object3 != null && object4 != null && object5 != null) break;
            object2 = (ScalarMap)vector.elementAt(n2);
            object = ((ScalarMap)object2).getDisplayScalar();
            if (((RealType)object).equals(Display.XAxis)) {
                object3 = object2;
            } else if (((RealType)object).equals(Display.YAxis)) {
                object4 = object2;
            } else if (((RealType)object).equals(Display.ZAxis)) {
                object5 = object2;
            }
            ++n2;
        }
        double[] dArray2 = new double[2];
        object2 = new double[2];
        object = new double[3];
        if (object3 == null) {
            object[0] = Double.NaN;
        } else {
            ((ScalarMap)object3).getScale(dArray2, (double[])object2, (double[])object2);
            object[0] = (dArray[0] - dArray2[1]) / dArray2[0];
        }
        if (object4 == null) {
            object[1] = Double.NaN;
        } else {
            ((ScalarMap)object4).getScale(dArray2, (double[])object2, (double[])object2);
            object[1] = (dArray[1] - dArray2[1]) / dArray2[0];
        }
        if (object5 == null) {
            object[2] = Double.NaN;
        } else {
            ((ScalarMap)object5).getScale(dArray2, (double[])object2, (double[])object2);
            object[2] = (dArray[2] - dArray2[1]) / dArray2[0];
        }
        return object;
    }

    private double distance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d2 - d4;
        double d11 = d5 - d;
        double d12 = d6 - d2;
        double d13 = (d11 * d9 + d12 * d10) / (d9 * d9 + d10 * d10);
        double d14 = d13 * d9 + d;
        double d15 = d13 * d10 + d2;
        int n = 0;
        if (d14 > d && d14 > d3) {
            n = d > d3 ? 1 : 2;
        } else if (d14 < d && d14 < d3) {
            n = d < d3 ? 1 : 2;
        } else if (d15 > d2 && d15 > d4) {
            n = d2 > d4 ? 1 : 2;
        } else if (d15 < d2 && d15 < d4) {
            int n2 = n = d2 < d4 ? 1 : 2;
        }
        if (n == 0) {
            d8 = d14 - d5;
            d7 = d15 - d6;
        } else if (n == 1) {
            d8 = d - d5;
            d7 = d2 - d6;
        } else {
            d8 = d3 - d5;
            d7 = d4 - d6;
        }
        return Math.sqrt(d8 * d8 + d7 * d7);
    }

    public MeasurePool(DisplayImpl displayImpl, MeasureToolbar measureToolbar, int n, int n2) {
        this.display = displayImpl;
        this.toolbar = measureToolbar;
        this.dim = n;
        this.blockSize = n2 < 1 ? 1 : n2;
        this.size = 0;
        this.lnUsed = 0;
        this.ptUsed = 0;
        displayImpl.addDisplayListener(this);
    }
}

