/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.rmi.RemoteException;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.TupleType;
import visad.VisADException;
import visad.bio.MeasureList;
import visad.bio.MeasurePool;
import visad.bio.MeasureToolbar;

public class MeasureMatrix {
    static final RealType ZAXIS_TYPE = RealType.getRealType("bio_line_z");
    private MeasureList[][] matrix;
    private DisplayImpl display2;
    private DisplayImpl display3;
    private MeasureToolbar toolbar;
    private MeasurePool pool;
    private MeasurePool[] pool3d;
    private int index = -1;
    private int slice = -1;
    private int numSlices = -1;
    private boolean inited = false;

    public void init(FieldImpl fieldImpl, ScalarMap[][] scalarMapArray) throws VisADException, RemoteException {
        Object object;
        if (this.inited) {
            return;
        }
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        RealTupleType realTupleType = functionType.getDomain();
        if (realTupleType.getDimension() > 1) {
            throw new VisADException("Field not an image stack");
        }
        RealType realType = (RealType)realTupleType.getComponent(0);
        Set set = fieldImpl.getDomainSet();
        if (!(set instanceof GriddedSet)) {
            throw new VisADException("Image stack not ordered");
        }
        GriddedSet griddedSet = (GriddedSet)set;
        int[] nArray = griddedSet.getLengths();
        this.numSlices = nArray[0];
        int n = 0;
        while (n < this.numSlices) {
            object = fieldImpl.getSample(n);
            if (!(object instanceof FieldImpl)) {
                throw new VisADException("Data #" + n + " not a field");
            }
            ++n;
        }
        FieldImpl fieldImpl2 = (FieldImpl)fieldImpl.getSample(0);
        functionType = (FunctionType)fieldImpl2.getType();
        object = functionType.getDomain();
        int n2 = ((TupleType)object).getDimension();
        RealType[] realTypeArray = new RealType[n2];
        int n3 = 0;
        while (n3 < n2) {
            realTypeArray[n3] = (RealType)((TupleType)object).getComponent(n3);
            ++n3;
        }
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray);
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray);
        set = fieldImpl2.getDomainSet();
        float[][] fArray = set.getSamples(false);
        Real[] realArray = new Real[n2];
        Real[] realArray2 = new Real[n2];
        Real[] realArray3 = new Real[n2];
        int n4 = 0;
        while (n4 < n2) {
            RealType realType2 = (RealType)((TupleType)object).getComponent(n4);
            float f = fArray[n4][0];
            float f2 = fArray[n4][fArray[n4].length - 1];
            if (f != f) {
                f = 0.0f;
            }
            if (f2 != f2) {
                f2 = 0.0f;
            }
            if (scalarMapArray != null && scalarMapArray.length > n4 && scalarMapArray[n4] != null) {
                int n5 = 0;
                while (n5 < scalarMapArray[n4].length) {
                    if (scalarMapArray[n4][n5] != null) {
                        scalarMapArray[n4][n5].setRange(f, f2);
                    }
                    ++n5;
                }
            }
            realArray[n4] = new Real(realType2, (double)f);
            realArray2[n4] = new Real(realType2, (double)f2);
            realArray3[n4] = new Real(realType2, (double)((f + f2) / 2.0f));
            ++n4;
        }
        if (scalarMapArray != null && scalarMapArray.length > n2 && scalarMapArray[n2] != null) {
            n4 = 0;
            while (n4 < scalarMapArray[n2].length) {
                if (scalarMapArray[n2][n4] != null) {
                    scalarMapArray[n2][n4].setRange(0.0, this.numSlices - 1);
                }
                ++n4;
            }
        }
        this.pool = new MeasurePool(this.display2, this.toolbar, 2, 8);
        this.pool.expand(16, (RealTupleType)object);
        this.pool3d = new MeasurePool[this.numSlices];
        if (this.display3 != null) {
            this.display3.disableAction();
            n4 = 0;
            while (n4 < this.numSlices) {
                this.pool3d[n4] = new MeasurePool(this.display3, null, 3, 8);
                this.pool3d[n4].expand(16, realTupleType2, false);
                ++n4;
            }
            this.display3.enableAction();
        }
        n4 = 0;
        while (n4 < this.matrix.length) {
            this.matrix[n4] = new MeasureList[this.numSlices];
            int n6 = 0;
            while (n6 < this.numSlices) {
                this.matrix[n4][n6] = new MeasureList(this, realArray, realArray2, realArray3, this.slice, this.pool, this.pool3d[n6]);
                ++n6;
            }
            ++n4;
        }
        this.inited = true;
        this.setEntry(0, 0);
    }

    public void refresh() {
        this.setEntry(this.index, this.slice);
        this.toolbar.updateGroupList();
    }

    public void setIndex(int n) {
        this.setEntry(n, this.slice);
    }

    public void setSlice(int n) {
        this.setEntry(this.index, n);
    }

    public void setEntry(int n, int n2) {
        Object object;
        if (!this.inited) {
            System.err.println("Warning: matrix not inited!");
        }
        if (this.display3 != null && this.index != n) {
            object = this.matrix[n];
            int n3 = 0;
            while (n3 < ((MeasureList[])object).length) {
                this.pool3d[n3].set(((MeasureList)object[n3]).getMeasurements());
                ++n3;
            }
        }
        this.index = n;
        this.slice = n2;
        object = this.matrix[n][n2];
        this.pool.set(((MeasureList)object).getMeasurements());
    }

    public int getIndex() {
        return this.index;
    }

    public int getSlice() {
        return this.slice;
    }

    public int getNumberOfSlices() {
        return this.numSlices;
    }

    public DisplayImpl getDisplay() {
        return this.display2;
    }

    public DisplayImpl getDisplay3d() {
        return this.display3;
    }

    public MeasureList getMeasureList() {
        return this.getMeasureList(this.index, this.slice);
    }

    public MeasureList getMeasureList(int n) {
        return this.getMeasureList(this.index, n);
    }

    public MeasureList getMeasureList(int n, int n2) {
        return this.matrix[n][n2];
    }

    public MeasureList[][] getMeasureLists() {
        MeasureList[][] measureListArray = new MeasureList[this.matrix.length][];
        int n = 0;
        while (n < this.matrix.length) {
            measureListArray[n] = new MeasureList[this.matrix[n].length];
            System.arraycopy(this.matrix[n], 0, measureListArray[n], 0, this.matrix[n].length);
            ++n;
        }
        return measureListArray;
    }

    public MeasureMatrix(int n, DisplayImpl displayImpl, DisplayImpl displayImpl2, MeasureToolbar measureToolbar) {
        this.matrix = new MeasureList[n][];
        this.display2 = displayImpl;
        this.display3 = displayImpl2;
        this.toolbar = measureToolbar;
    }
}

