/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.VisADException;
import visad.bio.MeasureGroup;
import visad.bio.MeasureMatrix;
import visad.bio.MeasurePool;
import visad.bio.Measurement;

public class MeasureList {
    private MeasureMatrix mm;
    private Vector measureList;
    private RealTuple[] lnVals;
    private RealTuple[] ptVals;
    private int slice;
    private RealType[] types;
    private MeasurePool pool;
    private MeasurePool pool3d;

    public void addMeasurement() {
        this.addMeasurement(false);
    }

    public void addMeasurement(boolean bl) {
        this.addMeasurement(bl, Color.white, (MeasureGroup)MeasureGroup.groups.elementAt(0));
    }

    public void addMeasurement(boolean bl, Color color, MeasureGroup measureGroup) {
        RealTuple[] realTupleArray = bl ? this.ptVals : this.lnVals;
        Measurement measurement = new Measurement(bl ? this.ptVals : this.lnVals, color, measureGroup);
        this.addMeasurement(measurement, true);
    }

    void addMeasurement(Measurement measurement, boolean bl) {
        if (this.measureList.contains(measurement)) {
            return;
        }
        this.measureList.add(measurement);
        if (bl) {
            this.pool.add(measurement);
            if (this.pool3d != null) {
                this.pool3d.add(measurement);
            }
        }
    }

    public void removeMeasurement(Measurement measurement) {
        this.removeMeasurement(measurement, true);
    }

    void removeMeasurement(Measurement measurement, boolean bl) {
        if (!this.measureList.contains(measurement)) {
            return;
        }
        this.measureList.remove(measurement);
        if (bl) {
            Measurement[] measurementArray = this.getMeasurements();
            this.pool.set(measurementArray);
            if (this.pool3d != null) {
                this.pool3d.set(measurementArray);
            }
        }
    }

    void removeAllMeasurements(boolean bl) {
        this.measureList.removeAllElements();
        if (bl) {
            Measurement[] measurementArray = this.getMeasurements();
            this.pool.set(measurementArray);
            if (this.pool3d != null) {
                this.pool3d.set(measurementArray);
            }
        }
    }

    public Measurement[] getMeasurements() {
        int n = this.measureList.size();
        Object[] objectArray = new Measurement[n];
        this.measureList.copyInto(objectArray);
        return objectArray;
    }

    public RealType[] getTypes() {
        return this.types;
    }

    public MeasureList(MeasureMatrix measureMatrix, Real[] realArray, Real[] realArray2, Real[] realArray3, int n, MeasurePool measurePool, MeasurePool measurePool2) throws VisADException, RemoteException {
        this.mm = measureMatrix;
        this.measureList = new Vector();
        this.types = new RealType[realArray.length];
        int n2 = 0;
        while (n2 < realArray.length) {
            this.types[n2] = (RealType)realArray[n2].getType();
            ++n2;
        }
        this.lnVals = new RealTuple[2];
        this.lnVals[0] = new RealTuple(realArray);
        this.lnVals[1] = new RealTuple(realArray2);
        this.ptVals = new RealTuple[1];
        this.ptVals[0] = new RealTuple(realArray3);
        this.slice = n;
        this.pool = measurePool;
        this.pool3d = measurePool2;
    }
}

