/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.DisplayImpl;
import visad.MathType;
import visad.VisADException;
import visad.bio.FileSeriesWidget;
import visad.bio.ImageStackWidget;
import visad.bio.MeasureDataFile;
import visad.bio.MeasureMatrix;
import visad.bio.MeasureToolbar;
import visad.bio.SeriesChooser;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.GUIFrame;
import visad.util.Util;

public class MeasureFrame
extends GUIFrame
implements ChangeListener {
    private static final String TITLE = "BioVisAD Measurement Tool";
    private JFileChooser fileBox = Util.getVisADFileChooser();
    private SeriesChooser seriesBox = new SeriesChooser();
    private MeasureMatrix matrix;
    private DisplayImpl display2;
    private DisplayImpl display3;
    private ImageStackWidget vertWidget;
    private FileSeriesWidget horizWidget;
    private MeasureToolbar toolbar;
    private String prefix;

    public void fileOpen() {
        MeasureFrame measureFrame = this;
        SwingUtilities.invokeLater(new Runnable(this, measureFrame){
            private final /* synthetic */ MeasureFrame this$0;
            private final /* synthetic */ JFrame val$frame;

            public void run() {
                ((Component)this.this$0).setCursor(Cursor.getPredefinedCursor(3));
                if (MeasureFrame.access$0(this.this$0).showDialog(this.val$frame) != 1) {
                    ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
                    return;
                }
                File[] fileArray = MeasureFrame.access$0(this.this$0).getSeries();
                MeasureFrame.access$2(this.this$0, MeasureFrame.access$0(this.this$0).getPrefix());
                if (fileArray == null || fileArray.length < 1) {
                    JOptionPane.showMessageDialog(this.val$frame, "Invalid series", "Cannot load series", 0);
                    ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
                    return;
                }
                MeasureFrame.access$3(this.this$0).setSeries(fileArray);
                MeasureFrame.access$5(this.this$0, MeasureFrame.access$3(this.this$0).getMatrix());
                ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
            }
            {
                this.val$frame = jFrame;
                this.this$0 = measureFrame;
                this.constructor$0(measureFrame);
            }

            private final void constructor$0(MeasureFrame measureFrame) {
            }
        });
    }

    public void fileRestore(boolean bl) {
        MeasureFrame measureFrame = this;
        boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(this, measureFrame, bl2){
            private final /* synthetic */ MeasureFrame this$0;
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ boolean val$fmicrons;

            public void run() {
                ((Component)this.this$0).setCursor(Cursor.getPredefinedCursor(3));
                MeasureFrame.access$6(this.this$0).setDialogType(0);
                if (MeasureFrame.access$6(this.this$0).showOpenDialog(this.val$frame) != 0) {
                    ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
                    return;
                }
                File file = MeasureFrame.access$6(this.this$0).getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this.val$frame, file.getName() + " does not exist", "Cannot load file", 0);
                    ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
                    return;
                }
                try {
                    MeasureDataFile measureDataFile = new MeasureDataFile(file);
                    if (this.val$fmicrons) {
                        double d = MeasureFrame.access$7(this.this$0).getMicronsPerPixel();
                        double d2 = MeasureFrame.access$7(this.this$0).getSliceDistance();
                        measureDataFile.readMatrix(MeasureFrame.access$4(this.this$0), d, d2);
                    } else {
                        measureDataFile.readMatrix(MeasureFrame.access$4(this.this$0));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
            }
            {
                this.val$frame = jFrame;
                this.val$fmicrons = bl;
                this.this$0 = measureFrame;
                this.constructor$0(measureFrame);
            }

            private final void constructor$0(MeasureFrame measureFrame) {
            }
        });
    }

    public void fileSave(boolean bl) {
        MeasureFrame measureFrame = this;
        boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(this, measureFrame, bl2){
            private final /* synthetic */ MeasureFrame this$0;
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ boolean val$fmicrons;

            public void run() {
                ((Component)this.this$0).setCursor(Cursor.getPredefinedCursor(3));
                MeasureFrame.access$6(this.this$0).setDialogType(1);
                if (MeasureFrame.access$6(this.this$0).showSaveDialog(this.val$frame) != 0) {
                    ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
                    return;
                }
                File file = MeasureFrame.access$6(this.this$0).getSelectedFile();
                try {
                    MeasureDataFile measureDataFile = new MeasureDataFile(file);
                    if (this.val$fmicrons) {
                        double d = MeasureFrame.access$7(this.this$0).getMicronsPerPixel();
                        double d2 = MeasureFrame.access$7(this.this$0).getSliceDistance();
                        measureDataFile.writeMatrix(MeasureFrame.access$4(this.this$0), d, d2);
                    } else {
                        measureDataFile.writeMatrix(MeasureFrame.access$4(this.this$0));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ((Component)this.this$0).setCursor(Cursor.getDefaultCursor());
            }
            {
                this.val$frame = jFrame;
                this.val$fmicrons = bl;
                this.this$0 = measureFrame;
                this.constructor$0(measureFrame);
            }

            private final void constructor$0(MeasureFrame measureFrame) {
            }
        });
    }

    public void fileRestoreLines() {
        this.fileRestore(false);
    }

    public void fileSaveLines() {
        this.fileSave(false);
    }

    public void fileRestoreMicrons() {
        this.fileRestore(true);
    }

    public void fileSaveMicrons() {
        this.fileSave(true);
    }

    public void fileExit() {
        System.exit(0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.horizWidget.getMaximum();
        int n2 = this.horizWidget.getValue();
        this.setTitle("BioVisAD Measurement Tool - " + this.prefix + " (" + n2 + "/" + n + ")");
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-3d");
        MeasureFrame measureFrame = new MeasureFrame(bl);
        measureFrame.pack();
        measureFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        Util.centerWindow(measureFrame);
        measureFrame.show();
    }

    static /* synthetic */ SeriesChooser access$0(MeasureFrame measureFrame) {
        return measureFrame.seriesBox;
    }

    static /* synthetic */ String access$1(MeasureFrame measureFrame) {
        return measureFrame.prefix;
    }

    static /* synthetic */ void access$2(MeasureFrame measureFrame, String string) {
        measureFrame.prefix = string;
    }

    static /* synthetic */ FileSeriesWidget access$3(MeasureFrame measureFrame) {
        return measureFrame.horizWidget;
    }

    static /* synthetic */ MeasureMatrix access$4(MeasureFrame measureFrame) {
        return measureFrame.matrix;
    }

    static /* synthetic */ void access$5(MeasureFrame measureFrame, MeasureMatrix measureMatrix) {
        measureFrame.matrix = measureMatrix;
    }

    static /* synthetic */ JFileChooser access$6(MeasureFrame measureFrame) {
        return measureFrame.fileBox;
    }

    static /* synthetic */ MeasureToolbar access$7(MeasureFrame measureFrame) {
        return measureFrame.toolbar;
    }

    public MeasureFrame() throws VisADException, RemoteException {
        this(false);
    }

    public MeasureFrame(boolean bl) throws VisADException, RemoteException {
        super(true);
        this.setTitle(TITLE);
        this.addMenuItem("File", "Open...", "fileOpen", 'o');
        this.addMenuSeparator("File");
        this.addMenuItem("File", "Restore lines (pixels)...", "fileRestoreLines", 'r');
        this.addMenuItem("File", "Save lines (pixels)...", "fileSaveLines", 's');
        this.addMenuItem("File", "Restore lines (microns)...", "fileRestoreMicrons", 'e');
        this.addMenuItem("File", "Save lines (microns)...", "fileSaveMicrons", 'a');
        this.addMenuSeparator("File");
        this.addMenuItem("File", "Exit", "fileExit", 'x');
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setContentPane(jPanel);
        this.display2 = null;
        try {
            this.display2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (this.display2 == null) {
            this.display2 = new DisplayImplJ2D("display2");
        }
        jPanel.add(this.display2.getComponent(), "Center");
        this.vertWidget = new ImageStackWidget(false);
        this.vertWidget.setAlignmentY(0.0f);
        jPanel.add((Component)this.vertWidget, "West");
        this.horizWidget = new FileSeriesWidget(true);
        this.horizWidget.setDisplay(this.display2);
        this.horizWidget.setWidget(this.vertWidget);
        this.horizWidget.addChangeListener(this);
        jPanel.add((Component)this.horizWidget, "South");
        this.toolbar = new MeasureToolbar(this, this.horizWidget, this.vertWidget);
        this.horizWidget.setToolbar(this.toolbar);
        jPanel.add((Component)this.toolbar, "East");
        if (bl) {
            JFrame jFrame = new JFrame("BioVisAD - Image stack");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jFrame.setContentPane(jPanel2);
            this.display3 = new DisplayImplJ3D("display3");
            jPanel2.add(this.display3.getComponent(), "Center");
            this.horizWidget.setDisplay3d(this.display3);
            jFrame.pack();
            jFrame.show();
        }
    }

    static {
        MathType.addTimeAlias("index");
    }
}

