/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.rmi.RemoteException;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.ColorControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.VisADException;
import visad.bio.MeasureMatrix;
import visad.bio.StepWidget;

public class ImageStackWidget
extends StepWidget
implements ControlListener,
ScalarMapListener {
    private static final int NORMAL_BRIGHTNESS = 50;
    private ScalarMap smap;
    private AnimationControl control;
    private MeasureMatrix mm;
    private boolean grayscale = false;
    private int brightness = 50;
    private static /* synthetic */ Class class$Lvisad$ColorControl;

    public void setMatrix(MeasureMatrix measureMatrix) {
        this.mm = measureMatrix;
    }

    public void setMap(ScalarMap scalarMap) throws VisADException, RemoteException {
        if (scalarMap != null && !Display.Animation.equals(scalarMap.getDisplayScalar())) {
            throw new DisplayException("ImageStackWidget: ScalarMap must be to Display.Animation");
        }
        if (this.smap != null) {
            scalarMap.removeScalarMapListener(this);
        }
        if (this.control != null) {
            this.control.removeControlListener(this);
        }
        this.smap = scalarMap;
        this.control = (AnimationControl)((Object)scalarMap.getControl());
        this.updateSlider();
        if (this.control != null) {
            this.control.addControlListener(this);
        }
        if (scalarMap != null) {
            scalarMap.addScalarMapListener(this);
        }
    }

    public void setGrayscale(boolean bl) {
        this.grayscale = bl;
        this.doColorTable();
    }

    public void setBrightness(int n) {
        this.brightness = n;
        this.doColorTable();
    }

    private void doColorTable() {
        float[][] fArray = this.grayscale ? BaseColorControl.initTableGreyWedge(new float[3][256]) : BaseColorControl.initTableVis5D(new float[3][256]);
        double d = 1.0 - 0.02 * (double)(this.brightness - 50);
        int n = 0;
        while (n < 256) {
            fArray[0][n] = (float)Math.pow(fArray[0][n], d);
            fArray[1][n] = (float)Math.pow(fArray[1][n], d);
            fArray[2][n] = (float)Math.pow(fArray[2][n], d);
            ++n;
        }
        DisplayImpl displayImpl = this.mm.getDisplay();
        DisplayImpl displayImpl2 = this.mm.getDisplay3d();
        ColorControl colorControl = (ColorControl)displayImpl.getControl(class$Lvisad$ColorControl != null ? class$Lvisad$ColorControl : (class$Lvisad$ColorControl = ImageStackWidget.class$("visad.ColorControl")));
        ColorControl colorControl2 = displayImpl2 == null ? null : (ColorControl)displayImpl2.getControl(class$Lvisad$ColorControl != null ? class$Lvisad$ColorControl : (class$Lvisad$ColorControl = ImageStackWidget.class$("visad.ColorControl")));
        try {
            if (colorControl != null) {
                colorControl.setTable(fArray);
            }
            if (colorControl2 != null) {
                colorControl2.setTable(fArray);
            }
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    private void updateSlider() {
        int n = 1;
        int n2 = 1;
        if (this.control == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            try {
                Set set = this.control.getSet();
                if (set != null) {
                    n = set.getLength();
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            n2 = this.control.getCurrent() + 1;
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > n) {
                n2 = n;
            }
        }
        this.setBounds(1, n, n2);
    }

    public void updateStep() {
        if (this.control != null && this.cur != this.control.getCurrent() + 1) {
            try {
                this.control.setCurrent(this.cur - 1);
                this.mm.setSlice(this.cur - 1);
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) {
        if (this.control != null) {
            int n = this.control.getCurrent() + 1;
            if (this.step.getValue() != n) {
                this.step.setValue(n);
            }
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        this.updateSlider();
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        int n = scalarMapControlEvent.getId();
        if (n == 4 || n == 5) {
            scalarMapControlEvent.getControl().removeControlListener(this);
            if (n == 4) {
                this.control = null;
            }
        }
        if (n == 5 || n == 3) {
            this.control = (AnimationControl)((Object)scalarMapControlEvent.getScalarMap().getControl());
            this.updateSlider();
            if (this.control != null) {
                this.control.addControlListener(this);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ImageStackWidget(boolean bl) {
        super(bl);
    }
}

